/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.LogonRealm;
import oracle.dbtools.rt.web.SecurityConstraint;

public class SecurityConfig {
    private final SecurityConstraint constraint;
    private final LogonRealm logonRealm;
    private final AuthenticationRealm scope;

    public SecurityConfig(SecurityConstraint constraint, AuthenticationRealm realm, LogonRealm logonRealm) {
        this.constraint = constraint;
        this.scope = realm == null ? AuthenticationRealm.NONE : realm;
        this.logonRealm = logonRealm == null ? LogonRealm.NONE : logonRealm;
    }

    public SecurityConstraint constraint() {
        return this.constraint;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityConfig other = (SecurityConfig)obj;
        if (this.constraint != other.constraint) {
            return false;
        }
        if (this.logonRealm == null ? other.logonRealm != null : !this.logonRealm.equals(other.logonRealm)) {
            return false;
        }
        return this.scope == other.scope;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constraint == null ? 0 : this.constraint.hashCode());
        result = 31 * result + (this.logonRealm == null ? 0 : this.logonRealm.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        return result;
    }

    public LogonRealm logonRealm() {
        return this.logonRealm;
    }

    public AuthenticationRealm realm() {
        return this.scope;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SecurityConfig [constraint=");
        builder.append((Object)this.constraint);
        builder.append(", realm=");
        builder.append((Object)this.scope);
        builder.append(", logonConfig=");
        builder.append(this.logonRealm);
        builder.append("]");
        return builder.toString();
    }
}

