/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.io.Serializable;
import java.util.Locale;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.authentication.LogonRealm;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.session.SessionState;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.RequestEntity;

public class PreLogonState
implements Serializable {
    private String signOnMessage = "";
    private static final String NO_MESSAGE = "";
    private static final long serialVersionUID = -1730023011519015816L;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreLogonState other = (PreLogonState)obj;
        return !(this.signOnMessage == null ? other.signOnMessage != null : !this.signOnMessage.equals(other.signOnMessage));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.signOnMessage == null ? 0 : this.signOnMessage.hashCode());
        return result;
    }

    public String signOnMessage() {
        return this.signOnMessage;
    }

    public PreLogonState signOnMessage(Iterable<Locale> localePreference, Translatable msg) {
        this.signOnMessage = msg == null ? NO_MESSAGE : msg.toString(localePreference);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PreLogonState [signOnMessage=");
        builder.append(this.signOnMessage);
        builder.append("]");
        return builder.toString();
    }

    public static RedirectException preLogonState(RequestEntity request, RedirectException redirect, LogonRealm realm, String startPath, Translatable message) {
        PreLogonState preLogon = PreLogonState.preLogonState(request);
        if (preLogon == null) {
            preLogon = new PreLogonState();
            AssociativeArray session = AssociativeArrays.builder().add((Object)"_com.oracle.al", (Object)SessionState.unauthenticatedSession(startPath, realm, preLogon)).build();
            redirect.session((AssociativeArray<String, Object>)session);
        }
        if (message == null) {
            message = realm.message();
        }
        if (message != null) {
            preLogon.signOnMessage((Iterable<Locale>)((Object)LocalePreference.preference(request)), message);
        }
        return redirect;
    }

    private static PreLogonState preLogonState(RequestEntity request) {
        Serializable state;
        PreLogonState preLogon = null;
        SessionState sessionState = SessionState.session(request);
        if (sessionState != null && (state = sessionState.state()) instanceof PreLogonState) {
            preLogon = (PreLogonState)state;
        }
        return preLogon;
    }
}

