/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.auth.AuthenticationStatus;
import oracle.dbtools.common.HTMLTranslatable;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.AnonymousPrincipal;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.AuthenticationService;
import oracle.dbtools.rt.authentication.LogonFormCredentials;
import oracle.dbtools.rt.authentication.PreLogonState;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.authorization.RoleMappers;
import oracle.dbtools.rt.session.ServletSessionPrincipal;
import oracle.dbtools.rt.session.SessionState;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.uri.URITemplates;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestPaths;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.SecurityConstraint;
import oracle.dbtools.rt.web.WebException;

public enum LogonRealm implements Serializable
{
    NONE("no", "", null, new String[0]),
    OAUTH_APPROVALS("oa", null, (Translatable)Messages.access$000(), new String[0]),
    OAUTH_CLIENTS("oc", "ui/oauth2/clients/", (Translatable)Messages.access$100(), "OAuth Client Developer");

    private final String defaultStartPath;
    private final String id;
    private final Translatable message;
    private final Iterable<String> requiredRoles;
    private final SecurityConfig securityConfig;
    private static final Map<String, LogonRealm> BY_ID;
    private static URITemplate LOGGED_OFF;
    private static URITemplate LOGOFF;
    private static URITemplate LOGON;
    private static URITemplate LOGON_CHECK;
    private static final HTMLTranslatable.Builder LOGON_FAILED;
    private static final URITemplate PATH_TEMPLATE;

    private LogonRealm(String id, String defaultStartPath, Translatable message, String ... requiredRoles) {
        this.id = id;
        this.defaultStartPath = defaultStartPath;
        this.message = message;
        this.requiredRoles = Iterables.iterable((Object[])requiredRoles);
        this.securityConfig = new SecurityConfig(SecurityConstraint.SECURE_AND_AUTHENTICATED, AuthenticationRealm.SESSION, this);
    }

    public AuthenticationStatus authorize(CompoundPrincipal principal) {
        if (NullOrEmpty.nullOrEmpty(this.requiredRoles)) {
            return AuthenticationStatus.VALID;
        }
        RoleMappers roleMapper = (RoleMappers)ServiceLocator.acquire(RoleMappers.class);
        for (String requiredRole : this.requiredRoles) {
            if (!roleMapper.isPrincipalInRole(principal, requiredRole)) continue;
            return AuthenticationStatus.VALID;
        }
        return AuthenticationStatus.NOT_AUTHORIZED;
    }

    public String id() {
        return this.id;
    }

    public WebException logoff(RequestEntity request) {
        if (NONE == this) {
            return WebException.badRequest(new Reason[0]);
        }
        SessionState session = SessionState.session(request);
        if (session == null) {
            if (this.defaultStartPath == null) {
                return RedirectException.temporaryRedirect(request.base());
            }
            return RedirectException.temporaryRedirect(this.defaultStartPath);
        }
        if (!session.authenticated()) {
            return RedirectException.temporaryRedirect(session.startPath());
        }
        String startPath = session.startPath();
        RedirectException redirect = RedirectException.temporaryRedirect(LOGGED_OFF.encode("id", this.id));
        Requests.invalidateSession(request);
        return PreLogonState.preLogonState(request, redirect, this, startPath, null);
    }

    public WebException logon(RequestEntity request) {
        if (NONE == this) {
            return WebException.badRequest(new Reason[0]);
        }
        AuthenticationService auth = (AuthenticationService)ServiceLocator.acquire(AuthenticationService.class);
        String referrer = SessionState.removeAuthenticationForceFlag(this.referrer(request));
        SecurityConfig securityConfig = new SecurityConfig(SecurityConstraint.SECURE, AuthenticationRealm.LOGON, this);
        LogonFormCredentials cb = new LogonFormCredentials(request);
        AuthenticationResult result = auth.authenticate(securityConfig, cb);
        if (result.isValid() && LogonRealm.hasUserPrincipal((Iterable<Principal>)result)) {
            return this.logonSuccessful((Iterable<Principal>)result, referrer);
        }
        return this.notAuthorized(request, result.status());
    }

    public WebException notAuthorized(RequestEntity request, AuthenticationStatus authStatus) {
        if (NONE == this) {
            return WebException.notAuthorized();
        }
        Translatable msg = null;
        String startPath = this.defaultStartPath;
        switch (authStatus) {
            case VALID: {
                msg = this.message;
                break;
            }
            case INVALID: 
            case NOT_AUTHORIZED: {
                msg = this.logonFailedMessage();
                break;
            }
        }
        String path = request.path();
        if (HttpMethod.GET.equals(request.method()) && !LOGON.matches(path) && !LOGOFF.matches(path) && !LOGGED_OFF.matches(path)) {
            startPath = path;
        }
        RedirectException redirect = RedirectException.temporaryRedirect(LOGON.encode("id", this.id));
        PreLogonState.preLogonState(request, redirect, this, startPath, msg);
        return redirect;
    }

    public SecurityConfig securityConfig() {
        return this.securityConfig;
    }

    String defaultStartPath() {
        return this.defaultStartPath;
    }

    Translatable message() {
        return this.message;
    }

    private HTMLTranslatable logonFailedMessage() {
        TranslatableMessage text = new TranslatableMessage(ResourceTemplateMessages.class, "LogonRealm.0", "Invalid Login Credentials", new Object[0]);
        return LOGON_FAILED.text((Translatable)text).build();
    }

    private WebException logonSuccessful(Iterable<Principal> principals, String referrer) {
        return RedirectException.temporaryRedirect(referrer).session(this.session(principals));
    }

    private String referrer(RequestEntity request) {
        String referrer = request.base();
        String text = SessionState.startPath(request);
        if (text != null) {
            referrer = text;
        }
        String relativePath = URIs.relativeTo((String)request.base(), (String)referrer);
        return relativePath;
    }

    private AssociativeArray<String, Object> session(Iterable<Principal> principals) {
        LinkedHashMap<String, Serializable> session = new LinkedHashMap<String, Serializable>();
        for (Principal principal : principals) {
            if (!(principal instanceof ServletSessionPrincipal)) continue;
            ServletSessionPrincipal p = (ServletSessionPrincipal)principal;
            session.put(p.getAttributeName(), p.getValue());
        }
        return AssociativeArrays.fromMap(session);
    }

    public static boolean hasUserPrincipal(Iterable<Principal> principals) {
        boolean hasPrincipal;
        boolean bl = hasPrincipal = !NullOrEmpty.nullOrEmpty(principals);
        if (hasPrincipal) {
            Principal p = (Principal)Iterables.first(principals);
            hasPrincipal = !(p instanceof AnonymousPrincipal);
        }
        return hasPrincipal;
    }

    public static LogonRealm realm(RequestPaths request) {
        String path = request.path();
        Map<String, String> params = PATH_TEMPLATE.decode(path);
        String id = params.get("id");
        if (id != null) {
            return LogonRealm.realm(id);
        }
        return NONE;
    }

    public static LogonRealm realm(String id) {
        LogonRealm realm = BY_ID.get(id);
        if (realm == null) {
            return NONE;
        }
        return realm;
    }

    static URITemplate loggedOffTemplate() {
        return LOGGED_OFF;
    }

    static URITemplate logoffTemplate() {
        return LOGOFF;
    }

    static URITemplate logonCheckTemplate() {
        return LOGON_CHECK;
    }

    static URITemplate logonTemplate() {
        return LOGON;
    }

    private static URITemplate realmTemplate(String path) {
        return URITemplates.uriTemplate(path + "?r={id}");
    }

    static {
        BY_ID = new HashMap<String, LogonRealm>(LogonRealm.values().length);
        LOGGED_OFF = LogonRealm.realmTemplate("signed-out");
        LOGOFF = LogonRealm.realmTemplate("sign-out");
        LOGON = LogonRealm.realmTemplate("sign-on");
        LOGON_CHECK = LogonRealm.realmTemplate("sign-on-check");
        LOGON_FAILED = HTMLTranslatable.builder().prefix((CharSequence)"<div class='ui-state-error ui-corner-all'><p><span style='float: left; margin-right: .7em;' class='ui-icon ui-icon-alert'></span>").suffix((CharSequence)"</p></div>");
        PATH_TEMPLATE = LogonRealm.realmTemplate("{path}");
        for (LogonRealm realm : LogonRealm.values()) {
            BY_ID.put(realm.id, realm);
        }
    }

    private static class Messages {
        private static final TranslatableMessage APPROVE_ACCESS = new TranslatableMessage(ResourceTemplateMessages.class, "LogonRealm.2", "An application would like to access some of your data, sign in to review and approve access", new Object[0]);
        private static final HTMLTranslatable APPROVE_ACCESS_HTML = HTMLTranslatable.builder().prefix((CharSequence)"<div class='ui-state-highlight ui-corner-all'><p><span style='float: left; margin-right: .7em;' class='ui-icon ui-icon-info'></span>").text((Translatable)APPROVE_ACCESS).suffix((CharSequence)"</p></div>").build();
        private static final TranslatableMessage MANAGE_CLIENTS = new TranslatableMessage(ResourceTemplateMessages.class, "LogonRealm.3", "Sign in to manage your registered applications", new Object[0]);
        private static final HTMLTranslatable MANAGE_CLIENTS_HTML = HTMLTranslatable.builder().prefix((CharSequence)"<div class='ui-state-highlight ui-corner-all'><p><span style='float: left; margin-right: .7em;' class='ui-icon ui-icon-info'></span>").text((Translatable)MANAGE_CLIENTS).suffix((CharSequence)"</p></div>").build();

        private Messages() {
        }

        static /* synthetic */ HTMLTranslatable access$000() {
            return APPROVE_ACCESS_HTML;
        }

        static /* synthetic */ HTMLTranslatable access$100() {
            return MANAGE_CLIENTS_HTML;
        }
    }
}

