/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.io.Serializable;
import java.util.Map;
import oracle.dbtools.auth.AuthenticationStatus;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.authentication.LogonRealm;
import oracle.dbtools.rt.authentication.PreLogonState;
import oracle.dbtools.rt.authentication.SecurityConfigs;
import oracle.dbtools.rt.session.SessionState;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.TemplateRequestHandler;
import oracle.dbtools.rt.web.TemplateResourceGenerator;

@Service(provides={ResourceDispatcher.class})
public class LogonFormHandler
extends TemplateRequestHandler {
    private static final RequestHandlerMetaData META_DATA = RequestHandlerMetaData.builder(LogonRealm.logonTemplate(), HttpMethod.GET).securityConfig(SecurityConfigs.SECURE).build();
    private static final TemplateResourceGenerator TEMPLATE = TemplateResourceGenerator.templateFromUrl((CharSequence)((Object)ContentTypes.HTML), "sign-on.html", "sign-on-message");

    public LogonFormHandler() {
        super(META_DATA, TEMPLATE);
    }

    @Override
    protected Map<String, String> values(RequestEntity request) {
        LogonRealm realm = LogonRealm.realm(request);
        SessionState sessionState = SessionState.session(request);
        if (sessionState == null) {
            throw realm.notAuthorized(request, AuthenticationStatus.UNKNOWN);
        }
        Map<String, String> values = META_DATA.uriTemplate().decode(request.path());
        values.put("base", request.base());
        values.put("logon-realm", realm.id());
        values.put("csrf-token", sessionState.csrfToken());
        Serializable state = sessionState.state();
        if (state instanceof PreLogonState) {
            PreLogonState preLogon = (PreLogonState)state;
            values.put("sign-on-message", this.spacer(preLogon.signOnMessage()));
        } else {
            values.put("sign-on-message", "");
        }
        return values;
    }

    private String spacer(String msg) {
        StringBuilder b = new StringBuilder();
        if (!NullOrEmpty.nullOrEmpty((CharSequence)msg)) {
            b.append("<div>&nbsp;");
            b.append(msg);
            b.append("&nbsp;</div>");
        }
        return b.toString();
    }
}

