/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt;

import java.io.IOException;
import java.security.Principal;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.ecid.ECIDPrincipal;
import oracle.dbtools.common.identifiers.SchemaIdentifier;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.dispatch.DispatchScore;
import oracle.dbtools.http.auth.RequestAuthorization;
import oracle.dbtools.http.cors.CrossOriginSharingConsraints;
import oracle.dbtools.http.ecid.ECIDs;
import oracle.dbtools.http.errors.InternalServerException;
import oracle.dbtools.http.errors.ServletResponseException;
import oracle.dbtools.http.resource.pagination.PaginatedRequests;
import oracle.dbtools.http.servlet.DispatchableServlet;
import oracle.dbtools.http.servlet.DispatchableServletBase;
import oracle.dbtools.http.servlet.HttpRequests;
import oracle.dbtools.listener.icap.InfectedFileException;
import oracle.dbtools.listener.icap.UnavailableException;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.http.annotations.CrossOriginSharingPolicy;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.ApexWorkspaceTenantPrincipal;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.ResourceTemplatesException;
import oracle.dbtools.rt.ServletResponses;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.ETags;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestDispatchers;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.WebException;

@Provides
public class ResourceTemplatesServlet
extends DispatchableServletBase
implements DispatchableServlet {
    private final ECIDs ecids;
    private final SchemaIdentifier schemaId;
    private static final long serialVersionUID = 5420847081939300971L;

    @Inject
    ResourceTemplatesServlet(HttpRequests requests, RequestAuthorization auth, PaginatedRequests pagination, ECIDs ecids, @Named(value="apex") SchemaIdentifier schemaId) {
        super(requests, auth, pagination);
        this.schemaId = schemaId;
        this.ecids = ecids;
    }

    public DispatchScore canDispatch(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        try {
            RequestEntity req = this.request(httpRequest);
            ResourceDispatcher.Score score = this.choose(req);
            if (ResourceDispatcher.NO_MATCH.equals(score)) {
                return DispatchScore.CANNOT_DISPATCH;
            }
            return new ResourceTemplatesScore(score);
        }
        catch (Throwable t) {
            throw new InternalServerException(t, new oracle.dbtools.http.errors.Reason[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        ServletResponses response = new ServletResponses(this.getServletContext(), resp);
        try {
            this.restfulServices(request, response);
        }
        catch (WebException e) {
            throw this.adapt(e);
        }
    }

    private ServletResponseException adapt(WebException e) {
        return new ResourceTemplatesException(e);
    }

    private HttpServletRequest addEcidPrincipal(HttpServletRequest request, String ecid) {
        if (ecid != null) {
            return (HttpServletRequest)this.requests.modify(request).addAttribute("ECID-Principal", (Object)new ECIDPrincipal(ecid)).build();
        }
        return request;
    }

    private ResourceDispatcher.Score choose(RequestEntity request) throws IOException {
        ResourceDispatcher.Score score = this.dispatchers().canDispatch(request);
        return score;
    }

    private final RequestDispatchers dispatchers() {
        return (RequestDispatchers)ServiceLocator.acquire(RequestDispatchers.class);
    }

    private RequestEntity request(HttpServletRequest request) throws IOException {
        String ecid = this.ecids.ecid(request);
        request = this.addEcidPrincipal(request, ecid);
        RequestEntity req = Requests.request(request);
        req = Requests.replacePrincipal(req, new ApexWorkspaceTenantPrincipal(this.schemaId), TenantPrincipal.class);
        req = Requests.replacePrincipal(req, (Principal)new ECIDPrincipal(ecid), ECIDPrincipal.class);
        return req;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restfulServices(HttpServletRequest request, ServletResponses response) throws IOException, ServletException {
        ResourceDispatcher.Score score = this.score(request);
        ETags etags = new ETags();
        Entity res = null;
        RequestEntity req = null;
        try {
            req = this.request(request);
            HttpResource httpResponse = etags.checkPrecondition(score, req, this.dispatchers());
            res = httpResponse.response(req);
            response.sendResponse(req.path(), res);
        }
        catch (URIs.IllegalURIException e) {
            try {
                throw WebException.badRequest(Reason.reason("uri", e.getTranslatableMessage())).cause(e);
                catch (JDBCException e2) {
                    throw ResourceTemplatesServlet.checkForDbLimitExceeded(e2);
                }
                catch (ConnectionPoolException e3) {
                    throw WebException.serviceUnavailable().cause(e3);
                }
                catch (InfectedFileException e4) {
                    throw WebException.badRequest(Reason.reason("request.body", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "HttpEndpointBase.0", "Content is infected", new Object[0]))).cause(e4);
                }
                catch (UnavailableException e5) {
                    throw WebException.serviceUnavailable().cause(e5).reasons(Reason.reason("cause", e5.getTranslatableMessage()));
                }
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new Object[]{req, res});
                throw throwable;
            }
        }
        Closeables.close((Object[])new Object[]{req, res});
    }

    private ResourceDispatcher.Score score(HttpServletRequest request) {
        ResourceTemplatesScore score = (ResourceTemplatesScore)request.getAttribute("oracle.dbtools.http.servlet.dispatch.score");
        return score.score;
    }

    private static RuntimeException checkForDbLimitExceeded(JDBCException e) {
        if (JDBCException.Kind.LIMIT_EXCEEDED == e.kind()) {
            Reason reason = Reason.reason("db.limit", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "HttpEndpointBase.2", "This request exceeded a database limit", new Object[0]));
            return WebException.serviceUnavailable().cause(e).reasons(reason);
        }
        return e;
    }

    private static class ResourceTemplatesScore
    implements DispatchScore,
    CrossOriginSharingConsraints {
        private final ResourceDispatcher.Score score;

        public ResourceTemplatesScore(ResourceDispatcher.Score score) {
            this.score = score;
        }

        public Iterable<String> allowedOrigins() {
            return this.score.originsAllowed();
        }

        public CrossOriginSharingPolicy policy() {
            return this.score.isCorsEnabled() ? CrossOriginSharingPolicy.ALLOW : CrossOriginSharingPolicy.DENY;
        }

        public int score() {
            return this.score.score();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ResourceTemplatesScore [score=");
            builder.append(this.score);
            builder.append("]");
            return builder.toString();
        }
    }
}

