/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.dbtools.auth.challenges.Challenges;
import oracle.dbtools.common.locale.LocalePreference;
import oracle.dbtools.common.locale.LocalePreferences;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.http.HttpHeader;
import oracle.dbtools.http.errors.ServletResponseException;
import oracle.dbtools.http.servlet.UriRequest;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.plugin.api.security.AuthenticationChallenge;
import oracle.dbtools.rt.authentication.AuthenticationException;
import oracle.dbtools.rt.web.HasSessionAttributes;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.WebException;

class ResourceTemplatesException
extends ServletResponseException {
    private final AuthenticationChallenge challenge;
    private final String redirectLocation;
    private final AssociativeArray<String, Object> session;
    private static final long serialVersionUID = 22594325184309882L;

    ResourceTemplatesException(WebException cause) {
        super(cause.statusCode().statusCode(), (Throwable)cause, ResourceTemplatesException.adapt(cause.reasons()));
        this.challenge = cause instanceof AuthenticationException ? ((AuthenticationException)cause).challenge() : null;
        if (cause instanceof RedirectException) {
            this.session = ((HasSessionAttributes)((Object)cause)).session();
            this.redirectLocation = ((RedirectException)cause).redirectLocation();
        } else {
            this.session = null;
            this.redirectLocation = null;
        }
    }

    public boolean service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        LocalePreference localePreference = LocalePreferences.INSTANCE.preference(req);
        if (this.challenge != null && !Challenges.NO_CHALLENGE.equals(this.challenge)) {
            resp.setHeader(HttpHeader.WWW_AUTHENTICATE.text(), this.challenge.toString((Iterable)localePreference));
        }
        if (this.redirectLocation != null) {
            UriRequest uri = UriRequest.uriRequest((HttpServletRequest)req);
            String absUri = URIs.resolve((URI)uri.getBaseURI(), (String)this.redirectLocation).toASCIIString();
            resp.setHeader(HttpHeader.LOCATION.text(), absUri);
        }
        if (this.session != null) {
            HttpSession existing = req.getSession(false);
            if (existing != null) {
                existing.invalidate();
            }
            HttpSession httpSession = req.getSession(true);
            for (String name : this.session) {
                Object value = this.session.get((Object)name);
                httpSession.setAttribute(name, value);
            }
        }
        return super.service(request, response);
    }

    private static Iterable<oracle.dbtools.http.errors.Reason> adapt(Iterable<Reason> reasons) {
        ArrayList<oracle.dbtools.http.errors.Reason> adapted = new ArrayList<oracle.dbtools.http.errors.Reason>();
        for (Reason reason : reasons) {
            adapted.add(oracle.dbtools.http.errors.Reason.reason((String)reason.target(), (Translatable)reason.reason()));
        }
        return adapted;
    }
}

