/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.net.URL;
import oracle.ide.model.Project;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Namespace;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.cmd.NewEmptyProjectCommand;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.wizard.project.ProjectWizardKeys;

public class WizardApplyHandler
implements ProjectWizardKeys {
    public static void applyWizardChanges(Project project, Namespace wizardData, Workspace workspace) {
        JProjectLibraries newLibs;
        JProjectLibraries libs;
        String defPkg = !wizardData.contains("DefaultPackage") ? JavaProject.generateDefaultPackageName(project) : (String)wizardData.get("DefaultPackage");
        NewEmptyProjectCommand.setProjectPackage(defPkg, project, workspace);
        URLPath srcPath = (URLPath)wizardData.get("ProjectSourcePath");
        if (srcPath != null) {
            PathsConfiguration.getInstance((Project)project).setProjectSourcePath(srcPath);
        } else if (WizardApplyHandler.projectUsesMaven(project) && wizardData.contains("DefaultProjectSourcePath")) {
            URLPath defaultSourcePath = (URLPath)wizardData.get("DefaultProjectSourcePath");
            PathsConfiguration.getInstance((Project)project).setProjectSourcePath(defaultSourcePath);
        }
        URL url = (URL)wizardData.get("HtmlRootDir");
        if (url != null) {
            J2eeSettings.getInstance((Project)project).setHtmlRootDirectory(url);
        }
        if ((url = (URL)wizardData.get("OutputDirectory")) != null) {
            url = URLFileSystem.canonicalize((URL)url);
            JProjectUtil.setOutputDirectory(project, url);
        }
        if ((libs = (JProjectLibraries)wizardData.get("oracle.jdevimpl.config.JProjectLibraries")) != null && (newLibs = JProjectLibraries.getInstance((PropertyStorage)project)) != null) {
            libs.copyTo((Object)newLibs);
        }
    }

    private static boolean projectUsesMaven(Project project) {
        TechnologyScopeConfiguration tsc = TechnologyScopeConfiguration.getInstance((PropertyStorage)project);
        TechnologyScope techScope = tsc.getTechnologyScope();
        TechnologyRegistry registry = TechnologyRegistry.getInstance();
        TechId mavenTechId = registry.getTechId("Maven");
        return mavenTechId != null && techScope.contains(mavenTechId);
    }
}

