/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.usage;

import java.net.URL;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.usage.event.ClassUsageEvent;
import oracle.jdeveloper.usage.event.ClassUsageListener;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdeveloper.usage.event.UsageListener;
import oracle.jdevimpl.java.usage.BaseUsageQuery;

class ClassUsageQuery
extends BaseUsageQuery {
    private final String targetClassName;

    ClassUsageQuery(URL url, UsageListener listener, int[] startLocations, int[] endLocations, String fqClassName) {
        super(url, listener, startLocations, endLocations);
        this.targetClassName = fqClassName;
    }

    @Override
    protected boolean match(JavaElement element) {
        JavaType type = (JavaType)element;
        String typeName = type.getRawName();
        int bracketIndex = typeName.indexOf(91);
        if (bracketIndex >= 0) {
            typeName = typeName.substring(0, bracketIndex);
        }
        return typeName.equals(this.targetClassName);
    }

    @Override
    protected UsageEvent generateUsageEvent(int category, int startOffset, int endOffset) {
        UsageEvent lastEvent;
        ClassUsageEvent event = new ClassUsageEvent(null, category, this.getURL(), startOffset, endOffset);
        boolean swallowEvent = false;
        if (category == 103 && (lastEvent = this.getLastEvent()) != null && lastEvent.getUsageCode() == 112 && startOffset == lastEvent.getStartOffset() && endOffset == lastEvent.getEndOffset()) {
            swallowEvent = true;
        }
        if (swallowEvent) {
            return null;
        }
        ClassUsageListener listener = (ClassUsageListener)this.getListener();
        listener.notifyClassUsage(event);
        return event;
    }

    public void declareClass(SourceClass s) {
        this.processCandidate((SourceElement)s, (JavaElement)s, 102);
    }

    public void declareTypeParameter(SourceTypeParameter s) {
    }

    public void useTypeInAnnotation(SourceAnnotation s, JavaType type) {
        this.processCandidate((SourceElement)s, (JavaElement)type, 110);
    }

    public void useTypeInDocComment(SourceDocReference s, JavaType type) {
        this.processCandidate((SourceElement)s, (JavaElement)type, 110);
    }

    public void useTypeInExpression(SourceExpression s, JavaType type) {
        this.processCandidate((SourceElement)s, (JavaElement)type, 110);
    }

    public void useTypeInClassExtends(SourceTypeReference s, JavaType type) {
        if (type.isInterface()) {
            this.processCandidate((SourceElement)s, (JavaElement)type, 104);
        } else {
            this.processCandidate((SourceElement)s, (JavaElement)type, 103);
        }
    }

    public void useTypeInFieldDecl(SourceTypeReference s, JavaType type) {
        this.processCandidate((SourceElement)s, (JavaElement)type, 108);
    }

    public void useTypeInInstanceof(SourceTypeReference s, JavaType type) {
        this.processCandidate((SourceElement)s, (JavaElement)type, 113);
    }

    public void useTypeInLocalVariableDecl(SourceTypeReference s, JavaType type) {
        this.processCandidate((SourceElement)s, (JavaElement)type, 109);
    }

    public void useTypeInMiscellaneous(SourceTypeReference s, JavaType type) {
        this.processCandidate((SourceElement)s, (JavaElement)type, 110);
    }

    public void useTypeInNarrowImport(SourceImport s, JavaType type) {
        this.processCandidate((SourceElement)s, (JavaElement)type, 101);
    }

    public void useTypeInCreator(SourceTypeReference s, JavaType type) {
        this.processCandidate((SourceElement)s, (JavaElement)type, 112);
    }

    public void useTypeInParameter(SourceTypeReference s, JavaType type) {
        this.processCandidate((SourceElement)s, (JavaElement)type, 106);
    }

    public void useTypeInReturnType(SourceTypeReference s, JavaType type) {
        this.processCandidate((SourceElement)s, (JavaElement)type, 105);
    }

    public void useTypeInThrows(SourceTypeReference s, JavaType type) {
        this.processCandidate((SourceElement)s, (JavaElement)type, 107);
    }

    public void useTypeInTypecast(SourceTypeReference s, JavaType type) {
        this.processCandidate((SourceElement)s, (JavaElement)type, 111);
    }
}

