/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.jdeveloper.cmt.CmtEvent;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.engine.MethodInfo;
import oracle.jdeveloper.java.legacy.Jot2Utils;
import oracle.jdeveloper.uieditor.UIEditorOptions;
import oracle.jdevimpl.cmtimpl.JbEvent;
import oracle.jdevimpl.cmtimpl.JbEventSet;
import oracle.jdevimpl.cmtimpl.JbInnerEventAdapter;
import oracle.jdevimpl.cmtimpl.JbNamedEventAdapter;
import oracle.jdevimpl.cmtimpl.JbPropertySetting;
import oracle.jdevimpl.cmtimpl.JbSubcomponent;

class JbEventAdapter {
    private static final int ANONYMOUS_INNER_ADAPTER_TYPE = 1;
    private static final int NAMED_CLASS_ADAPTER_TYPE = 2;
    JbEventSet eventSet;
    JbSubcomponent subcomponent;
    SourceClass clazz;
    JbPropertySetting ps;
    protected String[] settings;

    JbEventAdapter(JbSubcomponent subcomponent, JbEventSet eventSet, JbPropertySetting ps) {
        this.subcomponent = subcomponent;
        this.eventSet = eventSet;
        this.ps = ps;
    }

    String getName() {
        return "<noname>";
    }

    String getDelegate() {
        return null;
    }

    String getEventSetting(int index) {
        if (this.settings == null && this.clazz != null) {
            this.buildSettings();
        }
        String setting = this.settings != null ? this.settings[index] : null;
        return setting;
    }

    void createAdapterClass() {
    }

    void removeAdapterClass() {
    }

    void addEventSetting(JbEvent event, String valueText) {
        SourceMethod method;
        Collection collection;
        JavaType[] types;
        if (this.clazz == null) {
            this.createAdapterClass();
        }
        if ((types = new JavaType[(collection = Jot2Utils.getParameterTypes(event.listener)) != null ? collection.size() : 0]).length > 0) {
            collection.toArray(types);
        }
        if ((method = this.clazz.getSourceMethod(event.listener.getName(), types)) == null) {
            Iterator cIter;
            SourceFile jFile = this.clazz.getOwningSourceFile();
            MethodInfo mi = new MethodInfo("void", event.getName(), 1);
            this.buildCrackedParameterList(event.listener, mi);
            method = mi.createSourceMethod(jFile, true);
            this.clazz.getSourceMethods().add(method);
            collection = event.listener.getExceptions();
            Iterator iterator = cIter = collection != null ? collection.iterator() : null;
            if (cIter != null) {
                collection = method.getExceptions();
                while (cIter.hasNext()) {
                    collection.add((JavaType)cIter.next());
                }
            }
        }
        String delegate = this.getDelegate();
        String callText = (delegate != null ? delegate + "." : "") + valueText;
        SourceFile jFile = this.clazz.getOwningSourceFile();
        SourceFactory jFactory = jFile.getFactory();
        SourceExpression jExpr = jFactory.createExpression(callText + "(" + this.buildCrackedParameterList(event.listener, null) + ")");
        SourceExpressionStatement jStmt = jFactory.createExpressionStatement(jExpr);
        SourceBlock jBlock = method.getBlock();
        List list = jBlock.getCodeElements();
        SourceExpression[] calls = Jot2Utils.getMethodCalls(jBlock, null);
        if (calls.length > 0) {
            SourceExpressionStatement elem = Jot2Utils.getEnclosingStatement(calls[0]);
            int index = list.indexOf(elem);
            this.removeOrphanMethod(calls[0]);
            list.add(++index, jStmt);
            elem.removeSelf();
        } else {
            list.add(jStmt);
        }
        this.generateStub(event, valueText);
        if (this.settings == null) {
            this.settings = new String[this.eventSet.getEventCount()];
        }
        int index = this.eventSet.getEventIndex(event);
        this.settings[index] = valueText;
    }

    boolean weMadeAdapterClass() {
        return this.eventSet.getAdapterClass() == null;
    }

    void removeEventSetting(JbEvent event) {
        Iterator mIter;
        String eventName = event.getName();
        Collection methods = Jot2Utils.getDeclaredMethods((JavaClass)this.clazz, eventName);
        Iterator iterator = mIter = methods != null ? methods.iterator() : null;
        if (mIter != null && mIter.hasNext()) {
            this.buildSettings();
            int index = this.eventSet.getEventIndex(event);
            this.settings[index] = null;
            SourceMethod method = (SourceMethod)mIter.next();
            SourceBlock body = method.getBlock();
            SourceExpression[] calls = Jot2Utils.getMethodCalls(body, null);
            this.removeOrphanMethod(calls[0]);
            if (this.weMadeAdapterClass()) {
                body.getCodeElements().clear();
            } else {
                method.removeSelf();
            }
        }
        boolean atLeastOneSetting = false;
        for (int i = 0; i < this.settings.length; ++i) {
            if (this.settings[i] == null) continue;
            atLeastOneSetting = true;
            break;
        }
        if (!atLeastOneSetting) {
            this.removeAdapterClass();
        }
    }

    void removeOrphanMethod(SourceExpression jExpr) {
        Iterator mIter;
        if (!(jExpr instanceof SourceMethodCallExpression)) {
            return;
        }
        SourceMethodCallExpression jCall = (SourceMethodCallExpression)jExpr;
        SourceClass outerClass = (SourceClass)this.subcomponent.getOuterComponent().getType();
        Collection methods = Jot2Utils.getDeclaredMethods((JavaClass)outerClass, jCall.getName());
        Iterator iterator = mIter = methods != null ? methods.iterator() : null;
        if (mIter != null && mIter.hasNext()) {
            List list;
            SourceMethod method = (SourceMethod)mIter.next();
            SourceBlock body = method.getBlock();
            List list2 = list = body != null ? body.getCodeElements() : null;
            if (list == null || list.size() == 0) {
                method.removeSelf();
            }
        }
    }

    void buildSettings() {
        this.settings = new String[this.eventSet.getEventCount()];
        if (this.clazz != null) {
            Iterator mIter;
            List methods = this.clazz.getSourceMethods();
            Iterator iterator = mIter = methods != null ? methods.iterator() : null;
            if (mIter != null) {
                while (mIter.hasNext()) {
                    SourceMethod method = (SourceMethod)mIter.next();
                    SourceBlock body = method.getBlock();
                    SourceExpression[] calls = Jot2Utils.getMethodCalls(body, null);
                    if (calls.length <= 0 || !(calls[0] instanceof SourceMethodCallExpression)) continue;
                    JbEvent event = (JbEvent)this.eventSet.getEvent(method.getName());
                    int index = this.eventSet.getEventIndex(event);
                    this.settings[index] = ((SourceMethodCallExpression)calls[0]).getName();
                }
            }
        }
    }

    String uniqueParameterName(String[] paramDecls, String[] paramNames, int index) {
        String paramName = paramDecls[index];
        StringBuffer fsb = new StringBuffer(paramName);
        fsb.setCharAt(0, Character.toLowerCase(fsb.charAt(0)));
        String name = paramName = fsb.toString();
        for (int i = 1; i < 99; ++i) {
            int j;
            for (j = 0; j <= index && !name.equals(paramDecls[j]) && !name.equals(paramNames[j]); ++j) {
            }
            if (j > index) {
                return name;
            }
            name = paramName + Integer.toString(i);
        }
        return null;
    }

    void generateStub(CmtEvent event, String valueText) {
        JavaClass jCls;
        SourceMethod method;
        JavaMethod listener = event.getListenerMethod();
        Collection collection = Jot2Utils.getParameterTypes(listener);
        JavaType[] types = new JavaType[collection != null ? collection.size() : 0];
        if (types.length > 0) {
            collection.toArray(types);
        }
        if ((method = (SourceMethod)(jCls = this.subcomponent.getOuterComponent().getType()).getDeclaredMethod(valueText, types)) == null) {
            Iterator cIter;
            MethodInfo mi = new MethodInfo("void", valueText, 0);
            SourceFile jFile = this.clazz.getOwningSourceFile();
            SourceClass jClass = jCls.getSourceElement();
            this.buildCrackedParameterList(listener, mi);
            method = mi.createSourceMethod(jFile, true);
            jClass.getSourceMethods().add(method);
            collection = listener.getExceptions();
            Iterator iterator = cIter = collection != null ? collection.iterator() : null;
            if (cIter != null && cIter.hasNext()) {
                collection = method.getExceptions();
                while (cIter.hasNext()) {
                    collection.add((JavaType)cIter.next());
                }
            }
            if (this.getDelegate() == null) {
                method.setModifiers(2);
            }
        }
    }

    final String buildCrackedParameterList(JavaMethod source, MethodInfo target) {
        Iterator pIter;
        JavaClass clsCls = this.eventSet.getListenerType();
        if (clsCls == null) {
            clsCls = this.eventSet.getAdapterClass();
        }
        SourceClass srcCls = this.subcomponent.getComponent().getComponents().getPackages().getSourceClass(clsCls.getQualifiedName());
        Collection params = null;
        if (srcCls != null) {
            Collection collection = Jot2Utils.getParameterTypes(source);
            JavaType[] argTypes = collection != null ? collection.toArray(new JavaType[collection.size()]) : new JavaType[]{};
            SourceMethod m = srcCls.getSourceMethod(source.getName(), argTypes);
            if (m != null) {
                params = m.getParameters();
            }
        }
        if (params == null) {
            params = source.getParameters();
        }
        JavaClass eventClass = this.subcomponent.getComponent().getComponents().getPackages().getClass("java.util.EventObject");
        int paramCount = params != null ? params.size() : 0;
        Iterator iterator = pIter = paramCount > 0 ? params.iterator() : null;
        if (pIter != null && paramCount == 1) {
            String strType;
            JavaVariable jVar = (JavaVariable)pIter.next();
            JavaType jType = jVar != null ? jVar.getResolvedType() : null;
            String string = strType = jType != null ? jType.getQualifiedName() : "";
            if (jType != null && eventClass.isAssignableFrom(jType)) {
                if (target != null) {
                    target.addParameter(strType, "e");
                    return strType + " e";
                }
                return "e";
            }
        }
        StringBuffer fsb = new StringBuffer();
        boolean needComma = false;
        Iterator iterator2 = pIter = paramCount > 0 ? params.iterator() : null;
        if (pIter != null) {
            String[] paramNames = new String[paramCount];
            String[] paramDecls = new String[paramCount];
            for (int i = 0; i < paramCount; ++i) {
                JavaVariable jVar = (JavaVariable)pIter.next();
                String string = paramNames[i] = jVar.getName() == null ? this.uniqueParameterName(paramDecls, paramNames, i) : jVar.getName();
                if (needComma) {
                    fsb.append(", ");
                }
                needComma = true;
                if (target != null) {
                    target.addParameter(paramDecls[i], paramNames[i]);
                    fsb.append(paramDecls[i] + " ");
                }
                fsb.append(paramNames[i]);
            }
        }
        return fsb.toString();
    }

    void initializeInterfaceMethods() {
        try {
            Iterator mIter;
            JavaClass jType = this.eventSet.getListenerType();
            JavaClass iface = this.subcomponent.getComponent().getComponents().getPackages().getClass(jType.getQualifiedName());
            if (iface == null) {
                return;
            }
            Collection methods = iface.getDeclaredMethods();
            Iterator iterator = mIter = methods != null ? methods.iterator() : null;
            if (mIter != null) {
                SourceFile jFile = this.clazz.getOwningSourceFile();
                List list = this.clazz.getSourceMethods();
                while (mIter.hasNext()) {
                    Iterator tIter;
                    JavaMethod jMethod = (JavaMethod)mIter.next();
                    JavaType returnType = jMethod.getReturnType();
                    String returnString = returnType == null ? "void" : returnType.getQualifiedName();
                    MethodInfo mi = new MethodInfo(returnString, jMethod.getName(), 1);
                    this.buildCrackedParameterList(jMethod, mi);
                    SourceMethod method = mi.createSourceMethod(jFile, true);
                    Collection thrown = jMethod.getExceptions();
                    Iterator iterator2 = tIter = thrown != null ? thrown.iterator() : null;
                    if (tIter != null) {
                        while (tIter.hasNext()) {
                            method.getExceptions().add(tIter.next());
                        }
                    }
                    list.add(method);
                }
            }
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
        }
    }

    private static final int adapterTypeForSubcomponent(JbSubcomponent subcomponent) {
        JbEventAdapter[] adapters = subcomponent.getEventAdapters();
        for (int i = 0; i < adapters.length; ++i) {
            if (adapters[i].eventSet != null && adapters[i].eventSet.adapterType != -1) {
                return adapters[i].eventSet.adapterType;
            }
            if (adapters[i].ps == null) continue;
            SourceClass jCls = JbInnerEventAdapter.getAnonymousClass(adapters[i].ps);
            if (jCls != null) {
                return 1;
            }
            return 2;
        }
        return -1;
    }

    private static final int findExistingAdapterType(JbSubcomponent subcomponent) {
        int adapterType = JbEventAdapter.adapterTypeForSubcomponent(subcomponent);
        if (adapterType != -1) {
            return adapterType;
        }
        CmtSubcomponent[] subs = subcomponent.getOuterComponent().getSubcomponents();
        for (int i = 0; i < subs.length; ++i) {
            if (subs[i] == subcomponent || (adapterType = JbEventAdapter.adapterTypeForSubcomponent((JbSubcomponent)subs[i])) == -1) continue;
            return adapterType;
        }
        return -1;
    }

    private static final int determineAdapterType(JbSubcomponent subcomponent, JbEventSet eventSet, JbPropertySetting ps) {
        int adapterType = eventSet.adapterType;
        if (adapterType != -1) {
            return adapterType;
        }
        if (ps == null) {
            IdeSettings settings = Ide.getSettings();
            UIEditorOptions options = (UIEditorOptions)((Object)settings.getData("UIEditorOptions"));
            boolean matchAdapterType = options.isMatchExistingCode();
            if (matchAdapterType) {
                adapterType = JbEventAdapter.findExistingAdapterType(subcomponent);
            }
            if (adapterType == -1) {
                boolean useAnonymousAdapterType = options.isUseAnonymousInnerClass();
                adapterType = useAnonymousAdapterType ? 1 : 2;
            }
        } else {
            SourceClass jCls = JbInnerEventAdapter.getAnonymousClass(ps);
            adapterType = jCls != null ? 1 : 2;
        }
        eventSet.adapterType = adapterType;
        return adapterType;
    }

    public static final JbEventAdapter newEventAdapter(JbSubcomponent subcomponent, JbEventSet eventSet, JbPropertySetting ps) {
        try {
            int adapterType = JbEventAdapter.determineAdapterType(subcomponent, eventSet, ps);
            switch (adapterType) {
                case 2: {
                    return new JbNamedEventAdapter(subcomponent, eventSet, ps);
                }
                case 1: {
                    return new JbInnerEventAdapter(subcomponent, eventSet, ps);
                }
            }
        }
        catch (Throwable t) {
            Assert.printStackTrace((Throwable)t);
        }
        return null;
    }
}

