/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.cls;

import java.awt.Component;
import java.awt.Image;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.resource.GalleryArb;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.builder.AbstractBuilder;
import oracle.jdeveloper.builder.AbstractBuilderModel;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.builder.cls.ClassBuilderPanel;
import oracle.jdeveloper.builder.cls.CreateClassHook;
import oracle.jdeveloper.builder.cls.CreateClassRedirector;
import oracle.jdeveloper.builder.cls.GeneratorElement;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public class ClassBuilder
extends AbstractBuilder {
    private boolean displayProgressOnFinish = true;

    public String getShortLabel() {
        return GalleryArb.getString((int)31);
    }

    public String getLongLabel() {
        return GalleryArb.getString((int)32);
    }

    @Override
    protected final AbstractBuilderModel _buildModel(Context context) {
        if (context == null || !(context.getProject() instanceof Project)) {
            throw new IllegalStateException();
        }
        return this._createModel(context);
    }

    protected ClassBuilderModel _createModel(Context context) {
        return new ClassBuilderModel(context);
    }

    protected BaliWizardPanel buildPanel(Context context, BaliWizardState state) {
        ClassBuilderPanel panel = new ClassBuilderPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, this._getHelpID());
        return panel;
    }

    protected JEWTDialog buildDialog(Context context, BaliWizardState state) {
        JEWTDialog dlg = super.buildDialog(context, state);
        ((ClassBuilderModel)state).setBuilderDialog(dlg);
        ((ClassBuilderModel)state).updateStoredBaseClasses();
        return dlg;
    }

    @Override
    protected String getHeaderDescription() {
        return BuilderArb.getString(6);
    }

    @Override
    protected String _getTitleString() {
        return BuilderArb.getString(46);
    }

    protected String _getHelpID() {
        return "f1_idednewclass_html";
    }

    protected Image getHeaderImage() {
        return OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/java.png"));
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"class.png");
    }

    protected void noDisplayProgressBarOnFinish() {
        this.displayProgressOnFinish = false;
    }

    protected void finish() {
        if (this.state != null) {
            BaliWizardState wizardState = this.state;
            if (this.redirectClassCreation(wizardState)) {
                return;
            }
            if (!this.displayProgressOnFinish) {
                wizardState.commitWizardState();
            } else {
                boolean taskRunningDialog = false;
                final CreateClassBuilderWorker worker = new CreateClassBuilderWorker(wizardState);
                worker.execute();
                boolean classCreationCompleted = false;
                try {
                    classCreationCompleted = (Boolean)worker.get(200L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    taskRunningDialog = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (taskRunningDialog) {
                    class WaitForWorkerRunnable
                    implements Runnable {
                        private ProgressBar _progressBar;

                        public WaitForWorkerRunnable(Component parent) {
                            String _title = "Creating...";
                            this._progressBar = new ProgressBar(parent, "Creating...", (Runnable)this, true);
                            this._progressBar.setCancelable(true);
                        }

                        public void start() {
                            this._progressBar.start(null, null);
                        }

                        @Override
                        public void run() {
                            try {
                                while (true) {
                                    Thread.sleep(100L);
                                    try {
                                        worker.get(100L, TimeUnit.MILLISECONDS);
                                    }
                                    catch (TimeoutException timeoutException) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (ExecutionException executionException) {
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            finally {
                                this._progressBar.setDoneStatus();
                            }
                        }
                    }
                    WaitForWorkerRunnable runner = new WaitForWorkerRunnable((Component)this._dlg);
                    runner.start();
                }
            }
        }
    }

    private boolean redirectClassCreation(BaliWizardState wizardState) {
        String superClassName;
        CreateClassRedirector r;
        ClassBuilderModel cbm;
        Object gen;
        if (wizardState instanceof ClassBuilderModel && (gen = (cbm = (ClassBuilderModel)wizardState).getModel().getSelectedItem()) instanceof GeneratorElement && (r = CreateClassHook.getRegisteredRedirector(superClassName = ((GeneratorElement)gen).getClassName())) != null) {
            return r.createClass(cbm);
        }
        return false;
    }

    private class CreateClassBuilderWorker
    extends SwingWorker<Boolean, String> {
        private BaliWizardState state;
        private Boolean isDone;

        public CreateClassBuilderWorker(BaliWizardState execCommitState) {
            this.state = execCommitState;
            this.isDone = false;
        }

        @Override
        protected Boolean doInBackground() {
            this.isDone = false;
            this.state.commitWizardState();
            this.isDone = true;
            return this.isDone;
        }
    }
}

