/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.awt.Rectangle;
import java.sql.CallableStatement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.ide.model.Project;
import oracle.ide.peek.Peek;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.plsql.old.PlsqlParser;
import oracle.javatools.parser.plsql.old.symbol.CodeBlockSymbol;
import oracle.javatools.parser.plsql.old.symbol.CompoundStatement;
import oracle.javatools.parser.plsql.old.symbol.FunctionSymbol;
import oracle.javatools.parser.plsql.old.symbol.NameSymbol;
import oracle.javatools.parser.plsql.old.symbol.PackageSymbol;
import oracle.javatools.parser.plsql.old.symbol.RootSymbol;
import oracle.javatools.parser.plsql.old.symbol.Statement;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeArb;
import oracle.jdevimpl.debugger.probe.DebugProbeDataArrayInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeLocation;
import oracle.jdevimpl.debugger.probe.DebugProbeValue;
import oracle.jdevimpl.debugger.probe.DebugProbeVariableContainer;
import oracle.jdevimpl.debugger.probe.DebugProbeVariableInfo;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugEvaluator;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

final class DebugProbeStackFrameInfo
extends DebugProbeVariableContainer
implements DebugStackFrameInfo {
    DebugProbe dp;
    boolean expired;
    int frameNumber;
    int probeFrameNumber;
    DebugProbeLocation location;
    private DebugProbeVariableInfo[] arguments;
    private DebugProbeVariableInfo[] locals;
    private String _sourceCode;
    private int _locationOffset = -1;

    DebugProbeStackFrameInfo(DebugProbe dp, int frameNumber, int probeFrameNumber) {
        this.dp = dp;
        this.frameNumber = frameNumber;
        this.probeFrameNumber = probeFrameNumber;
    }

    public boolean hasExpired() {
        return this.expired;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public DebugLocation getLocation() {
        return this.location;
    }

    public DebugVariableInfo[] listArguments() {
        this.lookForVariables();
        return this.arguments;
    }

    public DebugVariableInfo[] listLocals() {
        this.lookForVariables();
        return this.locals;
    }

    public DebugVariableInfo getVariable(String name) {
        DebugProbeValue dpv = this.dp.getVariableValue(this, name, null);
        if (dpv != null) {
            String type = this.figureOutVariableType(name);
            if (type != null) {
                dpv.setType(type);
            }
            return new DebugProbeVariableInfo(this.dp, this, name, dpv, false, false);
        }
        return null;
    }

    public DebugStackSlotInfo[] listSlots() {
        return new DebugStackSlotInfo[0];
    }

    public int getLanguage() {
        return 2;
    }

    public boolean popBackToHere() {
        return false;
    }

    void clear() {
        this.expired = true;
    }

    static String code(String varName) {
        StringBuffer sb = new StringBuffer();
        sb.append("  ? := " + varName + ".LibunitType;\n");
        sb.append("  ? := " + varName + ".Owner;\n");
        sb.append("  ? := " + varName + ".Name;\n");
        sb.append("  ? := " + varName + ".Line#;\n");
        sb.append("  ? := " + varName + ".EntrypointName;\n");
        return sb.toString();
    }

    static int registerParameters(CallableStatement cs, int index) throws Exception {
        cs.registerOutParameter(index++, 4);
        cs.registerOutParameter(index++, 12);
        cs.registerOutParameter(index++, 12);
        cs.registerOutParameter(index++, 4);
        cs.registerOutParameter(index++, 12);
        return index;
    }

    int getParameters(CallableStatement cs, int index) throws Exception {
        int piLibunitType = cs.getInt(index++);
        String piOwner = cs.getString(index++);
        String piName = cs.getString(index++);
        int piLineNumber = cs.getInt(index++);
        String piEntryPointName = cs.getString(index++);
        this.location = new DebugProbeLocation(this.dp, piLibunitType, piOwner, piName, piLineNumber, piEntryPointName);
        return index;
    }

    String dump(String margin, String stackFrameInfoName) {
        StringBuffer sb = new StringBuffer();
        sb.append(margin);
        sb.append(stackFrameInfoName);
        sb.append("\n");
        sb.append(margin);
        sb.append("  libunitType:    ");
        sb.append(this.location.piLibunitType);
        sb.append("\n");
        sb.append(margin);
        sb.append("  owner:          ");
        sb.append(this.location.piOwner);
        sb.append("\n");
        sb.append(margin);
        sb.append("  name:           ");
        sb.append(this.location.piName);
        sb.append("\n");
        sb.append(margin);
        sb.append("  lineNumber:     ");
        sb.append(this.location.piLineNumber);
        sb.append("\n");
        sb.append(margin);
        sb.append("  entryPointName: ");
        sb.append(this.location.piEntryPointName);
        sb.append("\n");
        return sb.toString();
    }

    private String getSourceCode() {
        if (this._sourceCode == null) {
            this._sourceCode = this.dp.callShowFrameSource(this);
        }
        return this._sourceCode;
    }

    private int getLocationOffset() {
        String sourceCode;
        if (this._locationOffset == -1 && this.location != null && this.location.piLineNumber > 0 && (sourceCode = this.getSourceCode()) != null) {
            int lineNumber = 1;
            int offset = 0;
            while (true) {
                if (this.location.piLineNumber == lineNumber) {
                    this._locationOffset = offset;
                    break;
                }
                if ((offset = sourceCode.indexOf("\n", offset)) == -1) break;
                ++offset;
                ++lineNumber;
            }
        }
        return this._locationOffset;
    }

    private void lookForVariables() {
        if (this.arguments == null || this.locals == null) {
            ArrayList listOfArguments;
            ArrayList listOfLocals;
            block5: {
                ArrayList listOfVariableNames = new ArrayList();
                listOfLocals = new ArrayList();
                listOfArguments = new ArrayList();
                String sourceCode = this.getSourceCode();
                if (sourceCode != null) {
                    int locationOffset = this.getLocationOffset();
                    try {
                        ReadTextBuffer buffer = TextBufferFactory.createReadTextBuffer((String)sourceCode);
                        RootSymbol rs = PlsqlParser.parse((ReadTextBuffer)buffer);
                        if (rs != null) {
                            this.processPackages(rs.getPackages(), locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
                            this.processFunctions(rs.getFunctions(), locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
                        }
                    }
                    catch (Throwable e) {
                        Assert.println((String)("exception during parsing: " + e));
                        if (!(e instanceof ThreadDeath)) break block5;
                        throw (ThreadDeath)e;
                    }
                }
            }
            this.arguments = listOfArguments.toArray(new DebugProbeVariableInfo[listOfArguments.size()]);
            this.locals = listOfLocals.toArray(new DebugProbeVariableInfo[listOfLocals.size()]);
        }
    }

    private void processPackages(PackageSymbol[] packages, int locationOffset, List listOfVariableNames, List listOfLocals, List listOfArguments) {
        if (packages != null) {
            for (PackageSymbol pakkage : packages) {
                if (locationOffset < pakkage.getStartOffset() || locationOffset >= pakkage.getEndOffset()) continue;
                this.processFunctions(pakkage.getFunctions(), locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
            }
        }
    }

    private void processFunctions(FunctionSymbol[] functions, int locationOffset, List listOfVariableNames, List listOfLocals, List listOfArguments) {
        if (functions != null) {
            for (FunctionSymbol function : functions) {
                if (locationOffset < function.getStartOffset() || locationOffset >= function.getEndOffset()) continue;
                this.processCodeBlock((CodeBlockSymbol)function, locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
                this.processVariables(function.getParameters(), listOfVariableNames, listOfArguments);
            }
        }
    }

    private void processCodeBlock(CodeBlockSymbol codeBlock, int locationOffset, List listOfVariableNames, List listOfLocals, List listOfArguments) {
        this.processFunctions(codeBlock.getFunctions(), locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
        this.processStatements(codeBlock.getStatements(), locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
        this.processTypes(codeBlock.getTypes());
        this.processVariables(codeBlock.getVariables(), listOfVariableNames, listOfLocals);
    }

    private void processStatements(Statement[] statements, int locationOffset, List listOfVariableNames, List listOfLocals, List listOfArguments) {
        if (statements != null) {
            for (Statement statement : statements) {
                NameSymbol nameSymbol;
                CodeBlockSymbol codeBlock;
                if (locationOffset < statement.getStartOffset() || locationOffset >= statement.getEndOffset()) continue;
                if (statement instanceof CompoundStatement) {
                    CompoundStatement compoundStatement = (CompoundStatement)statement;
                    this.processStatements(compoundStatement.getClauses(), locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
                }
                if ((codeBlock = statement.getBlock()) != null && locationOffset >= codeBlock.getStartOffset() && locationOffset < codeBlock.getEndOffset()) {
                    this.processCodeBlock(codeBlock, locationOffset, listOfVariableNames, listOfLocals, listOfArguments);
                }
                if (!(statement instanceof CompoundStatement) || (nameSymbol = ((CompoundStatement)statement).getVariableName()) == null) continue;
                String name = nameSymbol.getValue();
                this.processVariable(name, null, listOfVariableNames, listOfLocals);
            }
        }
    }

    private String figureOutVariableType(String name) {
        String type = null;
        boolean tableElement = false;
        String baseName = name;
        String tableName = DebugProbeDataArrayInfo.isTableElementName(name);
        if (tableName != null) {
            baseName = tableName;
            tableElement = true;
        }
        this.lookForVariables();
        DebugProbeVariableInfo var = DebugProbeStackFrameInfo.lookForVariableNamed(baseName, this.arguments);
        if (var == null) {
            var = DebugProbeStackFrameInfo.lookForVariableNamed(baseName, this.locals);
        }
        if (var != null) {
            type = var.dpv.getType();
            String typeDefinition = this.getTypeDefinition(type);
            if (typeDefinition != null) {
                type = typeDefinition;
            }
            if (tableElement) {
                type = DebugProbeDataArrayInfo.getTableElementType(type);
            }
        }
        return type;
    }

    private static DebugProbeVariableInfo lookForVariableNamed(String name, DebugProbeVariableInfo[] vars) {
        if (name != null) {
            for (int i = vars.length - 1; i >= 0; --i) {
                if (!name.equalsIgnoreCase(vars[i].name)) continue;
                return vars[i];
            }
        }
        return null;
    }

    @Override
    protected Object getVariable(String name, String type) {
        DebugProbeValue dpv = this.dp.getVariableValue(this, name, type);
        if (dpv != null) {
            return new DebugProbeVariableInfo(this.dp, this, name, dpv, false, false);
        }
        return null;
    }

    @Override
    void clearCachedData() {
        this.arguments = null;
        this.locals = null;
    }

    public DebugEvaluator getEvaluator() {
        return null;
    }

    public String getStackWindowColumnValue(int zeroBasedColumnIndex, boolean showFullyQualifiedNames) {
        switch (zeroBasedColumnIndex) {
            case 0: {
                DebugLocation location = this.getLocation();
                if (location == null || location.getMethod() == null) break;
                if (location.getClassInfo() != null) {
                    int thirdDot;
                    int secondDot;
                    String className = location.getClassInfo().getName();
                    Assert.check((boolean)className.startsWith("$Oracle."));
                    int firstDot = className.indexOf(".");
                    if (firstDot != -1 && (secondDot = className.indexOf(".", 8)) != -1 && (thirdDot = className.indexOf(".", secondDot + 1)) != -1) {
                        String type = className.substring(firstDot + 1, secondDot);
                        String schemaDotBodyDotSubroutine = className.substring(secondDot + 1, thirdDot) + ".";
                        if (type.equals("Block")) {
                            schemaDotBodyDotSubroutine = schemaDotBodyDotSubroutine + DebugProbeArb.getString(9);
                        } else {
                            if (type.equals("PackageBody") || type.equals("TypeBody")) {
                                String body = className.substring(thirdDot + 1);
                                schemaDotBodyDotSubroutine = schemaDotBodyDotSubroutine + body + ".";
                            }
                            schemaDotBodyDotSubroutine = schemaDotBodyDotSubroutine + location.getMethod().getNameWithoutClassOrSignature();
                        }
                        return schemaDotBodyDotSubroutine;
                    }
                }
                if (showFullyQualifiedNames) {
                    return location.getMethod().getName();
                }
                return location.getMethod().getNameWithoutSignature();
            }
            case 1: {
                DebugLocation location = this.getLocation();
                if (location == null || location.getFilename() == null) break;
                String fileName = location.getFilename();
                if (fileName.endsWith(".pls")) {
                    fileName = fileName.substring(0, fileName.length() - 4);
                }
                return fileName;
            }
            case 2: {
                DebugLocation location = this.getLocation();
                if (location == null || location.getLine() <= 0) break;
                return Integer.toString(location.getLine());
            }
        }
        return "";
    }

    public String getStackWindowColumnTooltip(int zeroBasedColumnIndex) {
        return this.getStackWindowColumnValue(zeroBasedColumnIndex, true);
    }

    public boolean hasAnnotations() {
        return false;
    }

    public DebugAnnotationInfo[] getAnnotations() {
        return new DebugAnnotationInfo[0];
    }

    public String getLabel() {
        return this.getStackWindowColumnValue(0, true);
    }

    public Peek getCodePeek(JComponent owner, Rectangle rect, Project project) {
        return null;
    }

    public Icon getIcon() {
        return null;
    }
}

