/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.jdevimpl.db.DBArgusUtil;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeArb;
import oracle.jdevimpl.debugger.probe.DebugProbeClassInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeMethodInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

final class DebugProbeLocation
implements DebugLocation {
    DebugProbe dp;
    int piLibunitType;
    String piOwner;
    String piName;
    int piLineNumber;
    String piEntryPointName;
    private DebugProbeClassInfo classInfo;
    private DebugProbeMethodInfo methodInfo;
    static final int LibunitType_cursor = 0;
    static final int LibunitType_procedure = 7;
    static final int LibunitType_function = 8;
    static final int LibunitType_package = 9;
    static final int LibunitType_package_body = 11;
    static final int LibunitType_trigger = 12;
    static final int LibunitType_Unknown = -1;
    static final int namespace_cursor = 0;
    static final int namespace_pkgspec_or_toplevel = 1;
    static final int namespace_pkg_body = 2;
    static final int namespace_trigger = 3;
    static final int namespace_none = 127;

    DebugProbeLocation(DebugProbe dp, DebugProbeClassInfo classInfo, int piLineNumber, String piEntryPointName) {
        this(dp, classInfo.piLibunitType, classInfo.piOwner, classInfo.piName, piLineNumber, piEntryPointName);
        this.classInfo = classInfo;
    }

    DebugProbeLocation(DebugProbe dp, int piLibunitType, String piOwner, String piName, int piLineNumber, String piEntryPointName) {
        this.dp = dp;
        this.piLibunitType = piLibunitType;
        this.piOwner = piOwner;
        this.piName = piName;
        this.piLineNumber = piLineNumber;
        if (piEntryPointName == null && (piLibunitType == 7 || piLibunitType == 8)) {
            piEntryPointName = piName;
        }
        this.piEntryPointName = piEntryPointName;
    }

    boolean isAnonymousBlock() {
        return this.piLibunitType == 0;
    }

    public DebugMethodInfo getMethod() {
        if (this.methodInfo == null && this.piEntryPointName != null) {
            this.getClassInfo();
            if (this.classInfo != null) {
                this.methodInfo = new DebugProbeMethodInfo(this.dp, this.classInfo, this.piEntryPointName);
            }
        }
        return this.methodInfo;
    }

    public DebugClassInfo getClassInfo() {
        if (this.classInfo == null) {
            this.classInfo = this.dp.getClassInfoForLocation(this);
        }
        return this.classInfo;
    }

    public String getPath() {
        return "";
    }

    public String getFilename() {
        if (this.piName != null) {
            return this.piName + ".pls";
        }
        return null;
    }

    public int getLine() {
        return this.piLineNumber;
    }

    public boolean isLineExact() {
        return true;
    }

    public int getBytecodeOffset() {
        return -1;
    }

    public boolean isBytecodeExact() {
        return false;
    }

    public long getAddress() {
        return 0L;
    }

    public String getDescription() {
        return null;
    }

    static DebugProbeLocation makeLocation(DebugProbe dp, String pkg, String filename, int line) {
        DebugProbeLocation location = null;
        ArrayList<String> pkgTokens = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(pkg, ".");
        while (st.hasMoreTokens()) {
            pkgTokens.add(st.nextToken());
        }
        if (pkgTokens.size() == 3 && pkgTokens.get(0).equals("$Oracle") && filename.endsWith(".pls")) {
            String type = (String)pkgTokens.get(1);
            int piLibunitType = DebugProbeLocation.parseLibunitType(type);
            String piOwner = (String)pkgTokens.get(2);
            String piName = filename.substring(0, filename.length() - 4);
            location = new DebugProbeLocation(dp, piLibunitType, piOwner, piName, line, null);
        }
        return location;
    }

    static String formatLibunitType(int piLibunitType) {
        switch (piLibunitType) {
            default: {
                return DebugProbeArb.getString(6);
            }
            case 0: {
                return DBArgusUtil.getArgusNameForType("BLOCK");
            }
            case 7: {
                return DBArgusUtil.getArgusNameForType("PROCEDURE");
            }
            case 8: {
                return DBArgusUtil.getArgusNameForType("FUNCTION");
            }
            case 9: {
                return DBArgusUtil.getArgusNameForType("PACKAGE");
            }
            case 11: {
                return DBArgusUtil.getArgusNameForType("PACKAGE", "Body");
            }
            case 12: 
        }
        return DBArgusUtil.getArgusNameForType("TRIGGER");
    }

    static int parseLibunitType(String type) {
        if (type.equals(DBArgusUtil.getArgusNameForType("BLOCK"))) {
            return 0;
        }
        if (type.equals(DBArgusUtil.getArgusNameForType("PROCEDURE"))) {
            return 7;
        }
        if (type.equals(DBArgusUtil.getArgusNameForType("FUNCTION"))) {
            return 8;
        }
        if (type.equals(DBArgusUtil.getArgusNameForType("PACKAGE"))) {
            return 9;
        }
        if (type.equals(DBArgusUtil.getArgusNameForType("PACKAGE", "Body"))) {
            return 11;
        }
        if (type.equals(DBArgusUtil.getArgusNameForType("TRIGGER"))) {
            return 12;
        }
        return -1;
    }

    static int getNameSpaceFromLibunitType(int piLibunitType) {
        switch (piLibunitType) {
            default: {
                return 127;
            }
            case 0: {
                return 0;
            }
            case 7: 
            case 8: 
            case 9: {
                return 1;
            }
            case 11: {
                return 2;
            }
            case 12: 
        }
        return 3;
    }
}

