/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeClassInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeDataArrayInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeDataInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeValue;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;

final class DebugProbeArrayElementInfo
implements DebugArrayElementInfo {
    DebugProbe dp;
    DebugProbeDataArrayInfo array;
    int index;
    DebugProbeValue dpv;
    DebugProbeClassInfo classInfo;
    int stoppedCount;
    DebugProbeDataInfo dataInfo;

    DebugProbeArrayElementInfo(DebugProbe dp, DebugProbeDataArrayInfo array, int index, DebugProbeValue dpv) {
        this.dp = dp;
        this.array = array;
        this.index = index;
        this.dpv = dpv;
        this.classInfo = dp.getClassInfoForDataType(dpv);
        this.stoppedCount = dp.stoppedCount;
    }

    public boolean hasExpired() {
        return this.stoppedCount != this.dp.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("ArrayElement has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        return this.classInfo;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return "(" + this.index + ")";
    }

    public DebugDataInfo getDataInfo() {
        this.throwIfExpired();
        if (this.dataInfo == null) {
            this.dataInfo = this.dpv.isArray() ? new DebugProbeDataArrayInfo(this.dp, this.classInfo, this.dpv, this) : new DebugProbeDataInfo(this.dp, this.classInfo, this.dpv, this);
        }
        return this.dataInfo;
    }

    public int hashCode() {
        return this.array.hashCode() + this.index;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugProbeArrayElementInfo) {
            DebugProbeArrayElementInfo other = (DebugProbeArrayElementInfo)o;
            return ModelUtil.areEqual((Object)this.dp, (Object)other.dp) && ModelUtil.areEqual((Object)this.array, (Object)other.array) && this.index == other.index && ModelUtil.areEqual((Object)this.classInfo, (Object)other.classInfo) && ModelUtil.areEqual((Object)this.dpv, (Object)other.dpv);
        }
        return false;
    }
}

