/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.ide.log.MessagePage;
import oracle.ide.util.Assert;
import oracle.ideimpl.runner.MethodDescriptor;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.jdeveloper.debugger.support.DebuggerWindowOptions;
import oracle.jdevimpl.db.DBArgusUtil;
import oracle.jdevimpl.debugger.probe.DebugProbeArb;
import oracle.jdevimpl.debugger.probe.DebugProbeArrayElementInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeBackTrace;
import oracle.jdevimpl.debugger.probe.DebugProbeBreakpoint;
import oracle.jdevimpl.debugger.probe.DebugProbeBreakpointException;
import oracle.jdevimpl.debugger.probe.DebugProbeBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.probe.DebugProbeClassInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeClassLoaderInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeDataArrayInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeDataInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeFieldInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeLocation;
import oracle.jdevimpl.debugger.probe.DebugProbeRuntimeInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeStackFrameInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeThreadGroupInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeThreadInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeValue;
import oracle.jdevimpl.debugger.probe.DebugProbeVariableInfo;
import oracle.jdevimpl.debugger.shared.DebugEventMulticaster;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationThreshold;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointClassLoad;
import oracle.jdevimpl.debugger.support.DebugBreakpointDeadlock;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointLogListener;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodSignature;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointProperties;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugEvaluator;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugListener;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.UserSelectedURLCacher;

public final class DebugProbe
implements DebugVirtualMachine,
DebugCapabilities,
Runnable {
    private Database db;
    public int major;
    public int minor;
    private String debuggerSessionId;
    private String debuggeeSessionId;
    public int stoppedCount;
    private DebugProbeRuntimeInfo runtimeInfo;
    private DebugProbeBackTrace backTrace;
    private DebugProbeThreadGroupInfo mainThreadGroup;
    private DebugProbeThreadInfo mainThread;
    private List breakpoints;
    private DebugProbeBreakpoint currentBreakpoint;
    private List classes;
    private Map classesByName;
    private Map classesByNameWithoutPackage;
    private Map locationClassesByName;
    private Map primitiveClassesByName;
    private Map arrayClassesByName;
    public DebugProbeClassLoaderInfo bootstrapClassLoaderInfo;
    public DebugProbeClassInfo unknownClass;
    private String runCommand;
    private int timeout;
    private static int MIN_TIMEOUT = 1;
    private static int BIG_TIMEOUT = 60;
    private Thread runningThread;
    private List afterSynchronize;
    private Object[] syncObjects;
    private boolean[] syncValues;
    private static final int SYNC_NEED_SYNC = 0;
    private static final int SYNC_STOPPED = 1;
    private static final int SYNC_TERMINATED = 2;
    private static final int SYNC_TERMINATE_REQUESTED = 3;
    private static final int SYNC_COUNT = 4;
    public DebugListener debugListener;
    private DebugBreakpointLogListener bpLogListener;
    public static final int error_success = 0;
    public static final int error_no_debug_info = 2;
    public static final int error_no_such_object = 3;
    public static final int error_value_malformed = 7;
    public static final int error_indexed_table = 18;
    public static final int error_illegal_index = 19;
    public static final int error_timeout = 31;
    public static final int error_nullvalue = 32;
    private DebugStackFrameInfo currentStackFrame;
    private static final String RunCommand_Run = "0";
    private static final String RunCommand_StepInto = "DBMS_DEBUG.break_any_call";
    private static final String RunCommand_StepOver = "DBMS_DEBUG.break_next_line";
    private static final String RunCommand_StepOut = "DBMS_DEBUG.break_any_return";
    private UserSelectedURLCacher userUrlCacher = null;

    public DebugProbe(Database db, int major, int minor, String debuggerSessionId) {
        this.initSync();
        this.db = db;
        this.major = major;
        this.minor = minor;
        this.debuggerSessionId = debuggerSessionId;
        this.stoppedCount = 0;
        this.runtimeInfo = new DebugProbeRuntimeInfo(this);
        this.backTrace = new DebugProbeBackTrace(this);
        this.mainThreadGroup = new DebugProbeThreadGroupInfo(this, "main");
        this.mainThread = new DebugProbeThreadInfo(this, this.mainThreadGroup, "main");
        this.breakpoints = new ArrayList();
        this.classes = new ArrayList();
        this.classesByName = new HashMap();
        this.classesByNameWithoutPackage = new HashMap();
        this.locationClassesByName = new HashMap();
        this.primitiveClassesByName = new HashMap();
        this.arrayClassesByName = new HashMap();
        this.unknownClass = DebugProbeClassInfo.makePrimitiveClass(this, DebugProbeArb.getString(5));
        this.addBuiltInClass("BOOLEAN");
        this.addBuiltInClass("NUMBER");
        this.addBuiltInClass("PLS_INTEGER");
        this.addBuiltInClass("VARCHAR");
        this.addBuiltInClass("UNKNOWN");
        this.afterSynchronize = new ArrayList();
        this.afterSynchronize.add(new Runnable(){

            @Override
            public void run() {
                DebugProbe.this.debuggeeSessionId = DebugProbe.this.getDebuggeeSessionId();
            }
        });
        this.setSyncValue(0, true);
        this.setTimeout(BIG_TIMEOUT);
    }

    public void afterConnection(MessagePage logPage) {
    }

    public synchronized void addDebugListener(DebugListener l) {
        this.debugListener = DebugEventMulticaster.add((DebugListener)this.debugListener, (DebugListener)l);
    }

    public synchronized void removeDebugListener(DebugListener l) {
        this.debugListener = DebugEventMulticaster.remove((DebugListener)this.debugListener, (DebugListener)l);
    }

    public synchronized void addBreakpointLogListener(DebugBreakpointLogListener l) {
        this.bpLogListener = DebugEventMulticaster.add((DebugBreakpointLogListener)this.bpLogListener, (DebugBreakpointLogListener)l);
    }

    public synchronized void removeBreakpointLogListener(DebugBreakpointLogListener l) {
        this.bpLogListener = DebugEventMulticaster.remove((DebugBreakpointLogListener)this.bpLogListener, (DebugBreakpointLogListener)l);
    }

    public boolean wasRunning() {
        return false;
    }

    public synchronized void disconnect() {
        this.disconnect(true);
    }

    public synchronized void disconnect(boolean terminate) {
        if (terminate) {
            this.setSyncValue(3, true);
            if (!this.isRunning()) {
                this.doRunCommand(RunCommand_Run);
            }
        } else {
            throw new UnsupportedOperationException("Disconnect without terminating is not allowed");
        }
    }

    private synchronized void detach() {
        this.callDetachSession();
        this.db.close();
        this.incrementStoppedCount();
        this.db = null;
    }

    public boolean isConnected() {
        return this.db != null;
    }

    public boolean isStopped() {
        return this.getSyncValue(1);
    }

    public boolean isRunning() {
        return this.runningThread != null;
    }

    public boolean isTerminated() {
        return this.getSyncValue(2);
    }

    public void setNonDebuggablePackages(String nonDebuggablePackages) {
    }

    public void setDebuggablePackages(String debuggablePackages, String nonDebuggablePackages) {
    }

    public void requestCodeCoverage(String pkg, String filename) {
    }

    public void unrequestCodeCoverage(String pkg, String filename) {
    }

    public void discardCodeCoverage() {
    }

    public synchronized DebugBreakpointPackageFileLine putBreakpointPackageFileLine(String pkg, String filename, int line) {
        DebugProbeBreakpointPackageFileLine bp = new DebugProbeBreakpointPackageFileLine(this, pkg, filename, line);
        this.addBreakpoint(bp);
        return bp;
    }

    public synchronized DebugBreakpointFileLine putBreakpointFileLine(String filename, int line) {
        return null;
    }

    public synchronized DebugBreakpointMethodBytecode putBreakpointMethodBytecode(String method, int bytecodeOffset) {
        return null;
    }

    public synchronized DebugBreakpointMethod putBreakpointMethod(String method) {
        return null;
    }

    public synchronized DebugBreakpointClass putBreakpointClass(String className) {
        return null;
    }

    public synchronized DebugBreakpointException putBreakpointException(String exception) {
        return this.putBreakpointException(exception, true, true);
    }

    public synchronized DebugBreakpointException putBreakpointException(String exception, boolean caught, boolean uncaught) {
        if (this.checkVersion(2, 4)) {
            DebugProbeBreakpointException bp = new DebugProbeBreakpointException(this, exception, caught, uncaught);
            this.addBreakpoint(bp);
            return bp;
        }
        return null;
    }

    public synchronized DebugBreakpointClassLoad putBreakpointClassLoad(String className) {
        return null;
    }

    public synchronized DebugBreakpointAllocationThreshold putBreakpointAllocationThreshold(int threshold) {
        return null;
    }

    public synchronized DebugBreakpointAllocationClass putBreakpointAllocationClass(String classname) {
        return null;
    }

    public synchronized DebugBreakpointDeadlock putBreakpointDeadlock() {
        return null;
    }

    public synchronized DebugBreakpointWatchpoint putBreakpointWatchpoint(String className, String fieldName, boolean access, boolean modify) {
        return null;
    }

    public DebugBreakpointProperties putBreakpointProperties(Map<String, String> properties) {
        return null;
    }

    public synchronized void removeAllBreakpoints() {
        for (int i = this.breakpoints.size() - 1; i >= 0; --i) {
            DebugProbeBreakpoint bp = (DebugProbeBreakpoint)this.breakpoints.get(i);
            bp.prepareForChange();
        }
        this.breakpoints.clear();
    }

    private void addBreakpoint(final DebugProbeBreakpoint bp) {
        this.breakpoints.add(bp);
        if (!this.getSyncValue(0)) {
            this.putBreakpoint(bp);
        } else {
            this.afterSynchronize.add(new Runnable(){

                @Override
                public void run() {
                    DebugProbe.this.putBreakpoint(bp);
                }
            });
        }
    }

    public synchronized void putBreakpoint(DebugProbeBreakpoint bp) {
        if (bp instanceof DebugProbeBreakpointPackageFileLine) {
            int bn;
            DebugProbeBreakpointPackageFileLine bppfl = (DebugProbeBreakpointPackageFileLine)bp;
            DebugProbeLocation location = DebugProbeLocation.makeLocation(this, bppfl.getPackage(), bppfl.getFilename(), bppfl.getLine());
            if (location != null && (bn = this.callSetBreakpoint(location)) != -1) {
                bppfl.verified(bn, location);
                if (!bppfl.getEnabled()) {
                    this.callDisableBreakpoint(bn);
                }
                if (this.debugListener != null) {
                    this.debugListener.breakpointChanged((DebugBreakpoint)bppfl);
                }
            }
        } else if (bp instanceof DebugProbeBreakpointException) {
            // empty if block
        }
    }

    public synchronized boolean removeBreakpoint(DebugProbeBreakpoint bp) {
        if (this.breakpoints.indexOf(bp) != -1) {
            this.breakpoints.remove(bp);
            return true;
        }
        return false;
    }

    public synchronized void resume() {
        this.doRunCommand(RunCommand_Run);
    }

    public synchronized boolean didStepFinish() {
        return true;
    }

    public synchronized void continueStep() {
        this.doRunCommand(RunCommand_Run);
    }

    public synchronized void start(boolean stepOverClassInit) {
        this.doRunCommand(stepOverClassInit ? RunCommand_StepOver : RunCommand_StepInto);
    }

    public synchronized void setPauseInterval(int i) {
    }

    public synchronized void pauseProgram() {
    }

    public void cancelPauseProgram() {
    }

    public synchronized int getCurrentStatus() {
        if (this.currentBreakpoint instanceof DebugProbeBreakpointPackageFileLine) {
            return 1;
        }
        if (this.currentBreakpoint instanceof DebugProbeBreakpointException) {
            return 1;
        }
        return 0;
    }

    public synchronized DebugBreakpoint getCurrentBreakpoint() {
        return this.currentBreakpoint;
    }

    public synchronized DebugThreadInfo getCurrentThread() {
        return this.mainThread;
    }

    public synchronized DebugDataObjectInfo getCurrentThrow() {
        return null;
    }

    public synchronized boolean isCurrentThrowHandled() {
        return false;
    }

    public synchronized DebugLocation getCurrentThrowHandler() {
        return null;
    }

    public DebugDataObjectInfo getWatchpointObject() {
        return null;
    }

    public DebugFieldInfo getWatchpointField() {
        return null;
    }

    public DebugDataInfo getWatchpointFieldFutureValue() {
        return null;
    }

    public synchronized DebugThreadInfo[][] getDeadlockedThreads() {
        return new DebugThreadInfo[0][];
    }

    public synchronized DebugThreadGroupInfo[] listTopThreadGroups() {
        DebugThreadGroupInfo[] a = new DebugThreadGroupInfo[]{this.mainThreadGroup};
        return a;
    }

    public synchronized DebugThreadGroupInfo[] listAllThreadGroups() {
        return this.listTopThreadGroups();
    }

    public synchronized DebugThreadInfo[] listThreads() {
        DebugThreadInfo[] a = new DebugThreadInfo[]{this.mainThread};
        return a;
    }

    public synchronized DebugMonitorInfo[] listMonitorsInUse() {
        return new DebugMonitorInfo[0];
    }

    public synchronized DebugThreadInfo[] listWaitingThreads() {
        return new DebugThreadInfo[0];
    }

    public synchronized DebugThreadInfo[] listBlockedThreads() {
        return new DebugThreadInfo[0];
    }

    public synchronized DebugClassInfo[] listClasses() {
        return this.listClasses(false);
    }

    public DebugClassInfo[] listClasses(boolean fast) {
        return this.classes.toArray(new DebugClassInfo[this.classes.size()]);
    }

    public synchronized int countClasses() {
        return this.classes.size();
    }

    public DebugClassInfo findFirstClassByName(String name) {
        return this.findFirstClassByName(name, false);
    }

    public DebugClassInfo findFirstClassByName(String name, boolean nameWithoutPackage) {
        return DebugShared.getFirstClass((Map)(nameWithoutPackage ? this.classesByNameWithoutPackage : this.classesByName), (String)name);
    }

    public DebugClassLoaderInfo[] listClassLoaders() {
        DebugClassLoaderInfo[] a = new DebugClassLoaderInfo[]{DebugProbeClassLoaderInfo.makeClassLoaderInfo(this)};
        return a;
    }

    public synchronized int countHeap(DebugHeapSubset subset) {
        return 0;
    }

    public synchronized DebugHeapInfo getHeap(DebugHeapSubset subset) {
        return null;
    }

    public int getSizeOfAddress() {
        return 0;
    }

    public synchronized DebugHeapInfo getHeap(DebugHeapSubset subset, int sort) {
        return null;
    }

    public synchronized boolean isHeapAddressValid(long address) {
        return false;
    }

    public synchronized DebugHeapObjectInfo getHeapObjectAtAddress(long address) {
        return null;
    }

    public void doGarbageCollection() {
    }

    public DebugCapabilities getCapabilities() {
        return this;
    }

    public boolean canPutBreakpointPackageFileLine() {
        return true;
    }

    public boolean canPutBreakpointFileLine() {
        return false;
    }

    public boolean canPutBreakpointMethodBytecode() {
        return false;
    }

    public boolean canPutBreakpointMethod() {
        return false;
    }

    public boolean canPutBreakpointClass() {
        return false;
    }

    public boolean canPutBreakpointException() {
        return true;
    }

    public boolean canPutBreakpointClassLoad() {
        return false;
    }

    public boolean canPutBreakpointAllocationThreshold() {
        return false;
    }

    public boolean canPutBreakpointAllocationClass() {
        return false;
    }

    public boolean canPutBreakpointDeadlock() {
        return false;
    }

    public boolean canPutBreakpointWatchpoint() {
        return false;
    }

    public boolean canPutBreakpointProperties() {
        return false;
    }

    public boolean canSetDebuggablePackages() {
        return false;
    }

    public boolean canPauseProgram() {
        return false;
    }

    public boolean canRedefineClasses() {
        return false;
    }

    public boolean canCountObjectsOfClass() {
        return false;
    }

    public boolean canCountMemoryOfClass() {
        return false;
    }

    public boolean canSetDebuggableClass() {
        return false;
    }

    public boolean canGetHeap() {
        return false;
    }

    public boolean canDoGarbageCollection() {
        return false;
    }

    public boolean canDoCodeCoverage() {
        return false;
    }

    public boolean canDisassembleMethod() {
        return false;
    }

    public boolean canGetBytecodes() {
        return false;
    }

    public boolean canInvokeMethod() {
        return false;
    }

    public boolean canGetMonitors() {
        return false;
    }

    public boolean canGetMonitorEntryLocation() {
        return false;
    }

    public boolean canListSlots() {
        return false;
    }

    public boolean canPopFrames() {
        return false;
    }

    public boolean canSuspendThread() {
        return false;
    }

    public boolean canResumeThread() {
        return false;
    }

    public boolean canInterruptThread() {
        return false;
    }

    public boolean canDebuggerStopThread() {
        return false;
    }

    public boolean canListRegisters() {
        return false;
    }

    public boolean canListFloatRegisters() {
        return false;
    }

    public boolean canStepToEndOfMethod() {
        return false;
    }

    public boolean canStepIntoMethod() {
        return false;
    }

    public boolean canContinueStep() {
        return false;
    }

    public boolean canGetReturnValue() {
        return false;
    }

    public boolean canGetReturnedValue() {
        return false;
    }

    public boolean canSetLocation() {
        return false;
    }

    public boolean canPin() {
        return false;
    }

    public boolean canGetAddresses() {
        return false;
    }

    public boolean canGetUniqueIDs() {
        return false;
    }

    public void addConnectionLog(Object log) {
    }

    public void removeConnectionLog(Object log) {
    }

    public synchronized String getName() {
        if ("Oracle Database".equals(this.db.getDatabaseType())) {
            return "Oracle";
        }
        return DebugProbeArb.getString(2);
    }

    public int getLanguages() {
        return 2;
    }

    public String[] redefineClasses(Map nameToGuts) {
        return new String[0];
    }

    private void initSync() {
        this.syncObjects = new Object[4];
        this.syncValues = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            this.syncObjects[i] = new Integer(i);
            this.syncValues[i] = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setSyncValue(int i, boolean value) {
        Object object = this.syncObjects[i];
        synchronized (object) {
            boolean prevValue = this.syncValues[i];
            this.syncValues[i] = value;
            return prevValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getSyncValue(int i) {
        Object object = this.syncObjects[i];
        synchronized (object) {
            return this.syncValues[i];
        }
    }

    public synchronized void throwIfRunning() {
        if (this.runningThread != null) {
            throw new IllegalStateException("Program Is Running");
        }
    }

    private void incrementStoppedCount() {
        ++this.stoppedCount;
        this.backTrace.clear();
    }

    private synchronized void doRunCommand(String command) {
        this.throwIfRunning();
        this.runCommand = command;
        this.runningThread = new Thread((Runnable)this, "RunningThread");
        this.runningThread.start();
    }

    private void connectionLost() {
        this.detach();
        if (this.debugListener != null) {
            this.debugListener.connectionLost();
        }
    }

    private void programTerminated() {
        this.detach();
        if (this.debugListener != null) {
            this.debugListener.programTerminated();
        }
    }

    @Override
    public void run() {
        this.setSyncValue(1, false);
        this.incrementStoppedCount();
        this.currentBreakpoint = null;
        while (true) {
            if (this.getSyncValue(0)) {
                if (this.callSynchronize() != 0) {
                    this.connectionLost();
                    return;
                }
                if (this.isTerminated()) {
                    this.programTerminated();
                    return;
                }
                this.setTimeout(BIG_TIMEOUT);
                int size = this.afterSynchronize.size();
                for (int i = 0; i < size; ++i) {
                    Runnable r = (Runnable)this.afterSynchronize.get(i);
                    r.run();
                }
                this.afterSynchronize.clear();
                this.setSyncValue(0, false);
            }
            this.incrementStoppedCount();
            if (this.callContinue() != 0) {
                this.connectionLost();
                return;
            }
            if (this.isTerminated()) {
                this.programTerminated();
                return;
            }
            if (this.runtimeInfo.reason == 25) {
                this.setSyncValue(0, true);
                this.setSyncValue(3, false);
                this.setTimeout(MIN_TIMEOUT);
            } else {
                this.setTimeout(BIG_TIMEOUT);
            }
            if (this.runtimeInfo.reason == 3 || this.runtimeInfo.reason == 11) {
                this.updateClasses();
                DebugProbeBreakpoint bp = this.checkForBreakpointHit();
                if (bp != null) {
                    this.currentBreakpoint = bp;
                    break;
                }
                if (this.runCommand == RunCommand_Run) continue;
                break;
            }
            if (this.runtimeInfo.reason == 9 || this.runtimeInfo.reason == 6) break;
        }
        this.runningThread = null;
        this.incrementStoppedCount();
        this.updateClasses();
        this.setSyncValue(1, true);
        if (this.debugListener != null) {
            this.debugListener.programStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimeout(int t) {
        if (this.timeout != t) {
            try {
                this.timeout = t;
                Connection c = this.db.getConnection();
                StringBuffer sb = new StringBuffer();
                sb.append("begin\n");
                sb.append("  DBMS_DEBUG.default_timeout := " + this.timeout + ";\n");
                sb.append("end;");
                String s = sb.toString();
                try (CallableStatement cs = c.prepareCall(s);){
                    cs.execute();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int callSynchronize() {
        int result = -1;
        try {
            Connection c = this.db.getConnection();
            StringBuffer sb = new StringBuffer();
            sb.append("DECLARE\n");
            sb.append("  request binary_integer := " + this.runtimeInfo.info_request() + ";\n");
            sb.append("  info DBMS_DEBUG.runtime_info;\n");
            sb.append("begin\n");
            sb.append("  ? := DBMS_DEBUG.synchronize(info, request);\n");
            sb.append(this.runtimeInfo.code("info"));
            sb.append("end;");
            String s = sb.toString();
            boolean keepGoing = false;
            do {
                try (CallableStatement cs = c.prepareCall(s);){
                    cs.registerOutParameter(1, 4);
                    this.runtimeInfo.registerParameters(cs, 2);
                    cs.execute();
                    result = cs.getInt(1);
                    this.runtimeInfo.getParameters(cs, 2);
                }
                keepGoing = false;
                if (result != 31) continue;
                if (this.isDebuggeeDead()) {
                    result = 0;
                    this.setSyncValue(2, true);
                    continue;
                }
                keepGoing = true;
            } while (keepGoing);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int callContinue() {
        int result = -1;
        try {
            boolean keepGoing = false;
            do {
                String breakFlags;
                if (this.getSyncValue(3)) {
                    breakFlags = "DBMS_DEBUG.abort_execution";
                    this.setTimeout(BIG_TIMEOUT);
                } else {
                    breakFlags = this.getBreakFlags();
                    this.setTimeout(MIN_TIMEOUT);
                }
                Connection c = this.db.getConnection();
                StringBuffer sb = new StringBuffer();
                sb.append("DECLARE\n");
                sb.append("  request binary_integer := " + this.runtimeInfo.info_request() + ";\n");
                sb.append("  info DBMS_DEBUG.runtime_info;\n");
                sb.append("begin\n");
                sb.append("  ? := DBMS_DEBUG.continue(info, " + breakFlags + ", request);\n");
                sb.append(this.runtimeInfo.code("info"));
                sb.append("end;");
                String s = sb.toString();
                try (CallableStatement cs = c.prepareCall(s);){
                    cs.registerOutParameter(1, 4);
                    this.runtimeInfo.registerParameters(cs, 2);
                    cs.execute();
                    result = cs.getInt(1);
                    this.runtimeInfo.getParameters(cs, 2);
                }
                keepGoing = false;
                if (result == 31) {
                    if (this.isDebuggeeDead()) {
                        result = 0;
                        this.setSyncValue(2, true);
                        continue;
                    }
                    keepGoing = true;
                    continue;
                }
                if (result != 0 || this.runtimeInfo.stackDepth != 1 || this.runtimeInfo.lineNumber != 0) continue;
                keepGoing = true;
            } while (keepGoing);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int callSetBreakpoint(DebugProbeLocation location) {
        int bn = -1;
        try {
            Connection c = this.db.getConnection();
            StringBuffer sb = new StringBuffer();
            sb.append("DECLARE\n");
            sb.append("  pi  DBMS_DEBUG.program_info;\n");
            sb.append("  bn  BINARY_INTEGER;\n");
            sb.append("begin\n");
            sb.append("  pi.NameSpace := " + DebugProbeLocation.getNameSpaceFromLibunitType(location.piLibunitType) + ";\n");
            sb.append("  pi.Owner     := '" + location.piOwner + "';\n");
            sb.append("  pi.Name      := '" + location.piName + "';\n");
            sb.append("  pi.Line#     := " + location.piLineNumber + ";\n");
            sb.append("  ? := DBMS_DEBUG.set_breakpoint(pi, pi.Line#, bn);\n");
            sb.append("  ? := bn;\n");
            sb.append("end;");
            String s = sb.toString();
            try (CallableStatement cs = c.prepareCall(s);){
                cs.registerOutParameter(1, 4);
                cs.registerOutParameter(2, 4);
                cs.execute();
                int result = cs.getInt(1);
                bn = cs.getInt(2);
                if (result != 0) {
                    bn = -1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callEnableBreakpoint(int bn) {
        try {
            Connection c = this.db.getConnection();
            StringBuffer sb = new StringBuffer();
            sb.append("begin\n");
            sb.append("  ? := DBMS_DEBUG.enable_breakpoint(" + bn + ");\n");
            sb.append("end;");
            String s = sb.toString();
            try (CallableStatement cs = c.prepareCall(s);){
                cs.registerOutParameter(1, 4);
                cs.execute();
                int n = cs.getInt(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callDisableBreakpoint(int bn) {
        try {
            Connection c = this.db.getConnection();
            StringBuffer sb = new StringBuffer();
            sb.append("begin\n");
            sb.append("  ? := DBMS_DEBUG.disable_breakpoint(" + bn + ");\n");
            sb.append("end;");
            String s = sb.toString();
            try (CallableStatement cs = c.prepareCall(s);){
                cs.registerOutParameter(1, 4);
                cs.execute();
                int n = cs.getInt(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callDeleteBreakpoint(int bn) {
        try {
            Connection c = this.db.getConnection();
            StringBuffer sb = new StringBuffer();
            sb.append("begin\n");
            sb.append("  ? := DBMS_DEBUG.delete_breakpoint(" + bn + ");\n");
            sb.append("end;");
            String s = sb.toString();
            try (CallableStatement cs = c.prepareCall(s);){
                cs.registerOutParameter(1, 4);
                cs.execute();
                int n = cs.getInt(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isNameBadForGetValue(String name) {
        int firstOpenParen = name.indexOf("(");
        int firstCloseParen = name.indexOf(")");
        if (firstOpenParen != -1) {
            if (firstCloseParen == -1) {
                return true;
            }
            if (firstCloseParen < firstOpenParen) {
                return true;
            }
            int secondOpenParen = name.indexOf("(", firstOpenParen + 1);
            if (secondOpenParen != -1) {
                return true;
            }
            int secondCloseParen = name.indexOf(")", firstCloseParen + 1);
            if (secondCloseParen != -1) {
                return true;
            }
            try {
                String s = name.substring(firstOpenParen + 1, firstCloseParen);
                if (s.startsWith("0x") || s.startsWith("0X")) {
                    int i = Integer.parseInt(s.substring(2), 16);
                }
                int n = Integer.parseInt(s);
            }
            catch (Exception e) {
                return true;
            }
        } else if (firstCloseParen != -1) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DebugProbeValue callGetValue(Object context, String name, String type) {
        DebugProbeStackFrameInfo sf = null;
        DebugProbeClassInfo classInfo = null;
        if (context instanceof DebugProbeStackFrameInfo) {
            sf = (DebugProbeStackFrameInfo)context;
        } else if (context instanceof DebugProbeClassInfo) {
            classInfo = (DebugProbeClassInfo)context;
        }
        if (sf == null && classInfo == null) {
            return null;
        }
        if (classInfo != null) {
            if (classInfo.piLibunitType != 9 && classInfo.piLibunitType != 11) {
                return null;
            }
            if (!this.checkVersion(2, 2)) {
                return null;
            }
        }
        if (DebugProbe.isNameBadForGetValue(name)) {
            return null;
        }
        DebugProbeValue dpv = null;
        try {
            Connection c = this.db.getConnection();
            StringBuffer sb = new StringBuffer();
            if (sf != null) {
                sb.append("begin\n");
                sb.append("  ? := DBMS_DEBUG.get_value('" + name + "', " + sf.probeFrameNumber + ", ?);\n");
                sb.append("end;");
            } else {
                sb.append("DECLARE\n");
                sb.append("  pi        DBMS_DEBUG.program_info;\n");
                sb.append("begin\n");
                sb.append("  pi.NameSpace := " + DebugProbeLocation.getNameSpaceFromLibunitType(classInfo.piLibunitType) + ";\n");
                sb.append("  pi.Owner     := '" + classInfo.piOwner + "';\n");
                sb.append("  pi.Name      := '" + classInfo.piName + "';\n");
                sb.append("  ? := DBMS_DEBUG.get_value('" + name + "', pi, ?);\n");
                sb.append("end;");
            }
            String s = sb.toString();
            try (CallableStatement cs = c.prepareCall(s);){
                cs.registerOutParameter(1, 4);
                cs.registerOutParameter(2, 12);
                cs.execute();
                int result = cs.getInt(1);
                String value = cs.getString(2);
                if (result == 0 && value != null || result == 32 || result == 18) {
                    dpv = new DebugProbeValue(result, value, type);
                }
            }
        }
        catch (Exception e) {
            Assert.println((String)("callGetValue - name is \"" + name + "\""));
            e.printStackTrace();
        }
        return dpv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int callSetValue(Object context, String name, String newValue) {
        DebugProbeStackFrameInfo sf = null;
        DebugProbeClassInfo classInfo = null;
        if (context instanceof DebugProbeStackFrameInfo) {
            sf = (DebugProbeStackFrameInfo)context;
        } else if (context instanceof DebugProbeClassInfo) {
            classInfo = (DebugProbeClassInfo)context;
        }
        if (sf == null && classInfo == null) {
            return -1;
        }
        if (classInfo != null) {
            if (classInfo.piLibunitType != 9 && classInfo.piLibunitType != 11) {
                return -1;
            }
            if (!this.checkVersion(2, 2)) {
                return -1;
            }
        }
        if (DebugProbe.isNameBadForGetValue(name)) {
            return -1;
        }
        int result = -1;
        try {
            Connection c = this.db.getConnection();
            String assignment = name + " := " + newValue + ";";
            StringBuffer sb = new StringBuffer();
            if (sf != null) {
                sb.append("begin\n");
                sb.append("  ? := DBMS_DEBUG.set_value(" + sf.probeFrameNumber + ", '" + assignment + "');\n");
                sb.append("end;");
            } else {
                sb.append("DECLARE\n");
                sb.append("  pi        DBMS_DEBUG.program_info;\n");
                sb.append("begin\n");
                sb.append("  pi.NameSpace := " + DebugProbeLocation.getNameSpaceFromLibunitType(classInfo.piLibunitType) + ";\n");
                sb.append("  pi.Owner     := '" + classInfo.piOwner + "';\n");
                sb.append("  pi.Name      := '" + classInfo.piName + "';\n");
                sb.append("  ? := DBMS_DEBUG.set_value(pi, '" + assignment + "');\n");
                sb.append("end;");
            }
            String s = sb.toString();
            try (CallableStatement cs = c.prepareCall(s);){
                cs.registerOutParameter(1, 4);
                cs.execute();
                result = cs.getInt(1);
                if (result != 0) {
                    Assert.println((String)("setValue " + name + ", " + newValue + " returned " + result));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String callPrintInstantiations() {
        String buffer = null;
        if (this.checkVersion(2, 4)) {
            try {
                Connection c = this.db.getConnection();
                int flags = 23;
                StringBuffer sb = new StringBuffer();
                sb.append("DECLARE\n");
                sb.append("  pis     DBMS_DEBUG.backtrace_table;\n");
                sb.append("  each    BINARY_INTEGER;\n");
                sb.append("  pi      DBMS_DEBUG.program_info;\n");
                sb.append("  buffer  varchar2(5000):='';\n");
                sb.append("begin\n");
                sb.append("  DBMS_DEBUG.print_instantiations(pis, " + flags + ");\n");
                sb.append("  each := pis.FIRST;\n");
                sb.append("  WHILE (each IS NOT NULL) LOOP\n");
                sb.append("    pi := pis(each);\n");
                sb.append("    buffer := buffer || pi.LibunitType || '.' || pi.Owner || '.' || pi.Name || ';';\n");
                sb.append("    each := pis.NEXT(each);\n");
                sb.append("  END LOOP;\n");
                sb.append("  ? := buffer;\n");
                sb.append("end;");
                String s = sb.toString();
                try (CallableStatement cs = c.prepareCall(s);){
                    cs.registerOutParameter(1, 12);
                    cs.execute();
                    buffer = cs.getString(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String callSQLERRM(int sqlCode) {
        String msg = null;
        try {
            Connection c = this.db.getConnection();
            StringBuffer sb = new StringBuffer();
            sb.append("begin\n");
            sb.append("  ? := SQLERRM(" + sqlCode + ");\n");
            sb.append("end;");
            String s = sb.toString();
            try (CallableStatement cs = c.prepareCall(s);){
                cs.registerOutParameter(1, 12);
                cs.execute();
                msg = cs.getString(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String callShowFrameSource(DebugProbeStackFrameInfo sf) {
        String buffer = null;
        DebugClassInfo info = sf.getLocation().getClassInfo();
        if (info != null && (buffer = this.getSource((DebugProbeClassInfo)info)) != null) {
            return buffer;
        }
        if (this.checkVersion(2, 4)) {
            try {
                Connection c = this.db.getConnection();
                StringBuffer sb = new StringBuffer();
                sb.append("DECLARE\n");
                sb.append("  buffer     varchar2(32767):='';\n");
                sb.append("  first      binary_integer := 1;\n");
                sb.append("  last       binary_integer;\n");
                sb.append("  lines      DBMS_DEBUG.vc2_table;\n");
                sb.append("  notBlank   binary_integer;\n");
                sb.append("  each       binary_integer;\n");
                sb.append("  line       varchar2(90);\n");
                sb.append("begin\n");
                sb.append("  LOOP\n");
                sb.append("    last := first + 20;\n");
                sb.append("    DBMS_DEBUG.show_frame_source(first, last, lines, " + sf.probeFrameNumber + ");\n");
                sb.append("    notBlank := 0;\n");
                sb.append("    each := lines.FIRST;\n");
                sb.append("    WHILE (each IS NOT NULL) LOOP\n");
                sb.append("      line := lines(each);\n");
                sb.append("      buffer := buffer || line || '\n';\n");
                sb.append("      IF LENGTH(line) > 0 THEN\n");
                sb.append("        notBlank := notBlank + 1;\n");
                sb.append("      END IF;\n");
                sb.append("      each := lines.NEXT(each);\n");
                sb.append("    END LOOP;\n");
                sb.append("    first := last + 1;\n");
                sb.append("    EXIT WHEN notBlank = 0;\n");
                sb.append("  END LOOP;\n");
                sb.append("  ? := buffer;\n");
                sb.append("end;");
                String s = sb.toString();
                try (CallableStatement cs = c.prepareCall(s);){
                    cs.registerOutParameter(1, 12);
                    cs.execute();
                    buffer = cs.getString(1);
                    buffer = "*" + buffer;
                    buffer = buffer.trim();
                    buffer = new String(buffer.substring(1));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return buffer;
    }

    public String getSource(DebugProbeClassInfo classInfo) {
        String buffer = null;
        try {
            SchemaObject source;
            String dbObjectType;
            switch (classInfo.piLibunitType) {
                default: {
                    dbObjectType = null;
                    break;
                }
                case 7: {
                    dbObjectType = "PROCEDURE";
                    break;
                }
                case 8: {
                    dbObjectType = "FUNCTION";
                    break;
                }
                case 9: {
                    dbObjectType = "PACKAGE";
                    break;
                }
                case 11: {
                    dbObjectType = "PACKAGE BODY";
                }
            }
            if (dbObjectType != null && (source = this.db.getObject(dbObjectType, this.db.getSchema(classInfo.piOwner), classInfo.piName)) instanceof PlSqlSourceObject) {
                PlSqlSourceObject so = (PlSqlSourceObject)source;
                buffer = so.getSource();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callDetachSession() {
        try {
            Connection c = this.db.getConnection();
            StringBuffer sb = new StringBuffer();
            sb.append("begin\n");
            sb.append("  DBMS_DEBUG.detach_session;\n");
            sb.append("end;");
            String s = sb.toString();
            try (CallableStatement cs = c.prepareCall(s);){
                cs.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stepInto() {
        this.doRunCommand(RunCommand_StepInto);
    }

    public void stepOver() {
        this.doRunCommand(RunCommand_StepOver);
    }

    public void stepOut() {
        this.doRunCommand(RunCommand_StepOut);
    }

    public boolean checkVersion(int majorNeeded, int minorNeeded) {
        if (this.major > majorNeeded) {
            return true;
        }
        if (this.major == majorNeeded) {
            return this.minor >= minorNeeded;
        }
        return false;
    }

    public int getStackFrameCount() {
        this.backTrace.fill(this.db, this.runtimeInfo.stackDepth);
        return this.backTrace.getStackFrameCount();
    }

    public DebugStackFrameInfo getStackFrame(int frame) {
        this.backTrace.fill(this.db, this.runtimeInfo.stackDepth);
        return this.backTrace.getStackFrame(frame);
    }

    public DebugStackFrameInfo[] listStack() {
        this.backTrace.fill(this.db, this.runtimeInfo.stackDepth);
        return this.backTrace.listStack();
    }

    private String getBreakFlags() {
        String breakFlags = this.runCommand;
        for (int i = this.breakpoints.size() - 1; i >= 0; --i) {
            DebugProbeBreakpoint bp = (DebugProbeBreakpoint)this.breakpoints.get(i);
            if (!(bp instanceof DebugProbeBreakpointException) || !bp.getEnabled()) continue;
            breakFlags = breakFlags + " + DBMS_DEBUG.break_exception";
            break;
        }
        return breakFlags;
    }

    private DebugProbeBreakpoint checkForBreakpointHit() {
        DebugProbeBreakpoint stop = null;
        List v = this.findBreakpoints();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            DebugProbeBreakpoint bp = (DebugProbeBreakpoint)v.get(i);
            if (!this.doBreakpointActions(bp)) continue;
            stop = bp;
        }
        return stop;
    }

    private List findBreakpoints() {
        ArrayList<DebugProbeBreakpoint> v = new ArrayList<DebugProbeBreakpoint>();
        int size = this.breakpoints.size();
        for (int i = 0; i < size; ++i) {
            DebugProbeBreakpoint bp = (DebugProbeBreakpoint)this.breakpoints.get(i);
            if (!bp.isThisYourEvent(this.runtimeInfo, this.mainThread)) continue;
            v.add(bp);
        }
        return v;
    }

    private boolean doBreakpointActions(DebugProbeBreakpoint bp) {
        DebugProbeBreakpoint other;
        int i;
        int size;
        if (bp.enableOtherBPs != null && bp.enableOtherBPs.length() > 0) {
            size = this.breakpoints.size();
            for (i = 0; i < size; ++i) {
                other = (DebugProbeBreakpoint)this.breakpoints.get(i);
                if (!bp.enableOtherBPs.equals(other.name) || other.enabled) continue;
                other.setEnabled(true);
                if (this.debugListener == null) continue;
                this.debugListener.breakpointChanged((DebugBreakpoint)other);
            }
        }
        if (bp.disableOtherBPs != null && bp.disableOtherBPs.length() > 0) {
            size = this.breakpoints.size();
            for (i = 0; i < size; ++i) {
                other = (DebugProbeBreakpoint)this.breakpoints.get(i);
                if (!bp.disableOtherBPs.equals(other.name) || !other.enabled) continue;
                other.setEnabled(false);
                if (this.debugListener == null) continue;
                this.debugListener.breakpointChanged((DebugBreakpoint)other);
            }
        }
        if (bp.log) {
            DebugProbeThreadInfo thread = this.mainThread;
            DebugStackFrameInfo[] stack = thread.listStack();
            if (bp instanceof DebugProbeBreakpointPackageFileLine) {
                this.bpLogListener.logBreakpoint((DebugBreakpoint)bp, (DebugThreadInfo)thread, stack);
            } else if (bp instanceof DebugProbeBreakpointException) {
                String className = "$Oracle.EXCEPTION_ORA_" + this.runtimeInfo.oer;
                String detail = this.callSQLERRM(this.runtimeInfo.getSQLCode());
                this.bpLogListener.logException((DebugBreakpoint)bp, className, detail, (DebugThreadInfo)thread, stack);
            }
        }
        return bp.stop;
    }

    public DebugProbeValue getVariableValue(DebugProbeStackFrameInfo sf, String name, String type) {
        return this.callGetValue(sf, name, type);
    }

    public static Object findDataRoot(Object o, StringBuffer name) {
        if (o instanceof DebugProbeDataInfo) {
            DebugProbeDataInfo data = (DebugProbeDataInfo)o;
            return DebugProbe.findDataRoot(data.owner, name);
        }
        if (o instanceof DebugProbeVariableInfo) {
            DebugProbeVariableInfo var = (DebugProbeVariableInfo)o;
            if (name != null) {
                name.append(var.name);
            }
            return var.sf;
        }
        if (o instanceof DebugProbeFieldInfo) {
            DebugProbeFieldInfo field = (DebugProbeFieldInfo)o;
            if (name != null) {
                name.append(field.name);
            }
            return field.declaringClass;
        }
        if (o instanceof DebugProbeArrayElementInfo) {
            DebugProbeArrayElementInfo element = (DebugProbeArrayElementInfo)o;
            Object root = DebugProbe.findDataRoot(element.array, name);
            if (root != null) {
                if (name != null) {
                    name.append('(');
                    name.append(element.index);
                    name.append(')');
                }
                return root;
            }
        }
        return null;
    }

    public DebugProbeValue modifyData(DebugProbeDataInfo data, String type, String newValue) {
        StringBuffer sb = new StringBuffer();
        Object root = DebugProbe.findDataRoot(data, sb);
        if (root != null) {
            String name = sb.toString();
            if (root instanceof DebugProbeStackFrameInfo) {
                DebugProbeStackFrameInfo sf = (DebugProbeStackFrameInfo)root;
                sf.clearCachedData();
                int result = this.callSetValue(sf, name, newValue);
                if (result == 0) {
                    return this.callGetValue(sf, name, type);
                }
            } else if (root instanceof DebugProbeClassInfo) {
                DebugProbeClassInfo classInfo = (DebugProbeClassInfo)root;
                classInfo.clearCachedData();
                int result = this.callSetValue(classInfo, name, newValue);
                if (result == 0) {
                    return this.callGetValue(classInfo, name, type);
                }
            }
        }
        return null;
    }

    public DebugProbeArrayElementInfo getArrayElement(DebugProbeDataArrayInfo array, int index, String type) {
        StringBuffer sb = new StringBuffer();
        Object root = DebugProbe.findDataRoot(array, sb);
        if (root != null) {
            sb.append('(');
            sb.append(index);
            sb.append(')');
            String name = sb.toString();
            DebugProbeValue dpv = null;
            if (root instanceof DebugProbeStackFrameInfo) {
                DebugProbeStackFrameInfo sf = (DebugProbeStackFrameInfo)root;
                dpv = this.callGetValue(sf, name, type);
            } else if (root instanceof DebugProbeClassInfo) {
                DebugProbeClassInfo classInfo = (DebugProbeClassInfo)root;
                dpv = this.callGetValue(classInfo, name, type);
            }
            if (dpv != null) {
                return new DebugProbeArrayElementInfo(this, array, index, dpv);
            }
        }
        return null;
    }

    private void updateClasses() {
        String buffer = this.callPrintInstantiations();
        if (buffer != null) {
            String libunitTypePackage = Integer.toString(9);
            String prefixPackage = "$Oracle." + DBArgusUtil.getArgusNameForType("PACKAGE");
            String libunitTypePackageBody = Integer.toString(11);
            String prefixPackageBody = "$Oracle." + DBArgusUtil.getArgusNameForType("PACKAGE", "Body");
            StringTokenizer st = new StringTokenizer(buffer, ";");
            while (st.hasMoreTokens()) {
                DebugProbeClassInfo classInfo;
                String token = st.nextToken();
                int dot = token.indexOf(46);
                if (dot == -1) continue;
                String sLibunitType = token.substring(0, dot);
                String sOwnerName = token.substring(dot);
                String className = null;
                if (sLibunitType.equals(libunitTypePackage)) {
                    className = prefixPackage + sOwnerName;
                } else if (sLibunitType.equals(libunitTypePackageBody)) {
                    className = prefixPackageBody + sOwnerName;
                }
                if (className == null || (classInfo = (DebugProbeClassInfo)this.classesByName.get(className)) != null) continue;
                classInfo = DebugProbeClassInfo.makeObjectClass(this, className);
                this.addClass(classInfo);
            }
        }
    }

    private void addClass(DebugProbeClassInfo classInfo) {
        this.classes.add(classInfo);
        DebugShared.putClass((Map)this.classesByName, (String)classInfo.name, (DebugClassInfo)classInfo);
        DebugShared.putClass((Map)this.classesByNameWithoutPackage, (String)classInfo.getNameWithoutPackage(), (DebugClassInfo)classInfo);
    }

    public DebugProbeValue getFieldValue(DebugProbeClassInfo classInfo, String name, String type) {
        return this.callGetValue(classInfo, name, type);
    }

    public DebugProbeClassInfo getClassInfoForLocation(DebugProbeLocation location) {
        String className = DebugProbeClassInfo.makeClassName(location.piLibunitType, location.piOwner, location.piName);
        DebugProbeClassInfo classInfo = (DebugProbeClassInfo)this.classesByName.get(className);
        if (classInfo == null && (classInfo = (DebugProbeClassInfo)this.locationClassesByName.get(className)) == null) {
            classInfo = DebugProbeClassInfo.makeObjectClass(this, className);
            this.locationClassesByName.put(className, classInfo);
        }
        return classInfo;
    }

    private void addBuiltInClass(String type) {
        DebugProbeClassInfo classInfo = DebugProbeClassInfo.makePrimitiveClass(this, type);
        this.addClass(classInfo);
    }

    public DebugProbeClassInfo getClassInfoForDataType(DebugProbeValue dpv) {
        DebugProbeClassInfo classInfo = null;
        String type = dpv.getType();
        if (type != null) {
            if (dpv.isArray()) {
                classInfo = (DebugProbeClassInfo)this.arrayClassesByName.get(type);
                if (classInfo == null) {
                    classInfo = DebugProbeClassInfo.makeArrayClass(this, type);
                    this.arrayClassesByName.put(type, classInfo);
                }
            } else {
                classInfo = (DebugProbeClassInfo)this.primitiveClassesByName.get(type);
                if (classInfo == null) {
                    classInfo = DebugProbeClassInfo.makePrimitiveClass(this, type);
                    this.primitiveClassesByName.put(type, classInfo);
                }
            }
        }
        if (classInfo == null) {
            classInfo = this.unknownClass;
        }
        return classInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDebuggeeSessionId() {
        String result = null;
        try {
            Connection c = this.db.getConnection();
            StringBuffer sb = new StringBuffer();
            sb.append("declare\n");
            sb.append("  results      sys.dbms_debug_vc2coll;\n");
            sb.append("  errm         VARCHAR2(100);\n");
            sb.append("begin\n");
            sb.append("  DBMS_DEBUG.execute(\n");
            sb.append("    'declare ' ||\n");
            sb.append("    '  vc  SYS.dbms_debug_vc2coll := SYS.dbms_debug_vc2coll(); '||\n");
            sb.append("    'begin ' ||\n");
            sb.append("    '  vc.EXTEND(2); ' ||\n");
            sb.append("    '  vc(1) := DBMS_SESSION.unique_session_id; ' ||\n");
            sb.append("    '  vc(2) := null; ' ||\n");
            sb.append("    '  :1 := vc; ' ||\n");
            sb.append("    'end;',\n");
            sb.append("    -1, 1, results, errm);\n");
            sb.append("  ? := results(1);\n");
            sb.append("end;");
            String s = sb.toString();
            try (CallableStatement cs = c.prepareCall(s);){
                cs.registerOutParameter(1, 12);
                cs.execute();
                result = cs.getString(1);
                if (result != null && result.length() == 0) {
                    result = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDebuggeeDead() {
        boolean result = false;
        if (this.debuggeeSessionId != null) {
            try {
                Connection c = this.db.getConnection();
                StringBuffer sb = new StringBuffer();
                sb.append("declare\n");
                sb.append("  dead binary_integer;\n");
                sb.append("begin\n");
                sb.append("  IF DBMS_SESSION.is_session_alive('" + this.debuggeeSessionId + "') THEN\n");
                sb.append("    dead := 0;\n");
                sb.append("  ELSE\n");
                sb.append("    dead := 1;\n");
                sb.append("  END IF;\n");
                sb.append("  ? := dead;\n");
                sb.append("end;");
                String s = sb.toString();
                try (CallableStatement cs = c.prepareCall(s);){
                    cs.registerOutParameter(1, 4);
                    cs.execute();
                    result = cs.getInt(1) == 1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean canStopOnException() {
        return false;
    }

    public boolean canStopOnError() {
        return false;
    }

    public boolean canStopOnDebuggerStatement() {
        return false;
    }

    public boolean canTransferErrors() {
        return false;
    }

    public boolean getStopOnException() {
        return false;
    }

    public boolean getStopOnError() {
        return false;
    }

    public boolean getStopOnDebuggerStatement() {
        return false;
    }

    public boolean getTransferErrors() {
        return false;
    }

    public void setStopOnException(boolean b) {
    }

    public void setStopOnError(boolean b) {
    }

    public void setStopOnDebuggerStatement(boolean b) {
    }

    public void setTransferErrors(boolean b) {
    }

    public void setCurrentStackFrame(DebugStackFrameInfo sfInfo) {
        this.currentStackFrame = sfInfo;
    }

    public DebugStackFrameInfo getCurrentStackFrame() {
        return this.currentStackFrame;
    }

    public boolean canStopInChrome() {
        return false;
    }

    public boolean getStopInChrome() {
        return false;
    }

    public void setStopInChrome(boolean b) {
    }

    public Object newObject(String typeName, List<Object> parameters) throws Exception {
        throw new Exception("Unable to evaluate source expression: new object");
    }

    public void cacheUserFoundURL(String lookedFor, URL foundUrl) {
        if (this.userUrlCacher == null) {
            this.userUrlCacher = new UserSelectedURLCacher();
        }
        this.userUrlCacher.addCachedURL(lookedFor, foundUrl);
    }

    public URL getChachedUserFoundLocation(String lookingFor) {
        if (this.userUrlCacher == null) {
            return null;
        }
        return this.userUrlCacher.getCachedUrl(lookingFor);
    }

    public boolean canGetConstantPool() {
        return false;
    }

    public long[] countObjectsOfClasses(DebugClassInfo[] classes) {
        return null;
    }

    public DebugEvaluator[] getEvaluators() {
        return null;
    }

    public void clearEvaluators() {
    }

    public boolean canShowDebugLocations() {
        return false;
    }

    public boolean showDebugLocation(DebugLocation location) {
        return false;
    }

    public String getID() {
        return DebugProbeArb.getString(7);
    }

    public String getStackWindowColumnName(int zeroBasedColumnIndex) {
        switch (zeroBasedColumnIndex) {
            case 0: {
                return DebugProbeArb.getString(8);
            }
            case 1: {
                return DebugProbeArb.getString(10);
            }
            case 2: {
                return DebugProbeArb.getString(11);
            }
        }
        return null;
    }

    public boolean isStackWindowColumnVisibleByDefault(int zeroBasedColumnIndex) {
        return zeroBasedColumnIndex == 0;
    }

    public boolean isStackWindowThreadComboboxVisible() {
        return false;
    }

    public boolean isStackWindowColumnNumeric(int zeroBasedColumnIndex) {
        return zeroBasedColumnIndex == 2;
    }

    public void setSuspendBreakpoints(boolean suspended) {
    }

    public boolean getSuspendBreakpoints() {
        return false;
    }

    public boolean canSuspendBreakpoints() {
        return false;
    }

    public DebuggerWindowOptions getDebuggerWindowOptions(DebuggerWindowOptions.WindowId windowId) {
        return DebuggerWindowOptions.DEFAULT;
    }

    public boolean canStepIntoOuterMethod() {
        return false;
    }

    public DebugBreakpointMethodSignature putBreakpointMethodSignature(MethodDescriptor method) {
        return null;
    }

    public boolean canPutBreakpointMethodSignature() {
        return false;
    }
}

