/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.net.URL;
import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorWindow;

public abstract class FileHandler {
    protected FileHandler() {
    }

    protected static final String convertToFileName(String moduleName) {
        return moduleName.replace('/', '-').replace('\\', '-');
    }

    protected static final Project determineActiveProject(Context context) {
        return context.getProject() != null ? context.getProject() : Ide.getActiveProject();
    }

    protected static void selectNavigatorTNode(Context context, Element element) {
        if (!(context.getView() instanceof NavigatorWindow)) {
            return;
        }
        TreeExplorer navigatorTreeExplorer = ((NavigatorWindow)context.getView()).getTreeExplorer();
        if (navigatorTreeExplorer == null) {
            return;
        }
        TNode elementTNode = navigatorTreeExplorer.searchTNodeBreadthFirst(element, navigatorTreeExplorer.getRoot());
        if (elementTNode != null) {
            navigatorTreeExplorer.setSelected(elementTNode);
        }
    }

    protected static boolean migrateSystemFile(Node node) {
        MigrationInfo migInfo;
        NodeMigrator migrator = NodeMigrator.getNodeMigrator((String)NodeMigrator.getLookupKey((Node)node));
        boolean skipMigration = Boolean.getBoolean("ide.skipmigration");
        if (!skipMigration && migrator != null && (migInfo = migrator.getMigrationInfo(node)).getVersionStatus() != MigrationInfo.VERSION_CURRENT && migrator.migrate(migInfo).getMigrationStatus() != MigrationInfo.MIGRATION_DONE) {
            NodeFactory.uncache((URL)node.getURL());
            return false;
        }
        return true;
    }

    protected static final void openWorkspaces(Context context, Collection workspaceUrls) throws IllegalAccessException, InstantiationException {
        Workspaces workspaces = Ide.getWorkspaces();
        if (workspaces == null) {
            return;
        }
        for (URL url : workspaceUrls) {
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node == null || !(node instanceof Workspace) || workspaces.containsChild((Element)node) || !FileHandler.migrateSystemFile(node)) continue;
            workspaces.add((Element)node);
            FileOpenHistory.getInstance().updateWorkspaceHistory(node.getURL());
            UpdateMessage.fireChildAdded((Subject)workspaces, (Element)node);
            FileHandler.selectNavigatorTNode(context, (Element)node);
        }
    }
}

