/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic;

import java.util.HashMap;
import java.util.Map;
import oracle.jdevimpl.vcs.generic.profile.ProfileInfo;
import oracle.jdevimpl.vcs.generic.profile.VCSHookInfo;

public final class ProfileInfoRegistry {
    private static final ProfileInfoRegistry _instance = new ProfileInfoRegistry();
    private final Map<String, ProfileInfo> _profileRegistry = new HashMap<String, ProfileInfo>(10);

    public static final ProfileInfoRegistry getInstance() {
        return _instance;
    }

    private final void registerProfileInfo(String id, ProfileInfo p) {
        this._profileRegistry.put(id, p);
    }

    final ProfileInfo lookupProfileInfo(String id) {
        return this._profileRegistry.get(id);
    }

    public final void addVcsHook(Object o) {
        if (!(o instanceof VCSHookInfo)) {
            throw new IllegalArgumentException();
        }
        VCSHookInfo vcsHook = (VCSHookInfo)o;
        ProfileInfo vcsProfile = vcsHook.getProfile();
        if (vcsProfile != null) {
            this.registerProfileInfo(vcsProfile.getID(), vcsProfile);
        }
    }
}

