/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.versiontree;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.SwingWorker;
import oracle.ide.vhv.VHVContext;
import oracle.ide.vhv.VHVInContextResource;
import oracle.ide.vhv.VHVURLHelper;
import oracle.javatools.compare.CompareContributor;
import oracle.jdeveloper.compare.BinaryCompareContributor;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.compare.TextNodeContributor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;

public abstract class VersionTreeCompareCommand
extends Command {
    protected VersionTreeCompareCommand(int cmdId) {
        super(cmdId);
    }

    public int doit() throws Exception {
        if (!VHVContext.isVHVContext((Context)this.context)) {
            return -1;
        }
        SwingWorker swingWorker = new SwingWorker(){
            private CompareContributor _left;
            private CompareContributor _right;

            public Object construct() {
                try {
                    URL url = VHVURLHelper.getRealURL((URL)VersionTreeCompareCommand.this.context.getNode().getURL());
                    VHVInContextResource rightResource = VHVContext.getSelectedResource((Context)VersionTreeCompareCommand.this.context);
                    VHVInContextResource leftResource = VersionTreeCompareCommand.this.getLeftResource();
                    this._right = VersionTreeCompareCommand.this.createContributor(url, rightResource);
                    this._left = VersionTreeCompareCommand.this.createContributor(url, leftResource);
                    return null;
                }
                catch (Exception e) {
                    return e;
                }
            }

            public void finished() {
                Ide.getWaitCursor().hide();
                if (this.getValue() != null) {
                    VHVContext.getVHVControl((Context)VersionTreeCompareCommand.this.context).getCustomizer().getExceptionHandler().handleException((Exception)this.getValue(), (Component)IdeUtil.getMainWindow());
                } else {
                    CompareViewer.get().show(this._left, this._right, (Element)VHVContext.getRealNode((Context)VersionTreeCompareCommand.this.context));
                }
            }
        };
        Ide.getWaitCursor().show();
        swingWorker.start();
        return 0;
    }

    protected abstract VHVInContextResource getLeftResource();

    protected abstract CompareContributor createContributor(URL var1, VHVInContextResource var2) throws Exception;

    protected CompareContributor createURLContributor(URL url) throws IOException {
        if (VCSFileSystemUtils.isContentTypeBinary(url)) {
            return new BinaryCompareContributor(url);
        }
        Node node = NodeFactory.find((URL)url);
        return node != null ? this.createNodeContributor((Locatable)node) : new URLContributor(url);
    }

    private CompareContributor createNodeContributor(Locatable node) throws IOException {
        if (node instanceof TextNode && ((TextNode)node).isDirty()) {
            return new TextNodeContributor((TextNode)node);
        }
        return new URLContributor(node.getURL());
    }
}

