/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.PatternFilter;

public class VCSURLPatternFilters
implements URLFilter {
    private Collection<PatternFilter> filters = new LinkedHashSet<PatternFilter>();

    public VCSURLPatternFilters(Collection<String> patterns) {
        for (String pattern : patterns) {
            this.filters.add(PatternFilter.newExclude((String)pattern));
        }
    }

    public boolean accept(URL url) {
        if (this.filters == null) {
            return true;
        }
        for (PatternFilter pf : this.filters) {
            if (!pf.matches(URLFileSystem.getPath((URL)url))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return o instanceof VCSURLPatternFilters;
    }

    public String toString() {
        return "URLPatternFilters";
    }
}

