/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ideimpl.vcs.VCSContextUtil;
import oracle.jdeveloper.vcs.spi.VCSProtocolRegistry;
import oracle.jdeveloper.vcs.util.VCSURLFilters;

public final class VCSContextUtils {
    private static URLFilter _protocolFilter = null;

    private VCSContextUtils() {
    }

    public static final URLFilter createLocalProtocolFilter() {
        return VCSURLFilters.createChainedANDFilter(new URLFilter[]{new URLFilter(){

            public boolean accept(URL url) {
                return URLFileSystem.isLocal((URL)url);
            }
        }, new URLFilter(){

            public boolean accept(URL url) {
                for (String protocol : VCSProtocolRegistry.protocols()) {
                    if (!url.getProtocol().equals(protocol)) continue;
                    return true;
                }
                return false;
            }
        }});
    }

    public static final Locatable[] getContextLocatables(Context context, URLFilter filter) {
        return VCSContextUtil.getContextLocatables((Context)context, (URLFilter)filter);
    }

    public static final Locatable[] getContextLocatables(Context context) {
        if (_protocolFilter == null) {
            _protocolFilter = VCSContextUtils.createLocalProtocolFilter();
        }
        return VCSContextUtil.getContextLocatables((Context)context, (URLFilter)_protocolFilter);
    }

    public static final Locatable[] getExpandedLocatables(Element[] elements, URLFilter filter) {
        return VCSContextUtil.getExpandedLocatables((Element[])elements, (URLFilter)filter);
    }

    public static final Locatable[] getExpandedLocatables(Context context, Element[] elements, URLFilter filter) {
        return VCSContextUtil.getExpandedLocatables((Context)context, (Element[])elements, (URLFilter)filter);
    }

    public static final String getContextViewType(Context context) {
        return VCSContextUtil.getContextViewType((Context)context);
    }
}

