/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.cache.StatusCacheEvent;
import oracle.jdeveloper.vcs.cache.StatusCacheListener;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;

public class VCSWorkingCopyNonProjectBased {
    private String _vcsId;
    private String _adminPath;
    private Set<URL> _nonPrjRoots = Collections.synchronizedSet(new LinkedHashSet());
    private static final Map<String, VCSWorkingCopyNonProjectBased> _locators = new HashMap<String, VCSWorkingCopyNonProjectBased>();

    private VCSWorkingCopyNonProjectBased(String vcsId, String adminPath) {
        this._vcsId = vcsId;
        this._adminPath = adminPath;
        this.addListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized VCSWorkingCopyNonProjectBased getInstance(String vcsId, String adminPath) {
        Map<String, VCSWorkingCopyNonProjectBased> map = _locators;
        synchronized (map) {
            VCSWorkingCopyNonProjectBased locator = _locators.get(vcsId);
            if (locator == null) {
                locator = new VCSWorkingCopyNonProjectBased(vcsId, adminPath);
                _locators.put(vcsId, locator);
            }
            return locator;
        }
    }

    public boolean underRoot(URL url) {
        URL dir;
        if (url == null) {
            return false;
        }
        URL uRL = dir = URLFileSystem.isDirectoryPath((URL)url) ? url : URLFileSystem.getParent((URL)url);
        if (dir == null) {
            return false;
        }
        if (this.isRoot(dir)) {
            return true;
        }
        return this.isAdminDir(dir);
    }

    public URL[] getRoots() {
        return this._nonPrjRoots.toArray(new URL[0]);
    }

    public URL getRootContaining(URL url) {
        if (this.underRoot(url)) {
            for (URL root : this._nonPrjRoots) {
                if (!URLFileSystem.isBaseURLFor((URL)root, (URL)url)) continue;
                return root;
            }
        }
        return null;
    }

    private void addListener() {
        VCSProfileRegistry.getInstance().getProfile(this._vcsId).getPolicyStatusCache().addCacheListener(new StatusCacheListener(){

            @Override
            public final void statusesCleared(StatusCacheEvent e) {
                VCSWorkingCopyNonProjectBased.this.clear(e.getURLs(), e.getDepth());
            }
        });
    }

    private void clear(URL[] urls, Depth depth) {
        if (urls == null) {
            return;
        }
        for (URL url : urls) {
            URL parent = URLFileSystem.getParent((URL)url);
            this._nonPrjRoots.remove(parent);
        }
    }

    private boolean isRoot(URL dir) {
        for (URL url : this._nonPrjRoots) {
            if (!URLFileSystem.isBaseURLFor((URL)url, (URL)dir)) continue;
            return true;
        }
        return false;
    }

    private boolean isAdminDir(URL dir) {
        URL svnAdmin = URLFactory.newURL((URL)dir, (String)this._adminPath);
        if (URLFileSystem.exists((URL)svnAdmin)) {
            this._nonPrjRoots.add(dir);
            return true;
        }
        URL parent = URLFileSystem.getParent((URL)dir);
        if (parent != null && !URLFileSystem.isRoot((URL)dir)) {
            return this.isAdminDir(parent);
        }
        return false;
    }
}

