/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.ProductInformation;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.resource.VCSArb;

public class VCSComparePreferencesPanel
extends JPanel {
    private GridBagLayout m_layout = new GridBagLayout();
    private JLabel m_viewerLabel = new JLabel();
    private JRadioButton m_rbIntegratedCompare = new JRadioButton();
    private JRadioButton m_rbClientCompare = new JRadioButton();
    private Component m_clientPanel = new JPanel();
    private ButtonGroup m_buttonGroup;
    private boolean m_isClientToolAvailable = false;
    public static final int INTEGRATED_COMPARE = 0;
    public static final int CLIENT_COMPARE_TOOL = 1;
    public static final int EXTERNAL_COMPARE_TOOL = 2;

    public VCSComparePreferencesPanel() {
        this.jbInit();
        this.m_buttonGroup = new ButtonGroup();
        this.m_buttonGroup.add(this.m_rbIntegratedCompare);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    if (VCSComparePreferencesPanel.this.m_rbIntegratedCompare.isSelected()) {
                        VCSComparePreferencesPanel.this.m_clientPanel.setEnabled(false);
                    } else if (VCSComparePreferencesPanel.this.m_rbClientCompare.isSelected()) {
                        VCSComparePreferencesPanel.this.m_clientPanel.setEnabled(true);
                    }
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)VCSComparePreferencesPanel.this, (Throwable)re);
                }
            }
        };
        this.m_rbClientCompare.setVisible(false);
        this.m_clientPanel.setVisible(false);
        this.m_rbClientCompare.addActionListener(al);
        this.m_rbIntegratedCompare.addActionListener(al);
    }

    public void setSelectedOption(int selection) {
        if (selection == 1 && !this.m_isClientToolAvailable) {
            throw new IllegalArgumentException("Client tool not available.");
        }
        switch (selection) {
            case 1: {
                this.m_rbClientCompare.setSelected(true);
                this.m_clientPanel.setEnabled(true);
                break;
            }
            case 0: {
                this.m_rbIntegratedCompare.setSelected(true);
                this.m_clientPanel.setEnabled(false);
            }
        }
    }

    public int getSelectedOption() {
        if (this.m_rbClientCompare.isSelected()) {
            return 1;
        }
        return 0;
    }

    public void setClientToolDetails(String label, Component optionsComponent) {
        this.m_isClientToolAvailable = true;
        this.m_buttonGroup.add(this.m_rbClientCompare);
        this.m_rbClientCompare.setText(StringUtils.stripMnemonic((String)label));
        int mnemonic = StringUtils.getMnemonicKeyCode((String)label);
        if (mnemonic != -1) {
            this.m_rbClientCompare.setMnemonic(mnemonic);
        }
        if (optionsComponent != null) {
            this.remove(this.m_clientPanel);
            this.m_clientPanel = optionsComponent;
            this.add(this.m_clientPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 48, 0, 0), 0, 0));
        }
        this.m_rbClientCompare.setVisible(true);
    }

    private void jbInit() {
        this.setLayout(this.m_layout);
        ResourceUtils.resLabel((JLabel)this.m_viewerLabel, (Component)this.m_rbIntegratedCompare, (String)VCSArb.get("COMPARE_PREFS_VIEWER"));
        this.m_viewerLabel.setLabelFor(this.m_rbIntegratedCompare);
        ResourceUtils.resButton((AbstractButton)this.m_rbIntegratedCompare, (String)VCSArb.format("COMPARE_PREFS_JDEV", ProductInformation.getProductInformation().getShortName()));
        this.add((Component)this.m_viewerLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_rbIntegratedCompare, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 0), 0, 0));
        this.add((Component)this.m_rbClientCompare, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 0), 0, 0));
        this.add(this.m_clientPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 48, 0, 0), 0, 0));
    }
}

