/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.generic;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.cache.StatusCacheBridge;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSCommandType;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;

public abstract class ActionCommand
extends VCSCommand {
    private VCSProfile _profile;

    protected ActionCommand(int cmdId) {
        super(cmdId);
    }

    protected ActionCommand(int cmdId, int type) {
        super(cmdId, type);
    }

    protected ActionCommand(int cmdId, int type, String name) {
        super(cmdId, type, name);
    }

    protected ActionCommand(String commandId) {
        this(Ide.findCmdID((String)commandId));
    }

    protected ActionCommand(String commandId, int type) {
        this(Ide.findCmdID((String)commandId), type);
    }

    protected ActionCommand(String commandId, int type, String name) {
        this(Ide.findCmdID((String)commandId), type, name);
    }

    public void setProfile(VCSProfile profile) {
        this._profile = profile;
    }

    protected String getActionId() {
        return Ide.findCmdName((int)this.getId());
    }

    protected VCSProfile getProfile() {
        return this._profile;
    }

    protected VCSActionInfo getActionInfo() {
        return this.getProfile().getActionInfo(this.getActionId());
    }

    @Override
    @Deprecated
    protected VCSStatusCache getStatusCache() {
        return this.getProfile().getStatusCache();
    }

    @Override
    protected StatusCacheBridge<VCSStatus> getStatusCacheBridge() {
        return this.getProfile().getStatusCacheBridge();
    }

    @Override
    protected StatusCache<VCSStatus> getPolicyStatusCache() {
        return this.getProfile().getPolicyStatusCache();
    }

    @Override
    protected URLFilter getURLFilter() {
        return this.getProfile().getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT");
    }

    @Override
    protected boolean isAvailableImpl() throws Exception {
        return this.isAvailableImpl(this.getProfile());
    }

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        return this.requirementsSatisfied(profile) && this.locatablesValid(profile);
    }

    protected boolean requirementsSatisfied(VCSProfile profile) throws Exception {
        return this.getActionInfo().requirementsSatisfied(this.context);
    }

    protected boolean locatablesValid(VCSProfile profile) {
        try {
            return this.verifyStyle(profile) && this.verifyType(profile);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException(e);
            return false;
        }
    }

    private boolean verifyStyle(VCSProfile profile) throws Exception {
        VCSCommandStyle style = this.getActionInfo().getStyle();
        if (style == VCSCommandStyle.NORMAL) {
            return true;
        }
        List<Locatable> filtered = Arrays.asList(this.getOperands(profile));
        switch (filtered.size()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return style == VCSCommandStyle.MULTI;
    }

    private boolean verifyType(VCSProfile profile) throws Exception {
        VCSCommandType type = this.getActionInfo().getType();
        if (type == VCSCommandType.BOTH) {
            return true;
        }
        List<Locatable> filtered = Arrays.asList(this.getOperands(profile));
        if (type == VCSCommandType.FILE) {
            for (Locatable loc : filtered) {
                if (!URLFileSystem.isDirectory((URL)loc.getURL())) continue;
                return false;
            }
            return true;
        }
        if (type == VCSCommandType.FOLDER) {
            for (Locatable loc : filtered) {
                if (!URLFileSystem.isRegularFile((URL)loc.getURL())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected int doitImpl() throws Exception {
        return this.doitImpl(this.getProfile());
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        Locatable[] locatables = this.getOperands(profile);
        try {
            if (!this.saveDirtyNodes(locatables)) {
                return 1;
            }
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)ioe, (String)IdeUtil.getProgramName(), (String)ioe.getMessage(), null);
            return -1;
        }
        return this.doitImplInvoke(profile, locatables);
    }

    protected int doitImplInvoke(VCSProfile profile, Locatable[] locatables) throws Exception {
        CommandState commandState = this.getCommandState(profile, locatables);
        if (commandState == null) {
            return 9;
        }
        if (this.isSilent(this.getContext(), profile)) {
            this.invokeCommandSilently(profile, commandState);
            return 1;
        }
        boolean success = this.invokeCommand(profile, commandState);
        if (success) {
            this.postInvoke(profile, commandState);
        }
        return success ? 0 : 1;
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Collection c = this.getActionInfo().getFilteredSelection(this.getContext());
        return c.toArray(new Locatable[c.size()]);
    }

    protected boolean saveDirtyNodes(Locatable[] contextLocatables) throws Exception {
        return VCSCommandUtils.saveDirtyNodes(contextLocatables);
    }

    protected boolean isSilent(Context context, VCSProfile profile) {
        View view = context.getView();
        return this.isChangeListAction(view, profile) && !this.isDialogRequired(view instanceof ChangeListWindow ? (ChangeListWindow)view : null, profile);
    }

    protected boolean isChangeListAction(View view, VCSProfile profile) {
        String clViewId = profile.getChangeListViewID();
        if (clViewId != null && view != null && view instanceof ChangeListWindow && clViewId.equals(view.getId())) {
            return this.getActionInfo().isChangeListAction();
        }
        return false;
    }

    protected boolean isDialogRequired(ChangeListWindow changeListWindow, VCSProfile profile) {
        if (changeListWindow == null) {
            return true;
        }
        ChangeList changeList = changeListWindow.getContextChangeList();
        return !profile.getPendingChangesAdapter().isActionSilent(changeList, this.getActionId());
    }

    protected CommandState getCommandState(VCSProfile profile, Locatable[] locatables) throws Exception {
        if (locatables == null || locatables.length == 0) {
            return null;
        }
        URL[] urls = VCSModelUtils.convertNodesToURLs(locatables);
        Node[] affectedNodes = VCSModelUtils.findCachedNodes(VCSURLFilters.createBaseURLContentsFilter(urls));
        Map<Node, Long> timestamps = VCSBufferUtils.storeTimestamps(Arrays.asList(affectedNodes));
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(urls);
        CommandState commandState = this.createCommandState();
        this.configureCommandState(commandState, invokableState, timestamps, locatables);
        return commandState;
    }

    protected CommandState createCommandState() {
        return new CommandState();
    }

    protected void configureCommandState(CommandState commandState, VCSDirectoryInvokableState invokableState, Map timestamps, Locatable[] locatables) {
        commandState.setInvokableState(invokableState);
        commandState.setTimestampMap(timestamps);
        commandState.setLocatables(locatables);
    }

    protected boolean invokeCommand(final VCSProfile profile, final CommandState commandState) throws Exception {
        List<Locatable> nodes = Arrays.asList(commandState.getLocatables());
        VCSOptionsCustomizer customizer = this.createOptionsCustomizer(nodes);
        this.setCommandSpecificCustomizerOptions(profile, customizer);
        final JEWTDialog dialog = this.createOperationDialog(nodes, customizer);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected boolean doCommitOperation(Map options) throws Exception {
                return ActionCommand.this.invokeCommandImpl(profile, commandState, (Component)dialog, options);
            }
        });
        return VCSDialogRunner.runDialog((JDialog)dialog);
    }

    protected void setCommandSpecificCustomizerOptions(VCSProfile profile, VCSOptionsCustomizer customizer) {
    }

    protected VCSOptionsCustomizer createOptionsCustomizer(Collection nodes) {
        return this.createOptionsCustomizer();
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        return null;
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer) {
        return VCSComponents.createOperationDialog(VCSWindowUtils.getCurrentWindow(), this.getDialogTitle(), this.getDialogHint(), VCSComponents.createFileListerComponent(nodes), customizer != null ? customizer.getComponent() : null, this.getHelpTopicId(), customizer != null ? customizer.getInitialFocusComponent() : null);
    }

    protected String getDialogTitle() {
        String title = this.getActionInfo().getDialogTitle();
        if (title == null || title.equals("")) {
            title = "VCS Operation";
        }
        return title;
    }

    protected String getDialogHint() {
        return this.getActionInfo().getDialogHint();
    }

    protected String getHelpTopicId() {
        return this.getActionInfo().getHelpTopicId();
    }

    protected boolean invokeCommandSilently(final VCSProfile profile, final CommandState commandState) throws Exception {
        Ide.getWaitCursor().show(0);
        Thread runner = new Thread("ActionCommand"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    VCSOptionsCustomizer optionsCustomizer;
                    View view = ActionCommand.this.getContext().getView();
                    ChangeList changeList = null;
                    if (view instanceof ChangeListWindow) {
                        changeList = ((ChangeListWindow)view).getContextChangeList();
                    } else if (view instanceof ChangeListWindow) {
                        changeList = ((ChangeListWindow)view).getChangeList();
                    }
                    VCSOptionsCustomizer vCSOptionsCustomizer = optionsCustomizer = changeList != null ? changeList.getOptionsCustomizer() : null;
                    if (optionsCustomizer != null) {
                        optionsCustomizer.validateOptions();
                    }
                    Map<?, ?> options = changeList != null && changeList.getOptionsCustomizer() != null ? changeList.getOptionsCustomizer().getOptions() : Collections.EMPTY_MAP;
                    ActionCommand.this.invokeCommandSilentlyImpl(profile, commandState, options);
                }
                catch (Exception e) {
                    try {
                        ActionCommand.this.getExceptionHandler().handleException(e);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ActionCommand.this.postInvoke(profile, commandState);
                                }
                                catch (Exception e) {
                                    ActionCommand.this.getExceptionHandler().handleException(e);
                                }
                                finally {
                                    Ide.getWaitCursor().hide();
                                }
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        runner.start();
        return true;
    }

    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        return true;
    }

    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        return true;
    }

    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        Collection<URL> processed = commandState.getInvokableState().getProcessedURLs();
        URL[] urls = processed.toArray(new URL[processed.size()]);
        this.fireFileStructureChanged(urls);
        profile.getStatusCacheBridge().clear(urls);
        if (processed.size() > 0) {
            VCSBufferUtils.reloadBuffers(commandState.getTimestampMap());
        }
        VCSControlCache.getInstance().fireControlStateChanged(profile.getID());
    }
}

