/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.annotations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DefaultCaret;
import oracle.ide.ExtensionRegistry;
import oracle.ide.hover.HoverFlavor;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.jdeveloper.vcs.annotations.AnnotationMark;
import oracle.jdeveloper.vcs.annotations.VCSAnnotationExtention;
import oracle.jdeveloper.vcs.tracking.VCSBugTrackingHook;

final class AnnotationHover
extends InfoTipHover {
    static AnnotationHover get(final AnnotationMark mark, JComponent parent, Rectangle r, final InfoTipStyles style) {
        Collection<String> bugs;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        Insets insets = style.getBorderInsets();
        panel.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        panel.setOpaque(false);
        String revision = mark.getRevisionLabel();
        CopyableLabel revisionField = new CopyableLabel(revision);
        revisionField.setBorder(BorderFactory.createEmptyBorder());
        revisionField.setOpaque(false);
        revisionField.setEditable(false);
        revisionField.setFont(style.getItemTitleFont());
        GridBagConstraints gbc = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, style.getItemTitleInsets(), 0, 0);
        panel.add((Component)revisionField, gbc);
        String date = mark.getDate();
        if (date != null) {
            CopyableLabel dateField = new CopyableLabel(date);
            dateField.setBorder(BorderFactory.createEmptyBorder());
            dateField.setForeground(style.getContentTextColor());
            gbc.insets = new Insets(0, 0, 0, 0);
            panel.add((Component)dateField, gbc);
        }
        CopyableLabel authorField = new CopyableLabel(mark.getAuthor());
        authorField.setBorder(BorderFactory.createEmptyBorder());
        authorField.setForeground(style.getContentTextColor());
        gbc.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)authorField, gbc);
        String comment = mark.getComment();
        int preferredWidth = Math.max(300, revisionField.getPreferredSize().width);
        if (comment != null && !comment.isEmpty()) {
            JTextArea text = new JTextArea(comment.trim());
            text.setBackground(Color.WHITE);
            text.setEditable(false);
            text.setColumns(50);
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            text.setRows(10);
            text.setForeground(style.getContentTextColor());
            JScrollPane pane = new JScrollPane(text);
            pane.setBorder(BorderFactory.createLineBorder(style.getInternalBorderColor()));
            pane.setHorizontalScrollBarPolicy(31);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(3, 0, 0, 0);
            panel.add((Component)pane, gbc);
            preferredWidth = Math.max(preferredWidth, pane.getPreferredSize().width);
        }
        if ((bugs = mark.getBugNumbers()).size() > 0) {
            AnnotationHover.addExtendedProperties(style, panel, mark.getLink().getLabel(), gbc, preferredWidth, mark.getLink().isEnabled(), bugs, new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (mark.getLink().isEnabled()) {
                        e.getComponent().setForeground(style.getHyperLinkTextColor(true));
                        e.getComponent().setEnabled(true);
                    } else {
                        e.getComponent().setEnabled(false);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (mark.getLink().isEnabled()) {
                        e.getComponent().setForeground(style.getHyperLinkTextColor(false));
                    }
                }
            }, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object obj = e.getSource();
                    if (obj instanceof AbstractButton) {
                        mark.getLink().openLink(mark.getURL(), ((AbstractButton)obj).getText());
                    }
                }
            });
        } else {
            for (final VCSAnnotationExtention annotate : AnnotationHover.getAnnotations()) {
                Collection<String> issues = annotate.getIssues(mark.getURL(), mark.getComment());
                if (issues.isEmpty()) continue;
                AnnotationHover.addExtendedProperties(style, panel, annotate.getLabel(), gbc, preferredWidth, annotate.isEnabled(), issues, new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (annotate.isEnabled()) {
                            e.getComponent().setForeground(style.getHyperLinkTextColor(true));
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        if (annotate.isEnabled()) {
                            e.getComponent().setForeground(style.getHyperLinkTextColor(false));
                        }
                    }
                }, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object obj = e.getSource();
                        if (obj instanceof AbstractButton) {
                            annotate.openIssue(mark.getURL(), ((AbstractButton)obj).getText());
                        }
                    }
                });
            }
        }
        return new AnnotationHover((Template)new BasicTemplate((JComponent)panel), InfoTipStyles.DEFAULT, parent, r);
    }

    private static void addExtendedProperties(InfoTipStyles style, JPanel panel, String labelTxt, GridBagConstraints gbc, int preferredWidth, boolean enabled, Collection<String> bugs, MouseListener mlistener, ActionListener aListener) {
        if (bugs != null && !bugs.isEmpty()) {
            ArrayList<String> bugList = new ArrayList<String>(bugs);
            Collections.sort(bugList);
            JPanel bugPanel = new JPanel(new FlowLayout(0, 0, 0));
            bugPanel.setOpaque(false);
            JLabel label = new JLabel(labelTxt);
            label.setOpaque(false);
            label.setForeground(style.getContentTextColor());
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
            bugPanel.add(label);
            int w = 0;
            int h = 0;
            int maxHeight = 0;
            for (String bug : bugList) {
                HyperlinkButton bugField = new HyperlinkButton(bug);
                if (enabled) {
                    bugField.setForeground(style.getHyperLinkTextColor(false));
                } else {
                    bugField.setForeground(style.getContentTextColor());
                    bugField.setEnabled(false);
                }
                bugField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                Dimension d = bugField.getPreferredSize();
                d.width += 5;
                bugField.setPreferredSize(d);
                if ((w += d.width) > preferredWidth) {
                    w = d.width;
                    h += maxHeight;
                    maxHeight = 0;
                }
                maxHeight = Math.max(maxHeight, d.height);
                bugField.addMouseListener(mlistener);
                bugField.addActionListener(aListener);
                bugPanel.add((Component)bugField);
            }
            bugPanel.setPreferredSize(new Dimension(w + 3, h += maxHeight));
            gbc.insets = new Insets(3, 0, 0, 0);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            panel.add((Component)bugPanel, gbc);
        }
    }

    private AnnotationHover(Template template, InfoTipStyles style, JComponent parent, Rectangle location) {
        super(template, style, parent, location, HoverFlavor.getFlavor((String)"info"));
    }

    public boolean shouldHideHover(KeyEvent event) {
        return false;
    }

    private static Collection<VCSAnnotationExtention> getAnnotations() {
        VCSBugTrackingHook hook = (VCSBugTrackingHook)ExtensionRegistry.getExtensionRegistry().getHook(VCSBugTrackingHook.HOOK);
        return hook.getAnnotations();
    }

    private static final class CopyableLabel
    extends JTextField {
        public CopyableLabel(String text) {
            super(text);
            this.setOpaque(false);
            this.setEditable(false);
            this.setCaret(new DefaultCaret(){

                @Override
                public void paint(Graphics g) {
                }
            });
        }
    }
}

