/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.usage.UsageData;
import oracle.dbtools.raptor.usage.UsagesTracker;
import oracle.dbtools.raptor.usages.FeatureUsageReport;
import oracle.dbtools.raptor.usages.FileSender;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;

public final class UsagesTrackerImpl
extends UsagesTracker {
    private static final String LOG_FILE_PREFIX = "sqldev-usages-";
    private static final String LOG_FILE_EXTENSION = ".log";
    private static final String RETAIN_USAGES_TRACKING_LOGS_PROPERTY = "retain.usages.tracking.logs";
    private URL _extensionDir;
    private String _baseLogFileName;
    private Long _startTime;
    private boolean _userHasOptedInOut;
    private ShutdownHook _shutDownHook;
    private static final UsageData NULL_USAGE = new NullUsageData();
    private static final LogFileFilter LOG_FILE_FILTER = new LogFileFilter();
    private ArrayList<UsageData> activity = new ArrayList();

    public UsagesTrackerImpl() {
        this._startTime = System.currentTimeMillis();
        this.purgeAndProcessLogs();
        this.configureListeners();
    }

    @Override
    public void report(UsageData usageData) {
        if (!UsagesTrackerImpl.isOn()) {
            return;
        }
        Assert.check((usageData != null ? 1 : 0) != 0, (String)"UsageData should not be null.");
        this.activity.add(usageData);
        if (this.activity.size() == 50) {
            this.flushToFile();
        }
    }

    private void flushToFile() {
        final ArrayList arrayList = (ArrayList)this.activity.clone();
        this.activity.clear();
        RaptorTask raptorTask = new RaptorTask("Usage Data", true, IRaptorTaskRunMode.NO_GUI){

            protected Object doWork() throws TaskException {
                UsagesTrackerImpl.this.logToFile(arrayList);
                return null;
            }
        };
        if (Ide.isQuitting()) {
            this.logToFile(arrayList);
        } else {
            raptorTask.setCancellable(false);
            RaptorTaskManager.getInstance().addTask(raptorTask);
        }
    }

    private void logToFile(ArrayList<UsageData> arrayList) {
        try {
            URL uRL = this.uniqueLogFileURL();
            FeatureUsageReport.writeReport(this._startTime.toString(), arrayList, uRL);
            File file = new File(uRL.getPath());
            if (!Ide.isQuitting() && FileSender.getInstance().logToServer(file)) {
                this.deleteFile(file);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private URL uniqueLogFileURL() {
        String string = LOG_FILE_PREFIX + System.currentTimeMillis() + LOG_FILE_EXTENSION;
        URL uRL = URLFactory.newURL((URL)this.extensionDir(), (String)string);
        return URLFactory.newFileURL((File)new File(uRL.getPath()));
    }

    private URL extensionDir() {
        if (this._extensionDir == null) {
            this._extensionDir = ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.sqldeveloper.extras");
        }
        return this._extensionDir;
    }

    private void processUnsentLogs() {
        boolean bl;
        File[] fileArray = this.getPendingLogs();
        if (fileArray != null && fileArray.length > 0 && (bl = FileSender.getInstance().logToServer(fileArray))) {
            for (File file : fileArray) {
                this.deleteFile(file);
            }
        }
    }

    private File[] getPendingLogs() {
        File file = new File(this.extensionDir().getPath());
        return file.listFiles(LOG_FILE_FILTER);
    }

    private void deleteFile(File file) {
        if (Boolean.getBoolean(RETAIN_USAGES_TRACKING_LOGS_PROPERTY)) {
            this.backupFile(file);
            return;
        }
        try {
            URI uRI = file.toURI();
            URL uRL = uRI.toURL();
            URLFileSystem.delete((URL)uRL);
        }
        catch (MalformedURLException malformedURLException) {
            file.deleteOnExit();
        }
    }

    private void backupFile(File file) {
        try {
            URL uRL = file.toURI().toURL();
            URL uRL2 = URLFactory.newDirURL((String)file.getParent());
            String string = file.getName() + ".bak";
            URL uRL3 = URLFactory.newURL((URL)uRL2, (String)string);
            boolean bl = URLFileSystem.renameTo((URL)uRL, (URL)uRL3);
            Assert.println((String)String.format("%s %s %s %s %s", "Rename", URLFileSystem.getPlatformPathName((URL)uRL), "to\n             ", URLFileSystem.getPlatformPathName((URL)uRL3), bl ? "succeeded" : "failed"));
        }
        catch (MalformedURLException malformedURLException) {
            Assert.println((String)("Failed to backup log file: " + file));
            Assert.printStackTrace((Throwable)malformedURLException);
        }
    }

    private void purgeOldLogs() {
        File[] fileArray = this.getPendingLogs();
        if (fileArray != null && fileArray.length > 0) {
            for (File file : fileArray) {
                this.maybePurgeFile(file);
            }
        }
    }

    private void maybePurgeFile(File file) {
        long l = file.lastModified();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        if (calendar.after(l)) {
            this.deleteFile(file);
        }
    }

    private void purgeAndProcessLogs() {
        if (!UsagesTrackerImpl.isOn()) {
            return;
        }
        RaptorTask raptorTask = new RaptorTask("Usage Data", true, IRaptorTaskRunMode.NO_GUI){

            protected Object doWork() throws TaskException {
                UsagesTrackerImpl.this.purgeOldLogs();
                UsagesTrackerImpl.this.processUnsentLogs();
                return null;
            }
        };
        raptorTask.setCancellable(false);
        RaptorTaskManager.getInstance().addTask(raptorTask);
    }

    private void configureListeners() {
        if (UsagesTrackerImpl.isOn()) {
            ExitCommand.addShutdownHook((ShutdownHook)this.getShutdownHook());
        } else if (this._shutDownHook != null) {
            ExitCommand.removeShutdownHook((ShutdownHook)this._shutDownHook);
        }
    }

    private ShutdownHook getShutdownHook() {
        if (this._shutDownHook == null) {
            this._shutDownHook = new ShutdownHandler();
        }
        return this._shutDownHook;
    }

    @Override
    public UsageData createUsageData() {
        return new UsageData();
    }

    private static class NullUsageData
    extends UsageData {
    }

    private static class LogFileFilter
    implements FilenameFilter {
        private LogFileFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string != null && string.startsWith(UsagesTrackerImpl.LOG_FILE_PREFIX) && string.endsWith(UsagesTrackerImpl.LOG_FILE_EXTENSION);
        }
    }

    private class ShutdownHandler
    implements ShutdownHook {
        private ShutdownHandler() {
        }

        public boolean canShutdown() {
            return true;
        }

        public void shutdown() {
            if (!UsagesTracker.isOn()) {
                return;
            }
            UsagesTrackerImpl.this.flushToFile();
        }
    }
}

