/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ExtrasMessages;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.standalone.connection.ConnectionUtils;
import oracle.dbtools.raptor.utils.ConnectionMessages;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.OracleEnvHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;

public class AutoCreateController
implements Controller {
    private static final String NEW_LOCAL_CONN_CMD = "DatabaseNavigator.NewLocalConnection";
    static final int NEW_LOCAL_DBCONN_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.NewLocalConnection");
    private static String s_folderName = ConnectionMessages.get((String)"GENERATE_CONNECTIONS");
    private static final String SYSDBA_CONNECTION_NAME = "/ as sysdba";
    private static QueryXMLSupport s_xml;

    protected static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(AutoCreateController.class.getClassLoader(), "/oracle/dbtools/raptor/standalone/autocreate.xml"));
        }
        return s_xml;
    }

    private void createLocalConnections(Context context) {
        Databases databases;
        String string = OracleEnvHelper.getOracleEnv((String)"ORACLE_SID");
        if (string != null) {
            ConnectionUtils.addConnection(SYSDBA_CONNECTION_NAME, "/", null, null, null, null, false, null, "sysdba", s_folderName);
            ConnectionUtils.addConnection("system-" + string, "system", null, string, "localhost", "1521", false, null, null, s_folderName);
        }
        try {
            Connection connection = DatabaseConnectionStores.getInstance().getStore("IdeConnections").getConnection(SYSDBA_CONNECTION_NAME);
            if (connection != null) {
                databases = DBUtil.getInstance((Connection)connection);
                Query query = AutoCreateController.getXMLQueries().getQuery("AUTOCREATE_SCHEMALIST", connection);
                List list = databases.executeReturnList(query.getSql(), null);
                String string2 = null;
                for (Map map : list) {
                    string2 = (String)map.get("USERNAME");
                    ConnectionUtils.addNewConnectionBasedOn(s_folderName, SYSDBA_CONNECTION_NAME, string2, null);
                }
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        databases = (Databases)context.getNode();
        UpdateMessage.fireStructureChanged((Subject)databases);
    }

    public boolean handleEvent(IdeAction ideAction, final Context context) {
        if (ideAction.getCommandId() == NEW_LOCAL_DBCONN_CMD_ID) {
            Node node = context.getNode();
            if (node instanceof Databases) {
                RaptorTask<Void> raptorTask = new RaptorTask<Void>(ExtrasMessages.getString((String)"CREATING_CONNECTIONS")){

                    protected Void doWork() throws TaskException {
                        AutoCreateController.this.createLocalConnections(context);
                        return null;
                    }
                };
                raptorTask.setCancellable(false);
                RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == NEW_LOCAL_DBCONN_CMD_ID) {
            boolean bl = Connections.isOCIDriverAvailable();
            ideAction.setEnabled(bl);
            return true;
        }
        return false;
    }
}

