/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.logging;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TableCellWithTooltip
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            if (object instanceof Integer) {
                this.setToolTip(jLabel, ((Integer)object).toString());
            } else if (object != null) {
                jLabel.setIcon(null);
                String string = object.toString();
                if (string != null) {
                    if (jTable.convertColumnIndexToModel(n2) == 3 || string.startsWith("<", 0)) {
                        jLabel.setText(TableCellWithTooltip.scrubClass(string));
                    }
                    this.setToolTip(jLabel, string);
                }
            }
        }
        return component;
    }

    public static String scrubClass(String string) {
        if (string != null) {
            return string.replaceAll("oracle[.]", "o.").replaceAll("raptor[.]", "r.").replaceAll("javatools[.]", "jt.").replaceAll("java[.]", "j.").replaceAll("dbtools[.]", "d.");
        }
        return string;
    }

    private void setToolTip(JLabel jLabel, String string) {
        String string2 = string.toString();
        if (string2.length() > 200) {
            string2 = string2.substring(0, 200) + "\n...";
        }
        jLabel.setToolTipText("<html>" + string2.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br>") + "</html>");
    }
}

