/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.Workspace;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.ExtensionLibrary;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.library.LibraryReference;
import oracle.jdeveloper.library.UnresolvedLibrary;
import oracle.jdeveloper.model.ApplicationLibraries;
import oracle.jdevimpl.library.LibrariesHook;

public class JProjectLibraries
extends HashStructureAdapter {
    public static final String DATA_KEY = "oracle.jdevimpl.config.JProjectLibraries";
    public static final String JDK_NAME = "jdkReference";
    public static final String LIBRARIES = "libraryReferences";
    public static final String LIB_LIST = "internalDefinitions";
    public static final String EXPORTS = "exportedReferences";
    public static final String OVERRIDE_APP_LIBS = "overrideApplicationLibraries";
    private final Project project;

    public JProjectLibraries(HashStructure hash) {
        this(null, hash);
    }

    private JProjectLibraries(Project project, HashStructure hash) {
        super(hash);
        this.project = project;
    }

    public static JProjectLibraries getInstance(PropertyStorage prj) {
        boolean wasClean = prj != null && prj == Ide.getDefaultProject() ? !((Project)prj).isDirty() : false;
        HashStructure hash = JProjectLibraries.findOrCreate((PropertyStorage)prj, (String)DATA_KEY);
        JProjectLibraries settings = new JProjectLibraries(prj instanceof Project ? (Project)prj : null, hash);
        if (wasClean && ((Project)prj).isDirty()) {
            try {
                ((Project)prj).save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return settings;
    }

    public JDK getJDK() {
        LibraryReference ref;
        JDK jdk = null;
        HashStructure struct = this._hash.getHashStructure(JDK_NAME);
        LibraryReference libraryReference = ref = struct != null ? new LibraryReference(struct) : null;
        if (ref != null && ref.isJDK()) {
            JProjectLibraryList list = this.getProjectLibraryList();
            JDK jDK = jdk = list != null ? list.findJDK(ref.getID()) : null;
            if (jdk == null) {
                jdk = (JDK)ref.getLibrary();
            }
        }
        return jdk != null ? jdk : JLibraryManager.getDefaultJDK();
    }

    public void setJDK(final JDK jdk) {
        if (jdk == null || jdk == JLibraryManager.getDefaultJDK()) {
            this._hash.remove(JDK_NAME);
        } else {
            this._hash.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    HashStructure struct = JProjectLibraries.this._hash.getOrCreateHashStructure(JProjectLibraries.JDK_NAME);
                    LibraryReference ref = new LibraryReference(struct);
                    ref.setLibrary(jdk);
                }
            });
        }
    }

    public VersionNumber getJdkVersionNumber() {
        JDK jdk = this.getJDK();
        return jdk != null ? jdk.getJavaVersion() : null;
    }

    public String[] getLibraryList() {
        JLibrary[] libs = this.getLibraries();
        String[] ids = new String[libs != null ? libs.length : 0];
        for (int i = 0; i < ids.length; ++i) {
            Object id = libs[i].getID();
            if (id == null) {
                id = libs[i].getName();
            }
            ids[i] = id != null ? id.toString() : "";
        }
        return ids;
    }

    public JLibrary[] getLibraries() {
        ListStructure libs = this._hash.getListStructure(LIBRARIES);
        List list = this.getLibraries(libs);
        return list.toArray(new JLibrary[list.size()]);
    }

    public boolean hasLibrary(Object id) {
        ListStructure libs;
        List list;
        JLibrary lib = this.resolveLibrary(id);
        return lib != null && (list = this.getLibraries(libs = this._hash.getOrCreateListStructure(LIBRARIES))).contains(lib);
    }

    public void setLibraries(JLibrary[] newLibs) {
        if (newLibs == null) {
            this._hash.remove(LIBRARIES);
        } else {
            ListStructure libs = this._hash.getOrCreateListStructure(LIBRARIES);
            this.setLibraries(libs, newLibs);
        }
    }

    public JLibrary[] getExports() {
        ListStructure exports = this._hash.getListStructure(EXPORTS);
        List list = this.getLibraries(exports);
        return list.toArray(new JLibrary[list.size()]);
    }

    public boolean hasExport(Object id) {
        ListStructure libs;
        List list;
        JLibrary lib = this.resolveLibrary(id);
        return lib != null && (list = this.getLibraries(libs = this._hash.getOrCreateListStructure(EXPORTS))).contains(lib);
    }

    public void setExports(JLibrary[] exports) {
        if (exports == null) {
            this._hash.remove(EXPORTS);
        } else {
            ListStructure ls = this._hash.getOrCreateListStructure(EXPORTS);
            this.setLibraries(ls, exports);
        }
    }

    public JProjectLibraryList getProjectLibraryList() {
        return JProjectLibraryList.getInstance(this._hash.getOrCreateHashStructure(LIB_LIST));
    }

    public void setProjectLibraryList(JProjectLibraryList newList) {
        if (newList == null) {
            this._hash.remove(LIB_LIST);
        } else {
            JProjectLibraryList oldList = this.getProjectLibraryList();
            newList.copyTo(oldList);
        }
    }

    public boolean addLibrary(Object id) {
        return this.addLibrary(id, true);
    }

    public boolean addLibrary(Object id, final boolean export) {
        ListStructure libs;
        List list;
        final JLibrary lib = this.resolveLibrary(id);
        if (lib != null && !(list = this.getLibraries(libs = this._hash.getOrCreateListStructure(LIBRARIES))).contains(lib)) {
            if (this.applicationHasLibrary(lib)) {
                this.addTechnologies(lib);
                return false;
            }
            this._hash.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    ListStructure exportLibs;
                    List exportList;
                    list.add(lib);
                    JProjectLibraries.this.setLibraries(libs, list.toArray(new JLibrary[list.size()]));
                    if (export && !(exportList = JProjectLibraries.this.getLibraries(exportLibs = JProjectLibraries.this._hash.getOrCreateListStructure(JProjectLibraries.EXPORTS))).contains(lib)) {
                        exportList.add(lib);
                        JProjectLibraries.this.setLibraries(exportLibs, exportList.toArray(new JLibrary[exportList.size()]));
                    }
                }
            });
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLibrary(Object id) {
        JLibrary lib = this.resolveLibrary(id);
        if (lib != null) {
            List list;
            ListStructure libs = this._hash.getListStructure(LIBRARIES);
            List list2 = list = libs != null ? this.getLibraries(libs) : null;
            if (list != null && list.contains(lib)) {
                List exports;
                list.remove(lib);
                this.setLibraries(libs, list.toArray(new JLibrary[list.size()]));
                ListStructure exportedLibs = this._hash.getListStructure(EXPORTS);
                List list3 = exports = exportedLibs != null ? this.getLibraries(exportedLibs) : null;
                if (exports != null && exports.contains(lib)) {
                    exports.remove(lib);
                    this.setExports(exports.toArray(new JLibrary[exports.size()]));
                }
                return true;
            }
        } else {
            ListStructure testStruct = this._hash.getListStructure(LIBRARIES);
            if (testStruct == null) {
                return true;
            }
            Object object = testStruct.iteratorLock();
            synchronized (object) {
                Iterator i = testStruct.iterator();
                while (i.hasNext()) {
                    Object obj = i.next();
                    UnresolvedLibrary unresolvedLib = new UnresolvedLibrary((HashStructure)obj);
                    if (!id.equals(unresolvedLib.getID())) continue;
                    i.remove();
                    return true;
                }
            }
        }
        return false;
    }

    public JLibrary resolveLibrary(Object id) {
        JLibrary lib;
        JProjectLibraryList list = this.getProjectLibraryList();
        JLibrary jLibrary = lib = list != null ? list.findLibrary(id) : null;
        if (lib == null) {
            lib = JLibraryManager.findLibrary(id);
        }
        return this.override(lib);
    }

    public JDK resolveJDK(Object id) {
        JDK jdk;
        JProjectLibraryList list = this.getProjectLibraryList();
        JDK jDK = jdk = list != null ? list.findJDK(id) : null;
        if (jdk == null) {
            jdk = JLibraryManager.findJDK(id);
        }
        return jdk;
    }

    public boolean getOverrideApplicationLibraries() {
        return this._hash.getBoolean(OVERRIDE_APP_LIBS, false);
    }

    public void setOverrideApplicationLibraries(boolean override) {
        if (override) {
            this._hash.putBoolean(OVERRIDE_APP_LIBS, override);
        } else {
            this._hash.remove(OVERRIDE_APP_LIBS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getLibraries(ListStructure libs) {
        ArrayList<JLibrary> result = new ArrayList<JLibrary>();
        if (libs == null) {
            return result;
        }
        JProjectLibraryList list = this.getProjectLibraryList();
        Object object = libs.iteratorLock();
        synchronized (object) {
            for (HashStructure struct : libs) {
                JLibrary lib;
                LibraryReference ref = new LibraryReference(struct);
                Object id = ref.getID();
                JLibrary jLibrary = lib = list != null ? list.findLibrary(id) : null;
                if (lib == null && (lib = (JLibrary)ref.getLibrary()) == null) {
                    lib = new UnresolvedLibrary(id);
                }
                result.add(this.override(lib));
            }
        }
        return result;
    }

    private void setLibraries(ListStructure libs, JLibrary[] newLibs) {
        ArrayList<HashStructure> copy = new ArrayList<HashStructure>();
        for (int i = 0; i < newLibs.length; ++i) {
            HashStructure struct = HashStructure.newInstance();
            LibraryReference ref = new LibraryReference(struct);
            ref.setLibrary(newLibs[i]);
            copy.add(struct);
        }
        libs.mirror(copy);
    }

    private boolean applicationHasLibrary(JLibrary lib) {
        Workspace workspace;
        return this.project != null && (workspace = this.project.getWorkspace()) != null && ApplicationLibraries.getInstance(workspace).getLibraryReferences().contains(lib);
    }

    private void addTechnologies(JLibrary library) {
        ExtensionLibrary extensionLibrary;
        if (library instanceof ExtensionLibrary && this.project != null && (extensionLibrary = (ExtensionLibrary)library).getForceExtensionInitialization()) {
            String extensionId = extensionLibrary.getProviderExtensionId();
            Collection techIds = TechnologyRegistry.getInstance().getTechnologiesOfGroupByMemberExtension(Collections.singleton(extensionId));
            if (!techIds.isEmpty()) {
                TechnologyScopeConfiguration.getInstance((PropertyStorage)this.project).updateTechnologyScope(techIds.toArray(new String[techIds.size()]));
            }
        }
    }

    private JLibrary override(JLibrary original) {
        if (this.project != null && original != null && !(original instanceof UnresolvedLibrary)) {
            return LibrariesHook.getInstance().getLibraryOverride(this.project.getWorkspace(), this.project, original);
        }
        return original;
    }
}

