/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKAdapter;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryAdapter;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryReference;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.resource.LibraryArb;

public abstract class InternalLibraryList
extends HashStructureAdapter
implements MutableLibraryList {
    private static final String LIB_BASE = LibraryArb.getString(10);
    private static final String JDK_BASE = LibraryArb.getString(11);
    private static final int NAME = 0;
    private static final int ID = 1;

    public InternalLibraryList(HashStructure hash) {
        super(hash);
    }

    @Override
    public void setListName(String name) {
    }

    @Override
    public JDK findJDK(Object id) {
        Iterator i;
        if (id == null) {
            return null;
        }
        List list = this.getJdkList();
        Iterator iterator = i = list != null ? list.iterator() : null;
        if (i != null) {
            while (i.hasNext()) {
                JDK jdk = (JDK)i.next();
                if (jdk.getID() == null || !id.equals(jdk.getID())) continue;
                return jdk;
            }
        }
        return null;
    }

    @Override
    public JLibrary findLibrary(Object id) {
        Iterator i;
        if (id == null) {
            return null;
        }
        List list = this.getLibraryList();
        Iterator iterator = i = list != null ? list.iterator() : null;
        if (i != null) {
            while (i.hasNext()) {
                JLibrary lib = (JLibrary)i.next();
                if (!id.equals(lib.getID())) continue;
                return lib;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getLibraryList() {
        ArrayList<JLibraryAdapter> libs = new ArrayList<JLibraryAdapter>();
        ListStructure data = this._hash.getListStructure("libraryDefinitions");
        if (data != null) {
            Object object = data.iteratorLock();
            synchronized (object) {
                for (Object o : data) {
                    libs.add(new JLibraryAdapter((HashStructure)o));
                }
            }
        }
        return libs;
    }

    @Override
    public void setLibraryList(List libraries) {
        if (libraries == null) {
            this._hash.remove("libraryDefinitions");
        } else {
            ArrayList<HashStructure> hashes = new ArrayList<HashStructure>(libraries.size());
            for (Object library : libraries) {
                HashStructure hash = HashStructure.newInstance();
                JLibraryAdapter copy = new JLibraryAdapter(hash);
                ((JLibraryAdapter)library).copyTo(copy);
                hashes.add(hash);
            }
            this._hash.getOrCreateListStructure("libraryDefinitions").mirror(hashes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getJdkList() {
        ArrayList<JDK> jdks = new ArrayList<JDK>();
        ListStructure data = this._hash.getListStructure("jdkDefinitions");
        if (data != null) {
            Object object = data.iteratorLock();
            synchronized (object) {
                for (Object o : data) {
                    HashStructure hash = (HashStructure)o;
                    URL execURL = hash.getURL("javaExecutable");
                    if (execURL == null) {
                        LibraryReference ref = new LibraryReference(hash);
                        JDK jdk = (JDK)ref.getLibrary();
                        if (jdk == null) continue;
                        jdks.add(jdk);
                        continue;
                    }
                    jdks.add(new JDKAdapter(hash));
                }
            }
        }
        return jdks;
    }

    @Override
    public void setJdkList(List jdks) {
        if (jdks == null) {
            this._hash.remove("jdkDefinitions");
        } else {
            ArrayList<HashStructure> hashes = new ArrayList<HashStructure>(jdks.size());
            for (Object jdk : jdks) {
                HashStructure hash = HashStructure.newInstance();
                JDKAdapter copy = new JDKAdapter(hash);
                ((JDKAdapter)jdk).copyTo(copy);
                hashes.add(hash);
            }
            this._hash.getOrCreateListStructure("jdkDefinitions").mirror(hashes);
        }
    }

    @Override
    public JLibrary addLibrary(String name) {
        HashStructure hash = HashStructure.newInstance();
        JLibraryAdapter lib = new JLibraryAdapter(hash);
        ListStructure libs = this._hash.getOrCreateListStructure("libraryDefinitions");
        int start = 0;
        if (name == null) {
            start = 1;
            name = LIB_BASE;
        }
        lib.setName(this.getUniqueValue(name, 0, start, false));
        lib.setID(this.getUniqueValue(lib.getName(), 1, 0, false));
        libs.add((Object)hash);
        return lib;
    }

    @Override
    public JDK addJDK(String name, URL exeURL) {
        HashStructure hash = HashStructure.newInstance();
        JDKAdapter jdk = new JDKAdapter(hash);
        int start = 0;
        JDKUtil.initJDK(jdk, exeURL);
        ListStructure jdks = this._hash.getOrCreateListStructure("jdkDefinitions");
        if (name == null) {
            start = 1;
            name = JDK_BASE;
        }
        jdk.setName(this.getUniqueValue(name, 0, start, true));
        jdk.setID(this.getUniqueValue(jdk.getName(), 1, 0, true));
        jdks.add((Object)hash);
        return jdk;
    }

    @Override
    public boolean remove(Library library) {
        List libs;
        if (library instanceof JDKAdapter) {
            List jdks = this.getJdkList();
            if (jdks.remove(library)) {
                this.setJdkList(jdks);
                return true;
            }
        } else if (library instanceof JLibraryAdapter && (libs = this.getLibraryList()).remove(library)) {
            this.setLibraryList(libs);
            return true;
        }
        return false;
    }

    @Override
    public Object createIDFromName(String name, boolean isJDK) {
        name = name != null ? name.trim() : null;
        return name != null && name.length() > 0 ? name : null;
    }

    @Override
    public Icon getDefaultIcon() {
        return LibraryArb.getIcon(14);
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    public String getShortLabel() {
        return this.getListName();
    }

    public String getLongLabel() {
        return this.getListName();
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"library.png");
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String toString() {
        return this.getShortLabel();
    }

    private String getUniqueValue(String base, int key, int suffix, boolean isJDK) {
        List list = isJDK ? this.getJdkList() : this.getLibraryList();
        String[] values = new String[list.size()];
        switch (key) {
            case 0: {
                int i;
                for (i = 0; i < values.length; ++i) {
                    values[i] = ((Library)list.get(i)).getName();
                }
                break;
            }
            case 1: {
                int i;
                for (i = 0; i < values.length; ++i) {
                    values[i] = ((Library)list.get(i)).getID().toString();
                }
                break;
            }
            default: {
                return base;
            }
        }
        boolean found = false;
        String candidate = suffix > 0 ? base + suffix : base;
        block6: do {
            found = false;
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equals(candidate)) continue;
                found = true;
                candidate = base + ++suffix;
                continue block6;
            }
        } while (found);
        return candidate;
    }
}

