/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.patch;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.IdeClipboard;
import oracle.ide.ProductInformation;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.patch.AbstractPatchCommand;
import oracle.ideimpl.patch.PatchComponents;
import oracle.ideimpl.patch.PatchFilePanel;
import oracle.ideimpl.patch.PatchOperationException;
import oracle.ideimpl.patch.PatchValidationException;
import oracle.ideimpl.patch.res.Bundle;
import oracle.ideimpl.vcscore.VersioningCoreUtil;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.patch.PatchAssistance;
import oracle.javatools.patch.PatchFormat;
import oracle.javatools.patch.PatchModel;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.patch.ApplyPatchDialog;
import oracle.jdeveloper.patch.PatchAssistanceManager;
import oracle.jdeveloper.patch.PatchUtil;
import oracle.jdeveloper.patch.WaitRunnable;
import oracle.jdevimpl.compare.CompareEditor;
import oracle.jdevimpl.history.HistoryViewer;

public class ApplyPatchCommand
extends AbstractPatchCommand {
    public static final String APPLY_PATCH_CMD = ApplyPatchCommand.class.getName();
    public static final int APPLY_PATCH_CMD_ID = Ide.findOrCreateCmdID((String)APPLY_PATCH_CMD);

    public ApplyPatchCommand() {
        super(APPLY_PATCH_CMD_ID);
    }

    protected ApplyPatchCommand(int id) {
        super(id);
    }

    protected Locatable[] getLocatablesToApplyPatch() throws Exception {
        Project contextProject = this.getContextProject();
        if (contextProject != null) {
            if (this.getContext().getView() instanceof HistoryViewer) {
                return new Locatable[]{contextProject};
            }
            return this.getProjectFolderNodes(contextProject);
        }
        return this.getContextLocatables();
    }

    @Override
    protected boolean isAvailableImpl() throws Exception {
        if (this.getContext().getView() instanceof CompareEditor) {
            return false;
        }
        Locatable[] locatables = this.getLocatablesToApplyPatch();
        return true;
    }

    @Override
    protected int doitImpl() throws Exception {
        Locatable[] locatables = this.getLocatablesToApplyPatch();
        if (locatables.length <= 0) {
            return 0;
        }
        Collection<Object> nodes = Arrays.asList(locatables);
        if (this.getContextProject() != null) {
            nodes = this.processNodesForProjectOperation(this.getContextProject(), nodes);
        }
        if (nodes == null) {
            return 1;
        }
        Node[] affectedNodes = this.getCachedBaseURLNodes(ApplyPatchCommand.convertNodesToURLs(nodes));
        if (!VersioningCoreUtil.saveDirtyNodes((Locatable[])affectedNodes)) {
            return 1;
        }
        URL[] urls = ApplyPatchCommand.convertNodesToURLs(nodes);
        URL operationWorkingDirectoryUrl = PatchUtil.getOperationWorkingDirectoryURL(urls);
        if (operationWorkingDirectoryUrl == null) {
            return 9;
        }
        this.getContext().setProperty("apply-patch-encoding", (Object)StreamDecoder.getDefaultEncoding((URL)operationWorkingDirectoryUrl));
        final ApplyPatchUI ui = this.createUI(urls);
        JEWTDialog dialog = VersioningCoreUtil.createOperationDialog((Component)VersioningCoreUtil.getCurrentWindow(), (String)Bundle.get("APPLY_PATCH_TITLE"), null, (Component)PatchComponents.createFileListerComponent(nodes), (Component)ui, (String)"f1_scsapplypatch_html", (Component)ui.getClipboardRadioButton());
        dialog.setOKButtonText(Bundle.get("APPLY_PATCH_OK_BUTTON_TEXT"));
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)e)) {
                    return;
                }
                if (!ui.getFileRadioButton().isSelected()) {
                    return;
                }
                URL url = ui.getFileChooserPanel().getURL();
                if (!URLFileSystem.exists((URL)url)) {
                    this.validationFailed(Bundle.get("ERROR_APPLY_PATCH_NO_SUCH_FILE"), e);
                }
                if (URLFileSystem.isDirectory((URL)url)) {
                    this.validationFailed(Bundle.get("ERROR_APPLY_PATCH_IS_DIR"), e);
                }
            }

            private void validationFailed(String message, PropertyChangeEvent e) throws PropertyVetoException {
                ApplyPatchCommand.this.getExceptionHandler().handleException(new PatchValidationException(message));
                this.throwPropertyVetoException(e);
            }

            private void throwPropertyVetoException(PropertyChangeEvent e) throws PropertyVetoException {
                throw new PropertyVetoException("", e);
            }
        });
        if (!VersioningCoreUtil.runDialog((JDialog)dialog)) {
            return 1;
        }
        return this.doOperation(urls, ui);
    }

    private static final URL[] convertNodesToURLs(Locatable[] locatables) {
        URL[] urls = new URL[locatables.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = locatables[i].getURL();
        }
        return urls;
    }

    private static final URL[] convertNodesToURLs(Collection<? extends Locatable> locatables) {
        return ApplyPatchCommand.convertNodesToURLs(locatables.toArray(new Locatable[0]));
    }

    @Override
    protected void noOpImpl() throws PatchValidationException {
        throw new PatchValidationException(Bundle.get("ERROR_APPLY_PATCH_FILTERED_TITLE"), Bundle.format("ERROR_APPLY_PATCH_FILTERED", ProductInformation.getProductInformation().getShortName()));
    }

    private Node[] getCachedBaseURLNodes(URL[] baseUrls) {
        return VersioningCoreUtil.findCachedNodes((URLFilter)ApplyPatchCommand.createBaseURLContentsFilter(baseUrls));
    }

    private static final URLFilter createBaseURLContentsFilter(URL[] baseUrls) {
        final URL[] baseUrls2 = VersioningCoreUtil.removeRefAndQueryParts((URL[])baseUrls);
        return new URLFilter(){

            public boolean accept(URL url) {
                for (int i = 0; i < baseUrls2.length; ++i) {
                    if (!VersioningCoreUtil.isBaseURLFor((URL)baseUrls2[i], (URL)url)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private ApplyPatchUI createUI(URL[] urls) {
        final ApplyPatchUI ui = new ApplyPatchUI();
        this.initializeFileChooserPanel(ui.getFileChooserPanel(), urls);
        ui.getFileChooserPanel().setDialogType(1);
        String clipboardContents = this.getStringFromClipboard();
        if (clipboardContents == null || clipboardContents.equals("")) {
            ui.getClipboardRadioButton().setEnabled(false);
            ui.getFileRadioButton().setSelected(true);
        } else {
            ui.getClipboardRadioButton().setSelected(true);
        }
        ui.getFileRadioButton().addChangeListener(new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent e) {
                ApplyPatchCommand.this.updateFileOptionsEnabledState(ui);
            }
        });
        this.updateFileOptionsEnabledState(ui);
        this.initializePreferredSizeOfUI(ui);
        return ui;
    }

    private void updateFileOptionsEnabledState(ApplyPatchUI ui) {
        ui.getFileChooserPanel().setEnabled(ui.getFileRadioButton().isSelected());
    }

    private int doOperation(final URL[] urls, final ApplyPatchUI ui) throws Exception {
        WaitRunnable r = new WaitRunnable(this.getExceptionHandler()){

            @Override
            public final void runImpl() throws Exception {
                ApplyPatchCommand.this.doOperationImpl(urls, ui);
            }
        };
        new Thread((Runnable)r, "ApplyPatchCommand Parse").start();
        return 0;
    }

    private int doOperationImpl(URL[] urls, ApplyPatchUI ui) throws Exception {
        PatchAssistance assistance;
        boolean clipboard = ui.getClipboardRadioButton().isSelected();
        PatchModel patchModel = null;
        try {
            PatchFormat patchFormat = new PatchFormat();
            patchFormat.setEncoding((String)this.getContext().getProperty("apply-patch-encoding"));
            String patch = clipboard ? this.getStringFromClipboard() : this.readStringFromURL(ui.getFileChooserPanel().getURL(), patchFormat.getEncoding());
            assistance = PatchAssistanceManager.getAssistance(patch.getBytes());
            patchModel = patchFormat.parse(patch, assistance);
        }
        catch (ParseException pe) {
            if (clipboard) {
                throw new PatchOperationException(Bundle.get("ERROR_APPLY_PATCH_INVALID_CLIPBOARD_PATCH_TITLE"), Bundle.get("ERROR_APPLY_PATCH_INVALID_CLIPBOARD_PATCH"));
            }
            throw new PatchOperationException(Bundle.get("ERROR_APPLY_PATCH_INVALID_FILE_PATCH_TITLE"), Bundle.get("ERROR_APPLY_PATCH_INVALID_FILE_PATCH"));
        }
        return this.doOperationImpl2(urls, patchModel, assistance);
    }

    private int doOperationImpl2(final URL[] urls, final PatchModel patchModel, final PatchAssistance assistance) throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                try {
                    ApplyPatchDialog ui = new ApplyPatchDialog((String)ApplyPatchCommand.this.getContext().getProperty("apply-patch-encoding"), ApplyPatchCommand.this.getExceptionHandler());
                    ui.apply(urls, patchModel, assistance);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        });
        return 0;
    }

    private String getStringFromClipboard() {
        Transferable data = IdeClipboard.getClipboard().getContents((Object)this);
        if (data == null) {
            return null;
        }
        if (!data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return null;
        }
        try {
            return (String)data.getTransferData(DataFlavor.stringFlavor);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStringFromURL(URL url, String charsetName) throws IOException {
        InputStreamReader isr = null;
        StringWriter sw = new StringWriter();
        try {
            int n;
            isr = new InputStreamReader(URLFileSystem.openInputStream((URL)url), charsetName);
            char[] c = new char[(int)Math.pow(2.0, 10.0)];
            while ((n = isr.read(c, 0, c.length)) >= 0) {
                if (n <= 0) continue;
                sw.write(c, 0, n);
            }
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sw.toString();
    }

    private class ApplyPatchUI
    extends JPanel {
        private JLabel _patchSourceLabel;
        private JRadioButton _clipboardRadioButton;
        private JRadioButton _fileRadioButton;
        private PatchFilePanel _fileChooserPanel;

        public ApplyPatchUI() {
            this.setName("ApplyPatchUI");
            this.createComponents();
            this.layoutComponents();
            this.localizeComponentsMethod();
            ButtonGroup bg = new ButtonGroup();
            bg.add(this._clipboardRadioButton);
            bg.add(this._fileRadioButton);
        }

        private void createComponents() {
            this._patchSourceLabel = new JLabel();
            this._patchSourceLabel.setName("PatchSourceLabel");
            this._clipboardRadioButton = new JRadioButton();
            this._clipboardRadioButton.setName("ClipboardRadioButton");
            this._fileRadioButton = new JRadioButton();
            this._fileRadioButton.setName("FileRadioButton");
            this._fileChooserPanel = new PatchFilePanel();
            this._fileChooserPanel.setName("FileChooserPanel");
        }

        private void layoutComponents() {
            int insetSize = 2;
            Insets i = new Insets(insetSize, insetSize, insetSize, insetSize);
            LayoutBuilder builder = new LayoutBuilder();
            JComponent c = this._patchSourceLabel;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 2, false, true);
            builder.nl();
            builder.addHGap();
            c = this._clipboardRadioButton;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 1, false, true);
            builder.nl();
            builder.addHGap();
            c = this._fileRadioButton;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 1, false, true);
            builder.nl();
            builder.addHGap();
            c = this._fileChooserPanel;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 1, false, true);
            builder.nl();
            builder.addToPanel((Container)this);
        }

        private void localizeComponentsMethod() {
            ResourceUtils.resLabel((JLabel)this._patchSourceLabel, (Component)this._patchSourceLabel, (String)Bundle.get("APPLYPATCHUI_PATCHSOURCELABEL_TEXT"));
            ResourceUtils.resButton((AbstractButton)this._clipboardRadioButton, (String)Bundle.get("APPLYPATCHUI_CLIPBOARDRADIOBUTTON_TEXT"));
            ResourceUtils.resButton((AbstractButton)this._fileRadioButton, (String)Bundle.get("APPLYPATCHUI_FILERADIOBUTTON_TEXT"));
        }

        public JLabel getPatchSourceLabel() {
            return this._patchSourceLabel;
        }

        public JRadioButton getClipboardRadioButton() {
            return this._clipboardRadioButton;
        }

        public JRadioButton getFileRadioButton() {
            return this._fileRadioButton;
        }

        public PatchFilePanel getFileChooserPanel() {
            return this._fileChooserPanel;
        }
    }
}

