/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.patch;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.IdeClipboard;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.patch.BasePatchCommand;
import oracle.ideimpl.patch.PatchFilePanel;
import oracle.ideimpl.patch.res.Bundle;
import oracle.ideimpl.vcscore.VersioningCoreUtil;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.compare.CompareManager;
import oracle.jdeveloper.history.HistoryContext;
import oracle.jdeveloper.patch.PatchException;
import oracle.jdeveloper.patch.PatchExceptionHandler;
import oracle.jdeveloper.patch.PatchUtil;
import oracle.jdevimpl.history.HistoryViewer;

public abstract class AbstractPatchCommand
extends BasePatchCommand {
    private static final URLFilter _urlFilter = new URLFilter(){

        public final boolean accept(URL url) {
            return "file".equals(url.getProtocol());
        }
    };
    private PatchExceptionHandler _exceptionHandler;

    protected AbstractPatchCommand(int cmdId) {
        super(cmdId, 1);
    }

    @Override
    protected PatchExceptionHandler getExceptionHandler() {
        if (this._exceptionHandler == null) {
            this._exceptionHandler = new PatchExceptionHandler();
        }
        return this._exceptionHandler;
    }

    @Override
    protected boolean isAvailableImpl(URL url) throws Exception {
        return super.isAvailableImpl(url) && CompareManager.getCompareManager().isContentComparable(url);
    }

    public Context getContext() {
        Context context = super.getContext();
        if (context != null && context.getView() instanceof HistoryViewer) {
            URL realUrl = HistoryContext.getRealURL((Context)context);
            Node realNode = realUrl != null ? NodeFactory.find((URL)realUrl) : null;
            context.setNode(realNode != null ? realNode : context.getNode());
            context.setSelection(new Element[]{realNode != null ? realNode : context.getNode()});
        }
        return context;
    }

    @Override
    protected URLFilter getURLFilter() {
        return _urlFilter;
    }

    protected final Project getContextProject() {
        Locatable[] locatables = this.getContextLocatables();
        ArrayList<Locatable> projects = new ArrayList<Locatable>();
        for (int i = 0; i < locatables.length; ++i) {
            if (!(locatables[i] instanceof Project)) continue;
            projects.add(locatables[i]);
        }
        return projects.size() == 1 ? (Project)projects.iterator().next() : null;
    }

    protected final Locatable[] getProjectFolderNodes(Project project) {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        URL projectParentUrl = URLFileSystem.getParent((URL)project.getURL());
        urls.add(projectParentUrl);
        urls.addAll(Arrays.asList(this.getProjectSourcePathURLs(project)));
        return new LinkedHashSet<Locatable>(Arrays.asList(VersioningCoreUtil.findOrCreateNodes((URL[])urls.toArray(new URL[0])))).toArray(new Locatable[0]);
    }

    private final URL[] getProjectSourcePathURLs(Project project) {
        LinkedHashSet<URL> baseDirectoryUrls = new LinkedHashSet<URL>();
        baseDirectoryUrls.add(URLFileSystem.getParent((URL)project.getURL()));
        baseDirectoryUrls.addAll(ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs().asList());
        return baseDirectoryUrls.toArray(new URL[0]);
    }

    protected Collection processNodesForProjectOperation(Project project, Collection nodes) throws Exception {
        if (nodes.size() <= 1) {
            return nodes;
        }
        Locatable locatableFolder = this.showSelectPatchContextDialog(project, nodes);
        if (locatableFolder == null) {
            return null;
        }
        return Collections.singleton(locatableFolder);
    }

    protected URL[] getOperationURLs(URL[] urls) {
        return urls;
    }

    protected void initializeFileChooserPanel(PatchFilePanel PatchFilePanel2, URL[] urls) {
        PatchFilePanel2.setChooseFolders(false);
        PatchFilePanel2.setURL(this.constructDefaultPatchURL(urls));
        PatchFilePanel2.setURLFilter((URLFilter)new DefaultURLFilter(Bundle.get("GENERATE_PATCH_URL_FILTER_DESCRIPTION"), new String[]{".patch", ".diff"}));
    }

    protected void initializePreferredSizeOfUI(JComponent component) {
        Dimension preferredSize = component.getPreferredSize();
        component.setPreferredSize(new Dimension(Math.max(500, preferredSize.width), preferredSize.height));
    }

    protected Locatable showSelectPatchContextDialog(Project project, Collection nodes) {
        final JEWTDialog dialog = new JEWTDialog(IdeUtil.getMainWindow(), Bundle.get("PATCH_SELECT_PATCH_CONTEXT_TITLE"), 7);
        final JRadioButton projectFileRadioButton = new JRadioButton();
        final JRadioButton projectContentProviderRadioButton = new JRadioButton();
        final JList<Object> projectContentProviderList = new JList<Object>(nodes.toArray());
        JScrollPane projectContentProviderScrollPane = new JScrollPane(projectContentProviderList);
        ResourceUtils.resButton((AbstractButton)projectFileRadioButton, (String)Bundle.format("PATCH_PROJECT_FILE", project.getShortLabel()));
        ResourceUtils.resButton((AbstractButton)projectContentProviderRadioButton, (String)Bundle.get("PATCH_CONTENT_PROVIDER"));
        JPanel panel = new JPanel();
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets insets = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)projectFileRadioButton, insets, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.add((Component)projectContentProviderRadioButton, insets, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.add((Component)projectContentProviderScrollPane, insets, 1, true, true);
        layoutBuilder.nl();
        layoutBuilder.addToPanel((Container)panel);
        this.initializePreferredSizeOfUI(panel);
        Dimension preferredSize = panel.getPreferredSize();
        panel.setPreferredSize(new Dimension(preferredSize.width, 200));
        ButtonGroup bg = new ButtonGroup();
        bg.add(projectFileRadioButton);
        bg.add(projectContentProviderRadioButton);
        projectContentProviderRadioButton.setSelected(true);
        projectContentProviderList.setSelectedIndex(0);
        projectContentProviderList.setSelectionMode(0);
        projectContentProviderList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Locatable locatable = (Locatable)value;
                if (locatable != null) {
                    value = URLFileSystem.getPlatformPathName((URL)locatable.getURL());
                }
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setIcon(OracleIcons.getIcon((String)"folder.png"));
                return this;
            }
        });
        dialog.setInitialFocus((Component)projectContentProviderRadioButton);
        dialog.setContent((Component)panel);
        dialog.setResizable(true);
        class SelectContextEnablementListener
        implements ActionListener,
        ListSelectionListener {
            SelectContextEnablementListener() {
                this.updateComponentsEnabled();
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.updateComponentsEnabled();
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.updateComponentsEnabled();
            }

            private void updateComponentsEnabled() {
                projectContentProviderList.setEnabled(projectContentProviderRadioButton.isSelected());
                dialog.setOKButtonEnabled(projectFileRadioButton.isSelected() || projectContentProviderList.getSelectedValue() != null);
            }
        }
        SelectContextEnablementListener enablementListener = new SelectContextEnablementListener();
        projectFileRadioButton.addActionListener(enablementListener);
        projectContentProviderRadioButton.addActionListener(enablementListener);
        projectContentProviderList.addListSelectionListener(enablementListener);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_scsselectpatchcontext_html");
        if (!VersioningCoreUtil.runDialog((JDialog)dialog)) {
            return null;
        }
        return projectFileRadioButton.isSelected() ? project : (Locatable)projectContentProviderList.getSelectedValue();
    }

    protected URL constructDefaultPatchURL(URL[] urls) {
        URL[] operationUrls = this.getOperationURLs(urls);
        URL operationWorkingDirectoryUrl = PatchUtil.getOperationWorkingDirectoryURL(urls);
        URL patchNameUrl = operationUrls.length == 1 ? operationUrls[0] : operationWorkingDirectoryUrl;
        String fileName = URLFileSystem.getFileName((URL)patchNameUrl);
        if (!fileName.endsWith(".patch")) {
            fileName = fileName + ".patch";
        }
        return URLFactory.newURL((URL)operationWorkingDirectoryUrl, (String)fileName);
    }

    protected void copyStringToClipboard(String s) {
        StringSelection selection = new StringSelection(s);
        IdeClipboard.getClipboard().setContents(selection, selection);
    }

    protected void saveStringAsURL(String s, String charsetName, URL url) throws IOException {
        OutputStream out = URLFileSystem.openOutputStream((URL)url);
        OutputStreamWriter osw = charsetName != null ? new OutputStreamWriter(out, charsetName) : new OutputStreamWriter(out);
        BufferedWriter bw = new BufferedWriter(osw);
        bw.write(s);
        bw.close();
    }

    protected void savePatchToClipboard(String patchSource) throws PatchException {
        this.copyStringToClipboard(patchSource);
        this.checkPatchSourceEmpty(patchSource);
        MessageDialog.information((Component)VersioningCoreUtil.getCurrentWindow(), (Object)Bundle.get("PATCH_ON_CLIPBOARD"), (String)Bundle.get("PATCH_ON_CLIPBOARD_TITLE"), null);
    }

    protected void savePatchToURL(String patchSource, String charsetName, URL patchUrl, boolean openEditor) throws PatchException, IOException, InstantiationException, IllegalAccessException {
        this.saveStringAsURL(patchSource, charsetName, patchUrl);
        Node patchNode = NodeFactory.findOrCreate((URL)patchUrl);
        if (openEditor) {
            this.awtOpenDefaultEditorInFrame(patchUrl);
        }
        if (patchNode != null) {
            this.awtRevertNodeReload(patchNode);
        }
        this.checkPatchSourceEmpty(patchSource);
    }

    protected void checkPatchSourceEmpty(String patchSource) throws PatchException {
        if (!this.isPatchSourceEmpty(patchSource)) {
            return;
        }
        throw new PatchException(Bundle.get("ERROR_GENERATE_PATCH_NO_DIFF_TITLE"), Bundle.get("ERROR_GENERATE_PATCH_NO_DIFF"));
    }

    protected void awtOpenDefaultEditorInFrame(final URL url) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                EditorManager.getEditorManager().openDefaultEditorInFrame(url);
            }
        });
    }

    protected void awtRevertNodeReload(final Node node) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                RevertNodeCommand.reload((Node)node);
            }
        });
    }

    protected boolean isPatchSourceEmpty(String patchSource) {
        return patchSource.trim().equals("");
    }
}

