/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComponentInputMap;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.log.LogManager;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFileSystem;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.PromptedTextField;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.DefaultTransformsAction;
import oracle.jdeveloper.audit.service.Iteration;
import oracle.jdeveloper.audit.service.TransformAction;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.TransformerListener;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.log.AuditTreeTable;
import oracle.jdevimpl.audit.log.AuditTreeTableModel;
import oracle.jdevimpl.audit.log.ConfigureHierarchyPane;
import oracle.jdevimpl.audit.log.HierarchyFilter;
import oracle.jdevimpl.audit.log.LogBundle;
import oracle.jdevimpl.audit.log.PatternFilter;
import oracle.jdevimpl.audit.log.RuleFilter;
import oracle.jdevimpl.audit.log.SeverityFilter;
import oracle.jdevimpl.audit.log.SuppressionFilter;
import oracle.jdevimpl.audit.report.AuditXmlReportDialog;
import oracle.jdevimpl.audit.report.AuditXmlReporter;
import oracle.jdevimpl.audit.swing.MenuDropDownButton;
import oracle.jdevimpl.audit.swing.MessageDialog;
import oracle.jdevimpl.audit.swing.Resources;
import oracle.jdevimpl.audit.util.Strings;

public class AuditLogPanel
extends JPanel
implements ContextMenuListener,
Controller,
TreeSelectionListener,
AuditTreeTable.RowActionListener,
TransformerListener {
    private static final Log LOG = new Log("log");
    private static final Log EVENT_LOG = new Log("treetablemodel-event");
    private Auditor auditor;
    private AuditModel model;
    private View view;
    private SuppressionFilter suppressionFilter;
    private PatternFilter patternFilter;
    private RuleFilter ruleFilter;
    private SeverityFilter severityFilter;
    private HierarchyFilter hierarchyFilter;
    private AuditTreeTableModel treeTableModel;
    private Component topComponent;
    private Toolbar toolbar;
    private JButton refreshCancelButton;
    private FixButton fixButton;
    private SearchField searchField;
    private JScrollPane tableScrollPane;
    private String label;
    private AuditTreeTable table;
    private MouseListener mouseListener;
    public static final int EXPORT_CID = Ide.findOrCreateCmdID((String)"audit.export");
    public static final int EXPAND_ALL_CID = Ide.findOrCreateCmdID((String)"audit.expand-all");
    public static final int COLLAPSE_ALL_CID = Ide.findOrCreateCmdID((String)"audit.collapse-all");
    public static final int GOTO_SOURCE_CID = Ide.findOrCreateCmdID((String)"audit.goto-source");
    public static final int ABOUT_CID = Ide.findOrCreateCmdID((String)"audit.about");
    public static final int FIX_CID = Ide.findOrCreateCmdID((String)"audit.fix");
    public static final int DEFAULT_FIX_CID = Ide.findOrCreateCmdID((String)"audit.default-fix");
    public static final int HIDE_ISSUES_CID = Ide.findOrCreateCmdID((String)"audit.hide-issues");
    public static final int UNHIDE_ALL_ISSUES_CID = Ide.findOrCreateCmdID((String)"audit.unhide-all-issues");
    private Action refreshAction;
    private Action cancelAction;
    private IdeAction exportAction;
    private IdeAction expandAllAction;
    private IdeAction collapseAllAction;
    private IdeAction gotoSourceAction;
    private IdeAction aboutAction;
    private IdeAction defaultFixAction;
    private IdeAction hideIssuesAction;
    private IdeAction unhideAllIssuesAction;
    private static final FormatBundle BUNDLE = new FormatBundle(AuditBundle.class);
    private static Log SEARCH_LOG = new Log("search");

    AuditLogPanel(final Auditor auditor, AuditModel model, View view, final String label) {
        super(new BorderLayout());
        LOG.trace("setting model on {0} to {1}", (Object)this, (Object)model);
        this.auditor = auditor;
        this.model = model;
        this.view = view;
        this.label = label;
        this.setFilters(auditor, model);
        this.toolbar = new Toolbar();
        this.refreshAction = Resources.action(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                auditor.runAsynchronously(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread thread, Throwable exception) {
                        if (!(exception instanceof CancellationException)) {
                            if (exception instanceof IllegalStateException) {
                                MessageDialog dialog = new MessageDialog(MessageDialog.ERROR);
                                dialog.setTitle(LogBundle.get("refresh.locations-changed.title"));
                                dialog.setContent(LogBundle.format("refresh.locations-changed.message", label));
                                dialog.show();
                            } else {
                                MessageDialog dialog = new MessageDialog(MessageDialog.ERROR);
                                dialog.setTitle(LogBundle.get("refresh.exception.title"));
                                dialog.setContent(LogBundle.format("refresh.exception.message", exception));
                                dialog.show();
                                AuditLogger.error(exception, "Refresh of \"{0}\" failed with exception: {1}", label, exception);
                            }
                        }
                    }
                });
            }
        }, OracleIcons.getIcon((String)"refresh.png"), LogBundle.get("refresh.label"));
        this.cancelAction = Resources.action(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                auditor.cancel();
            }
        }, OracleIcons.getIcon((String)"terminate.png"), LogBundle.get("cancel.label"));
        this.refreshCancelButton = this.toolbar.add(auditor.isAuditing() ? this.cancelAction : this.refreshAction);
        this.toolbar.addSeparator();
        this.expandAllAction = this.action(EXPAND_ALL_CID, "expand-all", OracleIcons.getIcon((String)"expandall.png"));
        this.expandAllAction.setEnabled(this.hierarchyFilter.isHierarchy());
        this.toolbar.add((ToggleAction)this.expandAllAction);
        this.collapseAllAction = this.action(COLLAPSE_ALL_CID, "collapse-all", OracleIcons.getIcon((String)"collapseall.png"));
        this.collapseAllAction.setEnabled(this.hierarchyFilter.isHierarchy());
        this.toolbar.add((ToggleAction)this.collapseAllAction);
        this.toolbar.addSeparator();
        this.exportAction = this.action(EXPORT_CID, "export", OracleIcons.getIcon((String)"export.png"));
        this.exportAction.setEnabled(!auditor.isAuditing());
        this.toolbar.add((ToggleAction)this.exportAction);
        IdeAction fixAction = this.action(FIX_CID, "fix", OracleIcons.getIcon((String)"fix.png"));
        fixAction.setEnabled(false);
        this.fixButton = new FixButton((ToggleAction)fixAction);
        this.toolbar.add((Component)((Object)this.fixButton));
        this.defaultFixAction = this.action(DEFAULT_FIX_CID, "default-fix", null);
        this.toolbar.addSeparator();
        3 showErrorsAction = Resources.action(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuditLogPanel.this.severityFilter.setShowErrors(((JToggleButton)e.getSource()).isSelected());
            }
        }, OracleIcons.getIcon((String)"error.png"), LogBundle.get("show-errors.label"), this.severityFilter.isShowErrors());
        4 showWarningsAction = Resources.action(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuditLogPanel.this.severityFilter.setShowWarnings(((JToggleButton)e.getSource()).isSelected());
            }
        }, OracleIcons.getIcon((String)"warning.png"), LogBundle.get("show-warnings.label"), this.severityFilter.isShowWarnings());
        5 showIncompletesAction = Resources.action(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuditLogPanel.this.severityFilter.setShowIncompletes(((JToggleButton)e.getSource()).isSelected());
            }
        }, OracleIcons.getIcon((String)"incompletestatus.png"), LogBundle.get("show-incompletes.label"), this.severityFilter.isShowIncompletes());
        6 showAdvisoriesAction = Resources.action(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuditLogPanel.this.severityFilter.setShowAdvisories(((JToggleButton)e.getSource()).isSelected());
            }
        }, OracleIcons.getIcon((String)"info.png"), LogBundle.get("show-advisories.label"), this.severityFilter.isShowAdvisories());
        7 showSuppressionsAction = Resources.action(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuditLogPanel.this.suppressionFilter.setVisible(((JToggleButton)e.getSource()).isSelected());
            }
        }, OracleIcons.getIcon((String)"suppressed.png"), LogBundle.get("show-suppressions.label"), this.suppressionFilter.isVisible());
        8 showHierarchyAction = Resources.action(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean showHierarchy = ((JToggleButton)e.getSource()).isSelected();
                AuditLogPanel.this.hierarchyFilter.setHierarchy(showHierarchy);
                AuditLogPanel.this.expandAllAction.setEnabled(showHierarchy);
                AuditLogPanel.this.collapseAllAction.setEnabled(showHierarchy);
            }
        }, OracleIcons.getIcon((String)"group.png"), LogBundle.get("show-hierarchy.label"), this.hierarchyFilter.isHierarchy());
        this.toolbar.add((Component)new JToggleButton(showErrorsAction));
        this.toolbar.add((Component)new JToggleButton(showWarningsAction));
        this.toolbar.add((Component)new JToggleButton(showIncompletesAction));
        this.toolbar.add((Component)new JToggleButton(showAdvisoriesAction));
        this.toolbar.addFiller();
        this.toolbar.add((Component)new JToggleButton(showSuppressionsAction));
        this.toolbar.addSeparator();
        MenuDropDownButton hierarchyButton = Resources.button(new MenuDropDownButton((AbstractButton)new JToggleButton(showHierarchyAction), new Component[0]), "", LogBundle.get("configure-hierarchy.label"));
        hierarchyButton.addPopupMenuListener(new ConfigureHierarchyPane(this.hierarchyFilter));
        this.toolbar.add((Component)hierarchyButton);
        this.toolbar.add(Box.createHorizontalGlue());
        PromptedTextField searchFieldText = new PromptedTextField();
        searchFieldText.setColumns(20);
        searchFieldText.setMaximumSize(searchFieldText.getPreferredSize());
        this.searchField = new SearchField(searchFieldText, SearchField.Style.FILTER);
        this.searchField.setMaximumSize(this.searchField.getPreferredSize());
        this.searchField.addCategory((SearchCategory)new FilterCategory(LogBundle.get("search.name.label"), PatternFilter.NAME));
        this.searchField.addCategory((SearchCategory)new FilterCategory(LogBundle.get("search.package.label"), PatternFilter.PACKAGE));
        this.searchField.addCategory((SearchCategory)new FilterCategory(LogBundle.get("search.path.label"), PatternFilter.PATH));
        this.searchField.addCategory((SearchCategory)new FilterCategory(LogBundle.get("search.message.label"), PatternFilter.MESSAGE));
        this.searchField.setText(this.patternFilter.getText(), true);
        this.searchField.setSelectedCategory(FilterCategory.getCategory(this.patternFilter.getKind()));
        this.toolbar.add((Component)this.searchField);
        this.toolbar.setBorder(IdeConstants.TOOLBAR_EMPTY_BORDER);
        this.gotoSourceAction = this.action(GOTO_SOURCE_CID, "goto-source", null);
        this.aboutAction = this.action(ABOUT_CID, "about", null);
        this.hideIssuesAction = this.action(HIDE_ISSUES_CID, "hide-issues", null);
        this.unhideAllIssuesAction = this.action(UNHIDE_ALL_ISSUES_CID, "unhide-all-issues", null);
        this.tableScrollPane = new JScrollPane();
        this.tableScrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel corner = new JPanel();
        corner.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, IdeConstants.COLOR_IDE_LINES));
        this.tableScrollPane.setCorner("UPPER_RIGHT_CORNER", corner);
        this.tableScrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        if (model.getLocations() == null) {
            JLabel startingLabel = new JLabel("Audit starting...");
            startingLabel.setBackground(UIManager.getColor("Table.background"));
            startingLabel.setAlignmentX(0.5f);
            startingLabel.setAlignmentY(0.5f);
            startingLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            startingLabel.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.tableScrollPane.setViewportView(startingLabel);
        } else {
            this.createTable(model);
        }
        this.setBorder(null);
        this.add((Component)this.toolbar, "North");
        this.add(this.tableScrollPane);
        LogManager.getLogManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
    }

    private void setFilters(Auditor auditor, AuditModel model) {
        String profileName = auditor.getProfile().getName();
        this.ruleFilter = new RuleFilter(profileName + ".rule-filter");
        model.addFilter(this.ruleFilter);
        this.hierarchyFilter = new HierarchyFilter(profileName + ".structure-filter");
        this.hierarchyFilter.setTypeVisibility(Workspaces.class, false);
        model.addFilter(this.hierarchyFilter);
        this.suppressionFilter = new SuppressionFilter(false, profileName + ".suppression-filter");
        model.addFilter(this.suppressionFilter);
        this.patternFilter = new PatternFilter(profileName + ".name-filter");
        model.addFilter(this.patternFilter);
        this.severityFilter = new SeverityFilter(true, true, true, true, profileName + ".severity-filter");
        model.addFilter(this.severityFilter);
    }

    private IdeAction action(int cid, String name, Icon icon) {
        String label = BUNDLE.get("results." + name + ".label");
        if (label == null) {
            label = name;
        }
        Integer mnemonic = BUNDLE.get("results." + name + ".mnemonic").charAt(0);
        IdeAction globalAction = IdeAction.get((int)cid, null, (String)label, null, (Integer)mnemonic, (Icon)icon, null, (boolean)true);
        IdeAction localAction = globalAction.newLocalAction(this.view);
        if (label.indexOf(" {0}") > 0) {
            localAction.putValue("NoCtxName", (Object)Strings.remove(name, " {0}"));
        }
        localAction.addController((Controller)this);
        return localAction;
    }

    void reset(Auditor newAuditor) {
        this.clear();
        this.model.removeFilter(this.ruleFilter);
        this.model.removeFilter(this.hierarchyFilter);
        this.model.removeFilter(this.patternFilter);
        this.auditor = newAuditor;
        this.setFilters(newAuditor, this.model);
        this.refreshCancelButton.setAction(this.auditor.isAuditing() ? this.cancelAction : this.refreshAction);
        this.exportAction.setEnabled(!this.auditor.isAuditing());
    }

    public AuditModel getModel() {
        return this.model;
    }

    public Component getTopComponent() {
        if (this.topComponent == null) {
            this.topComponent = Box.createRigidArea(new Dimension(10, 0));
        }
        return this.topComponent;
    }

    public Toolbar getToolBar() {
        return this.toolbar;
    }

    public void clear() {
        this.model.clear();
    }

    public void auditStarted(AuditModel model, List<Metric> columns, Object root) {
        if (model != this.model) {
            throw new IllegalStateException("conflicting models");
        }
        if (this.table == null || this.model.getColumnCount() - 1 != columns.size()) {
            // empty if block
        }
        this.createTable(model);
        this.refreshCancelButton.setAction(this.cancelAction);
        this.exportAction.setEnabled(false);
    }

    private void createTable(AuditModel model) {
        if (this.table != null) {
            this.table.removeRowActionListener(this);
            this.table.removeRowSelectionListener(this);
            if (this.mouseListener != null) {
                this.table.removeMouseListener(this.mouseListener);
            }
        }
        this.treeTableModel = new AuditTreeTableModel(model);
        this.table = new AuditTreeTable(this.treeTableModel);
        this.tableScrollPane.setViewportView((Component)((Object)this.table));
        this.table.addRowActionListener(this);
        this.table.addRowSelectionListener(this);
        if (this.mouseListener != null) {
            this.table.addMouseListener(this.mouseListener);
        }
    }

    public void auditStopped(AuditModel model, boolean cancelled) {
        this.refreshCancelButton.setAction(this.refreshAction);
        this.exportAction.setEnabled(true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        EVENT_LOG.trace("row selection changed", (Object[])e.getPaths());
        this.updateFixButton();
    }

    @Override
    public void rowActionPerformed(AuditTreeTable table, int row) {
        this.gotoSourceAtRow(row);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        LOG.trace("adding mouse listener to {0}: {1}", (Object)this, (Object)listener);
        if (listener != null) {
            this.mouseListener = listener;
            super.addMouseListener(listener);
            this.tableScrollPane.getViewport().addMouseListener(listener);
            if (this.table != null) {
                this.table.addMouseListener(listener);
            }
        }
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        super.removeMouseListener(listener);
        LogManager.getLogManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
        if (listener != null) {
            this.tableScrollPane.getViewport().removeMouseListener(listener);
            if (this.table != null) {
                this.table.removeMouseListener(listener);
            }
            if (this.mouseListener == listener) {
                this.mouseListener = null;
            }
        }
        this.toolbar.dispose();
    }

    public boolean handleDefaultAction(Context context) {
        LOG.trace("handle default action {0}, context {1}", (Object)this, (Object)context);
        return false;
    }

    public void menuWillHide(ContextMenu menu) {
    }

    public void menuWillShow(ContextMenu menu) {
        String aboutLabel;
        if (menu == null) {
            return;
        }
        Context context = menu.getContext();
        if (context == null || context.getView() != this.view) {
            return;
        }
        menu.removeAll();
        int sections = 1;
        float FIX_SECTION = ++sections;
        float FILTER_SECTION = ++sections;
        float REFRESH_CANCEL_SECTION = ++sections;
        float EXPAND_COLLAPSE_SECTION = ++sections;
        float GOTO_SOURCE_SECTION = ++sections;
        float GOTO_SOURCE_WEIGHT = 1.0f;
        float EXPORT_SECTION = ++sections;
        Object[] selection = this.table.getSelectedObjects();
        if (selection.length > 0) {
            Location location = this.model.getLocation(selection[0]);
            this.gotoSourceAction.setEnabled(location.getModel().isNavigable(location));
        } else {
            this.gotoSourceAction.setEnabled(false);
        }
        menu.add((Component)menu.createMenuItem((ToggleAction)this.gotoSourceAction, 1.0f), GOTO_SOURCE_SECTION);
        Object violation = null;
        if (selection.length == 1) {
            violation = this.model.getViolation(selection[0]);
        }
        if (violation != null) {
            aboutLabel = BUNDLE.get("results.about.selection.label", new Object[]{violation.getRule().label()});
            this.aboutAction.setEnabled(true);
        } else {
            aboutLabel = BUNDLE.get("results.about.label");
            this.aboutAction.setEnabled(false);
        }
        JMenuItem menuItem = menu.createMenuItem((ToggleAction)this.aboutAction);
        menuItem.setText(aboutLabel);
        menu.add((Component)menuItem, FILTER_SECTION);
        List<? extends ToggleAction> fixes = this.getFixes();
        if (!fixes.isEmpty()) {
            violation = fixes.iterator();
            while (violation.hasNext()) {
                ToggleAction action = (ToggleAction)violation.next();
                menu.add((Component)menu.createMenuItem(action), FIX_SECTION);
            }
        }
        if (selection.length == 1 && (violation = this.model.getViolation(selection[0])) != null) {
            menuItem = menu.createMenuItem((ToggleAction)this.hideIssuesAction);
            String name = violation.getRule().label();
            String label = Strings.toString(menuItem.getText(), name);
            menuItem.setText(label);
            menu.add((Component)menuItem, FILTER_SECTION);
        }
        this.unhideAllIssuesAction.setEnabled(this.ruleFilter.getDisabledCount() > 0);
        menu.add((Component)menu.createMenuItem((ToggleAction)this.unhideAllIssuesAction), FILTER_SECTION);
    }

    private List<? extends ToggleAction> getFixes() {
        if (this.table == null) {
            return Collections.emptyList();
        }
        Object[] selection = this.table.getSelectedObjects();
        LOG.trace("getting fix actions for selected rows {0}", selection);
        if (selection.length == 1 && this.model.isViolation(selection[0])) {
            Violation violation = this.model.getViolation(selection[0]);
            LOG.trace("getting fix actions for {0}", (Object)violation);
            Transform defaultTransform = violation.getDefaultTransform();
            Transformer transformer = AuditManager.getAuditManager().createTransformer();
            List<TransformAction> actions = transformer.createTransformActions(Collections.singletonList(violation), this.model.getProfile(), this, this.model);
            for (TransformAction action : actions) {
                String label = action.getTransform() == defaultTransform ? BUNDLE.get("results.fix.context.default.label") : BUNDLE.get("results.fix.context.label");
                action.putValue("Name", Strings.toString(label, action.getValue("Name")));
            }
            return actions;
        }
        if (this.hasDefaultFix(selection)) {
            this.defaultFixAction.setEnabled(true);
            return Collections.singletonList(this.defaultFixAction);
        }
        return Collections.emptyList();
    }

    private boolean hasFixes() {
        if (this.table == null) {
            return false;
        }
        Object[] selection = this.table.getSelectedObjects();
        if (selection.length == 1 && this.model.isViolation(selection[0])) {
            Violation violation = this.model.getViolation(selection[0]);
            LOG.trace("getting fix actions for {0}", (Object)violation);
            Transform defaultTransform = violation.getDefaultTransform();
            Transformer transformer = AuditManager.getAuditManager().createTransformer();
            return transformer.hasTransforms(Collections.singletonList(violation), this.model.getProfile());
        }
        return this.hasDefaultFix(selection);
    }

    public boolean update(IdeAction action, Context context) {
        int cid = action.getCommandId();
        if (cid == EXPORT_CID) {
            return true;
        }
        if (cid == EXPAND_ALL_CID) {
            return true;
        }
        if (cid == COLLAPSE_ALL_CID) {
            return true;
        }
        if (cid == FIX_CID) {
            this.updateFixButton();
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        LOG.trace("handling action [{0}] in {1}, context {2}", (Object)action, (Object)this, (Object)context);
        int cid = action.getCommandId();
        if (cid == EXPORT_CID) {
            AuditXmlReportDialog<AuditModel> dialog = new AuditXmlReportDialog<AuditModel>(this.model, new AuditXmlReporter(), LogBundle.get("export.dialog.title"), LogBundle.format("export.default-title", this.label), this.label, "f1_aud_saveas_dlg_html", context);
            dialog.show();
            return true;
        }
        if (cid == EXPAND_ALL_CID) {
            this.table.expandAll();
            return true;
        }
        if (cid == COLLAPSE_ALL_CID) {
            this.table.collapseAll();
            return true;
        }
        if (cid == GOTO_SOURCE_CID) {
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow >= 0) {
                this.gotoSourceAtRow(selectedRow);
            }
            return true;
        }
        if (cid == ABOUT_CID) {
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow >= 0) {
                this.about(selectedRow);
            }
            return true;
        }
        if (cid == DEFAULT_FIX_CID) {
            Object[] selection = this.table.getSelectedObjects();
            this.fix((String)action.getValue("Name"), selection);
            return true;
        }
        if (cid == HIDE_ISSUES_CID) {
            Violation violation;
            Object value;
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow >= 0 && (value = this.table.getValueAt(selectedRow, this.table.convertColumnIndexToView(0))) != null && (violation = this.model.getViolation(value)) != null) {
                this.ruleFilter.setEnabled(violation.getRule(), false);
            }
            return true;
        }
        if (cid == UNHIDE_ALL_ISSUES_CID) {
            this.ruleFilter.enableAll();
            return true;
        }
        return false;
    }

    private void gotoSourceAtRow(int row) {
        Object value = this.table.getValueAt(row, this.table.convertColumnIndexToView(0));
        if (value == null) {
            Ide.getStatusBar().setText(BUNDLE.get("results.goto-source.no-file.message"));
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Location location = this.model.getFocusLocation(value);
        if (location == null) {
            location = this.model.getLocation(value);
        }
        if (location == null) {
            Ide.getStatusBar().setText(BUNDLE.get("results.goto-source.no-file.message"));
            Toolkit.getDefaultToolkit().beep();
        } else {
            ModelAdapter model = location.getModel();
            if (model instanceof ContainerModelAdapter) {
                this.table.toggleRow(row);
            } else {
                try {
                    boolean navigated = model.edit(location);
                    if (!navigated) {
                        Ide.getStatusBar().setText(BUNDLE.get("results.goto-source.uneditable-file.message", new Object[]{URLFileSystem.getFileName((URL)model.getUrl())}));
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                catch (Exception e) {
                    Ide.getStatusBar().setText(BUNDLE.get("results.goto-source.uneditable-file.message", new Object[]{URLFileSystem.getFileName((URL)model.getUrl())}));
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    private void about(int row) {
        Object value = this.table.getValueAt(row, this.table.convertColumnIndexToView(0));
        if (value == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Violation violation = this.model.getViolation(value);
        if (violation == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Rule rule = violation.getRule();
        String label = rule.label();
        String help = rule.description();
        final JEditorPane textArea = new JEditorPane("text/html", "");
        textArea.setEditable(false);
        textArea.setText(help);
        int height = 12 * textArea.getFont().getSize();
        JScrollPane scrollPane = new JScrollPane(textArea, 20, 31);
        scrollPane.setPreferredSize(new Dimension(height * 4, height));
        final JDialog dialog = new JDialog((Frame)Ide.getMainWindow(), BUNDLE.get("results.about.title", new Object[]{label}), true);
        dialog.getContentPane().add(scrollPane);
        ComponentInputMap inputMap = new ComponentInputMap(textArea);
        ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        SwingUtilities.replaceUIInputMap(textArea, 2, inputMap);
        ActionMap actionMap = new ActionMap();
        actionMap.put("cancel", new AbstractAction("cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        SwingUtilities.replaceUIActionMap(textArea, actionMap);
        dialog.pack();
        this.setLocationRelativeTo(dialog, this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                textArea.scrollRectToVisible(new Rectangle(16, 16));
            }
        });
        dialog.setVisible(true);
        dialog.dispose();
    }

    public void setLocationRelativeTo(JDialog dialog, Component c) {
        Container root = null;
        if (c != null) {
            if (c instanceof Window || c instanceof Applet) {
                root = (Container)c;
            } else {
                for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof Window) && !(parent instanceof Applet)) continue;
                    root = parent;
                    break;
                }
            }
        }
        if (c != null && !c.isShowing() || root == null || !root.isShowing()) {
            Dimension paneSize = dialog.getSize();
            Dimension screenSize = dialog.getToolkit().getScreenSize();
            Insets screenInsets = dialog.getToolkit().getScreenInsets(dialog.getGraphicsConfiguration());
            dialog.setLocation(screenInsets.left + (screenSize.width - screenInsets.left - screenInsets.right - paneSize.width) / 2, screenInsets.top + (screenSize.height - screenInsets.top - screenInsets.bottom - paneSize.height) / 2);
        } else {
            Point invokerScreenLocation;
            Dimension invokerSize = c.getSize();
            if (root instanceof Applet) {
                invokerScreenLocation = c.getLocationOnScreen();
            } else {
                invokerScreenLocation = new Point(0, 0);
                for (Component tc = c; tc != null; tc = tc.getParent()) {
                    Point tcl = tc.getLocation();
                    invokerScreenLocation.x += tcl.x;
                    invokerScreenLocation.y += tcl.y;
                    if (tc == root) break;
                }
            }
            Rectangle windowBounds = dialog.getBounds();
            int dx = invokerScreenLocation.x + (invokerSize.width - windowBounds.width >> 1);
            int dy = invokerScreenLocation.y + (invokerSize.height - windowBounds.height >> 1);
            Dimension ss = dialog.getToolkit().getScreenSize();
            Insets si = dialog.getToolkit().getScreenInsets(dialog.getGraphicsConfiguration());
            if (dy + windowBounds.height > ss.height - si.bottom) {
                dy = ss.height - si.bottom - windowBounds.height;
                int n = dx = invokerScreenLocation.x < ss.width >> 1 ? invokerScreenLocation.x + invokerSize.width : invokerScreenLocation.x - windowBounds.width;
            }
            if (dx + windowBounds.width > ss.width) {
                dx = ss.width - windowBounds.width;
            }
            if (dx < 0) {
                dx = 0;
            }
            if (dy < 0) {
                dy = 0;
            }
            dialog.setLocation(dx, dy);
        }
    }

    @Override
    public String toString() {
        return BUNDLE.get("audit.tab.summary", new Object[]{this.label}) + "#" + System.identityHashCode(this);
    }

    private void updateFixButton() {
        this.fixButton.setEnabled(this.hasFixes());
    }

    private boolean hasDefaultFix(Object[] objects) {
        for (Object object : objects) {
            boolean contains = this.model.iterateViolations(object, new Iteration(){

                @Override
                public boolean iteration(Object object) {
                    Violation violation = (Violation)object;
                    return violation.getDefaultTransform() == null;
                }
            }) != null;
            LOG.trace("item {1} contains transforms {0}", contains, object);
            if (!contains) continue;
            return true;
        }
        return false;
    }

    private int fix(String label, Object[] objects) {
        String text;
        Transformer transformer = AuditManager.getAuditManager().createTransformer();
        DefaultTransformsAction action = transformer.createDefaultTransformsAction(label, this.model, objects, this);
        int documentCount = action.getApplicableModelCount();
        int dirtyCount = action.getDirtyApplicableModelCount();
        if (documentCount > 0) {
            boolean ok;
            String key = documentCount == 1 ? (dirtyCount == 0 ? "fix.confirm.dialog.top-1-all.message" : "fix.confirm.dialog.top-1-none.message") : (dirtyCount == 0 ? "fix.confirm.dialog.top-n-all.message" : (dirtyCount < documentCount ? "fix.confirm.dialog.top-n-some.message" : "fix.confirm.dialog.top-n-none.message"));
            String top = BUNDLE.get(key, new Object[]{documentCount});
            Object[] fileNames = action.getApplicableModels().toArray();
            for (int i = 0; i < fileNames.length; ++i) {
                fileNames[i] = URLFileSystem.getPlatformPathName((URL)((ModelAdapter)fileNames[i]).getUrl());
            }
            JList<Object> fileList = new JList<Object>(fileNames);
            fileList.setVisibleRowCount(4);
            JScrollPane fileScrollPane = new JScrollPane(fileList, 20, 30);
            Object[] fixNames = action.getTransformDescriptions().toArray();
            Arrays.sort(fixNames);
            JList<Object> fixList = new JList<Object>(fixNames);
            fixList.setVisibleRowCount(4);
            JScrollPane fixScrollPane = new JScrollPane(fixList, 20, 31);
            MessageDialog confirmDialog = new MessageDialog(MessageDialog.WARNING);
            confirmDialog.setResizeable(true);
            confirmDialog.setTitle(BUNDLE.get("fix.confirm.dialog.title"));
            confirmDialog.setContent(top);
            confirmDialog.addContent(fileScrollPane);
            confirmDialog.addContent(BUNDLE.get(fixNames.length == 1 ? "fix.confirm.dialog.middle-1.message" : "fix.confirm.dialog.middle-n.message"));
            confirmDialog.addContent(fixScrollPane);
            confirmDialog.addContent(" ");
            String okLabel = BUNDLE.get("fix.confirm.dialog.ok.label");
            String cancelLabel = BUNDLE.get("fix.confirm.dialog.cancel.label");
            confirmDialog.setCommands(okLabel, cancelLabel);
            Object command = confirmDialog.show(null);
            boolean bl = ok = command == okLabel;
            if (!ok) {
                return 0;
            }
        }
        action.apply();
        int count = action.getAppliedTransformCount();
        switch (count) {
            case 0: {
                text = BUNDLE.get("results.fixed.0.message");
                break;
            }
            case 1: {
                text = BUNDLE.get("results.fixed.1.message");
                break;
            }
            default: {
                text = BUNDLE.get("results.fixed.n.message", new Object[]{count});
            }
        }
        Ide.getStatusBar().setText(text);
        return count;
    }

    @Override
    public void modelWritable(ModelAdapter model) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean transformFailed(Throwable exception, Violation violation, Transform transform, String label) {
        String line;
        Location location = violation.getLocation();
        ModelAdapter model = location.getModel();
        String url = URLFileSystem.getPlatformPathName((URL)model.getUrl());
        try {
            model.beginRead();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        try {
            line = model.getLine(location.getOffset());
        }
        finally {
            model.endRead();
        }
        AuditLogger.error(exception, "exception applying {0} to {1} at {2}: {3}", label, url, line, exception);
        MessageDialog dialog = new MessageDialog(MessageDialog.ERROR);
        dialog.setTitle(BUNDLE.get("results.fix.exception.title"));
        dialog.setContent(BUNDLE.get("results.fix.exception.message", new Object[]{label, exception}));
        dialog.show();
        return true;
    }

    @Override
    public void modelSaved(ModelAdapter model) {
    }

    @Override
    public boolean saveFailed(Throwable exception, ModelAdapter model, String label) {
        String url = URLFileSystem.getPlatformPathName((URL)model.getUrl());
        Log.error((String)"exception saving {0}: {1}", (Object)url, (Object)exception);
        MessageDialog dialog = new MessageDialog(MessageDialog.ERROR);
        dialog.setTitle(BUNDLE.get("results.fix.save.exception.title"));
        dialog.setContent(BUNDLE.get("results.fix.save.exception.message", new Object[]{url, exception}));
        dialog.show();
        return true;
    }

    public AuditTreeTable getTable() {
        return this.table;
    }

    private class FixButton
    extends MenuToolButton
    implements PopupMenuListener {
        public FixButton(ToggleAction buttonAction) {
            super(buttonAction);
            this.addPopupMenuListener(this);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.removeAllPopupItems();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.removeAllPopupItems();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.removeAllPopupItems();
            for (ToggleAction action : AuditLogPanel.this.getFixes()) {
                this.addPopupItem(action);
            }
        }
    }

    private static class SearchButtonModel
    extends DefaultButtonModel
    implements ChangeListener,
    DocumentListener,
    SearchListener {
        private SearchField searchField;
        private PatternFilter patternFilter;

        public SearchButtonModel(SearchField field, PatternFilter filter) {
            SEARCH_LOG.trace("init()");
            this.searchField = field;
            this.patternFilter = filter;
            this.searchField.addSearchListener((SearchListener)this);
            this.searchField.getTextField().getDocument().addDocumentListener(this);
            this.patternFilter.addChangeListener(this);
        }

        @Override
        public void setEnabled(boolean enabled) {
        }

        private void reset() {
            PatternFilter.Kind type = ((FilterCategory)this.searchField.getSelectedCategory()).getType();
            String text = this.searchField.getText();
            boolean willBeEnabled = !text.equals(this.patternFilter.getText()) || !text.isEmpty() && type != this.patternFilter.getKind();
            SEARCH_LOG.trace("reset: {0}", willBeEnabled);
            super.setEnabled(willBeEnabled);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.reset();
        }

        public void searchPerformed(SearchEvent se) {
            SEARCH_LOG.trace("searchPerformed: {0}", (Object)se);
            PatternFilter.Kind type = ((FilterCategory)this.searchField.getSelectedCategory()).getType();
            String text = this.searchField.getText();
            SEARCH_LOG.trace("searchPerformed: disabled, refiltering...", (Object)se);
            this.patternFilter.setAll(type, text);
            se.getSearchProgress().finish();
            SEARCH_LOG.trace("searchPerformed: completed refiltering", (Object)se);
        }

        public void searchCategoryChanged(SearchEvent se) {
            SEARCH_LOG.trace("searchCategoryChanged: {0}", (Object)se);
            this.reset();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SEARCH_LOG.trace("insertUpdate");
            this.reset();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SEARCH_LOG.trace("removeUpdate");
            this.reset();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SEARCH_LOG.trace("changedUpdate");
            this.reset();
        }
    }

    private static class FilterCategory
    extends SearchCategory {
        private static Map<PatternFilter.Kind, SearchCategory> categories = new HashMap<PatternFilter.Kind, SearchCategory>();
        private PatternFilter.Kind type;

        private FilterCategory(String label, PatternFilter.Kind type) {
            super(label);
            this.type = type;
            categories.put(type, this);
        }

        private PatternFilter.Kind getType() {
            return this.type;
        }

        public static SearchCategory getCategory(PatternFilter.Kind type) {
            return categories.get((Object)type);
        }
    }
}

