/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import oracle.javatools.util.IterablesIterator;
import oracle.javatools.util.Log;
import oracle.javatools.util.Maps;
import oracle.javatools.util.Tuple;
import oracle.javatools.util.WeakCache;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.AuditTaskContext;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.SuppressionScheme;
import oracle.jdeveloper.audit.extension.AnalyzerDefinition;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.ExtensionResource;
import oracle.jdeveloper.audit.extension.ModelDefinition;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdevimpl.audit.core.BoundMethod;

public final class AnalyzerBinding {
    private final Profile profile;
    private static final Set<AnalyzerDefinition> badAnalyzerTypes = new HashSet<AnalyzerDefinition>();
    private static final Map<Class<? extends Analyzer>, List<Tuple<Field, String>>> fieldsByAnalyzer = new Maps.SoftHashMap();
    private volatile boolean cancelled;
    private volatile Map<AnalyzerDefinition, Analyzer> analyzers;
    private Map<String, ExtensionBean> boundBeans;
    private List<AnalyzerDefinition> enabledAnalyzerTypes;
    private Map<Class<?>, List<Tuple<AnalyzerDefinition, Method>>> enterMethodsByConstruct;
    private Map<Class<?>, List<Tuple<AnalyzerDefinition, Method>>> exitMethodsByConstruct;
    private final Map<Class<?>, EnterExitMethods> boundEnterExitMethodsByConstruct = new HashMap();
    private List<Tuple<AnalyzerDefinition, Method>> reviewMethods;
    private List<BoundMethod<Analyzer>> boundReviewMethods;
    private List<Tuple<AnalyzerDefinition, Method>> startTaskMethods;
    private List<BoundMethod<Analyzer>> boundStartTaskMethods;
    private static Collection<AnalyzerDefinition> defaultAnalyzerDefinitions;
    private static final Log LOG;
    private static WeakCache<AnalyzerDefinition, List<Method>> methodsByAnalyzer;

    public AnalyzerBinding(Profile profile) {
        this.profile = profile;
    }

    public Profile getProfile() {
        return this.profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(Collection<AnalyzerDefinition> analyzerDefinitions, boolean disableAssists, Set<String> disableAnalyzers, Collection<Rule> rules, Collection<Metric> metrics, Collection<SuppressionScheme> suppressionSchemes, boolean forceAndVerify) {
        LOG.trace("binding {0}", (Object)this.profile);
        AuditHook hook = AuditHook.getAuditHook();
        Class<AnalyzerBinding> clazz = AnalyzerBinding.class;
        synchronized (AnalyzerBinding.class) {
            if (defaultAnalyzerDefinitions == null) {
                defaultAnalyzerDefinitions = hook.getAnalyzers();
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            this.throwIfCancelled();
            AnalyzerBinding analyzerBinding = this;
            synchronized (analyzerBinding) {
                if (analyzerDefinitions == null) {
                    analyzerDefinitions = defaultAnalyzerDefinitions;
                }
                LinkedHashMap<AnalyzerDefinition, Analyzer> analyzers = new LinkedHashMap<AnalyzerDefinition, Analyzer>();
                this.boundBeans = new LinkedHashMap<String, ExtensionBean>();
                Map<String, ExtensionBean> allBeans = this.profile.createBeans(forceAndVerify);
                this.throwIfCancelled();
                for (AnalyzerDefinition definition : analyzerDefinitions) {
                    Analyzer analyzer;
                    block43: {
                        if (disableAnalyzers.contains(definition.getTypeName())) continue;
                        try {
                            analyzer = definition.getInstance(forceAndVerify);
                            if (analyzer == null) {
                            }
                            break block43;
                        }
                        catch (Throwable e) {
                            if (!badAnalyzerTypes.add(definition)) continue;
                            definition.log(Level.SEVERE, e, "Analyzer {0} ignored because it could not be created: {1}", definition.getTypeName(), e);
                        }
                        continue;
                    }
                    this.throwIfCancelled();
                    try {
                        List<Tuple<Field, String>> fields = this.getFields(definition, allBeans);
                        if (!fields.isEmpty()) {
                            int enabled = 0;
                            for (Tuple<Field, String> field : fields) {
                                String fieldId = (String)field.object2();
                                ExtensionBean bean = allBeans.get(fieldId);
                                if (bean == null) continue;
                                String id = bean.id();
                                ExtensionBean boundBean = this.boundBeans.get(id);
                                if (boundBean == null) {
                                    String categoryId;
                                    Category category;
                                    boundBean = bean;
                                    this.boundBeans.put(id, boundBean);
                                    if (boundBean instanceof Rule) {
                                        Rule rule = (Rule)boundBean;
                                        category = rule.category();
                                        if (rule.assist() && disableAssists) {
                                            rule.setEnabled(false);
                                        }
                                        if (rule.isEnabled() || "oracle.ide.audit.internal".equals(rule.category().id())) {
                                            rules.add(rule);
                                            ++enabled;
                                        }
                                    } else if (boundBean instanceof SuppressionScheme) {
                                        SuppressionScheme scheme = (SuppressionScheme)boundBean;
                                        category = scheme.category();
                                        if (scheme.isEnabled()) {
                                            suppressionSchemes.add(scheme);
                                            ++enabled;
                                        }
                                    } else if (boundBean instanceof Metric) {
                                        Metric metric = (Metric)boundBean;
                                        category = metric.category();
                                        if (metric.isEnabled()) {
                                            metrics.add(metric);
                                            ++enabled;
                                        }
                                    } else {
                                        category = boundBean instanceof Category ? ((Category)boundBean).category() : null;
                                    }
                                    while (category != null && !this.boundBeans.containsKey(categoryId = category.id())) {
                                        this.boundBeans.put(categoryId, category);
                                        category = category.category();
                                    }
                                } else if (boundBean instanceof Rule && ((Rule)boundBean).isEnabled()) {
                                    ++enabled;
                                } else if (boundBean instanceof SuppressionScheme && ((SuppressionScheme)boundBean).isEnabled()) {
                                    ++enabled;
                                } else if (boundBean instanceof Metric && ((Metric)boundBean).isEnabled()) {
                                    ++enabled;
                                }
                                ((Field)field.object1()).set(analyzer, boundBean);
                            }
                            if (enabled <= 0) continue;
                            analyzers.put(definition, analyzer);
                            continue;
                        }
                        analyzers.put(definition, analyzer);
                        LOG.trace("Rule-less analyzer {0} enabled", (Object)definition);
                    }
                    catch (BindingException e) {
                        definition.log(Level.SEVERE, e, "Analyzer {0} ignored because it could not be created: {1}", definition, e.getMessage());
                    }
                    catch (Throwable e) {
                        if (!badAnalyzerTypes.add(definition)) continue;
                        definition.log(Level.SEVERE, e, "Analyzer {0} ignored because it could not be created: {1}", definition, e);
                    }
                }
                this.analyzers = analyzers;
                if (forceAndVerify) {
                    HashSet<ExtensionBean> unusedBeans = new HashSet<ExtensionBean>(allBeans.values());
                    unusedBeans.removeAll(this.boundBeans.values());
                    for (ExtensionBean extensionBean : unusedBeans) {
                        String id = extensionBean.id();
                        if (extensionBean instanceof Category) {
                            if ("oracle.ide.audit".equals(extensionBean.extensionId()) || extensionBean.definition() instanceof ModelDefinition) continue;
                            extensionBean.logWarning("Category ''{0}'' not referenced by any used category, rule, or metric", id);
                            continue;
                        }
                        if (extensionBean instanceof Rule) {
                            if ("oracle.ide.audit.internal".equals(((Rule)extensionBean).category().id())) continue;
                            extensionBean.logWarning("Rule ''{0}'' not referenced by any analyzer", id);
                            continue;
                        }
                        if (extensionBean instanceof SuppressionScheme) {
                            extensionBean.logWarning("Suppression scheme ''{0}'' not referenced by any analyzer", id);
                            continue;
                        }
                        if (extensionBean instanceof Metric) {
                            if ("oracle.ide.audit.internal".equals(((Metric)extensionBean).category().id())) continue;
                            extensionBean.logWarning("Metric ''{0}'' not referenced by any analyzer", id);
                            continue;
                        }
                        extensionBean.logError("Bean class " + extensionBean.getClass() + " not expected", new Object[0]);
                    }
                    for (Map.Entry entry : this.boundBeans.entrySet()) {
                        assert (((String)entry.getKey()).equals(((ExtensionBean)entry.getValue()).id()));
                    }
                }
                this.introspectVisitorMethods(analyzers);
            }
            return;
        }
    }

    private void throwIfCancelled() {
        if (this.cancelled) {
            throw new CancellationException();
        }
    }

    public void cancel() {
        this.cancelled = true;
        Map<AnalyzerDefinition, Analyzer> analyzers = this.analyzers;
        if (analyzers != null) {
            for (Analyzer analyzer : analyzers.values()) {
                if (analyzer == null) continue;
                analyzer.cancel();
            }
        }
    }

    public boolean enabledBeans(Analyzer analyzer, Collection<Rule> rules, Collection<Metric> metrics, Collection<SuppressionScheme> suppressionSchemes) {
        try {
            for (Tuple<Field, String> tuple : this.getFields(analyzer.getClass())) {
                Metric metric;
                Field field = (Field)tuple.object1();
                Object bean = field.get(analyzer);
                if (bean instanceof Rule) {
                    Rule rule = (Rule)bean;
                    if (!rule.isEnabled() && !"oracle.ide.audit.internal".equals(rule.category().id())) continue;
                    rules.add(rule);
                    continue;
                }
                if (bean instanceof SuppressionScheme) {
                    SuppressionScheme scheme = (SuppressionScheme)bean;
                    if (!scheme.isEnabled()) continue;
                    suppressionSchemes.add(scheme);
                    continue;
                }
                if (!(bean instanceof Metric) || !(metric = (Metric)bean).isEnabled()) continue;
                metrics.add(metric);
            }
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (BindingException e) {
            return false;
        }
    }

    public Collection<Analyzer> getAnalyzers() {
        return this.analyzers.values();
    }

    public synchronized EnterExitMethods getEnterExitMethods(Class<?> constructType) {
        EnterExitMethods methods = this.boundEnterExitMethodsByConstruct.get(constructType);
        if (methods == null) {
            LinkedHashSet types = new LinkedHashSet();
            for (Class<?> type = constructType; type != null; type = type.getSuperclass()) {
                types.add(type);
                this.addInterfaces(types, type.getInterfaces());
            }
            HashSet<AnalyzerDefinition> boundEntryClasses = new HashSet<AnalyzerDefinition>();
            HashSet<AnalyzerDefinition> boundExitClasses = new HashSet<AnalyzerDefinition>();
            ArrayList<BoundMethod<Analyzer>> boundEntryMethods = new ArrayList<BoundMethod<Analyzer>>();
            ArrayList<BoundMethod<Analyzer>> boundExitMethods = new ArrayList<BoundMethod<Analyzer>>();
            for (Class clazz : types) {
                this.bindMethods(this.analyzers, this.enterMethodsByConstruct.get(clazz), boundEntryClasses, boundEntryMethods);
                this.bindMethods(this.analyzers, this.exitMethodsByConstruct.get(clazz), boundExitClasses, boundExitMethods);
            }
            methods = new EnterExitMethods(boundEntryMethods, boundExitMethods);
            this.boundEnterExitMethodsByConstruct.put(constructType, methods);
        }
        return methods;
    }

    public synchronized List<BoundMethod<Analyzer>> getReviewMethods() {
        if (this.boundReviewMethods == null) {
            this.boundReviewMethods = new ArrayList<BoundMethod<Analyzer>>(this.reviewMethods.size());
            for (Tuple<AnalyzerDefinition, Method> tuple : this.reviewMethods) {
                this.boundReviewMethods.add(new BoundMethod<Analyzer>(this.analyzers.get(tuple.object1()), (Method)tuple.object2()));
            }
        }
        return this.boundReviewMethods;
    }

    public synchronized List<BoundMethod<Analyzer>> getStartTaskMethods() {
        if (this.boundStartTaskMethods == null) {
            this.boundStartTaskMethods = new ArrayList<BoundMethod<Analyzer>>(this.startTaskMethods.size());
            for (Tuple<AnalyzerDefinition, Method> tuple : this.startTaskMethods) {
                this.boundStartTaskMethods.add(new BoundMethod<Analyzer>(this.analyzers.get(tuple.object1()), (Method)tuple.object2()));
            }
        }
        return this.boundStartTaskMethods;
    }

    public synchronized void clear() {
        this.boundEnterExitMethodsByConstruct.clear();
        this.boundReviewMethods = null;
        this.boundStartTaskMethods = null;
        this.boundBeans = null;
        this.analyzers = null;
        this.cancelled = false;
    }

    private void addInterfaces(Set<Class<?>> types, Class[] interfaces) {
        for (Class type : interfaces) {
            types.add(type);
            this.addInterfaces(types, type.getInterfaces());
        }
    }

    private void bindMethods(Map<AnalyzerDefinition, Analyzer> analyzers, List<Tuple<AnalyzerDefinition, Method>> unboundMethods, Set<AnalyzerDefinition> boundClasses, List<BoundMethod<Analyzer>> boundMethods) {
        if (unboundMethods == null) {
            return;
        }
        for (Tuple<AnalyzerDefinition, Method> tuple : unboundMethods) {
            Analyzer analyzer;
            AnalyzerDefinition analyzerClass = (AnalyzerDefinition)tuple.object1();
            if (!boundClasses.add(analyzerClass) || (analyzer = analyzers.get(analyzerClass)) == null) continue;
            Method method = (Method)tuple.object2();
            boundMethods.add(new BoundMethod<Analyzer>(analyzer, method));
        }
    }

    private void introspectVisitorMethods(Map<AnalyzerDefinition, Analyzer> analyzers) {
        ArrayList<AnalyzerDefinition> analyzerTypes = new ArrayList<AnalyzerDefinition>(analyzers.keySet());
        if (analyzerTypes.equals(this.enabledAnalyzerTypes)) {
            LOG.trace("enabled analyzer types unchanged");
            return;
        }
        LOG.trace("enabled analyzer types changed; introspecting visitor methods");
        this.enabledAnalyzerTypes = analyzerTypes;
        this.enterMethodsByConstruct = new HashMap();
        this.exitMethodsByConstruct = new HashMap();
        this.reviewMethods = new ArrayList<Tuple<AnalyzerDefinition, Method>>();
        this.startTaskMethods = new ArrayList<Tuple<AnalyzerDefinition, Method>>();
        for (Map.Entry<AnalyzerDefinition, Analyzer> entry : analyzers.entrySet()) {
            AnalyzerDefinition analyzerType = entry.getKey();
            LOG.trace("loading methods for {0}", (Object)analyzerType);
            ArrayList<Method> list = (ArrayList<Method>)methodsByAnalyzer.get((Object)analyzerType);
            if (list == null) {
                list = new ArrayList<Method>();
                methodsByAnalyzer.put((Object)analyzerType, list);
                Method[] methods = entry.getValue().getClass().getMethods();
                this.throwIfCancelled();
                for (Method method : methods) {
                    Class<?>[] signature;
                    String name = method.getName();
                    if (name.startsWith("enter") || name.startsWith("exit")) {
                        signature = method.getParameterTypes();
                        if (signature.length != 2) {
                            AuditLogger.error("Method {0} ignored because it does not have exactly 2 parameters", method);
                            continue;
                        }
                        if (!AuditContext.class.equals(signature[0])) {
                            AuditLogger.error("Method {0} ignored because type of first parameter is not AuditContext", method);
                            continue;
                        }
                        list.add(method);
                        continue;
                    }
                    if (name.equals("review") && !method.getDeclaringClass().equals(Analyzer.class)) {
                        signature = method.getParameterTypes();
                        if (signature.length != 2) {
                            AuditLogger.error("Method {0} ignored because it does not have exactly 2 parameters", method);
                            continue;
                        }
                        if (!AuditContext.class.equals(signature[0])) {
                            AuditLogger.error("Method {0} ignored because type of first parameter is not AuditContext", method);
                            continue;
                        }
                        list.add(method);
                        continue;
                    }
                    if (!name.equals("startTask") || method.getDeclaringClass().equals(Analyzer.class) || (signature = method.getParameterTypes()).length != 1 || !AuditTaskContext.class.equals(signature[0])) continue;
                    list.add(method);
                }
            }
            for (Method method : list) {
                List<Tuple<AnalyzerDefinition, Method>> methods;
                Class<?> constructType;
                String name = method.getName();
                Tuple tuple = new Tuple((Object)analyzerType, (Object)method);
                if ("review".equals(name)) {
                    this.reviewMethods.add((Tuple<AnalyzerDefinition, Method>)tuple);
                    continue;
                }
                if ("startTask".equals(name)) {
                    this.startTaskMethods.add((Tuple<AnalyzerDefinition, Method>)tuple);
                    continue;
                }
                if (name.startsWith("enter")) {
                    constructType = method.getParameterTypes()[1];
                    methods = this.enterMethodsByConstruct.get(constructType);
                    if (methods == null) {
                        methods = new ArrayList<Tuple<AnalyzerDefinition, Method>>();
                        this.enterMethodsByConstruct.put(constructType, methods);
                    }
                    methods.add((Tuple<AnalyzerDefinition, Method>)tuple);
                    continue;
                }
                constructType = method.getParameterTypes()[1];
                methods = this.exitMethodsByConstruct.get(constructType);
                if (methods == null) {
                    methods = new ArrayList<Tuple<AnalyzerDefinition, Method>>();
                    this.exitMethodsByConstruct.put(constructType, methods);
                }
                methods.add((Tuple<AnalyzerDefinition, Method>)tuple);
            }
        }
    }

    public synchronized String statistics() {
        ArrayList methods = new ArrayList();
        Collection<EnterExitMethods> values = this.boundEnterExitMethodsByConstruct.values();
        for (EnterExitMethods value : values) {
            methods.addAll(value.getEnterMethods());
            methods.addAll(value.getExitMethods());
        }
        methods.addAll(this.boundReviewMethods);
        methods.addAll(this.boundStartTaskMethods);
        return BoundMethod.summarize(methods);
    }

    private List<Tuple<Field, String>> getFields(AnalyzerDefinition analyzerType, Map<String, ExtensionBean> declarativeBeans) throws BindingException {
        Class<? extends Analyzer> type = analyzerType.getType(false);
        ArrayList<Tuple<Field, String>> fields = new ArrayList<Tuple<Field, String>>();
        for (Tuple<Field, String> tuple : this.getFields(type)) {
            this.throwIfCancelled();
            Field field = (Field)tuple.object1();
            String id = (String)tuple.object2();
            ExtensionBean bean = declarativeBeans.get(id);
            if (field.getType().isInstance(bean)) {
                fields.add((Tuple<Field, String>)new Tuple((Object)field, (Object)bean.id()));
                continue;
            }
            if (bean != null) {
                throw new BindingException("Field ''{0}'' has type ''{1}'' but references bean ''{2}'' of type ''{3}''", field.getName(), field.getType().getName(), id, bean.getClass().getName());
            }
            throw new BindingException("Field ''{0}'' references undefined bean ''{1}''", field.getName(), id);
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Tuple<Field, String>> getFields(Class<? extends Analyzer> type) throws BindingException {
        if (type == null) {
            return Collections.emptyList();
        }
        Map<Class<? extends Analyzer>, List<Tuple<Field, String>>> map = fieldsByAnalyzer;
        synchronized (map) {
            List<Tuple<Field, String>> fields;
            block8: {
                Class<? extends Analyzer> superType;
                fields = fieldsByAnalyzer.get(type);
                if (fields != null) {
                    return fields;
                }
                fields = new ArrayList<Tuple<Field, String>>();
                fieldsByAnalyzer.put(type, fields);
                do {
                    for (Field field : type.getDeclaredFields()) {
                        ExtensionResource annotation = field.getAnnotation(ExtensionResource.class);
                        if (annotation == null) continue;
                        if (Modifier.isStatic(field.getModifiers())) {
                            throw new BindingException("Field ''{0}'' is static", field.getName());
                        }
                        field.setAccessible(true);
                        String id = annotation.value();
                        fields.add((Tuple<Field, String>)new Tuple((Object)field, (Object)id));
                    }
                    superType = type.getSuperclass();
                    if (superType == Analyzer.class) break block8;
                } while (!fieldsByAnalyzer.containsKey(type = superType.asSubclass(Analyzer.class)));
                fields.addAll((Collection<Tuple<Field, String>>)fieldsByAnalyzer.get(superType));
            }
            return fields;
        }
    }

    static {
        LOG = new Log("audit-binding");
        methodsByAnalyzer = new WeakCache();
    }

    private static class BindingException
    extends Exception {
        BindingException(String message, Object ... arguments) {
            super(arguments.length != 0 ? MessageFormat.format(message, arguments) : message);
        }
    }

    static class EnterExitMethods
    implements Iterable<BoundMethod<Analyzer>> {
        private List<BoundMethod<Analyzer>> boundEntryMethods = new ArrayList<BoundMethod<Analyzer>>();
        private List<BoundMethod<Analyzer>> boundExitMethods = new ArrayList<BoundMethod<Analyzer>>();

        private EnterExitMethods(List<BoundMethod<Analyzer>> boundEntryMethods, List<BoundMethod<Analyzer>> boundExitMethods) {
            this.boundEntryMethods = boundEntryMethods;
            this.boundExitMethods = boundExitMethods;
        }

        List<BoundMethod<Analyzer>> getEnterMethods() {
            return this.boundEntryMethods;
        }

        List<BoundMethod<Analyzer>> getExitMethods() {
            return this.boundExitMethods;
        }

        @Override
        public Iterator<BoundMethod<Analyzer>> iterator() {
            return new IterablesIterator(this.boundEntryMethods, new Iterable[]{this.boundExitMethods});
        }
    }
}

