/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.HandleHolder;
import oracle.aurora.rdbms.KGEException;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Schema;

public abstract class ReferencingHandle
extends Handle {
    ReferencingHandle(String name, Schema schema, long index, byte[] timestamp) {
        super(name, schema, index, timestamp);
    }

    private native Object[] referencedClasses(boolean var1, String var2) throws ObjectTypeChangedException;

    public String[] referencedClassNames() throws ObjectTypeChangedException {
        String[] x = null;
        try {
            x = (String[])this.referencedClasses(true, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".referencedClassNames");
        }
        if (x == null) {
            x = new String[]{};
        }
        return x;
    }

    public HandleHolder[] referencedClassHandleHolders() throws ObjectTypeChangedException {
        HandleHolder[] holders = null;
        try {
            holders = (HandleHolder[])this.referencedClasses(false, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".referencedClassHandles");
        }
        if (holders == null) {
            holders = new HandleHolder[]{};
        }
        int length = holders.length;
        for (int i = 0; i < length; ++i) {
            holders[i].handle = ClassHandle.intern(holders[i]);
        }
        return holders;
    }

    public ClassHandle[] referencedClassHandles() throws ObjectTypeChangedException {
        HandleHolder[] holders = this.referencedClassHandleHolders();
        if (holders == null) {
            return null;
        }
        int length = holders.length;
        ClassHandle[] handles = new ClassHandle[length];
        for (int i = 0; i < length; ++i) {
            handles[i] = (ClassHandle)holders[i].handle;
        }
        return handles;
    }
}

