/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class CopyIO {
    String encoding;

    CopyIO(String encoding) {
        this.encoding = encoding;
    }

    Reader toReader(String s) {
        return new StringReader(s);
    }

    InputStream toInputStream(byte[] bytes) throws IOException {
        return new ByteArrayInputStream(bytes);
    }

    Reader toReader(byte[] bytes) throws IOException {
        InputStream in = this.toInputStream(bytes);
        InputStreamReader r = this.encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, this.encoding);
        return r;
    }

    byte[] toBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(in.available());
        this.copy(out, in);
        out.close();
        return out.toByteArray();
    }

    String toString(InputStream in) throws IOException {
        InputStreamReader r = this.encoding != null ? new InputStreamReader(in, this.encoding) : new InputStreamReader(in);
        return this.toString(r, in.available());
    }

    String toString(Reader in, int size) throws IOException {
        StringWriter out = new StringWriter();
        this.copy(out, in);
        out.close();
        return out.toString();
    }

    String toString(Reader in) throws IOException {
        return this.toString(in, 1024);
    }

    byte[] toEncoded(Reader in, int size) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(3 * size);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, this.encoding);
        this.copy(w, in);
        w.close();
        return out.toByteArray();
    }

    byte[] toEncoded(Reader in) throws IOException {
        return this.toEncoded(in, 1024);
    }

    Reader toReader(InputStream in, String encoding) throws IOException {
        InputStreamReader r = new InputStreamReader(in, encoding);
        return r;
    }

    Reader toReader(InputStream in) throws IOException {
        InputStreamReader r = new InputStreamReader(in);
        return r;
    }

    void copy(Writer out, Reader in) throws IOException {
        char[] buf = new char[4096];
        int count = 0;
        while (count >= 0) {
            count = in.read(buf);
            if (count <= 0) continue;
            out.write(buf, 0, count);
        }
        out.flush();
    }

    void copy(OutputStream out, InputStream in) throws IOException {
        byte[] buf = new byte[4096];
        int count = 0;
        while (count >= 0) {
            count = in.read(buf);
            if (count <= 0) continue;
            out.write(buf, 0, count);
        }
        out.flush();
    }
}

