/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.internal.ui;

import java.awt.AWTEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import oracle.javatools.internal.ui.EventQueueObserver;
import oracle.javatools.internal.ui.EventQueueWrapper;
import oracle.javatools.logging.Diagnostics;
import org.netbeans.modules.sampler.Sampler;
import org.openide.util.RequestProcessor;

public final class EventThreadHangMonitor
extends EventQueueObserver {
    private static final RequestProcessor REQUEST_PROCESSOR = new RequestProcessor("EventDispatchThreadHangMonitor", 1, false);
    private static final Logger HANG_LOGGER = Logger.getLogger("slowness");
    private static final Logger LOGGER = Logger.getLogger(EventThreadHangMonitor.class.getName());
    private final JFrame mainWindow;
    private final long initDelay;
    private final int samplingLength;
    private final int hangTime;
    private final int reportTime;
    private long ignoreTill;
    private RequestProcessor.Task watchdogTask;
    private Watchdog watchdog;

    public static EventThreadHangMonitor create(JFrame mainWindow) {
        if (mainWindow != null && Boolean.getBoolean("ide.awthangmonitor")) {
            Sampler sampler = Sampler.createSampler((String)"awt");
            if (sampler == null) {
                return null;
            }
            long initDelay = Long.getLong("ide.awthangmonitor.initDelay", 15000L);
            int samplingLength = Integer.getInteger("ide.awthangmonitor.samplingLength", 120000);
            int hangTime = Integer.getInteger("ide.awthangmonitor.threshold", 1000);
            int reportTime = Integer.getInteger("ide.awthangmonitor.report", 3000);
            return new EventThreadHangMonitor(mainWindow, initDelay, samplingLength, hangTime, reportTime);
        }
        return null;
    }

    EventThreadHangMonitor(JFrame mainWindow, long initDelay, int samplingLength, int hangTime, int reportTime) {
        this.mainWindow = mainWindow;
        this.initDelay = initDelay;
        this.samplingLength = samplingLength;
        this.hangTime = hangTime;
        this.reportTime = reportTime;
        if (mainWindow == null) {
            this.ignoreTill = System.currentTimeMillis() + initDelay;
        } else {
            this.ignoreTill = mainWindow.isVisible() ? System.currentTimeMillis() + initDelay : Long.MAX_VALUE;
            mainWindow.addWindowListener(new MainWindowListener());
        }
        this.resetWatchdog();
    }

    private void resetWatchdog() {
        this.watchdog = new Watchdog();
        this.watchdogTask = REQUEST_PROCESSOR.create((Runnable)this.watchdog);
        this.watchdogTask.setPriority(1);
    }

    private void startWatchdog(AWTEvent event) {
        long start = System.currentTimeMillis();
        if (start > this.ignoreTill) {
            this.watchdog.start(start, event, Thread.currentThread());
            this.watchdogTask.schedule(this.hangTime);
        }
    }

    private void stopWatchdog() {
        boolean hangDetected = this.watchdog.stop(System.currentTimeMillis());
        boolean cancelled = this.watchdogTask.cancel();
        if (!cancelled || hangDetected) {
            this.resetWatchdog();
        }
    }

    @Override
    public void preDispatchEvent(EventQueueWrapper eventQueue, AWTEvent event) {
        this.stopWatchdog();
        this.startWatchdog(event);
    }

    @Override
    public void postDispatchEvent(EventQueueWrapper eventQueue, AWTEvent event) {
        this.stopWatchdog();
    }

    private static File saveSamplerData(Sampler sampler) {
        File npssFile;
        block3: {
            npssFile = null;
            try {
                npssFile = File.createTempFile("selfsampler", ".npss");
                DataOutputStream npss = new DataOutputStream(new FileOutputStream(npssFile));
                sampler.stopAndWriteTo(npss);
                if (npss.size() == 0) {
                    LOGGER.info("Sampler data file is empty");
                    npss.close();
                    npssFile.delete();
                    npssFile = null;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                if (npssFile == null) break block3;
                npssFile.delete();
                npssFile = null;
            }
        }
        return npssFile;
    }

    private class Watchdog
    implements Runnable {
        private boolean hangDetected;
        private boolean stopped;
        private Thread edt;
        private long start;
        private long hangDuration;
        private AWTEvent event;

        private Watchdog() {
        }

        synchronized void start(long start, AWTEvent event, Thread edt) {
            assert (!this.hangDetected);
            this.edt = edt;
            this.start = start;
            this.event = event;
        }

        synchronized boolean stop(long end) {
            if (this.hangDetected) {
                this.hangDuration = end - this.start;
                this.stopped = true;
                this.notify();
            }
            return this.hangDetected;
        }

        @Override
        public synchronized void run() {
            block11: {
                if (this.stopped) {
                    return;
                }
                this.hangDetected = true;
                File npssFile = null;
                try {
                    StringWriter swriter = new StringWriter();
                    PrintWriter writer = new PrintWriter(swriter);
                    Diagnostics.logThread((PrintWriter)writer, (Thread)this.edt, null);
                    writer.close();
                    String stackTrace = swriter.getBuffer().toString();
                    Sampler sampler = Sampler.createSampler((String)"awt");
                    LOGGER.info("Sampler = " + sampler);
                    if (sampler != null) {
                        sampler.start();
                    }
                    this.wait(EventThreadHangMonitor.this.samplingLength);
                    if (sampler != null) {
                        if (this.stopped && this.hangDuration < (long)EventThreadHangMonitor.this.reportTime) {
                            sampler.cancel();
                        } else {
                            npssFile = EventThreadHangMonitor.saveSamplerData(sampler);
                        }
                    }
                    while (!this.stopped) {
                        this.wait();
                    }
                    if (this.hangDuration < (long)EventThreadHangMonitor.this.reportTime) {
                        if (npssFile != null) {
                            npssFile.delete();
                        }
                    } else {
                        HANG_LOGGER.log(Level.INFO, "Slowness detected", new Object[]{this.hangDuration, this.event, stackTrace, npssFile});
                    }
                    npssFile = null;
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                    if (npssFile == null) break block11;
                    npssFile.delete();
                }
            }
        }
    }

    private class MainWindowListener
    extends WindowAdapter {
        private MainWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            EventThreadHangMonitor.this.ignoreTill = System.currentTimeMillis() + EventThreadHangMonitor.this.initDelay;
            LOGGER.severe("WINDOWEVENT: window opened");
        }
    }
}

