/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.javatools.history.AbstractHistoryModel;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.javatools.history.HistoryProperty;
import oracle.javatools.history.TableModelAdapter;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.util.Pair;

public class HistoryComponent
extends JPanel {
    public static final Date LIVE_DATE = new LiveDate();
    private GenericTable _table = new HistoryTable();
    private JScrollPane _scrollPane;
    private HistoryModel _model;
    private boolean m_tableInitialized = false;
    private boolean _useScrollPane = true;
    private boolean _useAutoSizeMaximums = false;

    public void setUseScrollPane(boolean useScrollPane) {
        this._useScrollPane = useScrollPane;
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (this._scrollPane != null) {
            this._scrollPane.addMouseListener(mouseListener);
        }
        this._table.addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        if (this._scrollPane != null) {
            this._scrollPane.removeMouseListener(mouseListener);
        }
        this._table.removeMouseListener(mouseListener);
    }

    public GenericTable getTable() {
        return this._table;
    }

    private JScrollPane getScrollPane() {
        return this._scrollPane;
    }

    public HistoryProperty getSortProperty() {
        if (this.getModel() == null) {
            return null;
        }
        if (this.getTable().isSorted()) {
            int sortColumn = this.getTable().getSortColumn();
            return this.getModel().getProperties()[sortColumn];
        }
        return null;
    }

    public void sortTableByProperty(HistoryProperty property, boolean ascending) {
        if (this.getModel() == null) {
            throw new IllegalStateException("No Model");
        }
        HistoryProperty[] props = this.getModel().getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (property != props[i]) continue;
            this.getTable().setSortColumn(i, ascending);
            return;
        }
        throw new IllegalArgumentException("Unknown property: " + property);
    }

    public void addListSelectionListener(ListSelectionListener lsl) {
        this.getTable().getSelectionModel().addListSelectionListener(lsl);
    }

    public void removeListSelectionListener(ListSelectionListener lsl) {
        this.getTable().getSelectionModel().removeListSelectionListener(lsl);
    }

    public void setSingleSelection(boolean isSingleSelection) {
        if (isSingleSelection) {
            this.getTable().setSelectionMode(0);
        } else {
            this.getTable().setSelectionMode(2);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.getTable().setEnabled(isEnabled);
    }

    public String getSelectionCopyString() {
        StringBuffer sb = new StringBuffer();
        HistoryEntry[] versions = this.getSelection();
        for (int i = 0; i < versions.length; ++i) {
            for (int j = 0; j < this.getTable().getColumnModel().getColumnCount(); ++j) {
                int modelCol = this.getTable().convertColumnIndexToModel(j);
                Object value = versions[i].getValue(this.getModel().getProperties()[modelCol]);
                sb.append(String.valueOf(value));
                if (j >= this.getTable().getColumnModel().getColumnCount() - 1) continue;
                sb.append(",\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public HistoryModel getModel() {
        return this._model;
    }

    public void selectAll() {
        this.getTable().getSelectionModel().setSelectionInterval(0, this.getTable().getModel().getRowCount() - 1);
    }

    public void selectFirst() {
        if (this.getTable().getModel().getRowCount() > 0) {
            this.getTable().getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void initTable() {
        this.getTable().getTableHeader().setReorderingAllowed(false);
        this.getTable().setDefaultRenderer(String.class, (TableCellRenderer)new GenericTableCellRenderer((TableCellRenderer)new StringCellRenderer()));
        this.getTable().setDefaultRenderer(Date.class, (TableCellRenderer)new GenericTableCellRenderer((TableCellRenderer)new DateCellRenderer()));
        this.getTable().setDefaultRenderer(Collection.class, (TableCellRenderer)new GenericTableCellRenderer((TableCellRenderer)new CollectionCellRenderer()));
        this.setLayout(new BorderLayout());
        this.getTable().setAutoResizeMode(0);
        this._scrollPane = new JScrollPane((Component)this.getTable());
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        if (this._useScrollPane) {
            this.add((Component)this._scrollPane, "Center");
        } else {
            this.add((Component)this.getTable().getTableHeader(), "North");
            this.add((Component)this._scrollPane.getViewport(), "Center");
        }
        this.m_tableInitialized = true;
    }

    public HistoryProperty[] getHiddenProperties() {
        TableModelAdapter model = (TableModelAdapter)((Object)this._table.getModel());
        LinkedHashSet<HistoryProperty> hiddenProperties = new LinkedHashSet<HistoryProperty>(Arrays.asList(this._model.getProperties()));
        for (int i = 0; i < this._table.getColumnCount(); ++i) {
            hiddenProperties.remove(model.getProperty(this._table.convertColumnIndexToModel(i)));
        }
        return hiddenProperties.toArray(new HistoryProperty[0]);
    }

    public void setUseAutoSizeMaximums(boolean useAutoSizeMaximums) {
        this._useAutoSizeMaximums = useAutoSizeMaximums;
    }

    public void setModel(HistoryModel model) {
        if (!this.m_tableInitialized) {
            this.initTable();
        }
        this._model = model;
        TableModelAdapter tableModelAdapter = new TableModelAdapter(model);
        tableModelAdapter.setUseAutoSizeMaximums(this._useAutoSizeMaximums);
        this._table.getSelectionModel().setValueIsAdjusting(true);
        this._table.setModel((TableModel)((Object)tableModelAdapter));
        this._table.setSorted(true);
        this._table.setSortColumn(0, true);
        this._table.getSelectionModel().setValueIsAdjusting(false);
        this._table.setSelectedRowsInModel(new int[0]);
        HistoryProperty[] properties = model.getProperties();
        Object[] prototypeValues = new Object[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            prototypeValues[i] = properties[i].getPrototypeValue();
        }
        this._table.autoSizeColumnsToFit(prototypeValues);
        List<HistoryProperty> defaultProperties = Arrays.asList(model.getDefaultProperties());
        int[] hiddenColumns = new int[properties.length - defaultProperties.size()];
        int j = 0;
        for (int i = 0; i < properties.length; ++i) {
            if (defaultProperties.contains(properties[i])) continue;
            hiddenColumns[j++] = i;
        }
        this._table.setHiddenColumns(hiddenColumns);
    }

    public HistoryEntry getSingleSelection() {
        HistoryEntry[] sel = this.getSelection();
        if (sel == null) {
            return null;
        }
        if (sel.length == 0) {
            return null;
        }
        return sel[0];
    }

    public void setSingleSelection(HistoryEntry version) {
        for (int i = 0; i < this.getTable().getModel().getRowCount(); ++i) {
            if (!version.equals(this._model.getEntry(i))) continue;
            this.getTable().setSelectedRowsInModel(new int[]{i});
            return;
        }
    }

    public HistoryEntry[] getSelection() {
        if (this._table == null) {
            return new HistoryEntry[0];
        }
        int count = this._table.getSelectedRowCount();
        if (count == -1) {
            return new HistoryEntry[0];
        }
        HistoryEntry[] versions = new HistoryEntry[count];
        int[] selectedRows = this._table.getSelectedRowsInModel();
        for (int i = 0; i < count; ++i) {
            versions[i] = this._model.getEntry(selectedRows[i]);
        }
        return versions;
    }

    public void dispose() {
        this.removeAll();
        this._scrollPane = null;
        this._table = null;
        this.m_tableInitialized = false;
        this._model = null;
    }

    public void setEditorMode(boolean editorMode) {
        if (this._scrollPane != null && editorMode) {
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this._scrollPane.setPreferredSize(new Dimension(0, 0));
        }
    }

    private List<String> getPatterns() {
        if (this._model instanceof AbstractHistoryModel) {
            return ((AbstractHistoryModel)this._model).getPatterns();
        }
        return Collections.emptyList();
    }

    private class HistoryTable
    extends GenericTable {
        private HistoryTable() {
        }

        public String getToolTipText(MouseEvent event) {
            if (!this.isShowToolTips()) {
                return super.getToolTipText(event);
            }
            Point mousePos = event.getPoint();
            int column = this.columnAtPoint(mousePos);
            int row = this.rowAtPoint(mousePos);
            if (column == -1 || row == -1) {
                return super.getToolTipText(event);
            }
            int modelColumn = this.convertColumnIndexToModel(column);
            int modelRow = this.convertRowIndexToModel(row);
            Object o = this.getModel().getValueAt(modelRow, modelColumn);
            if (o == null) {
                return super.getToolTipText(event);
            }
            if (o instanceof Collection) {
                StringBuffer htmlBuffer = new StringBuffer();
                for (Object item : (Collection)o) {
                    if (htmlBuffer.length() > 0) {
                        htmlBuffer.append("<br>");
                    }
                    htmlBuffer.append(item.toString());
                }
                htmlBuffer.append("</html>");
                htmlBuffer.insert(0, "<html>");
                return htmlBuffer.toString();
            }
            if (o instanceof String && o.toString().trim().indexOf(10) >= 0) {
                StringBuffer htmlBuffer = new StringBuffer();
                BufferedReader br = new BufferedReader(new StringReader(o.toString()));
                try {
                    String s;
                    while ((s = br.readLine()) != null) {
                        if (htmlBuffer.length() > 0) {
                            htmlBuffer.append("<br>");
                        }
                        htmlBuffer.append(s);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                htmlBuffer.append("</html>");
                htmlBuffer.insert(0, "<html>");
                return htmlBuffer.toString();
            }
            return super.getToolTipText(event);
        }
    }

    private class CollectionCellRenderer
    extends DefaultTableCellRenderer {
        private CollectionCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Collection) {
                value = this.formatStringForRendering((Collection)value);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        private String formatStringForRendering(Collection c) {
            StringBuffer listBuffer = new StringBuffer();
            for (Object entry : c) {
                if (listBuffer.length() > 0) {
                    listBuffer.append(',');
                }
                listBuffer.append(entry.toString());
            }
            return listBuffer.toString();
        }
    }

    private static final class LiveDate
    extends Date {
        public LiveDate() {
            super(Long.MAX_VALUE);
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public String toLocaleString() {
            return this.toString();
        }

        @Override
        public String toGMTString() {
            return this.toString();
        }
    }

    private class DateCellRenderer
    extends DefaultTableCellRenderer {
        private DateCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Date) {
                if (value == LIVE_DATE) {
                    this.setText(value.toString());
                } else {
                    DateFormat df = DateFormat.getDateTimeInstance();
                    this.setText(df.format((Date)value));
                }
            }
            return c;
        }
    }

    private class StringCellRenderer
    extends DefaultTableCellRenderer {
        private StringCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            List<Pair<String, Boolean>> txt;
            if (value instanceof String) {
                value = this.formatStringForRendering(value.toString());
            }
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof String && !(txt = this.getTextFromPattern((String)value)).isEmpty()) {
                return this.setHyperlinkColumn((String)value, isSelected, label, txt);
            }
            return label;
        }

        private String formatStringForRendering(String s) {
            if (s.indexOf(10) < 0 && s.indexOf(13) < 0 && s.indexOf(12) < 0) {
                return s;
            }
            s = s.trim();
            StringBuffer singleLineMesageBuffer = new StringBuffer();
            BufferedReader br = new BufferedReader(new StringReader(s));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    if (singleLineMesageBuffer.length() > 0) {
                        singleLineMesageBuffer.append("\\ ");
                    }
                    singleLineMesageBuffer.append(line.trim());
                }
                return singleLineMesageBuffer.toString();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return s;
            }
        }

        private List<Pair<String, Boolean>> getTextFromPattern(String value) {
            ArrayList<Pair<String, Boolean>> str = new ArrayList<Pair<String, Boolean>>();
            for (int p = 0; p < HistoryComponent.this.getPatterns().size(); ++p) {
                Pair<String, Boolean> txt;
                Pattern pt = Pattern.compile((String)HistoryComponent.this.getPatterns().get(p));
                Matcher matcher = pt.matcher(value);
                int stpos = 0;
                while (matcher.find()) {
                    txt = new Pair<String, Boolean>();
                    txt.setFirst(value.substring(stpos, matcher.start()));
                    txt.setSecond(Boolean.FALSE);
                    str.add(txt);
                    txt = new Pair();
                    txt.setFirst(value.substring(matcher.start(), matcher.end()));
                    txt.setSecond(Boolean.TRUE);
                    str.add(txt);
                    stpos = matcher.end();
                }
                if (str.isEmpty()) continue;
                if (stpos < value.length()) {
                    txt = new Pair();
                    txt.setFirst(value.substring(stpos));
                    txt.setSecond(Boolean.FALSE);
                    str.add(txt);
                }
                return str;
            }
            return Collections.emptyList();
        }

        private Component setHyperlinkColumn(String value, boolean isSelected, JLabel label, List<Pair<String, Boolean>> txt) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setOpaque(true);
            Font font = label.getFont();
            for (int t = 0; t < txt.size(); ++t) {
                if (!txt.get(t).getSecond().booleanValue()) {
                    JLabel lbl = new JLabel(txt.get(t).getFirst());
                    panel.add((Component)lbl, new GridBagConstraints(t, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                    lbl.setFont(font);
                    if (!isSelected) continue;
                    lbl.setForeground(label.getForeground());
                    continue;
                }
                HyperlinkButton button = new HyperlinkButton(txt.get(t).getFirst());
                button.setAlwaysUnderlined(true);
                panel.add((Component)button, new GridBagConstraints(t, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                if (!isSelected) continue;
                button.setForeground(label.getForeground());
            }
            JLabel dummy = new JLabel();
            panel.add((Component)dummy, new GridBagConstraints(txt.size(), 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.setBorder(label.getBorder());
            return panel;
        }
    }
}

