/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.print;

import java.awt.Font;
import java.util.StringTokenizer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public class PrintOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "PrintingOptions";
    private static final String PRINT_FONT_STYLES = "print.text.font.style";
    private static final String WRAP_LONG_LINES = "print.text.wrap.long.lines";
    private static final String PRINT_LINE_NUMBERS = "print.text.line.numbers";
    private static final String PRINT_FILE_HEADER = "print.header";
    private static final String TEXT_FONT = "print.text.font";
    public static final Font DEFAULT_TEXT_FONT = new Font("Monospaced", 0, 12);
    private static final String COMMA = ",";

    public PrintOptions() {
        this(HashStructure.newInstance());
    }

    public PrintOptions(HashStructure hash) {
        super(hash);
    }

    public static PrintOptions getInstance(PropertyStorage prefs) {
        return new PrintOptions(PrintOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public Object clone() {
        return this.copyTo(null);
    }

    public boolean getPrintFontStyles() {
        return this._hash.getBoolean(PRINT_FONT_STYLES, true);
    }

    public void setPrintFontStyles(boolean printFontStyles) {
        this._hash.putBoolean(PRINT_FONT_STYLES, printFontStyles);
    }

    public boolean getWrapLongLines() {
        return this._hash.getBoolean(WRAP_LONG_LINES, false);
    }

    public void setWrapLongLines(boolean wrapBehavior) {
        this._hash.putBoolean(WRAP_LONG_LINES, wrapBehavior);
    }

    public boolean getPrintLineNumbers() {
        return this._hash.getBoolean(PRINT_LINE_NUMBERS, false);
    }

    public void setPrintLineNumbers(boolean printLineNumbers) {
        this._hash.putBoolean(PRINT_LINE_NUMBERS, printLineNumbers);
    }

    public boolean getPrintFileHeader() {
        return this._hash.getBoolean(PRINT_FILE_HEADER, true);
    }

    public void setPrintFileHeader(boolean printFileHeader) {
        this._hash.putBoolean(PRINT_FILE_HEADER, printFileHeader);
    }

    public String getWrapSymbol() {
        return "\\";
    }

    public String getFontFamily() {
        Font font = this.getFont(this._hash.getString(TEXT_FONT, null), DEFAULT_TEXT_FONT);
        return font.getFamily();
    }

    public int getFontSize() {
        Font font = this.getFont(this._hash.getString(TEXT_FONT, null), DEFAULT_TEXT_FONT);
        return font.getSize();
    }

    private Font getFont(String value, Font defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        StringTokenizer stk = new StringTokenizer(value, COMMA);
        String name = this.getString(stk);
        int style = this.integer(stk);
        int size = this.integer(stk);
        if (name == null || style == -1 || size == -1) {
            return defaultValue;
        }
        return new Font(name, style, size);
    }

    private int integer(StringTokenizer stk) {
        if (!stk.hasMoreTokens()) {
            return -1;
        }
        return this.getInt(stk.nextToken());
    }

    private int getInt(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private String getString(StringTokenizer stk) {
        if (!stk.hasMoreTokens()) {
            return null;
        }
        return stk.nextToken();
    }
}

