/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import javax.swing.event.DocumentEvent;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocumentEvent;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.HistoryReadTextBuffer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.LexerDocumentRenderer;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.java.JavaBlockRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

final class JavaDocumentRenderer
extends LexerDocumentRenderer
implements JavaTokens {
    JavaDocumentRenderer(LanguageSupport support) {
        super(support);
    }

    @Override
    protected BlockRenderer createBlockRenderer() {
        TextBuffer textBuffer = this.getTextBuffer();
        return new JavaBlockRenderer(textBuffer);
    }

    @Override
    protected Lexer createLexer() {
        JavaLexer lexer = new JavaLexer();
        lexer.setRecognizeSQLJ(true);
        return lexer;
    }

    @Override
    public boolean isMultiLineToken(int token) {
        switch (token) {
            case 6: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void calculateDamage(DocumentEvent changes, NumberRange damageRange) {
        int adjustedBeforeTokenLength;
        int token;
        int token2;
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = this.getLineMap();
        int lineCount = lineMap.getLineCount();
        boolean isInsert = changes.getType() == DocumentEvent.EventType.INSERT;
        int changedLength = changes.getLength();
        int changedStart = changes.getOffset();
        int afterChangeEnd = isInsert ? changedLength + changedStart : changedStart;
        int beforeChangeEnd = isInsert ? changedStart : changedLength + changedStart;
        int changedLine = lineMap.getLineFromOffset(changedStart);
        Lexer lexer = this.getLexer();
        LexerToken lexerToken = this.getLexerToken();
        int lexerStartOffset = this.getOffsetsCache().findClosestOffset(lexer, lexerToken, changedStart);
        int afterTokenStart = -1;
        int afterTokenLength = -1;
        int afterToken = 0;
        lexer.setTextBuffer((ReadTextBuffer)textBuffer);
        lexer.setPosition(lexerStartOffset);
        while ((token2 = lexer.lex(lexerToken)) != 0) {
            int tokenStart = lexerToken.getStartOffset();
            int tokenEnd = lexerToken.getEndOffset();
            if (tokenEnd <= afterChangeEnd) continue;
            if (tokenStart >= changedStart) break;
            afterTokenStart = tokenStart;
            afterTokenLength = tokenEnd - tokenStart;
            afterToken = token2;
            break;
        }
        lexer.setTextBuffer(null);
        if (afterToken != 25 && afterToken != 26 && afterToken != 6) {
            super.calculateDamage(changes, damageRange);
            return;
        }
        int beforeTokenStart = -1;
        int beforeTokenLength = -1;
        int beforeToken = 0;
        HistoryReadTextBuffer historyBuffer = HistoryReadTextBuffer.acquireReadTextBuffer((ReadTextBuffer)textBuffer, (BasicDocumentEvent)changes);
        lexer.setTextBuffer((ReadTextBuffer)historyBuffer);
        lexer.setPosition(lexerStartOffset);
        while ((token = lexer.lex(lexerToken)) != 0) {
            int tokenStart = lexerToken.getStartOffset();
            int tokenEnd = lexerToken.getEndOffset();
            if (tokenEnd <= beforeChangeEnd) continue;
            if (tokenStart >= changedStart) break;
            beforeTokenStart = tokenStart;
            beforeTokenLength = tokenEnd - tokenStart;
            beforeToken = token;
            break;
        }
        lexer.setTextBuffer(null);
        HistoryReadTextBuffer.releaseReadTextBuffer(historyBuffer);
        int n = adjustedBeforeTokenLength = isInsert ? beforeTokenLength + changedLength : beforeTokenLength - changedLength;
        if (beforeTokenStart != afterTokenStart || adjustedBeforeTokenLength != afterTokenLength || beforeToken != afterToken) {
            super.calculateDamage(changes, damageRange);
            return;
        }
        if (afterToken == 25 || afterToken == 6) {
            damageRange.start = changedLine;
            damageRange.end = changedLine;
            return;
        }
        boolean hasTag = false;
        char[] changedData = ((BasicDocumentEvent)changes).getData();
        for (int i = 0; i < changedLength; ++i) {
            if (changedData[i] != '@') continue;
            hasTag = true;
            break;
        }
        if (hasTag) {
            int docEnd = afterTokenStart + afterTokenLength;
            int docEndLine = lineMap.getLineFromOffset(docEnd);
            damageRange.start = changedLine;
            damageRange.end = docEndLine;
        } else {
            damageRange.start = changedLine;
            damageRange.end = changedLine;
        }
    }
}

