/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.find;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.swing.text.BadLocationException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.find.Find;
import oracle.javatools.editor.find.FindBundle;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.find.FindResult;
import oracle.javatools.editor.find.Finder;
import oracle.javatools.editor.find.ReplaceCriteria;
import oracle.javatools.editor.find.ReplacePrompt;
import oracle.javatools.editor.find.ReplaceResult;
import oracle.javatools.editor.find.Replacer;

public final class PromptedReplacer
implements ActionListener {
    private final BasicEditorPane editor;
    private final FindCriteria findCriteria;
    private final ReplaceCriteria replaceCriteria;
    private final List<Find> finds;
    private Find find;
    private int offsetAdjustment = 0;
    private int skipped = 0;
    private int replaced = 0;
    private int total = 0;

    public PromptedReplacer(BasicEditorPane editor, FindCriteria findCriteria, ReplaceCriteria replaceCriteria) {
        this.editor = editor;
        this.replaceCriteria = replaceCriteria;
        this.findCriteria = findCriteria;
        FindResult findResult = Finder.find(editor, findCriteria);
        List<Find> allFinds = findResult == null ? null : findResult.getFinds();
        Find find = this.find = findResult == null ? null : findResult.getFind();
        if (allFinds != null) {
            this.finds = new ArrayList<Find>(allFinds.size());
            if (this.find == null) {
                if (findCriteria.isWrap() && allFinds.size() > 0) {
                    this.finds.addAll(allFinds);
                    this.find = this.finds.get(0);
                }
            } else {
                int index;
                int i;
                for (i = index = allFinds.indexOf(this.find); i < allFinds.size(); ++i) {
                    this.finds.add(allFinds.get(i));
                }
                if (findCriteria.isWrap()) {
                    for (i = 0; i < index; ++i) {
                        this.finds.add(allFinds.get(i));
                    }
                }
            }
        } else {
            this.finds = Collections.emptyList();
        }
    }

    public ReplaceResult start() {
        if (this.find != null) {
            this.total = this.finds.size();
            this.prompt(this.find);
            return new ReplaceResult(ReplaceResult.State.PROMPTED);
        }
        Toolkit.getDefaultToolkit().beep();
        return new ReplaceResult(ReplaceResult.State.NOT_FOUND);
    }

    private void prompt(Find currentFind) {
        ReplacePrompt prompt = new ReplacePrompt(this.editor, currentFind, this.offsetAdjustment);
        prompt.addActionListener(this);
        prompt.setFeedback(FindBundle.format("FEEDBACK_REPLACE_PROMPT", this.total, this.replaced, this.skipped));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        ReplacePrompt prompt = (ReplacePrompt)e.getSource();
        prompt.removeActionListener(this);
        Find find = prompt.getFind();
        boolean replaceDone = false;
        if (e.getActionCommand() == "YES") {
            if (!this.editor.makeEditable()) {
                Toolkit.getDefaultToolkit().beep();
                Finder.clearHighlights(this.editor);
                return;
            }
            boolean replaceOK = false;
            this.editor.beginEdit(Replacer.replaceDescriptor);
            try {
                replaceOK = this.replaceOccurence(this.editor, this.replaceCriteria, find, true) == ReplaceResult.State.DONE;
            }
            finally {
                this.editor.endEdit();
            }
            if (!replaceOK) {
                Finder.clearHighlights(this.editor);
                return;
            }
            replaceDone = true;
            ++this.replaced;
        } else {
            if (e.getActionCommand() == "GLOBAL") {
                FeedbackManager feedbackManager;
                if (!this.editor.makeEditable()) {
                    Toolkit.getDefaultToolkit().beep();
                    Finder.clearHighlights(this.editor);
                    return;
                }
                this.editor.beginEdit(Replacer.replaceAllDescriptor);
                try {
                    int index = this.finds.indexOf(find);
                    ListIterator<Find> li = this.finds.listIterator(index);
                    while (li.hasNext()) {
                        ReplaceResult.State state;
                        Find next = li.next();
                        if (next.getStartOffset() < find.getStartOffset()) {
                            this.offsetAdjustment = 0;
                        }
                        if ((state = this.replaceOccurence(this.editor, this.replaceCriteria, next, false)) != ReplaceResult.State.DONE) {
                            break;
                        }
                        ++this.replaced;
                        find = next;
                    }
                }
                finally {
                    this.editor.endEdit();
                }
                if ((feedbackManager = this.editor.getFeedbackManager()) != null) {
                    feedbackManager.showFeedback(this.editor, FindBundle.format("FEEDBACK_REPLACE_STATUS", this.replaced), 10000);
                }
                Finder.clearHighlights(this.editor);
                return;
            }
            if (e.getActionCommand() == "NO") {
                replaceDone = false;
                ++this.skipped;
            } else {
                if (this.findCriteria.isHighlight()) {
                    Finder.clearHighlights(this.editor);
                }
                return;
            }
        }
        int index = this.finds.indexOf(find);
        if (this.finds.size() > index + 1) {
            Find next = this.finds.get(index + 1);
            if (next.getStartOffset() < find.getStartOffset()) {
                this.offsetAdjustment = 0;
            }
            this.prompt(next);
        } else {
            FeedbackManager feedbackManager = this.editor.getFeedbackManager();
            if (feedbackManager != null) {
                feedbackManager.showFeedback(this.editor, FindBundle.format("FEEDBACK_REPLACE_STATUS", this.replaced), 10000);
            }
            Finder.clearHighlights(this.editor);
        }
    }

    private ReplaceResult.State replaceOccurence(BasicEditorPane editor, ReplaceCriteria criteria, Find find, boolean select) {
        try {
            int start = find.getStartOffset() + this.offsetAdjustment;
            int length = find.getEndOffset() - find.getStartOffset();
            String foundText = editor.getText(start, length);
            String replaceText = Replacer.getReplaceText(criteria, null, find, foundText);
            editor.remove(start, length);
            editor.insertString(start, replaceText, null);
            if (select) {
                editor.select(start, start + replaceText.length());
            }
            this.offsetAdjustment += replaceText.length() - foundText.length();
            return ReplaceResult.State.DONE;
        }
        catch (BadLocationException e) {
            return ReplaceResult.State.ERROR;
        }
    }
}

