/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.VariableLengthIntArrayFactory;

public class DeltaCodedIntArrayFactory
extends ObjectFactory {
    public static final DeltaCodedIntArrayFactory DELTA_CODED_INT_ARRAY_FACTORY = new DeltaCodedIntArrayFactory();
    private static final byte OBJECT_CODE = -117;

    private DeltaCodedIntArrayFactory() {
    }

    @Override
    public byte getObjectCode() {
        return -117;
    }

    @Override
    public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
        int len = VariableLengthIntArrayFactory.readVariableLengthInt(input);
        int[] array = new int[len];
        int lastValue = 0;
        for (int i = 0; i < len; ++i) {
            array[i] = lastValue + VariableLengthIntArrayFactory.readVariableLengthInt(input);
            lastValue = array[i];
        }
        return array;
    }

    @Override
    public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
        int[] array = (int[])object;
        int len = array.length;
        int lastValue = 0;
        VariableLengthIntArrayFactory.writeVariableLengthInt(output, len);
        for (int i = 0; i < len; ++i) {
            VariableLengthIntArrayFactory.writeVariableLengthInt(output, array[i] - lastValue);
            lastValue = array[i];
        }
    }
}

