/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.J3D_Geometry;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.GeometryExceptionWithContext;
import oracle.spatial.util.Logger;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GML3g {
    private static final String GML_POS_ELEMENT = "pos";
    public static final String GML_POS_LIST_ELEMENT = "posList";
    private static final String GML_CS_ATTRIBUTE = "cs";
    private static final String GML_CS_ATTRIBUTE_DEFAULT_VALUE = ",";
    private static final String GML_TS_ATTRIBUTE = "ts";
    private static final String GML_TS_ATTRIBUTE_DEFAULT_VALUE = " ";
    private static final String GML_DECIMAL_ATTRIBUTE = "decimal";
    private static final String GML_DECIMAL_ATTRIBUTE_DEFAULT_VALUE = ".";
    private static final String DECIMAL_SEPARATOR = ".";
    public static final String GML_SRS_DIMENSION_ATTRIBUTE = "srsDimension";
    public static final String GML_COORDINATES_ELEMENT = "coordinates";
    public static final String GML_COORD_ELEMENT = "coord";
    public static final String GML_LOWER_CORNER_ELEMENT = "lowerCorner";
    public static final String GML_UPPER_CORNER_ELEMENT = "upperCorner";
    public static final String GML_X = "X";
    public static final String GML_Y = "Y";
    public static final String GML_Z = "Z";
    private static final String GML_DOUBLE_LIST_SEPARATOR = "\\s+";
    protected static Connection _conn;
    protected static String _srsNameSpace;
    private static Logger logger;
    protected static final Set gmlTypes;

    public static void setConnection(Connection connection) {
        _conn = connection;
    }

    public static void setsrsNameSpace(String string) {
        _srsNameSpace = string;
    }

    public static String getNameSpace() {
        return _srsNameSpace;
    }

    private static double[] asDoubleArray(List<Double> list) {
        double[] dArray = new double[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            dArray[i] = list.get(i);
        }
        return dArray;
    }

    private static double[] readDoubleList(Node node) {
        if (node == null) {
            return null;
        }
        String[] stringArray = node.getFirstChild().getNodeValue().trim().split(GML_DOUBLE_LIST_SEPARATOR);
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = Double.parseDouble(stringArray[i]);
        }
        return dArray;
    }

    private static void copyDoubleValues(List<Double> list, double[] dArray) {
        for (double d : dArray) {
            list.add(d);
        }
    }

    private static final double[] getOrdinatesFromNode(Node node) {
        if (node == null || node.getFirstChild() == null) {
            return new double[0];
        }
        Node node2 = node.getFirstChild();
        do {
            if (node2.getNodeType() == 3) continue;
            String string = node2.getLocalName();
            if (GML_POS_ELEMENT.equalsIgnoreCase(string)) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                GML3g.copyDoubleValues(arrayList, GML3g.readDoubleList(node2));
                while (node2.getNextSibling() != null) {
                    string = (node2 = node2.getNextSibling()).getLocalName();
                    if (!GML_POS_ELEMENT.equalsIgnoreCase(string)) continue;
                    GML3g.copyDoubleValues(arrayList, GML3g.readDoubleList(node2));
                }
                return GML3g.asDoubleArray(arrayList);
            }
            if (GML_POS_LIST_ELEMENT.equalsIgnoreCase(string)) {
                return GML3g.readDoubleList(node2);
            }
            if (GML_LOWER_CORNER_ELEMENT.equalsIgnoreCase(string)) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                GML3g.copyDoubleValues(arrayList, GML3g.readDoubleList(node2));
                while (node2.getNextSibling() != null) {
                    string = (node2 = node2.getNextSibling()).getLocalName();
                    if (!GML_UPPER_CORNER_ELEMENT.equalsIgnoreCase(string)) continue;
                    GML3g.copyDoubleValues(arrayList, GML3g.readDoubleList(node2));
                }
                return GML3g.asDoubleArray(arrayList);
            }
            if (GML_COORDINATES_ELEMENT.equalsIgnoreCase(string)) {
                String string2 = GML3g.getAttributeOrDefault(node2, GML_TS_ATTRIBUTE, GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                String string3 = GML3g.getAttributeOrDefault(node2, GML_CS_ATTRIBUTE, GML_CS_ATTRIBUTE_DEFAULT_VALUE);
                String string4 = GML3g.getAttributeOrDefault(node2, GML_DECIMAL_ATTRIBUTE, ".");
                String string5 = node2.getFirstChild().getNodeValue().trim();
                ArrayList<Double> arrayList = new ArrayList<Double>();
                for (String string6 : string5.split(Pattern.quote(string2))) {
                    for (String string7 : string6.split(Pattern.quote(string3))) {
                        if (!string4.equals(".")) {
                            string7 = string7.replace(string4, ".");
                        }
                        arrayList.add(Double.parseDouble(string7));
                    }
                }
                return GML3g.asDoubleArray(arrayList);
            }
            if (!GML_COORD_ELEMENT.equalsIgnoreCase(string)) continue;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            GML3g.readXYZCoord(node2, arrayList);
            while (node2.getNextSibling() != null) {
                string = (node2 = node2.getNextSibling()).getLocalName();
                if (!GML_COORD_ELEMENT.equalsIgnoreCase(string)) continue;
                GML3g.readXYZCoord(node2, arrayList);
            }
            return GML3g.asDoubleArray(arrayList);
        } while ((node2 = node2.getNextSibling()) != null);
        return new double[0];
    }

    private static final int getSRIDFromNode(Node node) throws DataException, Exception {
        int n;
        block14: {
            XMLElement xMLElement = (XMLElement)node;
            String string = xMLElement.getAttribute("srsName");
            n = 0;
            String string2 = ((XMLElement)node).getAttribute("srsName");
            String string3 = GML3g.normalize(string2);
            String string4 = null;
            try {
                string4 = string2.substring(0, string2.indexOf(":"));
            }
            catch (Exception exception) {
                n = 0;
            }
            if (string4 == null) {
                return n;
            }
            if (string4.equalsIgnoreCase("SDO") || string4.equalsIgnoreCase("EPSG") || string4.equalsIgnoreCase("URN")) {
                try {
                    n = Integer.parseInt(string3);
                    break block14;
                }
                catch (Exception exception) {
                    try {
                        String string5 = string3.substring(string3.indexOf("EPSG"));
                        while (string5.indexOf(":") != -1) {
                            if ((string5 = string5.substring(string5.indexOf(":") + 1)).indexOf(":") != -1) continue;
                            n = Integer.valueOf(string5);
                        }
                        break block14;
                    }
                    catch (Exception exception2) {
                        if (string4.equalsIgnoreCase("SDO")) {
                            n = 0;
                            break block14;
                        }
                        throw new Exception("Invalid srsName for the Geometry Element");
                    }
                }
            }
            if (_conn == null || _srsNameSpace == null) {
                throw new DataException("GML Converter needs a valid connection and SrsNameSpace" + _srsNameSpace);
            }
            String string6 = " select sdo_srid   from MDSYS.SrsNameSpace_Table  where  SrsNameSpace = ? and SrsName = ? ";
            PreparedStatement preparedStatement = _conn.prepareStatement(string6);
            preparedStatement.setString(1, _srsNameSpace);
            preparedStatement.setString(2, string3);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new DataException("GML has unregistered SrsNameSpace/SrsName");
            }
            n = resultSet.getInt("sdo_srid");
        }
        return n;
    }

    private static Node getAttribute(Node node, String string, boolean bl) {
        if (node == null || string == null || string.length() == 0) {
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (bl) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                if (!string.equalsIgnoreCase(node2.getNodeName())) continue;
                return node2;
            }
            return null;
        }
        return namedNodeMap.getNamedItem(string);
    }

    private static final String getAttributeOrDefault(Node node, String string, String string2) {
        String string3 = null;
        Node node2 = null;
        node2 = GML3g.getAttribute(node, string, true);
        if (node2 != null) {
            string3 = node2.getNodeValue().trim();
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        return string3;
    }

    private static void readXYZCoord(Node node, List<Double> list) {
        if (list == null || node == null || node.getFirstChild() == null) {
            return;
        }
        Node node2 = node.getFirstChild();
        do {
            String string;
            if (!GML_X.equalsIgnoreCase(string = node2.getLocalName()) && !GML_Y.equalsIgnoreCase(string) && !GML_Z.equalsIgnoreCase(string)) continue;
            list.add(Double.parseDouble(node2.getFirstChild().getNodeValue().trim()));
        } while ((node2 = node2.getNextSibling()) != null);
    }

    private static final int guessDimensionality(Node node) {
        if (node == null || node.getFirstChild() == null) {
            return 0;
        }
        Node node2 = node.getFirstChild();
        do {
            if (node2.getNodeType() == 3) continue;
            String string = node2.getLocalName();
            if (GML_POS_LIST_ELEMENT.equalsIgnoreCase(string) || GML_POS_ELEMENT.equalsIgnoreCase(string)) {
                String string2;
                int n;
                Node node3 = GML3g.getAttribute(node2, GML_SRS_DIMENSION_ATTRIBUTE, true);
                if (node3 != null) {
                    try {
                        return Integer.parseInt(node3.getNodeValue().trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((n = (string2 = node2.getFirstChild().getNodeValue().trim()).trim().split(GML_DOUBLE_LIST_SEPARATOR).length) > 3) {
                    n = 2;
                }
                return n;
            }
            if (GML_COORDINATES_ELEMENT.equalsIgnoreCase(string)) {
                String string3 = GML3g.getAttributeOrDefault(node2, GML_TS_ATTRIBUTE, GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                String string4 = GML3g.getAttributeOrDefault(node2, GML_CS_ATTRIBUTE, GML_CS_ATTRIBUTE_DEFAULT_VALUE);
                String string5 = node2.getFirstChild().getNodeValue().trim();
                int n = string5.indexOf(string3);
                if (n != -1) {
                    string5 = string5.substring(0, n);
                }
                return string5.split(string4).length;
            }
            if (!GML_COORD_ELEMENT.equalsIgnoreCase(string)) continue;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            GML3g.readXYZCoord(node2, arrayList);
            return arrayList.size();
        } while ((node2 = node2.getNextSibling()) != null);
        return 0;
    }

    public static JGeometry fromNodeToPoint(Node node) throws DataException, Exception {
        int n = 0;
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        n = GML3g.getSRIDFromNode(node);
        double[] dArray = GML3g.getOrdinatesFromNode(node);
        if (dArray.length == 2) {
            return new JGeometry(dArray[0], dArray[1], n);
        }
        if (dArray.length == 3) {
            return new JGeometry(dArray[0], dArray[1], dArray[2], n);
        }
        return null;
    }

    public static final JGeometry fromNodeToEnvelope(Node node) throws DataException, Exception {
        int n = GML3g.getSRIDFromNode(node);
        double[] dArray = GML3g.getOrdinatesFromNode(node);
        if (dArray.length == 4) {
            return new JGeometry(Math.min(dArray[0], dArray[2]), Math.min(dArray[1], dArray[3]), Math.max(dArray[0], dArray[2]), Math.max(dArray[1], dArray[3]), n);
        }
        if (dArray.length == 6) {
            int[] nArray = new int[3];
            double[] dArray2 = new double[]{Math.min(dArray[0], dArray[3]), Math.min(dArray[1], dArray[4]), Math.min(dArray[2], dArray[5]), Math.max(dArray[0], dArray[3]), Math.max(dArray[1], dArray[4]), Math.max(dArray[2], dArray[5])};
            if (Math.abs(dArray[0] - dArray[3]) < 1.0E-16 || Math.abs(dArray[1] - dArray[4]) < 1.0E-16 || Math.abs(dArray[2] - dArray[5]) < 1.0E-16) {
                nArray[0] = 1;
                nArray[1] = 1003;
                nArray[2] = 3;
                return new JGeometry(3003, n, nArray, dArray2);
            }
            nArray[0] = 1;
            nArray[1] = 1007;
            nArray[2] = 3;
            return new JGeometry(3008, n, nArray, dArray2);
        }
        throw new DataException("13357");
    }

    public static JGeometry fromNodeToLineString(Node node) throws DataException, Exception {
        int n = GML3g.getSRIDFromNode(node);
        int n2 = GML3g.guessDimensionality(node);
        double[] dArray = GML3g.getOrdinatesFromNode(node);
        return JGeometry.createLinearLineString((double[])dArray, (int)n2, (int)n);
    }

    public static JGeometry fromNodeToCurve(Node node) throws DataException, Exception {
        int n = GML3g.getSRIDFromNode(node);
        Node node2 = GML3g.getFirst(node, new String[]{"segments", "LineStringSegment"});
        Node node3 = GML3g.getFirst(node, new String[]{"segments", "Arc"});
        Node node4 = GML3g.getFirst(node, new String[]{"segments", "BSplineType"});
        if (node2 != null) {
            int n2 = GML3g.guessDimensionality(node2);
            double[] dArray = GML3g.getOrdinatesFromNode(node2);
            return JGeometry.createLinearLineString((double[])dArray, (int)n2, (int)n);
        }
        if (node3 != null) {
            int n3 = GML3g.guessDimensionality(node3);
            double[] dArray = GML3g.getOrdinatesFromNode(node3);
            return JGeometry.createArc2d((double[])dArray, (int)n3, (int)n);
        }
        if (node4 != null) {
            int n4;
            Object object;
            Node node5;
            Vector<Double> vector = new Vector<Double>();
            int n5 = 0;
            int n6 = 0;
            int n7 = GML3g.guessDimensionality(node4);
            Node node6 = GML3g.getFirst(node4, new String[]{"degree"});
            vector.add(Double.valueOf(node6.getFirstChild().getNodeValue()));
            for (Node node7 = GML3g.getFirst(node4, new String[]{GML_POS_LIST_ELEMENT, "controlpoint"}); node7 != null; node7 = node7.getNextSibling()) {
                node5 = GML3g.getFirst(node7, new String[]{"weightedpoint"});
                GML3g.addDoubleCoords(vector, node5.getFirstChild().getNodeValue());
                object = GML3g.getFirst(node7, new String[]{"weight"});
                GML3g.addDoubleCoords(vector, object.getFirstChild().getNodeValue());
                ++n5;
            }
            vector.add(1, Double.valueOf(n5));
            node5 = GML3g.getFirst(node4, new String[]{"knot"});
            Node node8 = GML3g.getFirst(node5, new String[]{"value"});
            while (node8 != null) {
                object = node8.getNextSibling();
                n4 = Integer.valueOf(object.getFirstChild().getNodeValue());
                n6 += n4;
                for (int i = 0; i < n4; ++i) {
                    vector.add(Double.valueOf(node8.getFirstChild().getNodeValue()));
                }
                node8 = object.getNextSibling();
            }
            vector.add(vector.size() - n6, Double.valueOf(n6));
            object = new double[vector.size()];
            for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                object[n4] = (Double)vector.get(n4);
            }
            return JGeometry.createNURBScurve((double[])object, (int)n7, (int)n);
        }
        throw new DataException("Invalid Curve");
    }

    public static JGeometry fromNodeToPolygon(Node node) throws DataException, Exception {
        int n;
        String string;
        Object object;
        Object object2;
        Node node2;
        Node node3;
        Node node4;
        Object object3;
        int n2;
        int n3 = 0;
        Vector vector = GML3g.getAll(node, new String[]{"exterior"});
        Vector vector2 = GML3g.getAll(node, new String[]{"interior"});
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Node node5 = GML3g.getFirst(node, new String[]{"exterior", "LinearRing"});
        Node node6 = GML3g.getFirst(node, new String[]{"exterior", "Circle"});
        Node node7 = GML3g.getFirst(node, new String[]{"exterior", "Ring", "curveMember", "Curve", "segments", "LineStringSegment"});
        Node node8 = GML3g.getFirst(node, new String[]{"exterior", "Ring", "curveMember", "Curve", "segments", "Arc"});
        if (node5 != null) {
            n3 = GML3g.guessDimensionality(node5);
        } else if (node6 != null) {
            n3 = GML3g.guessDimensionality(node6);
        } else if (node7 != null) {
            n3 = GML3g.guessDimensionality(node7);
        } else if (node8 != null) {
            n3 = GML3g.guessDimensionality(node8);
        } else {
            throw new DataException("Invalid Polygon");
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object3 = (Node)vector.get(n2);
            node4 = GML3g.getFirst((Node)object3, new String[]{"LinearRing"});
            node3 = GML3g.getFirst((Node)object3, new String[]{"Circle"});
            node2 = GML3g.getFirst((Node)object3, new String[]{"Ring"});
            if (node4 != null) {
                object2 = GML3g.getOrdinatesFromNode(node4);
                object = new int[3];
                object = ((double[])object2).length > n3 * 2 ? new int[]{1, 1003, 1} : new int[]{1, 1003, 3};
                string = "";
                for (int i = 0; i < ((int[])object).length; ++i) {
                    string = i % 3 == 0 ? string.concat(String.valueOf((int)(object[i] + vector4.size()))).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE) : string.concat(String.valueOf((int)object[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector3, string);
                String string2 = "";
                for (n = 0; n < ((double[])object2).length; ++n) {
                    string2 = string2.concat(String.valueOf(object2[n])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector4, string2);
                continue;
            }
            if (node3 != null) {
                object2 = GML3g.getOrdinatesFromNode(node3);
                object = new int[3];
                object = new int[]{1, 1003, 4};
                string = "";
                for (int i = 0; i < ((int[])object).length; ++i) {
                    string = i % 3 == 0 ? string.concat(String.valueOf((int)(object[i] + vector4.size()))).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE) : string.concat(String.valueOf((int)object[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector3, string);
                String string3 = "";
                for (n = 0; n < ((double[])object2).length; ++n) {
                    string3 = string3.concat(String.valueOf(object2[n])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector4, string3);
                continue;
            }
            if (node2 != null) {
                object2 = null;
                object2 = GML3g.fromNodeToCompositeCurve(node2);
                object2.getElemInfo()[1] = 1005;
                object = "";
                for (int i = 0; i < object2.getElemInfo().length; ++i) {
                    object = i % 3 == 0 ? object.concat(String.valueOf(object2.getElemInfo()[i] + vector4.size())).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE) : object.concat(String.valueOf(object2.getElemInfo()[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector3, (String)object);
                string = "";
                for (int i = 0; i < object2.getOrdinatesArray().length; ++i) {
                    string = string.concat(String.valueOf(object2.getOrdinatesArray()[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector4, string);
                continue;
            }
            throw new DataException("Invalid Polygon");
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            object3 = (Node)vector2.get(n2);
            node4 = GML3g.getFirst((Node)object3, new String[]{"LinearRing"});
            node3 = GML3g.getFirst((Node)object3, new String[]{"Circle"});
            node2 = GML3g.getFirst((Node)object3, new String[]{"Ring"});
            if (node4 != null) {
                object2 = GML3g.getOrdinatesFromNode(node4);
                object = new int[3];
                object = ((double[])object2).length > n3 * 2 ? new int[]{1, 2003, 1} : new int[]{1, 2003, 3};
                string = "";
                for (int i = 0; i < ((Object)object).length; ++i) {
                    string = i % 3 == 0 ? string.concat(String.valueOf((int)(object[i] + vector4.size()))).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE) : string.concat(String.valueOf((int)object[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector3, string);
                String string4 = "";
                for (n = 0; n < ((double[])object2).length; ++n) {
                    string4 = string4.concat(String.valueOf(object2[n])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector4, string4);
                continue;
            }
            if (node3 != null) {
                object2 = GML3g.getOrdinatesFromNode(node3);
                object = new int[3];
                object = new int[]{1, 2003, 4};
                string = "";
                for (int i = 0; i < ((Object)object).length; ++i) {
                    string = i % 3 == 0 ? string.concat(String.valueOf((int)(object[i] + vector4.size()))).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE) : string.concat(String.valueOf((int)object[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector3, string);
                String string5 = "";
                for (n = 0; n < ((double[])object2).length; ++n) {
                    string5 = string5.concat(String.valueOf(object2[n])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector4, string5);
                continue;
            }
            if (node2 != null) {
                object2 = null;
                object2 = GML3g.fromNodeToCompositeCurve(node2);
                object2.getElemInfo()[1] = 2005;
                object = "";
                for (int i = 0; i < object2.getElemInfo().length; ++i) {
                    object = i % 3 == 0 ? object.concat(String.valueOf(object2.getElemInfo()[i] + vector4.size())).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE) : object.concat(String.valueOf(object2.getElemInfo()[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector3, (String)object);
                string = "";
                for (int i = 0; i < object2.getOrdinatesArray().length; ++i) {
                    string = string.concat(String.valueOf(object2.getOrdinatesArray()[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector4, string);
                continue;
            }
            throw new DataException("Invalid Polygon");
        }
        n2 = GML3g.getSRIDFromNode(node);
        object3 = new int[vector3.size()];
        for (int i = 0; i < ((Object)object3).length; ++i) {
            object3[i] = Integer.parseInt((String)vector3.get(i));
        }
        double[] dArray = new double[vector4.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector4.get(i));
        }
        return new JGeometry(n3 * 1000 + 3, n2, (int[])object3, dArray);
    }

    public static JGeometry fromNodeToSurface(Node node) throws DataException, Exception {
        return GML3g.fromNodeToPolygon(node);
    }

    public static JGeometry fromNodeToMultiCurve(Node node) throws DataException, Exception {
        int n;
        Node node2;
        Object object;
        int n2 = 0;
        Vector vector = GML3g.getAll(node, new String[]{"curveMember"});
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Node node3 = GML3g.getFirst(node, new String[]{"curveMember", "CompositeCurve", "curveMember", "Curve", "segments", "LineStringSegment"});
        Node node4 = GML3g.getFirst(node, new String[]{"curveMember", "CompositeCurve", "curveMember", "Curve", "segments", "Arc"});
        if (node3 != null || node4 != null) {
            n2 = node3 != null ? GML3g.guessDimensionality(node3) : GML3g.guessDimensionality(node4);
        } else {
            Node node5 = GML3g.getFirst(node, new String[]{"curveMember", "Curve", "segments", "LineStringSegment"});
            object = GML3g.getFirst(node, new String[]{"curveMember", "Curve", "segments", "Arc"});
            node2 = GML3g.getFirst(node, new String[]{"curveMember", "LineString"});
            n2 = node5 != null ? GML3g.guessDimensionality(node5) : (node2 != null ? GML3g.guessDimensionality(node2) : GML3g.guessDimensionality((Node)object));
        }
        for (n = 0; n < vector.size(); ++n) {
            object = (Node)vector.get(n);
            node2 = GML3g.getFirst((Node)object, new String[]{"CompositeCurve"});
            Node node6 = GML3g.getFirst((Node)object, new String[]{"Curve"});
            Node node7 = GML3g.getFirst((Node)object, new String[]{"LineString"});
            JGeometry jGeometry = null;
            if (node2 != null) {
                jGeometry = GML3g.fromNodeToGeometry(node2);
            } else if (node6 != null) {
                jGeometry = GML3g.fromNodeToGeometry(node6);
            } else if (node7 != null) {
                jGeometry = GML3g.fromNodeToGeometry(node7);
            } else {
                throw new Exception("Invalid Curve");
            }
            String string = "";
            for (int i = 0; i < jGeometry.getElemInfo().length; ++i) {
                string = i % 3 == 0 ? string.concat(String.valueOf(jGeometry.getElemInfo()[i] + vector3.size())).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE) : string.concat(String.valueOf(jGeometry.getElemInfo()[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
            }
            GML3g.addCoords(vector2, string);
            String string2 = "";
            for (int i = 0; i < jGeometry.getOrdinatesArray().length; ++i) {
                string2 = string2.concat(String.valueOf(jGeometry.getOrdinatesArray()[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
            }
            GML3g.addCoords(vector3, string2);
        }
        n = GML3g.getSRIDFromNode(node);
        object = new int[vector2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = Integer.parseInt((String)vector2.get(i));
        }
        double[] dArray = new double[vector3.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector3.get(i));
        }
        return new JGeometry(n2 * 1000 + 6, n, (int[])object, dArray);
    }

    public static JGeometry fromNodeToMultiPoint(Node node) throws DataException, Exception {
        int n = GML3g.getSRIDFromNode(node);
        int n2 = GML3g.guessDimensionality(GML3g.getFirst(node, new String[]{"pointMember", "Point"}));
        Vector vector = GML3g.getAll(node, new String[]{"pointMember", "Point"});
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = GML3g.getOrdinatesFromNode((Node)vector.get(i));
            objectArray[i] = dArray;
        }
        return JGeometry.createMultiPoint((Object[])objectArray, (int)n2, (int)n);
    }

    public static JGeometry fromNodeToGeometry(Node node) throws DataException, Exception {
        String string = GML3g.normalize(node.getNodeName());
        if (string.equals("Point")) {
            return GML3g.fromNodeToPoint(node);
        }
        if (string.equals("LineString")) {
            return GML3g.fromNodeToLineString(node);
        }
        if (string.equals("Curve")) {
            return GML3g.fromNodeToCurve(node);
        }
        if (string.equals("CompositeCurve")) {
            return GML3g.fromNodeToCompositeCurve(node);
        }
        if (string.equals("Polygon")) {
            return GML3g.fromNodeToPolygon(node);
        }
        if (string.equals("Surface")) {
            return GML3g.fromNodeToSurface(node);
        }
        if (string.equals("CompositeSurface")) {
            return GML3g.fromNodeToCompositeSurface(node);
        }
        if (string.equals("MultiGeometry")) {
            return GML3g.fromNodeToGeometryCollection(node);
        }
        if (string.equals("MultiPoint")) {
            return GML3g.fromNodeToMultiPoint(node);
        }
        if (string.equals("MultiCurve")) {
            return GML3g.fromNodeToMultiCurve(node);
        }
        if (string.equals("MultiPolygon")) {
            return GML3g.fromNodeToMultiSurface(node);
        }
        if (string.equals("MultiSurface")) {
            return GML3g.fromNodeToMultiSurface(node);
        }
        if (string.equals("Envelope")) {
            return GML3g.fromNodeToEnvelope(node);
        }
        if (string.equals("LinearRing")) {
            return GML3g.fromNodeToLinearRing(node);
        }
        if (string.equals("Solid")) {
            return GML3g.fromNodeToSolid(node);
        }
        if (string.equals("CompositeSolid")) {
            return GML3g.fromNodeToCompositeSolid(node);
        }
        if (string.equals("MultiSolid")) {
            return GML3g.fromNodeToMultiSolid(node);
        }
        throw new DataException("GML Geometry type " + node.getNodeName() + " not supported.");
    }

    public static JGeometry fromNodeToGeometry(Node node, int n) throws DataException, Exception {
        JGeometry jGeometry = GML3g.fromNodeToGeometry(node);
        if (n == 0) {
            return jGeometry;
        }
        if (n == 1) {
            int n2 = GML3g.reverseAxisOrder(n, jGeometry.getSRID(), _conn);
            if (n2 == 1) {
                jGeometry = GML3g.switchXYOrdinates(jGeometry);
            }
            return jGeometry;
        }
        if (n == 2) {
            jGeometry = GML3g.switchXYOrdinates(jGeometry);
            return jGeometry;
        }
        throw new Exception("Wrong value for coordOrder parameter: please choose among [0,1,2]");
    }

    public static JGeometry fromNodeToGeometryCollection(Node node) throws DataException, Exception {
        Object object;
        Object object2;
        int n;
        int n2 = 0;
        Vector<JGeometry> vector = new Vector<JGeometry>();
        int n3 = 0;
        int n4 = 0;
        Vector vector2 = GML3g.getAll(node, new String[]{"geometryMember"});
        for (n = 0; n < vector2.size(); ++n) {
            object2 = (Node)vector2.get(n);
            object = null;
            for (object = (Object)object2.getFirstChild(); object != null && !gmlTypes.contains(GML3g.normalize(object.getNodeName().toUpperCase())); object = object.getNextSibling()) {
            }
            if (object == null) continue;
            JGeometry jGeometry = GML3g.fromNodeToGeometry((Node)object);
            vector.add(jGeometry);
            if (jGeometry.getPoint() != null) {
                n3 += 3;
                n4 += jGeometry.getPoint().length;
                continue;
            }
            n3 += jGeometry.getElemInfo().length;
            n4 += jGeometry.getOrdinatesArray().length;
        }
        n = GML3g.getSRIDFromNode(node);
        object2 = new int[n3];
        object = new double[n4];
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            int n7;
            JGeometry jGeometry = (JGeometry)vector.get(i);
            n2 = jGeometry.getDimensions();
            int[] nArray = jGeometry.getElemInfo();
            double[] dArray = jGeometry.getOrdinatesArray();
            if (jGeometry.getPoint() != null) {
                object2[n5 + 0] = n6 + 1;
                object2[n5 + 1] = true;
                object2[n5 + 2] = true;
                n5 += 3;
                for (n7 = 0; n7 < jGeometry.getPoint().length; ++n7) {
                    object[n6 + n7] = jGeometry.getPoint()[n7];
                }
                n6 += jGeometry.getPoint().length;
                continue;
            }
            for (n7 = 0; n7 < nArray.length; n7 += 3) {
                object2[n5 + n7 + 0] = nArray[n7 + 0] + n6;
                object2[n5 + n7 + 1] = nArray[n7 + 1];
                object2[n5 + n7 + 2] = nArray[n7 + 2];
            }
            n5 += nArray.length;
            for (n7 = 0; n7 < dArray.length; ++n7) {
                object[n6 + n7] = dArray[n7];
            }
            n6 += dArray.length;
        }
        if (n2 == 0) {
            throw new DataException("54555");
        }
        return new JGeometry(n2 * 1000 + 4, n, (int[])object2, (double[])object);
    }

    public static JGeometry fromNodeToLinearRing(Node node) throws DataException, Exception {
        Node node2 = GML3g.getFirst(node, new String[]{GML_POS_LIST_ELEMENT});
        int n = GML3g.guessDimensionality(node);
        Vector<String> vector = new Vector<String>();
        if (node2 == null) {
            double[] dArray = GML3g.getOrdinatesFromNode(node);
            for (int i = 0; i < dArray.length; ++i) {
                vector.add(Double.toString(dArray[i]));
            }
        } else {
            GML3g.addCoords(vector, node2.getFirstChild().getNodeValue());
        }
        int n2 = GML3g.getSRIDFromNode(node);
        int[] nArray = new int[]{1, 2, 1};
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector.get(i));
        }
        if (n == 2 && dArray.length < 8 || n == 3 && dArray.length < 12) {
            throw new DataException("13343");
        }
        return new JGeometry(n * 1000 + 2, n2, nArray, dArray);
    }

    public static JGeometry fromNodeToMultiSurface(Node node) throws DataException, Exception {
        int n;
        Object object;
        Object object2;
        Object object3;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = GML3g.getAll(node, new String[]{"surfaceMember", "CompositeSurface"});
        for (int i = 0; i < vector3.size(); ++i) {
            Node node2 = (Node)vector3.get(i);
            object3 = GML3g.fromNodeToGeometry(node2);
            n2 = object3.getDimensions();
            object2 = object3.getElemInfo();
            for (int j = 0; j < ((int[])object2).length; ++j) {
                if (j % 3 == 0) {
                    vector.add("" + (object2[j] - 1 + vector2.size() + 1));
                    continue;
                }
                vector.add("" + object2[j]);
            }
            object = object3.getOrdinatesArray();
            for (int j = 0; j < ((double[])object).length; ++j) {
                vector2.add(Double.toString(object[j]));
            }
        }
        Vector vector4 = GML3g.getAll(node, new String[]{"surfaceMember", "Polygon"});
        for (n = 0; n < vector4.size(); ++n) {
            object3 = (Node)vector4.get(n);
            object2 = GML3g.fromNodeToGeometry((Node)object3);
            n2 = object2.getDimensions();
            object = "";
            for (int i = 0; i < object2.getElemInfo().length; ++i) {
                object = i % 3 == 0 ? ((String)object).concat(String.valueOf(object2.getElemInfo()[i] + vector2.size())).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE) : ((String)object).concat(String.valueOf(object2.getElemInfo()[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
            }
            GML3g.addCoords(vector, (String)object);
            String string = "";
            for (int i = 0; i < object2.getOrdinatesArray().length; ++i) {
                string = string.concat(String.valueOf(object2.getOrdinatesArray()[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
            }
            GML3g.addCoords(vector2, string);
        }
        n = GML3g.getSRIDFromNode(node);
        object3 = new int[vector.size()];
        for (int i = 0; i < ((JGeometry)object3).length; ++i) {
            object3[i] = (JGeometry)Integer.parseInt((String)vector.get(i));
        }
        double[] dArray = new double[vector2.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector2.get(i));
        }
        if (n2 == 0) {
            throw new DataException("54555");
        }
        return new JGeometry(n2 * 1000 + 7, n, (int[])object3, dArray);
    }

    protected static void addCoords(Vector vector, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.replace(',', ' '));
        while (stringTokenizer.hasMoreElements()) {
            vector.add(stringTokenizer.nextElement());
        }
    }

    protected static void addDoubleCoords(Vector vector, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.replace(',', ' '));
        while (stringTokenizer.hasMoreElements()) {
            vector.add(Double.parseDouble((String)stringTokenizer.nextElement()));
        }
    }

    protected static Vector getAll(Node node, String[] stringArray) {
        Vector vector = new Vector();
        GML3g.getAll(node, stringArray, 0, vector);
        return vector;
    }

    protected static void getAll(Node node, String[] stringArray, int n, Vector vector) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!GML3g.normalize(node2.getNodeName()).equalsIgnoreCase(stringArray[n])) continue;
            if (n + 1 == stringArray.length) {
                vector.add(node2);
                continue;
            }
            GML3g.getAll(node2, stringArray, n + 1, vector);
        }
    }

    protected static Node getFirst(Node node, String[] stringArray) {
        return GML3g.getFirst(node, stringArray, 0);
    }

    protected static Node getFirst(Node node, String[] stringArray, int n) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!GML3g.normalize(node2.getNodeName()).equalsIgnoreCase(stringArray[n])) continue;
            if (n + 1 == stringArray.length) {
                return node2;
            }
            Node node3 = GML3g.getFirst(node2, stringArray, n + 1);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    protected static String normalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(":") >= 0) {
            return string.substring(string.indexOf(":") + 1);
        }
        return string;
    }

    public static JGeometry fromNodeToCompositeCurve(Node node) throws DataException, Exception, GeometryExceptionWithContext {
        int n;
        Object object;
        int n2;
        Node node2;
        Node node3;
        int n3 = 0;
        Vector vector = GML3g.getAll(node, new String[]{"curveMember", "Curve"});
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = new Vector();
        vector2.add("" + (vector3.size() + 1));
        vector2.add("4");
        vector2.add("" + vector.size());
        Node node4 = GML3g.getFirst(node, new String[]{"curveMember", "Curve", "segments", "LineStringSegment"});
        if (node4 != null) {
            n3 = GML3g.guessDimensionality(node4);
        }
        if ((node3 = GML3g.getFirst(node, new String[]{"curveMember", "Curve", "segments", "Arc"})) != null) {
            n3 = GML3g.guessDimensionality(node3);
        }
        if ((node2 = GML3g.getFirst(node, new String[]{"curveMember", "Curve", "segments", "BSplineType"})) != null) {
            n3 = GML3g.guessDimensionality(node2);
        }
        Node node5 = (Node)vector.get(0);
        JGeometry jGeometry = GML3g.fromNodeToGeometry(node5);
        JGeometry jGeometry2 = null;
        for (n2 = 1; n2 <= vector.size(); ++n2) {
            if (n2 != vector.size()) {
                node5 = (Node)vector.get(n2);
                jGeometry2 = GML3g.fromNodeToGeometry(node5);
            }
            object = "";
            for (int i = 0; i < jGeometry.getElemInfo().length; ++i) {
                object = i % 3 == 0 ? ((String)object).concat(String.valueOf(jGeometry.getElemInfo()[i] + vector3.size())).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE) : ((String)object).concat(String.valueOf(jGeometry.getElemInfo()[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
            }
            GML3g.addCoords(vector2, (String)object);
            String string = "";
            if (n2 == vector.size() || jGeometry2.getElemInfo()[2] == 3) {
                for (n = 0; n < jGeometry.getOrdinatesArray().length; ++n) {
                    string = string.concat(String.valueOf(jGeometry.getOrdinatesArray()[n])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
            } else {
                for (n = 0; n < jGeometry.getOrdinatesArray().length - 2; ++n) {
                    string = string.concat(String.valueOf(jGeometry.getOrdinatesArray()[n])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
            }
            GML3g.addCoords(vector3, string);
            jGeometry = jGeometry2;
        }
        n2 = GML3g.getSRIDFromNode(node);
        object = new int[vector2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = Integer.parseInt((String)vector2.get(i));
        }
        double[] dArray = new double[vector3.size()];
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = Double.parseDouble((String)vector3.get(n));
        }
        return new JGeometry(n3 * 1000 + 2, n2, (int[])object, dArray);
    }

    public static JGeometry fromNodeToCompositeSurface(Node node) throws DataException, Exception {
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2 = GML3g.guessDimensionality(GML3g.getFirst(node, new String[]{"surfaceMember", "Polygon", "exterior", "LinearRing"}));
        Vector vector = GML3g.getAll(node, new String[]{"surfaceMember", "Polygon"});
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = new Vector();
        vector2.add("" + (vector3.size() + 1));
        vector2.add("1006");
        vector2.add("" + vector.size());
        Vector vector4 = GML3g.getAll(node, new String[]{"surfaceMember", "Polygon", "exterior", "LinearRing", GML_POS_ELEMENT});
        if (vector4.size() != 0) {
            for (n = 0; n < vector.size(); ++n) {
                object3 = (Node)vector.get(n);
                object2 = GML3g.fromNodeToGeometry((Node)object3);
                object = "";
                for (int i = 0; i < object2.getElemInfo().length; ++i) {
                    object = i % 3 == 0 ? ((String)object).concat(String.valueOf(object2.getElemInfo()[i] + vector3.size())).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE) : ((String)object).concat(String.valueOf(object2.getElemInfo()[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector2, (String)object);
                String string = "";
                for (int i = 0; i < object2.getOrdinatesArray().length; ++i) {
                    string = string.concat(String.valueOf(object2.getOrdinatesArray()[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector3, string);
            }
        } else {
            for (n = 0; n < vector.size(); ++n) {
                int n3;
                object3 = (Node)vector.get(n);
                object2 = GML3g.getAll((Node)object3, new String[]{"interior", "LinearRing", GML_POS_LIST_ELEMENT});
                object = GML3g.getAll((Node)object3, new String[]{"exterior", "LinearRing", GML_POS_LIST_ELEMENT});
                for (n3 = 0; n3 < ((Vector)object).size(); ++n3) {
                    vector2.add("" + (vector3.size() + 1));
                    vector2.add("1003");
                    vector2.add("1");
                    GML3g.addCoords(vector3, ((Node)((Vector)object).get(n3)).getFirstChild().getNodeValue());
                }
                for (n3 = 0; n3 < ((Vector)object2).size(); ++n3) {
                    vector2.add("" + (vector3.size() + 1));
                    vector2.add("2003");
                    vector2.add("1");
                    GML3g.addCoords(vector3, ((Node)((Vector)object2).get(n3)).getFirstChild().getNodeValue());
                }
            }
        }
        n = GML3g.getSRIDFromNode(node);
        object3 = new int[vector2.size()];
        for (int i = 0; i < ((Object)object3).length; ++i) {
            object3[i] = Integer.parseInt((String)vector2.get(i));
        }
        double[] dArray = new double[vector3.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector3.get(i));
        }
        return new JGeometry(n2 * 1000 + 3, n, (int[])object3, dArray);
    }

    public static JGeometry fromNodeToSolid(Node node) throws DataException, Exception {
        Object object;
        Object object2;
        int n;
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        int n2 = GML3g.guessDimensionality(GML3g.getFirst(node, new String[]{"exterior", "CompositeSurface", "surfaceMember", "Polygon", "exterior", "LinearRing"}));
        Vector vector3 = GML3g.getAll(node, new String[]{"exterior", "CompositeSurface"});
        Vector vector4 = GML3g.getAll(node, new String[]{"interior", "CompositeSurface"});
        vector.add("" + (vector2.size() + 1));
        vector.add("1007");
        vector.add("1");
        Node node2 = (Node)vector3.get(0);
        Vector vector5 = GML3g.getAll(node2, new String[]{"surfaceMember", "Polygon", "exterior", "LinearRing", GML_POS_ELEMENT});
        if (vector5.size() != 0) {
            vector5 = GML3g.getAll(node2, new String[]{"surfaceMember", "Polygon"});
            vector.add("" + (vector2.size() + 1));
            vector.add("1006");
            vector.add("" + vector5.size());
            for (n = 0; n < vector5.size(); ++n) {
                object2 = (Node)vector5.get(n);
                JGeometry jGeometry = GML3g.fromNodeToGeometry((Node)object2);
                vector.add("" + (vector2.size() + 1));
                vector.add("1003");
                vector.add("1");
                object = "";
                for (int i = 0; i < jGeometry.getOrdinatesArray().length; ++i) {
                    object = ((String)object).concat(String.valueOf(jGeometry.getOrdinatesArray()[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                }
                GML3g.addCoords(vector2, (String)object);
            }
        } else {
            vector5 = GML3g.getAll(node2, new String[]{"surfaceMember", "Polygon", "exterior", "LinearRing", GML_POS_LIST_ELEMENT});
            vector.add("" + (vector2.size() + 1));
            vector.add("1006");
            vector.add("" + vector5.size());
            for (n = 0; n < vector5.size(); ++n) {
                vector.add("" + (vector2.size() + 1));
                vector.add("1003");
                vector.add("1");
                GML3g.addCoords(vector2, ((Node)vector5.get(n)).getFirstChild().getNodeValue());
            }
        }
        vector5.clear();
        for (n = 0; n < vector4.size(); ++n) {
            int n3;
            object2 = (Node)vector4.get(n);
            vector5 = GML3g.getAll((Node)object2, new String[]{"surfaceMember", "Polygon", "exterior", "LinearRing", GML_POS_ELEMENT});
            if (vector5.size() != 0) {
                vector5 = GML3g.getAll((Node)object2, new String[]{"surfaceMember", "Polygon"});
                vector.add("" + (vector2.size() + 1));
                vector.add("2006");
                vector.add("" + vector5.size());
                for (n3 = 0; n3 < vector5.size(); ++n3) {
                    object = (Node)vector5.get(n3);
                    JGeometry jGeometry = GML3g.fromNodeToGeometry((Node)object);
                    vector.add("" + (vector2.size() + 1));
                    vector.add("2003");
                    vector.add("1");
                    String string = "";
                    for (int i = 0; i < jGeometry.getOrdinatesArray().length; ++i) {
                        string = string.concat(String.valueOf(jGeometry.getOrdinatesArray()[i])).concat(GML_TS_ATTRIBUTE_DEFAULT_VALUE);
                    }
                    GML3g.addCoords(vector2, string);
                }
                continue;
            }
            vector5 = GML3g.getAll((Node)object2, new String[]{"surfaceMember", "Polygon", "exterior", "LinearRing", GML_POS_LIST_ELEMENT});
            vector.add("" + (vector2.size() + 1));
            vector.add("2006");
            vector.add("" + vector5.size());
            for (n3 = 0; n3 < vector5.size(); ++n3) {
                vector.add("" + (vector2.size() + 1));
                vector.add("2003");
                vector.add("1");
                GML3g.addCoords(vector2, ((Node)vector5.get(n3)).getFirstChild().getNodeValue());
            }
        }
        n = GML3g.getSRIDFromNode(node);
        object2 = new int[vector.size()];
        for (int i = 0; i < ((Object)object2).length; ++i) {
            object2[i] = Integer.parseInt((String)vector.get(i));
        }
        double[] dArray = new double[vector2.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector2.get(i));
        }
        return new JGeometry(n2 * 1000 + 8, n, (int[])object2, dArray);
    }

    public static JGeometry fromNodeToCompositeSolid(Node node) throws DataException, Exception {
        Object object;
        Object object2;
        int n;
        Vector<JGeometry> vector = new Vector<JGeometry>();
        int n2 = 0;
        int n3 = 0;
        int n4 = GML3g.guessDimensionality(GML3g.getFirst(node, new String[]{"solidMember", "Solid", "exterior", "CompositeSurface", "surfaceMember", "Polygon", "exterior", "LinearRing"}));
        Vector vector2 = GML3g.getAll(node, new String[]{"solidMember"});
        for (n = 0; n < vector2.size(); ++n) {
            object2 = (Node)vector2.get(n);
            object = null;
            for (object = object2.getFirstChild(); object != null && !gmlTypes.contains(GML3g.normalize(object.getNodeName().toUpperCase())); object = object.getNextSibling()) {
            }
            if (object == null) continue;
            JGeometry jGeometry = GML3g.fromNodeToGeometry((Node)object);
            vector.add(jGeometry);
            if (jGeometry.getPoint() != null) {
                n2 += 3;
                n3 += jGeometry.getPoint().length;
                continue;
            }
            n2 += jGeometry.getElemInfo().length;
            n3 += jGeometry.getOrdinatesArray().length;
        }
        n = GML3g.getSRIDFromNode(node);
        object2 = new int[n2 + 3];
        object = new double[n3];
        object2[0] = true;
        object2[1] = 1008;
        object2[2] = vector2.size();
        int n5 = 3;
        int n6 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            int n7;
            JGeometry jGeometry = (JGeometry)vector.get(i);
            int[] nArray = jGeometry.getElemInfo();
            double[] dArray = jGeometry.getOrdinatesArray();
            if (jGeometry.getPoint() != null) {
                object2[n5 + 0] = n6 + 1;
                object2[n5 + 1] = true;
                object2[n5 + 2] = true;
                n5 += 3;
                for (n7 = 0; n7 < jGeometry.getPoint().length; ++n7) {
                    object[n6 + n7] = jGeometry.getPoint()[n7];
                }
                n6 += jGeometry.getPoint().length;
                continue;
            }
            for (n7 = 0; n7 < nArray.length; n7 += 3) {
                object2[n5 + n7 + 0] = nArray[n7 + 0] + n6;
                object2[n5 + n7 + 1] = nArray[n7 + 1];
                object2[n5 + n7 + 2] = nArray[n7 + 2];
            }
            n5 += nArray.length;
            for (n7 = 0; n7 < dArray.length; ++n7) {
                object[n6 + n7] = dArray[n7];
            }
            n6 += dArray.length;
        }
        return new JGeometry(n4 * 1000 + 8, n, (int[])object2, (double[])object);
    }

    public static JGeometry fromNodeToMultiSolid(Node node) throws DataException, Exception {
        int n;
        Object[] objectArray;
        Object object;
        Object object2;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = GML3g.getAll(node, new String[]{"solidMember", "CompositeSolid"});
        for (int i = 0; i < vector3.size(); ++i) {
            Node node2 = (Node)vector3.get(i);
            object2 = GML3g.fromNodeToGeometry(node2);
            n2 = object2.getDimensions();
            object = object2.getElemInfo();
            for (int j = 0; j < ((int[])object).length; ++j) {
                if (j % 3 == 0) {
                    vector.add("" + (object[j] - 1 + vector2.size() + 1));
                    continue;
                }
                vector.add("" + object[j]);
            }
            objectArray = object2.getOrdinatesArray();
            for (int j = 0; j < objectArray.length; ++j) {
                vector2.add(Double.toString(objectArray[j]));
            }
        }
        Vector vector4 = GML3g.getAll(node, new String[]{"solidMember", "Solid"});
        for (n = 0; n < vector4.size(); ++n) {
            object2 = (Node)vector4.get(n);
            object = GML3g.fromNodeToGeometry((Node)object2);
            n2 = object.getDimensions();
            objectArray = object.getElemInfo();
            for (int i = 0; i < objectArray.length; ++i) {
                if (i % 3 == 0) {
                    vector.add("" + (int)(objectArray[i] - true + vector2.size() + true));
                    continue;
                }
                vector.add("" + (int)objectArray[i]);
            }
            double[] dArray = object.getOrdinatesArray();
            for (int i = 0; i < dArray.length; ++i) {
                vector2.add(Double.toString(dArray[i]));
            }
        }
        n = GML3g.getSRIDFromNode(node);
        object2 = new int[vector.size()];
        for (int i = 0; i < ((JGeometry)object2).length; ++i) {
            object2[i] = (JGeometry)Integer.parseInt((String)vector.get(i));
        }
        double[] dArray = new double[vector2.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector2.get(i));
        }
        if (n2 == 0) {
            throw new DataException("54555");
        }
        return new JGeometry(n2 * 1000 + 9, n, (int[])object2, dArray);
    }

    public static int reverseAxisOrder(int n, int n2, Connection connection) throws DataException, Exception {
        int n3 = 0;
        if (n == 1) {
            if (connection == null) {
                throw new DataException("GML Converter needs a valid connection for deciding on whether to reorder coordinate axis sequence");
            }
            CallableStatement callableStatement = connection.prepareCall("{ ? = call mdsys.sdo_cs.reverse_axis_order(?)}");
            callableStatement.registerOutParameter(1, 4);
            callableStatement.setInt(2, n2);
            callableStatement.execute();
            n3 = callableStatement.getInt(1);
            callableStatement.close();
        }
        return n3;
    }

    public static JGeometry switchXYOrdinates(JGeometry jGeometry) throws DataException, Exception {
        int n;
        JGeometry jGeometry2 = null;
        if (GML3g.containsNURBSorArcs(jGeometry)) {
            return jGeometry;
        }
        jGeometry = GML3g.expandShortcuts(jGeometry);
        int n2 = jGeometry.getSRID();
        if (jGeometry.getElemInfo() == null || jGeometry.getOrdinatesArray() == null) {
            double[] dArray = jGeometry.getPoint();
            jGeometry2 = dArray.length == 3 ? new JGeometry(dArray[1], dArray[0], dArray[2], n2) : new JGeometry(dArray[1], dArray[0], n2);
            return jGeometry2;
        }
        int n3 = jGeometry.getDimensions();
        int n4 = jGeometry.getOrdinatesArray().length;
        double[] dArray = new double[n4];
        if (n3 == 2) {
            for (n = 0; n < n4 / n3; ++n) {
                dArray[n3 * n] = jGeometry.getOrdinatesArray()[n3 * n + 1];
                dArray[n3 * n + 1] = jGeometry.getOrdinatesArray()[n3 * n];
            }
        } else if (n3 == 3) {
            for (n = 0; n < n4 / n3; ++n) {
                dArray[n3 * n] = jGeometry.getOrdinatesArray()[n3 * n + 1];
                dArray[n3 * n + 1] = jGeometry.getOrdinatesArray()[n3 * n];
                dArray[n3 * n + 2] = jGeometry.getOrdinatesArray()[n3 * n + 2];
            }
        } else {
            throw new DataException("Wrong Geometry dimension");
        }
        int[] nArray = new int[jGeometry.getElemInfo().length];
        System.arraycopy(jGeometry.getElemInfo(), 0, nArray, 0, jGeometry.getElemInfo().length);
        jGeometry2 = new JGeometry(n3 * 1000 + jGeometry.getType(), n2, nArray, dArray);
        return jGeometry2;
    }

    static JGeometry expandShortcuts(JGeometry jGeometry) throws DataException, Exception {
        J3D_Geometry j3D_Geometry = null;
        if (jGeometry.getElemInfo() == null || jGeometry.getOrdinatesArray() == null) {
            return jGeometry;
        }
        int n = jGeometry.getType();
        int n2 = jGeometry.getSRID();
        int n3 = jGeometry.getDimensions();
        int n4 = jGeometry.getLRMDimension();
        int[] nArray = new int[jGeometry.getElemInfo().length];
        System.arraycopy(jGeometry.getElemInfo(), 0, nArray, 0, jGeometry.getElemInfo().length);
        double[] dArray = new double[jGeometry.getOrdinatesArray().length];
        System.arraycopy(jGeometry.getOrdinatesArray(), 0, dArray, 0, jGeometry.getOrdinatesArray().length);
        boolean bl = false;
        int n5 = 0;
        while (n5 + 2 < jGeometry.getElemInfo().length) {
            if (jGeometry.getElemInfo()[n5 + 1] == 1007 && jGeometry.getElemInfo()[n5 + 2] == 3) {
                bl = true;
                break;
            }
            if (jGeometry.getElemInfo()[n5 + 1] == 1003 && jGeometry.getElemInfo()[n5 + 2] == 3) {
                bl = true;
                break;
            }
            if (jGeometry.getElemInfo()[n5 + 1] == 2003 && jGeometry.getElemInfo()[n5 + 2] == 3) {
                bl = true;
                break;
            }
            n5 += 3;
        }
        if (jGeometry.getDimensions() == 2 && bl) {
            JGeometry jGeometry2 = JGeometry.make_3d((JGeometry)jGeometry, (boolean)true, (int)0, (double)0.0);
            nArray = new int[jGeometry2.getElemInfo().length];
            System.arraycopy(jGeometry2.getElemInfo(), 0, nArray, 0, jGeometry2.getElemInfo().length);
            dArray = new double[jGeometry2.getOrdinatesArray().length];
            System.arraycopy(jGeometry2.getOrdinatesArray(), 0, dArray, 0, jGeometry2.getOrdinatesArray().length);
            int n6 = jGeometry2.getSRID();
            J3D_Geometry j3D_Geometry2 = new J3D_Geometry(jGeometry2.getType() % 100, n6, nArray, dArray);
            J3D_Geometry j3D_Geometry3 = J3D_Geometry.expandGeom((J3D_Geometry)j3D_Geometry2);
            nArray = new int[j3D_Geometry3.getElemInfo().length];
            System.arraycopy(j3D_Geometry3.getElemInfo(), 0, nArray, 0, j3D_Geometry3.getElemInfo().length);
            dArray = new double[j3D_Geometry3.getOrdinatesArray().length];
            System.arraycopy(j3D_Geometry3.getOrdinatesArray(), 0, dArray, 0, j3D_Geometry3.getOrdinatesArray().length);
            JGeometry jGeometry3 = new JGeometry(j3D_Geometry3.getType() % 100 + 3000, n6, nArray, dArray);
            jGeometry3.setType(j3D_Geometry3.getType() % 100 + 3000);
            j3D_Geometry = JGeometry.make_2d((JGeometry)jGeometry3, (boolean)false, (int)n2);
            j3D_Geometry.setLRMDimension(n4);
            return j3D_Geometry;
        }
        if (jGeometry.getDimensions() == 3 && bl) {
            J3D_Geometry j3D_Geometry4 = new J3D_Geometry(n % 100, n2, nArray, dArray);
            j3D_Geometry4.setType(n % 100 + 3000);
            j3D_Geometry4.setLRMDimension(n4);
            j3D_Geometry = J3D_Geometry.expandGeom((J3D_Geometry)j3D_Geometry4);
            return j3D_Geometry;
        }
        return jGeometry;
    }

    static boolean containsNURBSorArcs(JGeometry jGeometry) throws DataException, Exception {
        boolean bl = false;
        int[] nArray = jGeometry.getElemInfo();
        if (jGeometry.getElemInfo() == null || jGeometry.getOrdinatesArray() == null) {
            bl = false;
            return bl;
        }
        int n = jGeometry.getElemInfo().length / 3;
        for (int i = 0; i < n && !bl; ++i) {
            if (nArray[3 * i + 2] == 3 && nArray[3 * i + 1] % 10 == 2) {
                bl = true;
                continue;
            }
            if (nArray[3 * i + 2] == 2 && nArray[3 * i + 1] % 10 > 1) {
                bl = true;
                continue;
            }
            if (nArray[3 * i + 1] % 10 == 3 && nArray[3 * i + 2] == 4) {
                bl = true;
                continue;
            }
            if (jGeometry.getDimensions() != 2 || nArray[3 * i + 1] % 10 <= 3) continue;
            bl = true;
        }
        return bl;
    }

    static {
        _srsNameSpace = "Test";
        logger = Logger.getLogger("oracle.spatial.util.GML3g");
        gmlTypes = new HashSet(16);
        gmlTypes.add("POINT");
        gmlTypes.add("LINESTRING");
        gmlTypes.add("CURVE");
        gmlTypes.add("COMPOSITECURVE");
        gmlTypes.add("POLYGON");
        gmlTypes.add("SURFACE");
        gmlTypes.add("COMPOSITESURFACE");
        gmlTypes.add("MULTIGEOMETRY");
        gmlTypes.add("MULTIPOINT");
        gmlTypes.add("MULTICURVE");
        gmlTypes.add("MULTIPOLYGON");
        gmlTypes.add("MULTISURFACE");
        gmlTypes.add("ENVELOPE");
        gmlTypes.add("LINEARRING");
        gmlTypes.add("SOLID");
        gmlTypes.add("COMPOSITESOLID");
        gmlTypes.add("MULTISOLID");
    }
}

