/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.ceditor.tint;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.text.BadLocationException;
import oracle.ide.ceditor.tint.BlockPainter;
import oracle.ide.ceditor.tint.TintBlock;
import oracle.ide.ceditor.tint.TintModel;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.CodeFoldingMargin;

public abstract class DefaultBlockPainter
implements BlockPainter {
    protected static int LEADING_INSET = 2;
    protected static int TRAILING_INSET = 8;

    protected abstract boolean isPaintingEnabled();

    @Override
    public void paint(Graphics2D g2, BasicEditorPane editor, TintModel model) {
        if (this.isPaintingEnabled()) {
            return;
        }
        TintBlock block = model.getRoot();
        if (block == null) {
            return;
        }
        Rectangle visRect = editor.getVisibleRect();
        int firstOff = editor.viewToModel(visRect.getLocation());
        int lastOff = editor.viewToModel(new Point(visRect.x + visRect.width, visRect.y + visRect.height));
        int depth = 0;
        int lineHeight = editor.getFontHelper().getFontMetrics(editor.getFont(), (Component)editor).getHeight();
        this.visit(g2, editor, model, block, firstOff, lastOff, depth, lineHeight);
    }

    protected void visit(Graphics2D g2, BasicEditorPane editor, TintModel model, TintBlock block, int firstOff, int lastOff, int depth, int lineHeight) {
        if (block.getEndOffset() < firstOff) {
            return;
        }
        if (block.getStartOffset() > lastOff) {
            return;
        }
        if (DefaultBlockPainter.isFolded(editor, block)) {
            return;
        }
        if (block.isVisible()) {
            this.paintBlock(g2, editor, model, block, depth, lineHeight);
        }
        ++depth;
        for (TintBlock childBlock : model.getChildren(block)) {
            this.visit(g2, editor, model, childBlock, firstOff, lastOff, depth, lineHeight);
        }
    }

    protected void paintBlock(Graphics2D g2, BasicEditorPane editor, TintModel model, TintBlock block, int depth, int lineHeight) {
        try {
            Point start = editor.modelToView(block.getStartOffset()).getLocation();
            Point end = editor.modelToView(block.getEndOffset()).getLocation();
            int x = Math.min(start.x, end.x) - LEADING_INSET;
            int width = this.getBlockWidth(editor, model, block, x, depth);
            int height = Math.min(end.y - start.y + lineHeight, editor.getHeight() - 1);
            if (block.getBlockType().getColor() != null) {
                g2.setColor(block.getBlockType().getColor());
                g2.fillRoundRect(x, start.y, width, height, 10, 10);
            }
            if (block.getBlockType().getBlockStroke().getStroke() != null && block.getBlockType().getStrokeColor() != null) {
                g2.setStroke(block.getBlockType().getBlockStroke().getStroke());
                g2.setColor(block.getBlockType().getStrokeColor());
                g2.drawRoundRect(x, start.y, width, height, 10, 10);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected static boolean isFolded(BasicEditorPane editor, TintBlock block) {
        CodeFoldingMargin foldingMargin = (CodeFoldingMargin)editor.getProperty("code-folding-margin");
        if (foldingMargin == null || foldingMargin.getModel() == null) {
            return false;
        }
        Object foldedBlock = foldingMargin.getLargestCollapsedBlock(foldingMargin.getModel(), foldingMargin.getModel().getRoot(), block.getStartOffset());
        return foldedBlock != null;
    }

    protected int getEditorBlockWidth(BasicEditorPane editor, TintModel model, TintBlock block, int x, int depth) {
        int width = editor.getPreferredSize().width;
        int w = width + LEADING_INSET + (model.getMaxDepth() - depth - 1) * TRAILING_INSET - x;
        return w;
    }

    protected int getBlockWidth(BasicEditorPane editor, TintModel model, TintBlock block, int x, int depth) {
        return this.getEditorBlockWidth(editor, model, block, x, depth);
    }
}

