/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.schedule;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPTZ;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.QualifiedIdentifier;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.TIMESTAMPTZ;

public class ScheduleWhenModel {
    public static final String HAS_CHANGES = "has_changes";
    public static final String QUEUE_SPEC = ScheduleWhenModel.formatValueName("QUEUE_SPEC");
    public static final String EVENT_SPEC = ScheduleWhenModel.formatValueName("EVENT_SPEC");
    public static final String SCHEDULE_SPEC = ScheduleWhenModel.formatValueName("SCHEDULE_SPEC");
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Properties properties = new Properties(new Properties());

    protected static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    protected static String formatValueName(String string) {
        return string != null ? string.toLowerCase() : null;
    }

    protected Properties getInitProperties() {
        return this.properties.getInitProperties();
    }

    public Object initProperty(Property property, Object object) {
        return this.properties.initProperty(property, object);
    }

    public void doInitialize() {
        this.properties.reset(false);
    }

    public void reset() {
        this.properties.reset(true);
    }

    protected Object setProperty(Property property, Object object) {
        Object object2 = this.properties.getProperty(property);
        this.properties.setProperty(property, object, true);
        return object2;
    }

    public Object getProperty(Property property) {
        return this.properties.getProperty(property);
    }

    public EventType getEventType() {
        return this.properties.getEventType();
    }

    protected String makeQueueSpec() {
        String string = null;
        String string2 = (String)this.getProperty(Property.EVENT_QUEUE_OWNER);
        String string3 = (String)this.getProperty(Property.EVENT_QUEUE_NAME);
        String string4 = (String)this.getProperty(Property.EVENT_QUEUE_AGENT);
        String string5 = (String)this.getProperty(Property.FILE_WATCHER_OWNER);
        String string6 = (String)this.getProperty(Property.FILE_WATCHER_NAME);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string4 != null && string4.length() == 0) {
            string4 = null;
        }
        if (string5 != null && string5.length() == 0) {
            string5 = null;
        }
        if (string6 != null && string6.length() == 0) {
            string6 = null;
        }
        if (this.getEventType() == EventType.FILE_EVENT) {
            string = this.makeIdentifier(string5, string6);
        } else if (this.getEventType() == EventType.QUEUE_EVENT) {
            String string7 = this.makeIdentifier(string2, string3);
            if (string4 != null && string4.length() > 0) {
                string4 = this.makeIdentifier(null, string4);
                string = string7 != null ? string7 + "," + string4 : "," + string4;
            } else {
                string = string7;
            }
        }
        return string;
    }

    protected String makeScheduleSpec() {
        String string = null;
        switch (this.getEventType()) {
            case NAMED_SCHEDULE: 
            case NAMED_WINDOW: 
            case NAMED_WINDOW_GROUP: {
                String string2 = (String)this.getProperty(Property.SCHEDULE_OWNER);
                String string3 = (String)this.getProperty(Property.SCHEDULE_NAME);
                if (string2 != null && string2.length() == 0) {
                    string2 = null;
                }
                if (string3 != null && string3.length() == 0) {
                    string3 = null;
                }
                string = this.makeIdentifier(string2, string3);
            }
        }
        return string;
    }

    private String makeIdentifier(String string, String string2) {
        QualifiedIdentifier qualifiedIdentifier = new QualifiedIdentifier(string, string2);
        return qualifiedIdentifier.getId(true);
    }

    public Map<Property, Object> getProperties() {
        return this.properties.getProperties();
    }

    public Map<Property, PropertyChangeEvent> getChangedProperties() {
        return this.properties.getChangedProperties();
    }

    public boolean isPropertyChanged(Property property) {
        return this.properties.isChanged(property);
    }

    public Map<String, Boolean> getChanges() {
        return this.getChanges(new HashMap<String, Boolean>());
    }

    public Map<String, Boolean> getChanges(Map<String, Boolean> map) {
        Map<Property, PropertyChangeEvent> map2 = this.getChangedProperties();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Set<Property> set = map2.keySet();
        for (Property property : Property.values()) {
            String string = property.getValueName();
            if (set.contains((Object)property)) {
                switch (property) {
                    case SCHEDULE_NAME: 
                    case SCHEDULE_OWNER: {
                        bl3 = true;
                        break;
                    }
                    case EVENT_QUEUE_AGENT: 
                    case EVENT_QUEUE_NAME: 
                    case EVENT_QUEUE_OWNER: 
                    case FILE_WATCHER_NAME: 
                    case FILE_WATCHER_OWNER: {
                        bl = true;
                    }
                    case EVENT_CONDITION: {
                        bl2 = true;
                    }
                }
                map.put(string, true);
                map.put(HAS_CHANGES, true);
                continue;
            }
            map.put(string, false);
        }
        if (bl) {
            map.put(QUEUE_SPEC, true);
        }
        if (bl2) {
            map.put(EVENT_SPEC, true);
        }
        if (bl3) {
            map.put(SCHEDULE_SPEC, true);
        }
        return map;
    }

    public Map<String, Boolean> getIsNull() {
        return this.getIsNull(new HashMap<String, Boolean>());
    }

    public Map<String, Boolean> getIsNull(Map<String, Boolean> map) {
        boolean bl = false;
        for (Property property : Property.values()) {
            Object object = this.getProperty(property);
            if (property == Property.EVENT_CONDITION) {
                bl = object == null;
            }
            map.put(property.getValueName(), object == null);
        }
        String string = this.makeQueueSpec();
        map.put(QUEUE_SPEC, string == null);
        map.put(EVENT_SPEC, string == null && bl);
        String string2 = this.makeScheduleSpec();
        map.put(SCHEDULE_SPEC, string2 == null);
        return map;
    }

    public boolean firePropertyChangeListeners(ScheduleWhenModel scheduleWhenModel) {
        boolean bl = false;
        if (scheduleWhenModel != null) {
            bl = this.properties.firePropertyChangeListeners(scheduleWhenModel.properties);
        } else {
            for (Property property : Property.values()) {
                this.firePropertyChangeListeners(property, null, this.getProperty(property));
            }
            bl = true;
        }
        return bl;
    }

    protected void firePropertyChangeListeners(Property property, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(property.toString(), object, object2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public Object initPropertyFromRS(OracleResultSet oracleResultSet, Property property, Connection connection) throws SQLException {
        return this.initProperty(property, property.getValueFromRS(oracleResultSet, connection));
    }

    public void initPropertiesFromRS(OracleResultSet oracleResultSet, Connection connection) throws SQLException {
        this.initPropertyFromRS(oracleResultSet, Property.REPEAT_INTERVAL, connection);
        try {
            this.initPropertyFromRS(oracleResultSet, Property.EVENT_QUEUE_OWNER, connection);
            this.initPropertyFromRS(oracleResultSet, Property.EVENT_QUEUE_NAME, connection);
            this.initPropertyFromRS(oracleResultSet, Property.EVENT_QUEUE_AGENT, connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.initPropertyFromRS(oracleResultSet, Property.FILE_WATCHER_OWNER, connection);
            this.initPropertyFromRS(oracleResultSet, Property.FILE_WATCHER_NAME, connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.initPropertyFromRS(oracleResultSet, Property.EVENT_CONDITION, connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.initPropertyFromRS(oracleResultSet, Property.SCHEDULE_OWNER, connection);
            this.initPropertyFromRS(oracleResultSet, Property.SCHEDULE_NAME, connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.initPropertyFromRS(oracleResultSet, Property.SCHEDULE_TYPE, connection);
        }
        catch (SQLException sQLException) {
            String string = (String)this.getInitProperties().getProperty(Property.SCHEDULE_OWNER);
            String string2 = (String)this.getInitProperties().getProperty(Property.SCHEDULE_NAME);
            if (string != null || string2 != null) {
                TriggerType triggerType = this.getTriggerType(string, string2, connection);
                if (triggerType != null) {
                    EventType eventType = EventType.defaultEventType(triggerType);
                    if (eventType != null) {
                        this.initProperty(Property.SCHEDULE_TYPE, (Object)eventType.getScheduleType());
                    } else {
                        this.initProperty(Property.SCHEDULE_TYPE, (Object)ScheduleType.NAMED);
                    }
                } else {
                    this.initProperty(Property.SCHEDULE_TYPE, (Object)ScheduleType.NAMED);
                }
            }
            String string3 = (String)this.getInitProperties().getProperty(Property.REPEAT_INTERVAL);
            if (string3 != null) {
                this.initProperty(Property.SCHEDULE_TYPE, (Object)ScheduleType.CALENDAR);
            }
            this.initProperty(Property.SCHEDULE_TYPE, (Object)ScheduleType.ONCE);
        }
        EventType eventType = this.getInitProperties().getEventType();
        if (eventType == null || eventType.getScheduleType() != ScheduleType.NAMED && eventType.getScheduleType() != ScheduleType.WINDOW && eventType.getScheduleType() != ScheduleType.WINDOW_GROUP) {
            this.initPropertyFromRS(oracleResultSet, Property.START_DATE, connection);
            this.initPropertyFromRS(oracleResultSet, Property.END_DATE, connection);
        }
    }

    protected String getQuery(Connection connection, String string) {
        return Utils.getQuery(ScheduleWhenModel.class, (Connection)connection, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TriggerType getTriggerType(String string, String string2, Connection connection) {
        TriggerType triggerType = null;
        if (connection != null) {
            String string3 = this.getQuery(connection, "getTriggerType");
            try {
                OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string3);
                oraclePreparedStatement.setStringAtName("OWNER", string);
                oraclePreparedStatement.setStringAtName("SCHEDULE_NAME", string2);
                try (ResultSet resultSet = oraclePreparedStatement.executeQuery();){
                    String string4;
                    if (resultSet.next() && (string4 = resultSet.getString(1)) != null) {
                        triggerType = TriggerType.valueOf(string4);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return triggerType;
    }

    protected class Properties {
        private final HashMap<Property, Object> propertyMap = new HashMap();
        private Properties initProperties;
        private EventType eventType;

        protected Properties(Properties properties) {
            this.initProperties = properties;
            this.eventType = null;
        }

        protected Properties() {
            this(null);
        }

        protected int size() {
            return this.propertyMap.size();
        }

        protected Object initProperty(Property property, Object object) {
            Object object2 = this.initProperties.getProperty(property);
            this.initProperties.setProperty(property, object, false);
            return object2;
        }

        protected Properties getInitProperties() {
            return this.initProperties;
        }

        protected boolean reset(boolean bl) {
            boolean bl2 = false;
            if (this.initProperties != null) {
                for (Property property : Property.values()) {
                    Object object = this.initProperties.getProperty(property);
                    bl2 |= this.setProperty(property, object, bl);
                }
            }
            return bl2;
        }

        protected boolean setProperty(Property property, Object object, boolean bl) {
            boolean bl2;
            Object object2 = this.getProperty(property);
            Object object3 = property.castToValue(object);
            Object object4 = property.castToValue(object);
            boolean bl3 = bl2 = !ScheduleWhenModel.areEqual(object2, object);
            if (bl2) {
                this.changeProperty(property, object2, object3, object4, bl);
            }
            return bl2;
        }

        protected Object getProperty(Property property) {
            if (property == Property.EVENT_TYPE) {
                return this.eventType;
            }
            return this.propertyMap.get((Object)property);
        }

        protected EventType getEventType() {
            return (EventType)((Object)this.getProperty(Property.EVENT_TYPE));
        }

        protected void changeProperty(Property property, Object object, Object object2, Object object3, boolean bl) {
            this.preChangeProperty(property, object, object2, bl);
            if (object2 == null) {
                this.propertyMap.remove((Object)property);
            } else {
                this.propertyMap.put(property, object2);
            }
            if (property == Property.EVENT_TYPE) {
                this.eventType = (EventType)((Object)object2);
            }
            if (bl) {
                ScheduleWhenModel.this.firePropertyChangeListeners(property, object, object3);
            }
            this.postChangeProperty(property, object, object2, bl);
        }

        protected void preChangeProperty(Property property, Object object, Object object2, boolean bl) {
            switch (property) {
                case EVENT_TYPE: {
                    break;
                }
                case SCHEDULE_TYPE: {
                    ScheduleType scheduleType = (ScheduleType)((Object)object2);
                    if (scheduleType == null) {
                        this.setProperty(Property.EVENT_TYPE, null, bl);
                        break;
                    }
                    if (this.eventType != null && this.eventType.getScheduleType() == scheduleType) break;
                    this.setProperty(Property.EVENT_TYPE, (Object)EventType.defaultEventType(scheduleType), bl);
                    break;
                }
                default: {
                    if (object2 == null) break;
                    this.setProperty(Property.EVENT_TYPE, (Object)property.getCompatibleEventType(this.eventType), bl);
                }
            }
        }

        protected void postChangeProperty(Property property, Object object, Object object2, boolean bl) {
            switch (property) {
                case EVENT_TYPE: {
                    this.setProperty(Property.SCHEDULE_TYPE, (Object)(this.eventType != null ? this.eventType.getScheduleType() : null), bl);
                    for (Property property2 : Property.values()) {
                        if (property2.isValidForEventType(this.eventType)) continue;
                        this.setProperty(property2, null, bl);
                    }
                    break;
                }
            }
        }

        protected boolean isChanged(Property property) {
            Object object = this.getProperty(property);
            Object object2 = this.initProperties == null ? null : this.initProperties.getProperty(property);
            return !ScheduleWhenModel.areEqual(object2, object);
        }

        protected Map<Property, PropertyChangeEvent> getChangedProperties() {
            HashMap<Property, PropertyChangeEvent> hashMap = new HashMap<Property, PropertyChangeEvent>();
            for (Property property : Property.values()) {
                Object object;
                Object object2 = this.getProperty(property);
                Object object3 = object = this.initProperties == null ? null : this.initProperties.getProperty(property);
                if (ScheduleWhenModel.areEqual(object, object2)) continue;
                hashMap.put(property, new PropertyChangeEvent(this, property.toString(), object, object2));
            }
            return hashMap;
        }

        protected boolean firePropertyChangeListeners(Properties properties) {
            boolean bl = false;
            for (Property property : Property.values()) {
                Object object = this.getProperty(property);
                Object object2 = properties.getProperty(property);
                if (ScheduleWhenModel.areEqual(object2, object)) continue;
                bl = true;
                ScheduleWhenModel.this.firePropertyChangeListeners(property, object2, object);
            }
            return bl;
        }

        protected Map<Property, Object> getProperties() {
            return (Map)this.propertyMap.clone();
        }
    }

    public static enum Property {
        EVENT_TYPE,
        SCHEDULE_TYPE,
        REPEAT_INTERVAL(EventType.REPEATING),
        EVENT_QUEUE_OWNER(EventType.QUEUE_EVENT),
        EVENT_QUEUE_NAME(EventType.QUEUE_EVENT),
        EVENT_QUEUE_AGENT(EventType.QUEUE_EVENT),
        FILE_WATCHER_OWNER(EventType.FILE_EVENT),
        FILE_WATCHER_NAME(EventType.FILE_EVENT),
        SCHEDULE_OWNER(EventType.NAMED_SCHEDULE, new ScheduleType[]{ScheduleType.NAMED, ScheduleType.WINDOW, ScheduleType.WINDOW_GROUP}),
        SCHEDULE_NAME(EventType.NAMED_SCHEDULE, new ScheduleType[]{ScheduleType.NAMED, ScheduleType.WINDOW, ScheduleType.WINDOW_GROUP}),
        EVENT_CONDITION(EventType.QUEUE_EVENT, new ScheduleType[]{ScheduleType.EVENT}),
        START_DATE(EventType.DELAYED, new ScheduleType[]{ScheduleType.ONCE, ScheduleType.CALENDAR, ScheduleType.EVENT}),
        END_DATE(EventType.REPEATING, new ScheduleType[]{ScheduleType.CALENDAR, ScheduleType.EVENT});

        private final EventType defaultEventType;
        private final Set<ScheduleType> validIn;

        private Property() {
            this(null);
        }

        private Property(EventType eventType) {
            this(eventType, null);
        }

        private Property(EventType eventType, ScheduleType[] scheduleTypeArray) {
            this.defaultEventType = eventType;
            if (scheduleTypeArray != null) {
                this.validIn = new TreeSet<ScheduleType>();
                for (ScheduleType scheduleType : scheduleTypeArray) {
                    this.validIn.add(scheduleType);
                }
            } else {
                this.validIn = null;
            }
        }

        public boolean isValidForEventType(EventType eventType) {
            return eventType != null && (this == SCHEDULE_TYPE || this == EVENT_TYPE || this.defaultEventType == eventType || this.validIn != null && this.validIn.contains((Object)eventType.getScheduleType()));
        }

        public EventType getCompatibleEventType(EventType eventType) {
            if (this.isValidForEventType(eventType)) {
                return eventType;
            }
            return this.defaultEventType;
        }

        protected Object castToValue(Object object) {
            Object object2 = object;
            if (object2 != null) {
                switch (this) {
                    case SCHEDULE_TYPE: {
                        ScheduleType scheduleType = (ScheduleType)((Object)object2);
                        object2 = scheduleType;
                        break;
                    }
                    case EVENT_TYPE: {
                        EventType eventType = (EventType)((Object)object2);
                        object2 = eventType;
                        break;
                    }
                    case START_DATE: 
                    case END_DATE: {
                        OraTIMESTAMPTZ oraTIMESTAMPTZ = (OraTIMESTAMPTZ)object2;
                        object2 = oraTIMESTAMPTZ.clone();
                        break;
                    }
                    default: {
                        String string = (String)object2;
                        object2 = string;
                    }
                }
            }
            return object2;
        }

        public String getValueName() {
            return ScheduleWhenModel.formatValueName(this.toString());
        }

        public Object getValueFromRS(OracleResultSet oracleResultSet) throws SQLException {
            return this.getValueFromRS(oracleResultSet, null);
        }

        public Object getValueFromRS(OracleResultSet oracleResultSet, Connection connection) throws SQLException {
            String string = this.toString();
            switch (this) {
                case SCHEDULE_TYPE: {
                    return Property.getScheduleTypeFromRS(oracleResultSet, string);
                }
                case START_DATE: 
                case END_DATE: {
                    return Property.getCalendarFromRS(oracleResultSet, string, connection);
                }
            }
            return Property.getStringFromRS(oracleResultSet, string);
        }

        protected static OraTIMESTAMPTZ getCalendarFromRS(OracleResultSet oracleResultSet, String string, Connection connection) throws SQLException {
            OraTIMESTAMPTZ oraTIMESTAMPTZ = null;
            TIMESTAMPTZ tIMESTAMPTZ = oracleResultSet.getTIMESTAMPTZ(string);
            if (tIMESTAMPTZ != null && (oraTIMESTAMPTZ = OraTIMESTAMPTZ.getInstance((TIMESTAMPTZ)tIMESTAMPTZ)).getNanos() == 0) {
                oraTIMESTAMPTZ.setPrecision(OraTemporalDatum.Precision.SECOND);
            }
            return oraTIMESTAMPTZ;
        }

        protected static String getStringFromRS(OracleResultSet oracleResultSet, String string) throws SQLException {
            return oracleResultSet.getString(string);
        }

        protected static ScheduleType getScheduleTypeFromRS(OracleResultSet oracleResultSet, String string) throws SQLException {
            ScheduleType scheduleType = null;
            String string2 = Property.getStringFromRS(oracleResultSet, string);
            if (string2 != null) {
                scheduleType = ScheduleType.valueOf(string2);
            }
            return scheduleType;
        }
    }

    public static enum EventType {
        NAMED_SCHEDULE(ScheduleType.NAMED, TriggerType.SCHEDULE),
        NAMED_WINDOW(ScheduleType.WINDOW, TriggerType.WINDOW),
        NAMED_WINDOW_GROUP(ScheduleType.WINDOW_GROUP, TriggerType.WINDOW_GROUP),
        REPEATING(ScheduleType.CALENDAR, TriggerType.CALENDAR),
        DELAYED(ScheduleType.ONCE, TriggerType.CALENDAR),
        IMMEDIATE(ScheduleType.IMMEDIATE, TriggerType.ON_DEMAND),
        QUEUE_EVENT(ScheduleType.EVENT, TriggerType.QUEUE),
        FILE_EVENT(ScheduleType.EVENT, TriggerType.FILE);

        private ScheduleType scheduleType;
        private TriggerType triggerType;

        private EventType(ScheduleType scheduleType, TriggerType triggerType) {
            this.scheduleType = scheduleType;
            this.triggerType = triggerType;
        }

        public ScheduleType getScheduleType() {
            return this.scheduleType;
        }

        public TriggerType getTriggerType() {
            return this.triggerType;
        }

        public static EventType getEventType(ScheduleType scheduleType, TriggerType triggerType) {
            for (EventType eventType : EventType.values()) {
                if (eventType.getScheduleType() != scheduleType || eventType.getTriggerType() != triggerType) continue;
                return eventType;
            }
            return null;
        }

        public static EventType defaultEventType(ScheduleType scheduleType) {
            for (EventType eventType : EventType.values()) {
                if (eventType.getScheduleType() != scheduleType) continue;
                return eventType;
            }
            return null;
        }

        public static EventType defaultEventType(TriggerType triggerType) {
            for (EventType eventType : EventType.values()) {
                if (eventType.getTriggerType() != triggerType) continue;
                return eventType;
            }
            return null;
        }
    }

    public static enum TriggerType {
        SCHEDULE,
        WINDOW,
        WINDOW_GROUP,
        CALENDAR,
        ON_DEMAND,
        QUEUE,
        FILE;

    }

    public static enum ScheduleType {
        NAMED,
        WINDOW,
        WINDOW_GROUP,
        CALENDAR,
        ONCE,
        IMMEDIATE,
        EVENT;

    }
}

