/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.dbdestination;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.NameBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.ActionDialogBase;
import oracle.dbtools.scheduler.panels.common.ObjectNameValidator;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IdentifierImpl;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;

public class DBDestinationCreateAction
extends ActionDialogBase {
    public static final String OWNER = "owner";
    public static final String NAME = "destination_name";
    public static final String CONNECT_INFO = "connect_info";
    public static final String AGENT = "agent";
    public static final String ENABLED = "enabled";
    public static final String COMMENTS = "comments";
    public static final String NAME_VALID_MSG = "namevalidmsg";
    public static final String AGENT_VALID_MSG = "agentvalidmsg";
    public static final String CONNECT_INFO_VALID_MSG = "connect_infovalidmsg";
    public static final String SCHEMA_LIST = "schemaList";
    boolean showOwner = false;
    String owner = null;
    String dest_name = null;
    String connect_info = null;
    String agent = null;
    Boolean enabled = Boolean.TRUE;
    String comments = null;
    ActionControl ownerCtl = null;
    NameBoxActionControl nameCtl = null;
    ActionControl conInfoCtl = null;
    ActionControl agentCtl = null;
    ActionControl enabledCtl = null;
    ActionControl commentsCtl = null;

    public DBDestinationCreateAction() {
        this.setScriptEditingEnabled(false);
    }

    protected String getTitle() {
        return SchedulerArb.getString("DB_DESTINATION_CREATE_TITLE");
    }

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListTask();
    }

    @Override
    protected String getObjectType() {
        return "SCHDBDESTINATION";
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    protected String getQuery(Connection connection, String string) {
        String string2 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        return dBMSSchedulerCodeGenerator.generate(string2, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        Operation operation;
        block18: {
            String string;
            block19: {
                String string2;
                operation = this.getOperation();
                try {
                    string2 = this.getObjectName();
                }
                catch (Exception exception) {
                    string2 = "null";
                }
                try {
                    string = this.getDBObjectSchemaName();
                    if (string == null) {
                        string = this.getDBObject().getSchemaName();
                    }
                }
                catch (Exception exception) {
                    string = "null";
                }
                if (operation == Operation.CREATE_NEW) break block19;
                if (!Connections.getInstance().lock(connection)) break block18;
                object = null;
                try {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("OBJECT_NAME", string2);
                    hashMap.put("OBJECT_OWNER", string);
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    object = dBUtil.executeOracleQuery(this.getQuery(connection, "DB_DESTINATION_DATA"), hashMap);
                    if (object != null && object.next()) {
                        this.owner = object.getString("OWNER");
                        this.dest_name = object.getString("DESTINATION_NAME");
                        this.connect_info = object.getString("CONNECT_INFO");
                        this.agent = object.getString("AGENT");
                        this.enabled = object.getString("ENABLED") == null ? null : Boolean.valueOf(object.getString("ENABLED").equalsIgnoreCase("true"));
                        this.comments = object.getString("COMMENTS");
                    }
                    DBUtil.closeResultSet((ResultSet)object);
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    break block18;
                }
                finally {
                    DBUtil.closeResultSet(object);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
                break block18;
            }
            this.owner = string;
        }
        switch (operation) {
            case UPDATE: {
                this.ownerCtl = new TextBoxActionControl(OWNER, SchedulerArb.getString("DB_DESTINATION_OWNER_LABEL"), this.owner);
                this.ownerCtl.setEditable(false);
                object = ObjectNameValidator.displayName(this.dest_name);
                this.nameCtl = new NameBoxActionControl(NAME, SchedulerArb.getString("DB_DESTINATION_DESTINATION_NAME_LABEL"), (String)object);
                this.nameCtl.setEditable(false);
                this.conInfoCtl = new TextBoxActionControl(CONNECT_INFO, SchedulerArb.getString("DB_DESTINATION_CONNECTION_INFO_LABEL"), this.connect_info);
                this.agentCtl = new SqlComboBoxActionControl(AGENT, SchedulerArb.getString("DB_DESTINATION_AGENT_LABEL"), connection, this.getQuery(connection, "AGENT_LIST"), this.agent);
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("DB_DESTINATION_ENABLED_LABEL"), this.enabled.booleanValue(), false);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("DB_DESTINATION_COMMENTS_LABEL"), this.comments);
                break;
            }
            case CREATE_LIKE: {
                this.ownerCtl = new SqlComboBoxActionControl(OWNER, SchedulerArb.getString("DB_DESTINATION_OWNER_LABEL"), connection, this.getQuery(connection, "SCHEMAS_LIST"), null, this.owner);
                this.nameCtl = new NameBoxActionControl(NAME, SchedulerArb.getString("DB_DESTINATION_DESTINATION_NAME_LABEL"), "");
                this.conInfoCtl = new TextBoxActionControl(CONNECT_INFO, SchedulerArb.getString("DB_DESTINATION_CONNECTION_INFO_LABEL"), this.connect_info);
                this.agentCtl = new SqlComboBoxActionControl(AGENT, SchedulerArb.getString("DB_DESTINATION_AGENT_LABEL"), connection, this.getQuery(connection, "AGENT_LIST"), this.agent);
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("DB_DESTINATION_ENABLED_LABEL"), this.enabled.booleanValue(), false);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("DB_DESTINATION_COMMENTS_LABEL"), this.comments);
                break;
            }
            case CREATE_NEW: {
                this.ownerCtl = new SqlComboBoxActionControl(OWNER, SchedulerArb.getString("DB_DESTINATION_OWNER_LABEL"), connection, this.getQuery(connection, "SCHEMAS_LIST"), null, this.owner);
                this.nameCtl = new NameBoxActionControl(NAME, SchedulerArb.getString("DB_DESTINATION_DESTINATION_NAME_LABEL"), this.dest_name);
                this.conInfoCtl = new TextBoxActionControl(CONNECT_INFO, SchedulerArb.getString("DB_DESTINATION_CONNECTION_INFO_LABEL"), this.connect_info);
                this.agentCtl = new SqlComboBoxActionControl(AGENT, SchedulerArb.getString("DB_DESTINATION_AGENT_LABEL"), connection, this.getQuery(connection, "AGENT_LIST"), this.agent);
                this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("DB_DESTINATION_ENABLED_LABEL"), this.enabled.booleanValue(), false);
                this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("DB_DESTINATION_COMMENTS_LABEL"), this.comments);
            }
        }
        object = new ArrayList<Object>();
        if (this.showOwner) {
            ((ArrayList)object).add(this.ownerCtl);
        } else {
            this.ownerCtl = new TextBoxActionControl(OWNER, SchedulerArb.getString("DB_DESTINATION_OWNER_LABEL"), this.owner);
        }
        ((ArrayList)object).add(this.nameCtl);
        ((ArrayList)object).add(this.enabledCtl);
        ((ArrayList)object).add(this.commentsCtl);
        ((ArrayList)object).add(this.conInfoCtl);
        ((ArrayList)object).add(this.agentCtl);
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        Object object;
        Operation operation = this.getOperation();
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = this.ownerCtl.getValue().get();
        String string3 = values.get(NAME);
        string3 = ObjectNameValidator.validateName(string3);
        String string4 = values.get(CONNECT_INFO);
        String string5 = values.get(AGENT);
        Boolean bl = values.get(ENABLED) == null ? Boolean.FALSE.booleanValue() : values.get(ENABLED).equalsIgnoreCase("true");
        String string6 = values.get(COMMENTS);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string2 != null) {
            string2 = string2.trim();
            object = new IdentifierImpl(string2);
            string2 = ((IdentifierImpl)object).getId();
        }
        if (string3 != null) {
            string3 = string3.trim();
            object = new IdentifierImpl(string3);
            string3 = ((IdentifierImpl)object).getId();
        }
        if (string4 != null && string4.length() == 0) {
            string4 = null;
        }
        if (string5 != null && string5.length() == 0) {
            string5 = null;
        }
        if (string6 != null && string6.length() == 0) {
            string6 = null;
        }
        object = new TreeMap();
        object.put(OWNER, string2);
        object.put(NAME, string3);
        object.put(CONNECT_INFO, string4);
        object.put(AGENT, string5);
        object.put(ENABLED, bl);
        object.put(COMMENTS, string6);
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        treeMap.put(OWNER, DBDestinationCreateAction.equals(string2, this.owner) == false);
        treeMap.put(NAME, DBDestinationCreateAction.equals(string3, this.dest_name) == false);
        treeMap.put(CONNECT_INFO, DBDestinationCreateAction.equals(string4, this.connect_info) == false);
        treeMap.put(AGENT, DBDestinationCreateAction.equals(string5, this.agent) == false);
        treeMap.put(ENABLED, DBDestinationCreateAction.equals(bl, this.enabled) == false);
        treeMap.put(COMMENTS, DBDestinationCreateAction.equals(string6, this.comments) == false);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("model", object);
        treeMap2.put("changes", treeMap);
        String string7 = null;
        switch (operation) {
            case UPDATE: {
                string7 = dBMSSchedulerCodeGenerator.generate(string, "DB_DESTINATION_UPDATE", treeMap2);
                break;
            }
            case CREATE_LIKE: {
                string7 = dBMSSchedulerCodeGenerator.generate(string, "DB_DESTINATION_CREATE", treeMap2);
                break;
            }
            case CREATE_NEW: {
                string7 = dBMSSchedulerCodeGenerator.generate(string, "DB_DESTINATION_CREATE", treeMap2);
            }
        }
        return string7;
    }

    private static Boolean equals(Object object, Object object2) {
        if (object == null || object2 == null) {
            return Boolean.FALSE;
        }
        return object.equals(object2);
    }

    protected boolean isCloseOnError() {
        return false;
    }

    public boolean isEnabled(Context context) {
        Version version = new Version("11.2");
        return DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version) && super.isEnabled(context);
    }

    protected void initializeValues(JEWTDialog jEWTDialog) {
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_newDBDestinationDialog_html");
    }

    private class ListTask
    extends DatabaseQueryTask<List<String>> {
        public ListTask() {
            super("ListTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return DBDestinationCreateAction.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = dBMSSchedulerCodeGenerator.generate(DBDestinationCreateAction.this.getDBObject().getDBVersion(), "DB_DESTINATION_LIST", null);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector;
            block9: {
                vector = new Vector<String>();
                Connection connection = DBDestinationCreateAction.this.getDBObject().getConnection();
                DBUtil.getConnectionResolver().lock(connection);
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    ResultSet resultSet = dBUtil.executeOracleQuery(this.getQuery(), null);
                    if (resultSet == null) break block9;
                    try {
                        while (resultSet.next()) {
                            String string = resultSet.getString("OWNER") + "." + resultSet.getString("DESTINATION_NAME");
                            vector.add(string);
                        }
                    }
                    finally {
                        DBUtil.closeResultSet((ResultSet)resultSet);
                    }
                }
                catch (Throwable throwable) {
                    throw new TaskException(throwable);
                }
                finally {
                    DBUtil.getConnectionResolver().unlock(connection);
                }
            }
            return vector;
        }
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        UPDATE;

    }
}

