/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.metadata.util.MetadataProviderUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoXmlKeyUtil {
    private static final String _PSEUDO_XML_KEY_NAME = "pseudoXmlKey";
    private static final String _ID_NAME = "id";
    private Element _pseudoXmlKeys;
    private Collection<String> _identifiers;
    private Map _metadataValues;

    public PseudoXmlKeyUtil(Element pseudoXmlKeys) {
        this._pseudoXmlKeys = pseudoXmlKeys;
    }

    public Collection<String> getPseudoXmlKeyIdentifiers() {
        if (this._identifiers == null) {
            this._init();
        }
        return this._identifiers;
    }

    public Map getMetadataMap(String identifier) {
        Map metadataMap;
        if (this._metadataValues == null) {
            this._init();
        }
        if ((metadataMap = (Map)this._metadataValues.get(identifier)) == null) {
            metadataMap = Collections.EMPTY_MAP;
        }
        return metadataMap;
    }

    private void _init() {
        this._identifiers = new LinkedList<String>();
        this._metadataValues = new HashMap();
        for (Node child = this._pseudoXmlKeys.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element pseudoXmlKey;
            String id;
            if (!_PSEUDO_XML_KEY_NAME.equals(DomUtils.getLocalName(child)) || !"http://xmlns.oracle.com/bali/xml/metadata".equals(child.getNamespaceURI()) || child.getNodeType() != 1 || (id = (pseudoXmlKey = (Element)child).getAttribute(_ID_NAME)) == null || "".equals(id)) continue;
            this._identifiers.add(id);
            HashMap metadataMap = new HashMap();
            for (Node metadataItem = pseudoXmlKey.getFirstChild(); metadataItem != null; metadataItem = metadataItem.getNextSibling()) {
                if (metadataItem.getNodeType() != 1) continue;
                MetadataProviderUtils.addMetadataToMap(metadataMap, (Element)metadataItem);
            }
            this._metadataValues.put(id, metadataMap);
        }
    }
}

