/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.IdentityConstraint;
import oracle.bali.xml.grammar.SubstitutionGroup;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.common.AbstractElementDef;
import oracle.bali.xml.grammar.schema.OracleAnnotation;
import oracle.bali.xml.grammar.schema.OracleIdentityConstraint;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDIdentity;
import oracle.xml.parser.schema.XSDNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleElementDef
extends AbstractElementDef {
    private OracleSchemaFactory _factory = null;
    private XSDElement _xsdElement = null;
    private volatile Type _type = null;
    private volatile SubstitutionGroup _substitutionGroup = null;
    private volatile Annotation _annotation = null;
    private volatile ElementDef _referencedElementDef = null;
    private volatile boolean _referencedElementDefResolved = false;
    private Object _substitutionGroupLock = new Object();
    private Object _referencedElementLock = new Object();
    private volatile Collection _identityConstraints = null;

    @Override
    public String getTargetNamespace() {
        String namespace = this._xsdElement.getTargetNS();
        if (namespace != null && namespace.length() == 0) {
            return null;
        }
        return namespace;
    }

    @Override
    public String getName() {
        return this._xsdElement.getName();
    }

    @Override
    public SubstitutionGroup getSubstitutionGroup() {
        return this._getSubstitutionGroup();
    }

    @Override
    public Type getType() {
        return this._getType();
    }

    @Override
    public boolean isAbstract() {
        return this._xsdElement.isAbstract();
    }

    @Override
    public boolean isReference() {
        ElementDef reference = this.getReferencedElementDef();
        return reference != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementDef getReferencedElementDef() {
        if (!this._referencedElementDefResolved && this._referencedElementDef == null) {
            Object object = this._referencedElementLock;
            synchronized (object) {
                if (!this._referencedElementDefResolved && this._referencedElementDef == null) {
                    int refState = this._xsdElement.getRefState();
                    String refLocalName = this._xsdElement.getRefLocalname();
                    if (refState != 0 && refState != 1 || refLocalName == null) {
                        this._referencedElementDefResolved = true;
                        this._referencedElementDef = null;
                    } else {
                        String refNamespace = this._xsdElement.getRefNamespace();
                        ElementDef referencedElementDef = this._factory.resolveElementReference(refNamespace, refLocalName);
                        this._referencedElementDef = referencedElementDef == this ? null : referencedElementDef;
                    }
                }
            }
        }
        return this._referencedElementDef;
    }

    @Override
    public int getMinOccurs() {
        return this._xsdElement.getMinOccurs();
    }

    @Override
    public int getMaxOccurs() {
        int maxOccurs = this._xsdElement.getMaxOccurs();
        if (0x7FFFFFF8 == maxOccurs) {
            maxOccurs = -1;
        }
        return maxOccurs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Annotation getAnnotation() {
        if (this._annotation == null) {
            OracleElementDef oracleElementDef = this;
            synchronized (oracleElementDef) {
                if (this._annotation == null) {
                    this._annotation = new OracleAnnotation((XSDNode)this._xsdElement);
                }
            }
        }
        return this._annotation;
    }

    @Override
    public String getDefaultValue() {
        return this._xsdElement.getDefaultVal();
    }

    @Override
    public String getFixedValue() {
        return this._xsdElement.getFixedVal();
    }

    @Override
    public boolean hasIdentityConstraints() {
        return this._xsdElement.hasIdentityConstraints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IdentityConstraint> getIdentityConstraints() {
        if (this._identityConstraints == null) {
            OracleElementDef oracleElementDef = this;
            synchronized (oracleElementDef) {
                if (this._identityConstraints == null) {
                    this._identityConstraints = new ArrayList();
                    if (this._xsdElement.getIdentities() != null) {
                        for (XSDIdentity xsdIdentity : this._xsdElement.getIdentities()) {
                            OracleIdentityConstraint identityConstraint = new OracleIdentityConstraint(xsdIdentity, this._factory, this, this._xsdElement);
                            if (identityConstraint.getType().equals((Object)IdentityConstraint.ConstraintType.KEY) && identityConstraint.getName() != null) {
                                this._factory.addKeyIdentityConstraint(identityConstraint.getName(), identityConstraint);
                            }
                            this._identityConstraints.add(identityConstraint);
                        }
                    }
                }
            }
        }
        return this._identityConstraints;
    }

    OracleElementDef(OracleSchemaFactory factory, XSDElement xsdElement) {
        this._factory = factory;
        this._xsdElement = xsdElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type _getType() {
        if (this._type == null) {
            OracleElementDef oracleElementDef = this;
            synchronized (oracleElementDef) {
                XSDNode xsdType;
                if (this._type == null && (xsdType = this._xsdElement.getType()) != null) {
                    this._type = this._factory.getTypeWrapper(xsdType);
                }
            }
        }
        return this._type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubstitutionGroup _getSubstitutionGroup() {
        if (this._substitutionGroup == null) {
            Object object = this._substitutionGroupLock;
            synchronized (object) {
                if (this._substitutionGroup == null) {
                    ElementDef referencedElementDef = this.getReferencedElementDef();
                    if (referencedElementDef != null) {
                        this._substitutionGroup = referencedElementDef.getSubstitutionGroup();
                    } else {
                        SubstitutionGroup substitutionGroup = new SubstitutionGroup();
                        Vector equivClass = this._xsdElement.getSubstitutionGroup();
                        if (equivClass != null) {
                            for (int i = 0; i < equivClass.size(); ++i) {
                                XSDElement aSubstitute = (XSDElement)equivClass.elementAt(i);
                                OracleElementDef wrapper = this._factory.getElementWrapper(aSubstitute);
                                if (wrapper.isAbstract() || wrapper.getName() == null) continue;
                                substitutionGroup.addElementDef(wrapper);
                            }
                        }
                        this._substitutionGroup = substitutionGroup;
                        this._factory.addElementDefWithSubstitutionGroup(this);
                    }
                }
            }
        }
        return this._substitutionGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSubstitutionGroup() {
        Object object = this._substitutionGroupLock;
        synchronized (object) {
            Vector equivClass = this._xsdElement.getSubstitutionGroup();
            if (equivClass != null) {
                for (int i = 0; i < equivClass.size(); ++i) {
                    XSDElement aSubstitute = (XSDElement)equivClass.elementAt(i);
                    OracleElementDef wrapper = this._factory.getElementWrapper(aSubstitute);
                    if (this._substitutionGroup.containsElementDef(wrapper) || wrapper.isAbstract() || wrapper.getName() == null) continue;
                    this._substitutionGroup.addElementDef(wrapper);
                }
            }
        }
    }
}

