/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.traversal;

import oracle.bali.xml.dom.traversal.TreeTraversal;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public abstract class TreeTraversalTreeWalker
implements TreeWalker {
    private Node _currNode;

    protected abstract TreeTraversal getTreeTraversal();

    public int getWhatToShow() {
        return -1;
    }

    public NodeFilter getFilter() {
        throw new UnsupportedOperationException();
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public Node getCurrentNode() {
        if (this._currNode == null) {
            this._currNode = this.getRoot();
        }
        return this._currNode;
    }

    public void setCurrentNode(Node currentNode) throws DOMException {
        if (currentNode == null) {
            throw new DOMException(9, "Can't set current node to null");
        }
        this._currNode = currentNode;
    }

    public Node parentNode() {
        Node parentNode = this._parentNode(this._currNode);
        if (parentNode != null) {
            this._currNode = parentNode;
        }
        return parentNode;
    }

    public Node firstChild() {
        Node firstChild = this.getTreeTraversal().getFirstChild(this._currNode);
        if (firstChild != null) {
            this._currNode = firstChild;
        }
        return firstChild;
    }

    public Node lastChild() {
        Node lastChild = this.getTreeTraversal().getLastChild(this._currNode);
        if (lastChild != null) {
            this._currNode = lastChild;
        }
        return lastChild;
    }

    public Node previousSibling() {
        Node previousSibling = this.getTreeTraversal().getPreviousSibling(this._currNode);
        if (previousSibling != null) {
            this._currNode = previousSibling;
        }
        return previousSibling;
    }

    public Node nextSibling() {
        Node nextSibling = this.getTreeTraversal().getNextSibling(this._currNode);
        if (nextSibling != null) {
            this._currNode = nextSibling;
        }
        return nextSibling;
    }

    public Node previousNode() {
        Node previousNode = this.getTreeTraversal().getPreviousNode(this._currNode);
        if (previousNode != null) {
            this._currNode = previousNode;
        }
        return previousNode;
    }

    public Node nextNode() {
        Node nextNode = this.getTreeTraversal().getNextNode(this._currNode);
        if (nextNode != null) {
            this._currNode = nextNode;
        }
        return nextNode;
    }

    public Node _parentNode(Node node) {
        TreeTraversal strategy = this.getTreeTraversal();
        Node parentNode = strategy.getParentNode(node);
        if (parentNode != null) {
            Node rootNode = this.getRoot();
            if (rootNode == null) {
                return parentNode;
            }
            do {
                if ((rootNode = strategy.getParentNode(rootNode)) != parentNode) continue;
                return null;
            } while (rootNode != null);
        }
        return parentNode;
    }
}

