/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditor;
import java.beans.VetoableChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlTableEditor;
import oracle.bali.xml.gui.swing.xmlComponent.XmlCheckBoxEditor;
import oracle.bali.xml.gui.swing.xmlComponent.XmlContextualActionButton;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableEditor;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.javatools.ui.ExtendedTextField;
import org.w3c.dom.Node;

public class XmlTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final String EMPTY_STRING = "";
    private XmlContext _xmlContext;
    private XmlKey _xmlKey;
    private NodeResolver _nodeResolver;
    private NodeResolver _OwnerNodeResolver;
    private AbstractXmlTableEditor.FocusLostBehavior mFocusLostBehavior;
    private MyFocusDispatcher _focusDispatcher;
    private MyFocusLostListener _focusLostListener;
    private boolean _isEditing = false;
    private String _initialValue = null;
    private String mCurrentValue = null;
    private XmlComponentWrapper _xmlComponentWrapper;
    private XmlTextComponent _xmlTextComponent = null;
    private boolean _isActiveCustomEditor = false;

    public XmlTableCellEditor(XmlContext xmlContext, XmlKey xmlKey, Node node, Node ownerNode, AbstractXmlTableEditor.FocusLostBehavior focusLostBehavior, XmlComponentWrapper xmlComponentWrapper) {
        this._xmlContext = xmlContext;
        this._xmlKey = xmlKey;
        this._nodeResolver = new SimpleNodeResolver(node);
        this._OwnerNodeResolver = new SimpleNodeResolver(ownerNode);
        this.mFocusLostBehavior = focusLostBehavior;
        this._xmlComponentWrapper = xmlComponentWrapper;
    }

    public XmlContext getXmlContext() {
        return this._xmlContext;
    }

    public XmlKey getXmlKey() {
        return this._xmlKey;
    }

    public NodeResolver getNodeResolver() {
        return this._nodeResolver;
    }

    public NodeResolver getOwnerNodeResolver() {
        return this._OwnerNodeResolver;
    }

    public AbstractXmlTableEditor.FocusLostBehavior getFocusLostBehavior() {
        return this.mFocusLostBehavior;
    }

    @Override
    public Object getCellEditorValue() {
        return this.mCurrentValue;
    }

    public void setCurrentValue(Object currentValue) {
        this.mCurrentValue = (String)currentValue;
    }

    public XmlComponentWrapper getXmlComponentWrapper() {
        return this._xmlComponentWrapper;
    }

    public String getInitialValue() {
        return this._initialValue;
    }

    public void setInitialValue(String value) {
        this._initialValue = value;
    }

    public boolean useComboBox() {
        return this.getXmlComponentWrapper().getXmlWrappedComponent().getWrappedComponent() instanceof JComboBox;
    }

    public boolean useToggleButton() {
        return this.getXmlComponentWrapper().getXmlWrappedComponent().getWrappedComponent() instanceof JToggleButton;
    }

    public XmlTextComponent getXmlTextComponent() {
        return this._xmlTextComponent;
    }

    public void setXmlTextComponent(XmlTextComponent xmlTextComponent) {
        this._xmlTextComponent = xmlTextComponent;
    }

    public boolean isEditing() {
        return this._isEditing;
    }

    public void setIsEditing(boolean isEditing) {
        this._isEditing = isEditing;
    }

    public MyFocusDispatcher getFocusDispatcher() {
        return this._focusDispatcher;
    }

    public void setFocusDispatcher(MyFocusDispatcher focusDispatcher) {
        this._focusDispatcher = focusDispatcher;
    }

    public MyFocusLostListener getFocusLostListener() {
        return this._focusLostListener;
    }

    public void setFocusLostListener(MyFocusLostListener focusLostListener) {
        this._focusLostListener = focusLostListener;
    }

    public boolean useExtendedTextField() {
        return false;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
        this.getXmlComponentWrapper().invalidateXmlComponent();
        this.getXmlComponentWrapper().dispose();
        if (value instanceof Node) {
            this.setInitialValue(((Node)value).getTextContent());
        } else if (value != null) {
            this.setInitialValue(value.toString());
        } else {
            this.setInitialValue(EMPTY_STRING);
        }
        if (this.useComboBox()) {
            XmlComboBox comboBox = new XmlComboBox(this.getXmlContext(), this.getXmlKey(), this.getNodeResolver(), this.getOwnerNodeResolver(), this.getXmlComponentWrapper());
            this.setXmlTextComponent(comboBox);
            this.getXmlTextComponent().initialize();
            this.getXmlTextComponent().setText(this.getInitialValue());
            comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (XmlTableCellEditor.this._isEditing) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                XmlTableCellEditor.this.stopCellEditing();
                            }
                        });
                    }
                }
            });
        } else if (this.useToggleButton()) {
            XmlToggleButton toggleButton = new XmlToggleButton(this.getXmlContext(), this.getXmlKey(), this.getNodeResolver(), this.getOwnerNodeResolver(), this.getXmlComponentWrapper());
            this.setXmlTextComponent(toggleButton);
            this.getXmlTextComponent().initialize();
            this.getXmlTextComponent().setText(this.getInitialValue());
            toggleButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (XmlTableCellEditor.this._isEditing) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                XmlTableCellEditor.this.stopCellEditing();
                            }
                        });
                    }
                }
            });
        } else {
            XmlTextField textField = new XmlTextField(this.getXmlContext(), this.getXmlKey(), this.getNodeResolver(), this.getOwnerNodeResolver(), this.getXmlComponentWrapper());
            this.setXmlTextComponent(textField);
            this.getXmlTextComponent().initialize();
            this.getXmlTextComponent().setText(this.getInitialValue());
            textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (XmlTableCellEditor.this.isEditing()) {
                        XmlTableCellEditor.this.stopCellEditing();
                    }
                }
            });
        }
        if (this.dispatchFocusEvents()) {
            this.setFocusDispatcher(new MyFocusDispatcher(table));
            this.getXmlTextComponent().addFocusListener(this.getFocusDispatcher());
        }
        if (this.useFocusLostListener()) {
            this.setFocusLostListener(new MyFocusLostListener(table));
            this.getXmlTextComponent().addFocusListener(this.getFocusLostListener());
        }
        this.setIsEditing(true);
        table.getSelectionModel().clearSelection();
        table.getSelectionModel().setLeadSelectionIndex(row);
        return this.getXmlTextComponent();
    }

    @Override
    public boolean stopCellEditing() {
        if (this.getXmlTextComponent() == null) {
            return super.stopCellEditing();
        }
        this.getXmlComponentWrapper().getPropertyEditor().updatePropertyValueFromXmlComponent();
        this.mCurrentValue = this.getXmlTextComponent().getText();
        if (!this.getInitialValue().equals(this.mCurrentValue)) {
            if (this.dispatchFocusEvents()) {
                this.getXmlTextComponent().removeFocusListener(this.getFocusDispatcher());
            }
            if (this.useFocusLostListener()) {
                this.getXmlTextComponent().removeFocusListener(this.getFocusLostListener());
            }
            this.setXmlTextComponent(null);
            this.setIsEditing(false);
            return super.stopCellEditing();
        }
        this.cancelCellEditing();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        if (this.dispatchFocusEvents()) {
            this.getXmlTextComponent().removeFocusListener(this.getFocusDispatcher());
        }
        if (this.useFocusLostListener()) {
            this.getXmlTextComponent().removeFocusListener(this.getFocusLostListener());
        }
        this.setXmlTextComponent(null);
        this.setIsEditing(false);
        super.cancelCellEditing();
    }

    public boolean showContextualAction() {
        return true;
    }

    public void addContextualAction(Object container, GridBagConstraints gbc) {
        XmlContextualActionButton xmlContextualActionButton;
        if (this.showContextualAction() && (xmlContextualActionButton = new XmlContextualActionButton(this.getXmlComponentWrapper(), this)).getContextualActionsCount() > 0) {
            ((Container)container).add((Component)xmlContextualActionButton, gbc);
        }
    }

    public boolean dispatchFocusEvents() {
        return false;
    }

    public boolean useFocusLostListener() {
        return false;
    }

    public boolean isActiveCustomEditor() {
        return this._isActiveCustomEditor;
    }

    public void setIsActiveCustomEditor(boolean isActiveCustomEditor) {
        this._isActiveCustomEditor = isActiveCustomEditor;
    }

    protected static class XmlPropertyEditorAction
    extends AbstractAction {
        private static final String EDIT_ACTION_NAME = "Edit...";
        private static final String EDIT_DIALOG_TITLE = "Edit Property - {0}";
        private static final int EDIT_DIALOG_BUTTON_MASK = 3;
        private static final String EMPTY_STRING = "";
        private XmlTextComponentWithPropertyEditor mXmlTextComponent;
        private String mDialogTitle;

        static XmlPropertyEditorAction createXmlPropertyEditorAction(XmlTextComponentWithPropertyEditor xmlTextComponent) {
            boolean supportsCustomEditor = xmlTextComponent.supportsCustomEditor();
            if (supportsCustomEditor) {
                PropertyEditor propertyEditor = xmlTextComponent.getPropertyEditor();
                return new XmlPropertyEditorAction(xmlTextComponent, EDIT_ACTION_NAME, EDIT_DIALOG_TITLE);
            }
            return null;
        }

        protected XmlPropertyEditorAction(XmlTextComponentWithPropertyEditor xmlTextComponent, String name, String dialogTitle) {
            super(name);
            this.mXmlTextComponent = xmlTextComponent;
            this.mDialogTitle = dialogTitle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.mXmlTextComponent.setPropertyEditorContext();
            try {
                boolean result;
                PropertyEditor propertyEditor = this.mXmlTextComponent.getPropertyEditor();
                propertyEditor.setValue(this.mXmlTextComponent.getText());
                Component customEditor = propertyEditor.getCustomEditor();
                String editDialogTitle = FastMessageFormat.formatMessage((String)this.mDialogTitle, (String)this.mXmlTextComponent.getXmlKey().getLocalName());
                int buttonMask = 7;
                String helpId = HelpUtils.getHelpID((Component)customEditor);
                if (helpId == null || helpId.equals(HelpUtils.getDefaultHelpID())) {
                    buttonMask = 3;
                }
                JEWTDialog editDialog = JEWTDialog.createDialog(null, (String)editDialogTitle, (int)buttonMask);
                editDialog.setContent(customEditor);
                if (customEditor instanceof VetoableChangeListener) {
                    editDialog.addVetoableChangeListener((VetoableChangeListener)((Object)customEditor));
                }
                if (result = editDialog.runDialog()) {
                    Object propertyValue = propertyEditor.getValue();
                    if (propertyValue != null) {
                        this.mXmlTextComponent.setText(propertyValue.toString());
                    } else {
                        this.mXmlTextComponent.setText("");
                    }
                    this.mXmlTextComponent.fireActionPerformed();
                }
            }
            finally {
                this.mXmlTextComponent.clearPropertyEditorContext();
            }
        }
    }

    private static interface NodeResolver {
        public Node resolveNode();
    }

    public class XmlTextField
    extends XmlTextComponent {
        private static final String EMPTY_STRING = "";
        private JTextField mTextField;

        public XmlTextField(XmlContext xmlContext, XmlKey xmlKey, Node node, Node ownerNode, XmlComponentWrapper xmlComponentWrapper) {
            this(xmlContext, xmlKey, this$0.new SimpleNodeResolver(node), this$0.new SimpleNodeResolver(ownerNode), xmlComponentWrapper);
        }

        protected XmlTextField(XmlContext xmlContext, XmlKey xmlKey, NodeResolver nodeResolver, NodeResolver ownerNodeResolver, XmlComponentWrapper xmlComponentWrapper) {
            super(xmlContext, xmlKey, nodeResolver, ownerNodeResolver);
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.mTextField = xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent() instanceof ExtendedTextField ? (XmlTableCellEditor.this.useExtendedTextField() ? (JTextField)xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent() : new MyTextField()) : (JTextField)xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 1;
            gbc.insets.set(0, 0, 0, 0);
            gbc.anchor = 21;
            this.add((Component)this.mTextField, gbc);
            gbc.gridx = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.insets.set(0, 0, 0, 0);
            gbc.anchor = 22;
            XmlTableCellEditor.this.addContextualAction(this, gbc);
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            super.addActionListener(actionListener);
            this.mTextField.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            super.removeActionListener(actionListener);
            this.mTextField.removeActionListener(actionListener);
        }

        public void addDocumentListener(DocumentListener documentListener) {
            this.mTextField.getDocument().addDocumentListener(documentListener);
        }

        public void removeDocumentListener(DocumentListener documentListener) {
            this.mTextField.getDocument().removeDocumentListener(documentListener);
        }

        @Override
        public void addFocusListener(FocusListener focusListener) {
            super.addFocusListener(focusListener);
            this.mTextField.addFocusListener(focusListener);
        }

        @Override
        public void removeFocusListener(FocusListener focusListener) {
            super.removeFocusListener(focusListener);
            this.mTextField.removeFocusListener(focusListener);
        }

        @Override
        public void initialize() {
            this.mTextField.setText("");
        }

        public Document getDocument() {
            return this.mTextField.getDocument();
        }

        @Override
        public String getText() {
            return this.mTextField.getText();
        }

        @Override
        public void setText(String text) {
            this.mTextField.setText(text);
            this.fireActionPerformed();
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            InputMap map = this.mTextField.getInputMap(condition);
            ActionMap am = this.mTextField.getActionMap();
            if (map != null && am != null && this.isEnabled()) {
                Action action;
                Object binding = map.get(ks);
                Action action2 = action = binding == null ? null : am.get(binding);
                if (action != null) {
                    return SwingUtilities.notifyAction(action, ks, e, this.mTextField, e.getModifiers());
                }
            }
            return false;
        }

        @Override
        public boolean hasFocus() {
            return this.mTextField.hasFocus();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.mTextField.requestFocus();
            this.mTextField.selectAll();
        }

        private class MyTextField
        extends JTextField {
            private MyTextField() {
            }

            @Override
            public void updateUI() {
                super.updateUI();
                if (!(this.getCaret() instanceof BasicTextUI.BasicCaret)) {
                    this.setCaret(new BasicTextUI.BasicCaret());
                }
            }

            @Override
            public void addNotify() {
                super.addNotify();
                this.requestFocus();
            }
        }
    }

    protected class XmlToggleButton
    extends XmlTextComponentWithPropertyEditor {
        private JToggleButton mToggleButton;

        public XmlToggleButton(XmlContext xmlContext, XmlKey xmlKey, Node node, Node ownerNode, XmlComponentWrapper xmlComponentWrapper) {
            this(xmlContext, xmlKey, (NodeResolver)this$0.new SimpleNodeResolver(node), (NodeResolver)this$0.new SimpleNodeResolver(ownerNode), xmlComponentWrapper);
        }

        public XmlToggleButton(XmlContext xmlContext, XmlKey xmlKey, NodeResolver nodeResolver, NodeResolver ownerNodeResolver, XmlComponentWrapper xmlComponentWrapper) {
            super(xmlContext, xmlKey, nodeResolver, ownerNodeResolver, (PropertyEditor)xmlComponentWrapper.getPropertyEditor());
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            if (this.getPropertyEditor() instanceof XmlCheckBoxEditor) {
                XmlCheckBoxEditor checkBoxEditor = (XmlCheckBoxEditor)((Object)this.getPropertyEditor());
                this.mToggleButton = checkBoxEditor.getRenderAsRadioButton() ? new JRadioButton() : new JCheckBox();
                if (checkBoxEditor.showLabel()) {
                    String labelText = XmlTableCellEditor.this.getXmlComponentWrapper().getXmlComponentModel().getShortDisplayName();
                    this.mToggleButton.setText(StringUtils.stripMnemonic((String)labelText));
                    this.mToggleButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)labelText));
                }
            }
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 1;
            gbc.insets.set(0, 0, 0, 0);
            gbc.anchor = 21;
            this.add((Component)this.mToggleButton, gbc);
            gbc.gridx = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.insets.set(0, 0, 0, 0);
            gbc.anchor = 22;
            XmlTableCellEditor.this.addContextualAction(this, gbc);
        }

        @Override
        public void initialize() {
        }

        @Override
        public String getText() {
            return this.mToggleButton.isSelected() ? "true" : "false";
        }

        @Override
        public void setText(String text) {
            if ("true".equals(text)) {
                this.mToggleButton.setSelected(true);
            } else {
                this.mToggleButton.setSelected(false);
            }
        }

        public void addItemListener(ItemListener itemListener) {
            this.mToggleButton.addItemListener(itemListener);
        }

        public void removeItemListener(ItemListener itemListener) {
            this.mToggleButton.removeItemListener(itemListener);
        }

        @Override
        public void addFocusListener(FocusListener focusListener) {
            super.addFocusListener(focusListener);
            this.mToggleButton.addFocusListener(focusListener);
        }

        @Override
        public void removeFocusListener(FocusListener focusListener) {
            super.removeFocusListener(focusListener);
            this.mToggleButton.removeFocusListener(focusListener);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.mToggleButton.requestFocus();
        }
    }

    protected class XmlComboBox
    extends XmlTextComponentWithPropertyEditor {
        private JComboBox mComboBox;

        public XmlComboBox(XmlContext xmlContext, XmlKey xmlKey, Node node, Node ownerNode, XmlComponentWrapper xmlComponentWrapper) {
            this(xmlContext, xmlKey, (NodeResolver)this$0.new SimpleNodeResolver(node), (NodeResolver)this$0.new SimpleNodeResolver(ownerNode), xmlComponentWrapper);
        }

        public XmlComboBox(XmlContext xmlContext, XmlKey xmlKey, NodeResolver nodeResolver, NodeResolver ownerNodeResolver, XmlComponentWrapper xmlComponentWrapper) {
            super(xmlContext, xmlKey, nodeResolver, ownerNodeResolver, (PropertyEditor)xmlComponentWrapper.getPropertyEditor());
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.mComboBox = (JComboBox)xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 1;
            gbc.insets.set(0, 0, 0, 0);
            gbc.anchor = 21;
            this.add((Component)this.mComboBox, gbc);
            gbc.gridx = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.insets.set(0, 0, 0, 0);
            gbc.anchor = 22;
            XmlTableCellEditor.this.addContextualAction(this, gbc);
        }

        @Override
        public void initialize() {
        }

        @Override
        public String getText() {
            return this.getPropertyEditor().getAsText();
        }

        @Override
        public void setText(String text) {
            this.getPropertyEditor().setAsText(text);
        }

        public void addItemListener(ItemListener itemListener) {
            this.mComboBox.addItemListener(itemListener);
        }

        public void removeItemListener(ItemListener itemListener) {
            this.mComboBox.removeItemListener(itemListener);
        }

        @Override
        public void addFocusListener(FocusListener focusListener) {
            super.addFocusListener(focusListener);
            this.mComboBox.addFocusListener(focusListener);
        }

        @Override
        public void removeFocusListener(FocusListener focusListener) {
            super.removeFocusListener(focusListener);
            this.mComboBox.removeFocusListener(focusListener);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.mComboBox.requestFocus();
        }
    }

    protected abstract class XmlTextComponentWithPropertyEditor
    extends XmlTextComponent {
        private PropertyEditor mPropertyEditor;

        public XmlTextComponentWithPropertyEditor(XmlContext xmlContext, XmlKey xmlKey, Node node, Node ownerNode, PropertyEditor propertyEditor) {
            this(xmlContext, xmlKey, this$0.new SimpleNodeResolver(node), this$0.new SimpleNodeResolver(ownerNode), propertyEditor);
        }

        public XmlTextComponentWithPropertyEditor(XmlContext xmlContext, XmlKey xmlKey, NodeResolver nodeResolver, NodeResolver ownerNodeResolver, PropertyEditor propertyEditor) {
            super(xmlContext, xmlKey, nodeResolver, ownerNodeResolver);
            this.mPropertyEditor = propertyEditor;
        }

        public PropertyEditor getPropertyEditor() {
            return this.mPropertyEditor;
        }

        public boolean supportsCustomEditor() {
            if (this.mPropertyEditor != null) {
                this.setPropertyEditorContext();
                try {
                    boolean bl = this.mPropertyEditor.supportsCustomEditor();
                    return bl;
                }
                finally {
                    this.clearPropertyEditorContext();
                }
            }
            return false;
        }

        public void setPropertyEditorContext() {
            PropertyEditorContext context = PropertyEditorContext.create((XmlContext)this.getXmlContext(), (XmlKey)this.getXmlKey(), (Node)this.getNode(), (Node)this.getOwnerNode(), (XmlKey)this.getXmlKey(), (Node)this.getOwnerNode(), (Node)this.getOwnerNode());
            PropertyEditorContext.setContext((Object)this.mPropertyEditor, (PropertyEditorContext)context);
        }

        public void clearPropertyEditorContext() {
            PropertyEditorContext.clearContext((Object)this.mPropertyEditor);
        }
    }

    public abstract class XmlTextComponent
    extends JPanel {
        private XmlContext _xmlContext;
        private XmlKey _xmlKey;
        private NodeResolver _nodeResolver;
        private NodeResolver _ownerNodeResolver;
        private List<ActionListener> mActionListeners = new CopyOnWriteArrayList<ActionListener>();

        public XmlTextComponent(XmlContext xmlContext, XmlKey xmlKey, Node node, Node ownerNode) {
            this(xmlContext, xmlKey, this$0.new SimpleNodeResolver(node), this$0.new SimpleNodeResolver(ownerNode));
        }

        public XmlTextComponent(XmlContext xmlContext, XmlKey xmlKey, NodeResolver nodeResolver, NodeResolver ownerNodeResolver) {
            this._xmlContext = xmlContext;
            this._xmlKey = xmlKey;
            this._nodeResolver = nodeResolver;
            this._ownerNodeResolver = ownerNodeResolver;
        }

        public abstract void initialize();

        public abstract String getText();

        public abstract void setText(String var1);

        public XmlContext getXmlContext() {
            return this._xmlContext;
        }

        public XmlKey getXmlKey() {
            return this._xmlKey;
        }

        public Node getNode() {
            return this._nodeResolver == null ? null : this._nodeResolver.resolveNode();
        }

        public Node getOwnerNode() {
            return this._ownerNodeResolver == null ? null : this._ownerNodeResolver.resolveNode();
        }

        public void addActionListener(ActionListener actionListener) {
            this.mActionListeners.add(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.mActionListeners.remove(actionListener);
        }

        public void fireActionPerformed() {
            ActionEvent actionEvent = new ActionEvent(this, 0, null);
            for (ActionListener actionListener : this.mActionListeners) {
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    private class SimpleNodeResolver
    implements NodeResolver {
        private Node mNode;

        public SimpleNodeResolver() {
            this.mNode = null;
        }

        public SimpleNodeResolver(Node node) {
            this.mNode = node;
        }

        public void setNode(Node node) {
            this.mNode = node;
        }

        @Override
        public Node resolveNode() {
            return this.mNode;
        }
    }

    protected class MyFocusLostListener
    implements FocusListener {
        private JTable mTable;

        MyFocusLostListener(JTable table) {
            this.mTable = table;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            TableCellEditor cellEditor;
            Component oppositeComponent;
            if (XmlTableCellEditor.this.mFocusLostBehavior != null && XmlTableCellEditor.this.mFocusLostBehavior != AbstractXmlTableEditor.FocusLostBehavior.DO_NOTHING && !this.mTable.isAncestorOf(oppositeComponent = focusEvent.getOppositeComponent()) && (cellEditor = this.mTable.getCellEditor()) != null) {
                if (XmlTableCellEditor.this.mFocusLostBehavior == AbstractXmlTableEditor.FocusLostBehavior.STOP_CELL_EDITING) {
                    cellEditor.stopCellEditing();
                } else if (XmlTableCellEditor.this.mFocusLostBehavior == AbstractXmlTableEditor.FocusLostBehavior.CANCEL_CELL_EDITING) {
                    cellEditor.cancelCellEditing();
                }
            }
        }
    }

    protected class MyFocusDispatcher
    implements FocusListener {
        private JTable mTable;

        MyFocusDispatcher(JTable table) {
            this.mTable = table;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component oppositeComponent = focusEvent.getOppositeComponent();
            if (oppositeComponent != null && XmlTableCellEditor.this._xmlTextComponent != null && !XmlTableCellEditor.this._xmlTextComponent.isAncestorOf(oppositeComponent)) {
                FocusListener[] focusListeners;
                for (FocusListener focusListener : focusListeners = this.mTable.getFocusListeners()) {
                    focusListener.focusGained(focusEvent);
                }
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Component oppositeComponent = focusEvent.getOppositeComponent();
            if (oppositeComponent != null && XmlTableCellEditor.this._xmlTextComponent != null && !XmlTableCellEditor.this._xmlTextComponent.isAncestorOf(oppositeComponent)) {
                FocusListener[] focusListeners;
                XmlTableEditor xmlTableEditor;
                if (XmlTableCellEditor.this._xmlComponentWrapper.getPropertyEditor() instanceof XmlTableEditor && oppositeComponent == (xmlTableEditor = (XmlTableEditor)XmlTableCellEditor.this._xmlComponentWrapper.getPropertyEditor()).getTablePanel()) {
                    return;
                }
                for (FocusListener focusListener : focusListeners = this.mTable.getFocusListeners()) {
                    focusListener.focusLost(focusEvent);
                }
            }
        }
    }
}

