/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;

public class ScrollableMenu
extends JMenu {
    private int _visibleItems = 13;
    private int _indexVisible = 0;
    private JButton _upButton;
    private JButton _downButton;
    private Vector _menuItems = new Vector();

    public ScrollableMenu(String name) {
        super(name);
        this._createButtons();
    }

    @Override
    public JMenuItem add(Action action) {
        JMenuItem menuItem = new JMenuItem(action);
        return this.add(menuItem);
    }

    @Override
    public Component add(Component componentItem) {
        super.add(componentItem, this._menuItems.size() + 1);
        this._menuItems.add(componentItem);
        if (this._menuItems.size() > this._visibleItems) {
            componentItem.setVisible(false);
        }
        return componentItem;
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        return (JMenuItem)this.add((Component)menuItem);
    }

    private void _closeOpenedSubMenus() {
        int i;
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        MenuElement[] path = manager.getSelectedPath();
        JPopupMenu popup = this.getPopupMenu();
        for (i = 0; i < path.length && path[i] != popup; ++i) {
        }
        MenuElement[] subPath = new MenuElement[i + 1];
        System.arraycopy(path, 0, subPath, 0, i + 1);
        manager.setSelectedPath(subPath);
    }

    private void scrollUp() {
        this._closeOpenedSubMenus();
        if (this._indexVisible == 0) {
            return;
        }
        this._setMenuItemVisibility(false);
        this._indexVisible -= this._visibleItems;
        if (this._indexVisible < 0) {
            this._indexVisible = 0;
        }
        this._setMenuItemVisibility(true);
        this.setVisible(false);
        this.setVisible(true);
    }

    private void scrollDown() {
        this._closeOpenedSubMenus();
        if (this._indexVisible + this._visibleItems >= this._menuItems.size()) {
            return;
        }
        this._setMenuItemVisibility(false);
        this._indexVisible += this._visibleItems;
        if (this._indexVisible + this._visibleItems > this._menuItems.size()) {
            this._indexVisible = this._menuItems.size() - this._visibleItems;
        }
        this._setMenuItemVisibility(true);
        this.setVisible(false);
        this.setVisible(true);
    }

    private void _createButtons() {
        this._upButton = new JButton("    /\\                          ");
        this._upButton.setBorderPainted(false);
        this._upButton.setFocusPainted(false);
        this._upButton.setRolloverEnabled(true);
        this._upButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ScrollableMenu.this.scrollUp();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        super.add(this._upButton);
        this._downButton = new JButton("    \\/    ");
        this._downButton.setBorderPainted(false);
        this._downButton.setFocusPainted(false);
        this._downButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ScrollableMenu.this.scrollDown();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        super.add(this._downButton);
    }

    private void _setMenuItemVisibility(boolean visible) {
        for (int i = this._indexVisible; i < this._indexVisible + this._visibleItems && i < this._menuItems.size(); ++i) {
            ((JComponent)this._menuItems.get(i)).setVisible(visible);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        JFrame f = new JFrame("Test Popup Menu Bug");
        ScrollableMenu menu = new ScrollableMenu("Menu");
        menu.add(new JMenuItem("Menu Item1"));
        menu.add(new JMenuItem("Menu Item2"));
        menu.add(new JMenuItem("Menu Item3"));
        menu.add(new JMenuItem("Menu Item4"));
        menu.add(new JMenuItem("Menu Item5"));
        menu.add(new JMenuItem("Menu Item6"));
        menu.add(new JMenuItem("Menu Item7"));
        ScrollableMenu subMenu = new ScrollableMenu("SubMenu1");
        subMenu.add(new JMenuItem("Sub Menu Item1"));
        subMenu.add(new JMenuItem("Sub Menu Item2"));
        subMenu.add(new JMenuItem("Sub Menu Item3"));
        subMenu.add(new JMenuItem("Sub Menu Item4"));
        subMenu.add(new JMenuItem("Sub Menu Item5"));
        subMenu.add(new JMenuItem("Sub Menu Item6"));
        subMenu.add(new JMenuItem("Sub Menu Item7"));
        menu.add(subMenu);
        menu.add(new JMenuItem("Menu Item8"));
        menu.add(new JMenuItem("Menu Item9"));
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menu);
        f.setJMenuBar(menuBar);
        f.setBounds(100, 100, 300, 300);
        f.setVisible(true);
    }
}

