/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.creator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.gui.swing.creator.XmlElementCreator;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.util.XmlNameUtils;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class ProcessingInstructionCreator
extends XmlElementCreator {
    private JTextArea _data;
    private JTextField _target;

    @Override
    protected Component createContent(boolean create) {
        return this._createUI(create, true);
    }

    @Override
    protected Component createCustomEditor() {
        return this._createUI(false, false);
    }

    @Override
    protected String getTitle(XmlKey key) {
        return this.getContext().getTranslatedString("PROCESSINGINSTRUCTION_CREATOR_TITLE");
    }

    @Override
    protected Node createNode(XmlKey key, Node prototype) {
        return this.getContext().getModel().getDocument().createProcessingInstruction(this._target.getText(), "");
    }

    @Override
    protected final void updateNode() {
        ProcessingInstruction pi = (ProcessingInstruction)this.getNode();
        pi.setData(this._data.getText());
    }

    @Override
    protected void dialogClosing(PropertyChangeEvent e) throws PropertyVetoException {
        String target = this._target.getText();
        if ((target = target.trim()) == null || "".equals(target)) {
            throw new PropertyVetoException(this.getContext().getTranslatedString("PROCESSINGINSTRUCTION_CREATOR_ERROR_EMPTY"), e);
        }
        if (target.equalsIgnoreCase("xml")) {
            throw new PropertyVetoException(this.getContext().getTranslatedString("PROCESSINGINSTRUCTION_CREATOR_ERROR_XML"), e);
        }
        if (0 <= target.indexOf(" ")) {
            throw new PropertyVetoException(this.getContext().getTranslatedString("PROCESSINGINSTRUCTION_CREATOR_ERROR_SPACE"), e);
        }
        try {
            XmlNameUtils.validateName((CharSequence)target);
        }
        catch (IllegalArgumentException ise) {
            throw new PropertyVetoException(ise.getMessage(), e);
        }
        if (!this.isValidText(target) || !this.isValidText(this._data.getText())) {
            throw new PropertyVetoException(this.getContext().getTranslatedString("PROCESSINGINSTRUCTION_ERROR_NESTED"), e);
        }
        if (!this._target.getText().equals(target)) {
            this._target.setText(target);
        }
    }

    @Override
    public final void setValue(Object value) {
        if (this.isValidText((String)value)) {
            super.setValue(value);
            if (this._data != null) {
                this._data.setText((String)value);
            }
        } else {
            throw new IllegalArgumentException(this.getContext().getTranslatedString("PROCESSINGINSTRUCTION_ERROR_NESTED"));
        }
    }

    private boolean isValidText(String text) {
        return null == text || 0 > text.indexOf("?>") && 0 > text.indexOf("<?");
    }

    private void _update() {
        super.setValue(this._data.getText());
        this.firePropertyChange();
    }

    private Component _createUI(boolean enableTarget, boolean showTarget) {
        ProcessingInstruction pi = (ProcessingInstruction)this.getNode();
        JPanel c = new JPanel(new BorderLayout(0, 5));
        if (showTarget) {
            String targetText = this.getContext().getTranslatedString("PROCESSINGINSTRUCTION_CREATOR_TARGET_LABEL");
            JLabel targetLabel = new JLabel(StringUtils.stripMnemonic((String)targetText));
            targetLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)targetText));
            JTextField target = new JTextField(30);
            if (pi != null) {
                target.setText(pi.getTarget());
            }
            targetLabel.setLabelFor(target);
            target.setEditable(enableTarget);
            JPanel top = new JPanel(new BorderLayout(12, 0));
            top.add("West", targetLabel);
            top.add("Center", target);
            c.add("North", top);
            this._target = target;
        }
        String dataText = this.getContext().getTranslatedString("PROCESSINGINSTRUCTION_CREATOR_DATA_LABEL");
        JLabel dataLabel = new JLabel(StringUtils.stripMnemonic((String)dataText));
        dataLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)dataText));
        JTextArea data = new JTextArea(10, 40);
        if (pi != null) {
            data.setText(pi.getData());
        }
        dataLabel.setLabelFor(data);
        data.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProcessingInstructionCreator.this._update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProcessingInstructionCreator.this._update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProcessingInstructionCreator.this._update();
            }
        });
        JScrollPane pane = new JScrollPane(data);
        JPanel bottom = new JPanel(new BorderLayout(0, 5));
        bottom.add("North", dataLabel);
        bottom.add("Center", pane);
        c.add("Center", bottom);
        this._data = data;
        return c;
    }
}

